/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.tools.collection;

import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.lang.ruby.rbs.RbsSupport;
import com.intellij.lang.ruby.rbs.settings.RbsLanguageSettings;
import com.intellij.lang.ruby.rbs.tools.collection.project.RbsCollectionLibraryUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public final class RbsCollectionSupport {
    @NotNull
    public static final GemDependency RBS_COLLECTION_LIBRARY_DEPENDENCY = Objects.requireNonNull(GemDependency.create((String)"rbs", (String[])new String[]{">= 3.2.0"}));

    private RbsCollectionSupport() {
    }

    public static boolean isRbsCollectionManagementAvailable(@NotNull Project project) {
        if (project == null) {
            RbsCollectionSupport.$$$reportNull$$$0(0);
        }
        if (project.isDefault() || project.isDisposed() || !TrustedProjects.isProjectTrusted((Project)project)) {
            return false;
        }
        String projectUrl = project.getPresentableUrl();
        if (projectUrl == null || WslPath.isWslUncPath((String)projectUrl)) {
            return false;
        }
        if (!ProjectUtil.getProjectDataPath((Project)project, (String)"rbs_collection").isAbsolute()) {
            return false;
        }
        for (Module module : RModuleUtil.getInstance().getAllModulesWithRubySupport(project)) {
            if (!RbsCollectionSupport.isRbsCollectionManagementAvailable(project, module)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRbsCollectionManagementAvailable(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            RbsCollectionSupport.$$$reportNull$$$0(1);
        }
        if (module == null) {
            RbsCollectionSupport.$$$reportNull$$$0(2);
        }
        if (project.isDefault() || project.isDisposed() || !TrustedProjects.isProjectTrusted((Project)project)) {
            return false;
        }
        String projectUrl = project.getPresentableUrl();
        if (projectUrl == null || WslPath.isWslUncPath((String)projectUrl)) {
            return false;
        }
        Path path = RbsCollectionLibraryUtil.getRbsCollectionLibraryPath(project, module);
        if (!path.isAbsolute() || ContainerUtil.exists((Iterable)BaseProjectDirectories.getBaseDirectories((Project)project), it -> path.startsWith(it.toNioPath()))) {
            return false;
        }
        if (RbsSupport.isRbsGemExplicitlyUsedInProject(project)) {
            return false;
        }
        Ref foundRef = new Ref((Object)false);
        ReadAction.run(() -> FilenameIndex.processFilesByName((String)"rbs_collection.lock.yaml", (boolean)false, (GlobalSearchScope)module.getModuleContentScope(), __ -> !foundRef.setIfNull((Object)true)));
        if (((Boolean)foundRef.get()).booleanValue()) {
            return false;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            return false;
        }
        if (RubyGemSearchUtil.findGem(null, (Sdk)sdk, (GemDependency)RBS_COLLECTION_LIBRARY_DEPENDENCY) == null) {
            return false;
        }
        return BundlerUtil.getGemfileLock((Module)module) != null;
    }

    public static boolean isRbsCollectionManagementAvailableAndEnabled(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            RbsCollectionSupport.$$$reportNull$$$0(3);
        }
        if (module == null) {
            RbsCollectionSupport.$$$reportNull$$$0(4);
        }
        if (!RbsLanguageSettings.getInstance(project).isCollectionManagementEnabled()) {
            return false;
        }
        return RbsCollectionSupport.isRbsCollectionManagementAvailable(project, module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ruby/rbs/tools/collection/RbsCollectionSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isRbsCollectionManagementAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isRbsCollectionManagementAvailableAndEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

