/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.tools.collection;

import com.intellij.lang.ruby.rbs.ruby.project.RbsRubysigsLibraryUtil;
import com.intellij.lang.ruby.rbs.tools.collection.RbsCollectionConfig;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;

final class RbsCollectionSearchScope
extends DelegatingGlobalSearchScope {
    private RbsCollectionSearchScope(@NotNull GlobalSearchScope delegate) {
        if (delegate == null) {
            RbsCollectionSearchScope.$$$reportNull$$$0(0);
        }
        super(delegate);
    }

    @NotNull
    public String getDisplayName() {
        String string = RbsBundle.message((String)"rbs.search.scope.display.name", (Object[])new Object[0]);
        if (string == null) {
            RbsCollectionSearchScope.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    static RbsCollectionSearchScope fromConfig(@NotNull Project project, @NotNull PsiFile file, @NotNull RbsCollectionConfig config) {
        if (project == null) {
            RbsCollectionSearchScope.$$$reportNull$$$0(2);
        }
        if (file == null) {
            RbsCollectionSearchScope.$$$reportNull$$$0(3);
        }
        if (config == null) {
            RbsCollectionSearchScope.$$$reportNull$$$0(4);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        VirtualFile coreRoot = RbsRubysigsLibraryUtil.getRbsCoreLibraryRoot(project, module);
        VirtualFile stdlibRoot = RbsRubysigsLibraryUtil.getRbsStdlibLibraryRoot(project, module);
        VirtualFile collectionRoot = (VirtualFile)ObjectUtils.doIfNotNull((Object)config.path(), path -> VfsUtilCore.findRelativeFile((String)path, (VirtualFile)file.getVirtualFile()));
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        if (coreRoot != null) {
            roots.add(coreRoot);
        }
        block5: for (RbsCollectionConfig.GemEntry entry : config.gemEntries()) {
            switch (entry.source()) {
                case GIT: {
                    ContainerUtil.addIfNotNull(roots, (Object)VfsUtilCore.findRelativeFile((String)(entry.name() + "/" + entry.version()), (VirtualFile)collectionRoot));
                    break;
                }
                case RUBYGEMS: {
                    GemInfo gem = module != null ? RubyProjectGemSearchService.Companion.findGem(module, entry.name()) : null;
                    if (gem == null) continue block5;
                    ContainerUtil.addIfNotNull(roots, (Object)VfsUtilCore.findRelativeFile((String)"sig", (VirtualFile)gem.getFile()));
                    break;
                }
                case STDLIB: {
                    ContainerUtil.addIfNotNull(roots, (Object)VfsUtilCore.findRelativeFile((String)(entry.name() + "/" + entry.version()), (VirtualFile)stdlibRoot));
                }
            }
        }
        GlobalSearchScope projectScope = collectionRoot != null ? RbsCollectionSearchScope.projectScope((Project)project).intersectWith(RbsCollectionSearchScope.notScope((GlobalSearchScope)GlobalSearchScopes.directoryScope((Project)project, (VirtualFile)collectionRoot, (boolean)true))) : RbsCollectionSearchScope.projectScope((Project)project);
        GlobalSearchScope directoriesScope = GlobalSearchScopes.directoriesScope((Project)project, (boolean)true, (VirtualFile[])roots.toArray(VirtualFile.EMPTY_ARRAY));
        return new RbsCollectionSearchScope(projectScope.union((SearchScope)directoriesScope));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/tools/collection/RbsCollectionSearchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/tools/collection/RbsCollectionSearchScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

