/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.tools.collection;

import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.lang.ruby.rbs.RbsSupport;
import com.intellij.lang.ruby.rbs.settings.RbsLanguageSettings;
import com.intellij.lang.ruby.rbs.tools.collection.RbsCollectionSupport;
import com.intellij.lang.ruby.rbs.tools.collection.project.RbsCollectionLibraryUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInstallCommandOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallProcessOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

@Service(value={Service.Level.PROJECT})
public final class RbsCollectionNotificationService
implements Disposable.Default {
    private static final String NOTIFICATION_GROUP_ID = "rbs.collection";
    private final Project myProject;

    public RbsCollectionNotificationService(@NotNull Project project) {
        if (project == null) {
            RbsCollectionNotificationService.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void notifyInstallGem() {
        if (this.myProject.isDisposed() || this.isInstallGemNotificationActive()) {
            return;
        }
        new MyInstallGemNotification(this.myProject).notify(this.myProject);
    }

    public void expireInstallGemNotification() {
        this.getInstallGemNotifications().forEach(Notification::expire);
    }

    public boolean isInstallGemNotificationActive() {
        return !this.getInstallGemNotifications().isEmpty();
    }

    public boolean shouldNotifyInstallGem() {
        if (this.myProject.isDisposed() || !TrustedProjects.isProjectTrusted((Project)this.myProject)) {
            return false;
        }
        VirtualFile projectFile = this.myProject.getProjectFile();
        if (projectFile != null && WslPath.isWslUncPath((String)projectFile.getPresentableUrl())) {
            return false;
        }
        if (!RbsLanguageSettings.getInstance(this.myProject).isCollectionManagementEnabled() || RbsSupport.isRbsGemUsedInProject(this.myProject)) {
            return false;
        }
        return ContainerUtil.exists((Object[])RModuleUtil.getInstance().getAllModulesWithRubySupport(this.myProject), module -> {
            Path path = RbsCollectionLibraryUtil.getRbsCollectionLibraryPath(this.myProject, module);
            if (!path.isAbsolute() || ContainerUtil.exists((Iterable)BaseProjectDirectories.getBaseDirectories((Project)this.myProject), it -> path.startsWith(it.toNioPath()))) {
                return false;
            }
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            if (sdk == null) {
                return false;
            }
            LanguageLevel languageLevel = RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk);
            if (languageLevel.isLessThan(LanguageLevel.RUBY30)) {
                return false;
            }
            if (RubyGemSearchUtil.findGem(null, (Sdk)sdk, (GemDependency)RbsCollectionSupport.RBS_COLLECTION_LIBRARY_DEPENDENCY) != null) {
                return false;
            }
            return BundlerUtil.getGemfileLock((Module)module) != null;
        });
    }

    @NotNull
    private List<MyInstallGemNotification> getInstallGemNotifications() {
        List<MyInstallGemNotification> list = List.of((MyInstallGemNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(MyInstallGemNotification.class, this.myProject));
        if (list == null) {
            RbsCollectionNotificationService.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static RbsCollectionNotificationService getInstance(@NotNull Project project) {
        if (project == null) {
            RbsCollectionNotificationService.$$$reportNull$$$0(2);
        }
        RbsCollectionNotificationService rbsCollectionNotificationService = (RbsCollectionNotificationService)project.getService(RbsCollectionNotificationService.class);
        if (rbsCollectionNotificationService == null) {
            RbsCollectionNotificationService.$$$reportNull$$$0(3);
        }
        return rbsCollectionNotificationService;
    }

    private static void doInstallGem(@NotNull Project project) {
        if (project == null) {
            RbsCollectionNotificationService.$$$reportNull$$$0(4);
        }
        RModuleUtil service = RModuleUtil.getInstance();
        Object[] modules = service.getAllModulesWithRubySupport(project);
        ArrayList sdks = new ArrayList(ContainerUtil.mapNotNull((Object[])modules, arg_0 -> ((RModuleUtil)service).findRubySdkForModule(arg_0)));
        ContainerUtil.removeDuplicates(sdks);
        for (Sdk sdk : sdks) {
            if (RubyGemSearchUtil.findGem(null, (Sdk)sdk, (GemDependency)RbsCollectionSupport.RBS_COLLECTION_LIBRARY_DEPENDENCY) != null) continue;
            LinkedHashMap errors = new LinkedHashMap();
            Runnable callback = () -> {
                if (!errors.isEmpty()) {
                    ApplicationManager.getApplication().invokeLater(() -> GemUiUtil.showInstallErrors((Project)project, (Map)errors));
                }
            };
            GemInstallUtil.installGemsInBackground((Sdk)sdk, null, List.of(RbsCollectionSupport.RBS_COLLECTION_LIBRARY_DEPENDENCY), (GemInstallCommandOptions)new GemInstallCommandOptions().withNoDocument(), (GemInstallProcessOptions)GemInstallProcessOptions.installMissingOnlyAsync(errors).withCallback(callback));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/tools/collection/RbsCollectionNotificationService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/tools/collection/RbsCollectionNotificationService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallGemNotifications";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doInstallGem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    private static final class MyInstallGemNotification
    extends Notification {
        private MyInstallGemNotification(@NotNull Project project) {
            if (project == null) {
                MyInstallGemNotification.$$$reportNull$$$0(0);
            }
            super(RbsCollectionNotificationService.NOTIFICATION_GROUP_ID, RbsBundle.message((String)"rbs.collection.notification.installGem.title", (Object[])new Object[0]), RbsBundle.message((String)"rbs.collection.notification.installGem.body", (Object[])new Object[0]), NotificationType.INFORMATION);
            this.setSuggestionType(true);
            this.addAction((AnAction)new MyInstallAction(project));
            this.addAction((AnAction)new MyDontShowAgainAction(project));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ruby/rbs/tools/collection/RbsCollectionNotificationService$MyInstallGemNotification", "<init>"));
        }
    }

    private static final class MyDontShowAgainAction
    extends NotificationAction {
        private final Project myProject;

        private MyDontShowAgainAction(@NotNull Project project) {
            if (project == null) {
                MyDontShowAgainAction.$$$reportNull$$$0(0);
            }
            super(IdeBundle.messagePointer((String)"label.dont.show", (Object[])new Object[0]));
            this.myProject = project;
        }

        public void actionPerformed(@NotNull AnActionEvent event, @NotNull Notification notification) {
            if (event == null) {
                MyDontShowAgainAction.$$$reportNull$$$0(1);
            }
            if (notification == null) {
                MyDontShowAgainAction.$$$reportNull$$$0(2);
            }
            notification.setDoNotAskFor(this.myProject);
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/tools/collection/RbsCollectionNotificationService$MyDontShowAgainAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyInstallAction
    extends DumbAwareAction {
        private final Project myProject;

        private MyInstallAction(@NotNull Project project) {
            if (project == null) {
                MyInstallAction.$$$reportNull$$$0(0);
            }
            super(RbsBundle.messagePointer((String)"rbs.collection.notification.installGem.install.action.title", (Object[])new Object[0]));
            this.myProject = project;
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                MyInstallAction.$$$reportNull$$$0(1);
            }
            RbsCollectionNotificationService.doInstallGem(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/tools/collection/RbsCollectionNotificationService$MyInstallAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

