/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.tools.collection;

import com.intellij.lang.ruby.rbs.tools.collection.RbsCollectionConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/ruby/rbs/tools/collection/RbsCollectionConfigService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getConfig", "Lcom/intellij/lang/ruby/rbs/tools/collection/RbsCollectionConfig;", "file", "Lcom/intellij/psi/PsiFile;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dataHolder", "Lcom/intellij/openapi/util/UserDataHolder;", "Companion", "intellij.ruby.rbs.backend"})
@SourceDebugExtension(value={"SMAP\nRbsCollectionConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RbsCollectionConfigService.kt\ncom/intellij/lang/ruby/rbs/tools/collection/RbsCollectionConfigService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,109:1\n13#2:110\n*S KotlinDebug\n*F\n+ 1 RbsCollectionConfigService.kt\ncom/intellij/lang/ruby/rbs/tools/collection/RbsCollectionConfigService\n*L\n103#1:110\n*E\n"})
public final class RbsCollectionConfigService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Lazy<VirtualFileGist<RbsCollectionConfig>> CONFIG_GIST$delegate = LazyKt.lazy(RbsCollectionConfigService::CONFIG_GIST_delegate$lambda$0);
    @NotNull
    private static final Logger logger;

    public RbsCollectionConfigService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final RbsCollectionConfig getConfig(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return RbsCollectionConfig.Companion.getEMPTY();
        }
        VirtualFile virtualFile2 = virtualFile;
        return this.getConfig((UserDataHolder)file, virtualFile2);
    }

    @NotNull
    public final RbsCollectionConfig getConfig(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(virtualFile);
        if (psiFile == null) {
            return RbsCollectionConfig.Companion.getEMPTY();
        }
        PsiFile file = psiFile;
        return this.getConfig((UserDataHolder)file, virtualFile);
    }

    private final RbsCollectionConfig getConfig(UserDataHolder dataHolder, VirtualFile file) {
        Object object = CachedValuesManager.getManager((Project)this.project).getCachedValue(dataHolder, () -> RbsCollectionConfigService.getConfig$lambda$0(this, file));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (RbsCollectionConfig)object;
    }

    private static final CachedValueProvider.Result getConfig$lambda$0(RbsCollectionConfigService this$0, VirtualFile $file) {
        Object[] objectArray = new Object[]{$file};
        return CachedValueProvider.Result.create((Object)RbsCollectionConfigService.Companion.getCONFIG_GIST().getFileData(this$0.project, $file), (Object[])objectArray);
    }

    private static final VirtualFileGist CONFIG_GIST_delegate$lambda$0() {
        return GistManager.getInstance().newVirtualFileGist(RbsCollectionConfigService.class.getName(), 1, RbsCollectionConfig.Companion.getDATA_EXTERNALIZER(), RbsCollectionConfigService::CONFIG_GIST_delegate$lambda$0$0);
    }

    private static final RbsCollectionConfig CONFIG_GIST_delegate$lambda$0$0(Project project, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return RbsCollectionConfigService.Companion.getConfig(file);
    }

    @JvmStatic
    @NotNull
    public static final RbsCollectionConfigService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RbsCollectionConfigService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RbsCollectionConfigService.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/ruby/rbs/tools/collection/RbsCollectionConfigService$Companion;", "", "<init>", "()V", "CONFIG_GIST", "Lcom/intellij/util/gist/VirtualFileGist;", "Lcom/intellij/lang/ruby/rbs/tools/collection/RbsCollectionConfig;", "getCONFIG_GIST", "()Lcom/intellij/util/gist/VirtualFileGist;", "CONFIG_GIST$delegate", "Lkotlin/Lazy;", "getConfig", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "readFileTree", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/lang/ruby/rbs/tools/collection/RbsCollectionConfigService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ruby.rbs.backend"})
    @SourceDebugExtension(value={"SMAP\nRbsCollectionConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RbsCollectionConfigService.kt\ncom/intellij/lang/ruby/rbs/tools/collection/RbsCollectionConfigService$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,109:1\n808#2,11:110\n1#3:121\n30#4,2:122\n*S KotlinDebug\n*F\n+ 1 RbsCollectionConfigService.kt\ncom/intellij/lang/ruby/rbs/tools/collection/RbsCollectionConfigService$Companion\n*L\n80#1:110,11\n106#1:122,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final VirtualFileGist<RbsCollectionConfig> getCONFIG_GIST() {
            Lazy lazy = CONFIG_GIST$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (VirtualFileGist)object;
        }

        /*
         * WARNING - void declaration
         */
        private final RbsCollectionConfig getConfig(VirtualFile file) {
            void $this$filterIsInstanceTo$iv$iv;
            Object object;
            List list;
            String path;
            Map<?, ?> map = this.readFileTree(file);
            if (map == null) {
                return RbsCollectionConfig.Companion.getEMPTY();
            }
            Map<?, ?> tree = map;
            Object obj = tree.get("path");
            String string = obj instanceof String ? (String)obj : null;
            if (string == null || (string = StringKt.nullize((String)string, (boolean)true)) == null) {
                string = path = ".gem_rbs_collection";
            }
            if ((list = (object = tree.get("gems")) instanceof List ? (List)object : null) == null) {
                list = CollectionsKt.emptyList();
            }
            List gems = list;
            ArrayList<RbsCollectionConfig.GemEntry> gemEntries = new ArrayList<RbsCollectionConfig.GemEntry>();
            Iterable $this$filterIsInstance$iv = gems;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection<Object> destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo2 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Map)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Map gem : (List)destination$iv$iv) {
                RbsCollectionConfig.GemEntry.Source source;
                Object sourceType;
                String version;
                String name;
                destination$iv$iv = gem.get("name");
                if ((destination$iv$iv instanceof String ? (String)((Object)destination$iv$iv) : null) == null) continue;
                name = name;
                Object $i$f$filterIsInstanceTo2 = gem.get("version");
                if (($i$f$filterIsInstanceTo2 instanceof String ? (String)$i$f$filterIsInstanceTo2 : null) == null) continue;
                version = version;
                Iterator<Object> iterator = gem.get("source");
                Object object2 = iterator instanceof Map ? (Map)((Object)iterator) : null;
                if (object2 == null) continue;
                Map it = object2;
                boolean bl = false;
                Object v = it.get("type");
                String string2 = v instanceof String ? (String)v : null;
                object2 = string2;
                if (string2 == null || RbsCollectionConfig.GemEntry.Source.Companion.find((String)(sourceType = object2)) == null) continue;
                gemEntries.add(new RbsCollectionConfig.GemEntry(name, version, source));
            }
            return new RbsCollectionConfig(path, (List<RbsCollectionConfig.GemEntry>)gemEntries);
        }

        private final Map<?, ?> readFileTree(VirtualFile file) {
            try {
                Object object = new Yaml().load(VirtualFileUtil.readText((VirtualFile)file));
                return object instanceof Map ? (Map)object : null;
            }
            catch (YAMLException e) {
                logger.warn((Throwable)e);
                return null;
            }
        }

        @JvmStatic
        @NotNull
        public final RbsCollectionConfigService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RbsCollectionConfigService> serviceClass$iv = RbsCollectionConfigService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RbsCollectionConfigService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

