/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.structureView;

import com.intellij.lang.ruby.rbs.model.api.RbsSymbol;
import com.intellij.lang.ruby.rbs.model.psi.declaration.RbsPsiSymbolDeclaration;
import com.intellij.model.presentation.SymbolDeclarationPresentation;
import com.intellij.model.presentation.SymbolDeclarationPresentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.psi.api.RbsQualifiedNameDeclaration;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;

final class RbsSymbolDeclarationPresentationProvider
implements SymbolDeclarationPresentationProvider<RbsPsiSymbolDeclaration> {
    private static final Logger LOG = Logger.getInstance(RbsSymbolDeclarationPresentationProvider.class);

    RbsSymbolDeclarationPresentationProvider() {
    }

    @Nullable
    public SymbolDeclarationPresentation getPresentation(@NotNull RbsPsiSymbolDeclaration symbolDeclaration) {
        RbsSymbol symbol;
        if (symbolDeclaration == null) {
            RbsSymbolDeclarationPresentationProvider.$$$reportNull$$$0(0);
        }
        if ((symbol = symbolDeclaration.getSymbol()) instanceof PresentableSymbol) {
            final SymbolPresentation symbolPresentation = ((PresentableSymbol)symbol).getPresentation();
            final String qualifier = (String)ObjectUtils.doIfCast((Object)symbolDeclaration.getDeclaringElement(), RbsQualifiedNameDeclaration.class, declaration -> {
                String name = declaration.getFqn().getName();
                int index = name.lastIndexOf("::");
                if (index < 0) {
                    return null;
                }
                return index > 0 ? name.substring(0, index) : "::";
            });
            return new SymbolDeclarationPresentation(){

                @NotNull
                public String getPresentableText() {
                    String name = symbolPresentation.name();
                    String string = qualifier != null && !qualifier.isBlank() ? RbsBundle.message((String)"rbs.structure.view.qualified.name", (Object[])new Object[]{name, qualifier}) : name;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Nullable
                public Icon getIcon(boolean unused) {
                    return symbolPresentation.icon();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ruby/rbs/structureView/RbsSymbolDeclarationPresentationProvider$1", "getPresentableText"));
                }
            };
        }
        LOG.error("Presentable symbol expected, got " + String.valueOf(symbol.getClass()) + " (from " + String.valueOf(symbolDeclaration.getClass()) + ")");
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolDeclaration", "com/intellij/lang/ruby/rbs/structureView/RbsSymbolDeclarationPresentationProvider", "getPresentation"));
    }
}

