/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.types;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsSearchScope;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureBinding;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureResolver;
import com.intellij.lang.ruby.rbs.ruby.codeInsight.types.RbsRubyInterfaceType;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeConverter;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.psi.data.RbsOptionalTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsProcTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsQualifiedNameTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsRecursiveTypeSignatureVisitor;
import com.intellij.ruby.rbs.common.psi.data.RbsSingletonTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTupleTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignatureVisitor;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeVariableReferenceSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsUnionTypeSignature;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.NilAnalysisComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionTypeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.TypeInferenceComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicCall;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSymbolType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeWithNilability;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RUnionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections.RCollectionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections.RHashType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RArgumentToBlock;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RbsRubyTypeVariableExtractor {
    private RbsRubyTypeVariableExtractor() {
    }

    @NotNull
    public static List<RTypeWithNilability> extractContainerTypeVariableTypes(@NotNull SymbolicExecutionContext context, @NotNull SymbolicCall symbolicCall, @NotNull RbsProcTypeSignature signature) {
        if (context == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(0);
        }
        if (symbolicCall == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(1);
        }
        if (signature == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(2);
        }
        return RbsRubyTypeVariableExtractor.extractTypeVariableTypes(context, symbolicCall, signature, RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE);
    }

    @NotNull
    public static List<RTypeWithNilability> extractMethodTypeVariableTypes(@NotNull RPossibleCall call, @NotNull RbsProcTypeSignature signature) {
        if (call == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(3);
        }
        if (signature == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(4);
        }
        return RbsRubyTypeVariableExtractor.extractTypeVariableTypes(call, signature, RbsTypeVariableReferenceSignature.ReferenceType.METHOD_VARIABLE);
    }

    @NotNull
    public static List<RTypeWithNilability> extractMethodTypeVariableTypes(@NotNull SymbolicExecutionContext context, @NotNull SymbolicCall symbolicCall, @NotNull RbsProcTypeSignature signature) {
        if (context == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(5);
        }
        if (symbolicCall == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(6);
        }
        if (signature == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(7);
        }
        return RbsRubyTypeVariableExtractor.extractTypeVariableTypes(context, symbolicCall, signature, RbsTypeVariableReferenceSignature.ReferenceType.METHOD_VARIABLE);
    }

    @NotNull
    public static List<RTypeWithNilability> extractMethodTypeVariableTypes(@NotNull SymbolicExecutionContext context, @NotNull SymbolicCall symbolicCall, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable TypeInferenceInstance.CallContext callContext, @NotNull List<RTypeWithNilability> containerTypeVariableTypes, @NotNull RbsProcTypeSignature signature) {
        if (context == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(8);
        }
        if (symbolicCall == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(9);
        }
        if (containerTypeVariableTypes == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(10);
        }
        if (signature == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(11);
        }
        return RbsRubyTypeVariableExtractor.extractTypeVariableTypes(context, symbolicCall, callContext, containerTypeVariableTypes, signature, RbsTypeVariableReferenceSignature.ReferenceType.METHOD_VARIABLE);
    }

    @NotNull
    public static List<RType> getTypeArguments(@NotNull RType type) {
        if (type == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(12);
        }
        List list = ContainerUtil.map(RbsRubyTypeVariableExtractor.getTypeArguments(new RTypeWithNilability(type)), RTypeWithNilability::getType);
        if (list == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public static List<RTypeWithNilability> getTypeArguments(@NotNull RTypeWithNilability typeWithNilability) {
        RType type;
        if (typeWithNilability == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(14);
        }
        if ((type = typeWithNilability.getType()) instanceof RbsRubyInterfaceType) {
            List<RTypeWithNilability> list = ((RbsRubyInterfaceType)type).getTypeArguments();
            if (list == null) {
                RbsRubyTypeVariableExtractor.$$$reportNull$$$0(15);
            }
            return list;
        }
        ArrayList<RType> arguments = new ArrayList<RType>();
        if (type instanceof RHashType) {
            RHashType hashType = (RHashType)type;
            arguments.addAll(List.of(hashType.getKeyType(), hashType.getValueType()));
        } else if (type instanceof RCollectionType) {
            RCollectionType collectionType = (RCollectionType)type;
            arguments.add((RType)collectionType.getEachType());
        } else {
            RSymbolType symbolType = RTypeUtil.extractSymbolType((RType)type);
            if (symbolType != null) {
                arguments.addAll(ContainerUtil.map((Collection)symbolType.getTypeArguments(), it -> (RType)it.second));
            }
        }
        List list = ContainerUtil.map(arguments, RTypeWithNilability::new);
        if (list == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    private static List<RTypeWithNilability> extractTypeVariableTypes(@NotNull RPossibleCall call, @NotNull RbsProcTypeSignature signature, @NotNull RbsTypeVariableReferenceSignature.ReferenceType referenceType) {
        if (call == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(17);
        }
        if (signature == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(18);
        }
        if (referenceType == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(19);
        }
        List arguments = RubyPsiUtil.getCallArgumentsIncludingIndexes((RPossibleCall)call);
        MultiMap typeVariableTypes = new MultiMap();
        for (RPsiElement argument : arguments) {
            RbsTypeSignature parameterTypeSignature = RbsRubyTypeUtil.findMatchingParameterTypeSignature(signature, arguments, (PsiElement)argument);
            if (parameterTypeSignature == null || !RbsRubyTypeVariableExtractor.hasTypeVariableReferences(parameterTypeSignature, referenceType)) continue;
            typeVariableTypes.putAllValues(RbsRubyTypeVariableExtractor.extractTypeVariableTypes(RTypeWithNilability.fromPsiElement((PsiElement)argument), parameterTypeSignature, referenceType));
        }
        return RbsRubyTypeVariableExtractor.collectTypesToList((MultiMap<Integer, RTypeWithNilability>)typeVariableTypes);
    }

    @NotNull
    private static List<RTypeWithNilability> extractTypeVariableTypes(@NotNull SymbolicExecutionContext context, @NotNull SymbolicCall symbolicCall, @NotNull RbsProcTypeSignature signature, @NotNull RbsTypeVariableReferenceSignature.ReferenceType referenceType) {
        if (context == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(20);
        }
        if (symbolicCall == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(21);
        }
        if (signature == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(22);
        }
        if (referenceType == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(23);
        }
        return RbsRubyTypeVariableExtractor.extractTypeVariableTypes(context, symbolicCall, null, Collections.emptyList(), signature, referenceType);
    }

    @NotNull
    private static List<RTypeWithNilability> extractTypeVariableTypes(@NotNull SymbolicExecutionContext context, @NotNull SymbolicCall symbolicCall, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable TypeInferenceInstance.CallContext callContext, @NotNull List<RTypeWithNilability> containerTypeVariableTypes, @NotNull RbsProcTypeSignature signature, @NotNull RbsTypeVariableReferenceSignature.ReferenceType referenceType) {
        if (context == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(24);
        }
        if (symbolicCall == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(25);
        }
        if (containerTypeVariableTypes == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(26);
        }
        if (signature == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(27);
        }
        if (referenceType == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(28);
        }
        TypeInferenceComponent typeInferenceComponent = (TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class);
        NilAnalysisComponent nilAnalysisComponent = (NilAnalysisComponent)context.getComponent(NilAnalysisComponent.class);
        List argumentInfos = symbolicCall.getArguments();
        MultiMap typeVariableTypes = new MultiMap();
        for (SymbolicCall.SymbolicArgumentInfo argumentInfo : argumentInfos) {
            RbsTypeSignature parameterTypeSignature = RbsRubyTypeUtil.findMatchingParameterTypeSignature(signature, argumentInfos, argumentInfo);
            if (parameterTypeSignature == null || !RbsRubyTypeVariableExtractor.hasTypeVariableReferences(parameterTypeSignature, referenceType)) continue;
            SymbolicExpression expression = argumentInfo.getExpression();
            RType argumentType = expression.getType((SymbolicExpressionTypeHolder)typeInferenceComponent);
            ThreeState canBeNil = nilAnalysisComponent != null ? nilAnalysisComponent.getCanBeNil(expression) : ThreeState.UNSURE;
            typeVariableTypes.putAllValues(RbsRubyTypeVariableExtractor.extractTypeVariableTypes(new RTypeWithNilability(argumentType, canBeNil), parameterTypeSignature, referenceType));
        }
        RbsProcTypeSignature blockTypeSignature = signature.getBlockTypeSignature();
        if (symbolicCall.isBlockGiven() && blockTypeSignature != null && callContext != null && RbsRubyTypeVariableExtractor.hasTypeVariableReferences((RbsTypeSignature)blockTypeSignature, referenceType)) {
            RTypeWithNilability returnType;
            RTypeWithNilability rTypeWithNilability = returnType = referenceType == RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE ? RbsRubyTypeVariableExtractor.getBlockReturnType(callContext, RbsRubyTypeVariableExtractor.collectTypesToList((MultiMap<Integer, RTypeWithNilability>)typeVariableTypes), ContainerUtil.emptyList(), blockTypeSignature) : RbsRubyTypeVariableExtractor.getBlockReturnType(callContext, containerTypeVariableTypes, RbsRubyTypeVariableExtractor.collectTypesToList((MultiMap<Integer, RTypeWithNilability>)typeVariableTypes), blockTypeSignature);
            if (returnType != null) {
                typeVariableTypes.putAllValues(RbsRubyTypeVariableExtractor.extractTypeVariableTypes(returnType, blockTypeSignature.getReturnTypeSignature(), referenceType));
            }
        }
        return RbsRubyTypeVariableExtractor.collectTypesToList((MultiMap<Integer, RTypeWithNilability>)typeVariableTypes);
    }

    @Nullable
    private static RTypeWithNilability getBlockReturnType(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TypeInferenceInstance.CallContext callContext, @NotNull List<RTypeWithNilability> containerTypeVariableTypes, @NotNull List<RTypeWithNilability> localTypeVariableTypes, @NotNull RbsProcTypeSignature blockTypeSignature) {
        PsiElement invocationPoint;
        GlobalSearchScope searchScope;
        RCodeBlock block;
        if (containerTypeVariableTypes == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(29);
        }
        if (localTypeVariableTypes == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(30);
        }
        if (blockTypeSignature == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(31);
        }
        if (callContext == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(32);
        }
        if ((block = callContext.getCurrentCodeBlock()) != null) {
            return new RTypeWithNilability(block.getCompoundStatement().getType());
        }
        RbsTypeSignature receiverTypeSignature = (RbsTypeSignature)ObjectUtils.doIfNotNull((Object)blockTypeSignature.findParameter(RbsProcTypeSignature.ParameterType.POSITIONAL_TYPES), RbsProcTypeSignature.Parameter::getTypeSignature);
        if (receiverTypeSignature == null) {
            return null;
        }
        PsiElement element = callContext.getElement();
        String procName = RbsRubyTypeVariableExtractor.getProcName(element);
        if (procName == null) {
            return null;
        }
        Project project = element.getProject();
        RTypeWithNilability procReceiverType = RbsRubyTypeConverter.convert(project, (SearchScope)(searchScope = element.getResolveScope().intersectWith(RbsSearchScope.collectionScope(element))), null, containerTypeVariableTypes, localTypeVariableTypes, receiverTypeSignature, invocationPoint = callContext.getInvocationPoint());
        return procReceiverType != null ? RbsRubyTypeVariableExtractor.extractProcReturnType(project, (SearchScope)searchScope, procReceiverType, procName, invocationPoint) : null;
    }

    @Nullable
    private static RTypeWithNilability extractProcReturnType(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RTypeWithNilability procReceiverType, @NotNull String procName, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(33);
        }
        if (searchScope == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(34);
        }
        if (procReceiverType == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(35);
        }
        if (procName == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(36);
        }
        RTypeWithNilability typeWithNilability = RTypeWithNilability.EMPTY;
        for (RType receiverType : RTypeUtil.flattenUnionAndIntersectionType((RType)procReceiverType.getType())) {
            RbsMethodSymbol methodSymbol;
            List<RTypeWithNilability> containerTypeVariableTypes = RbsRubyTypeVariableExtractor.getTypeArguments(new RTypeWithNilability(receiverType));
            RbsContainerSymbol containerSymbol = RbsRubyTypeUtil.findContainerSymbolForRubyType(project, searchScope, receiverType);
            if (containerSymbol == null || (methodSymbol = (RbsMethodSymbol)containerSymbol.allChildren(project, searchScope).mapMulti(StreamUtil.select(RbsMethodSymbol.class, (Class[])new Class[0])).filter(child -> child.getName().equals(procName)).findFirst().orElse(null)) == null) continue;
            Function<RbsTypeSignature, RbsTypeSignature> binding = containerSymbol.getTypeVariableBinding(project, searchScope).getOrDefault(methodSymbol.getContainerSymbol(), RbsTypeSignatureBinding.UNTYPED);
            RTypeWithNilability returnType = methodSymbol.getMethodTypeSignatures(project, searchScope).stream().map(typeSignature -> typeSignature.apply(binding).apply((Function)new RbsTypeSignatureResolver(project, searchScope))).map(signature -> RbsRubyTypeConverter.convert(project, searchScope, receiverType, containerTypeVariableTypes, ContainerUtil.emptyList(), signature.getReturnTypeSignature(), invocationPoint)).filter(Objects::nonNull).reduce(RTypeWithNilability.EMPTY, RTypeWithNilability::union);
            typeWithNilability = typeWithNilability.union(returnType);
        }
        return typeWithNilability.isEmpty() ? null : typeWithNilability;
    }

    @NotNull
    private static MultiMap<Integer, RTypeWithNilability> extractTypeVariableTypes(@NotNull RTypeWithNilability type, @NotNull RbsTypeSignature typeSignature, @NotNull RbsTypeVariableReferenceSignature.ReferenceType referenceType) {
        if (type == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(37);
        }
        if (typeSignature == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(38);
        }
        if (referenceType == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(39);
        }
        if (type.getType() instanceof RUnionType) {
            MultiMap typeVariableTypes = new MultiMap();
            for (RType subtype : ((RUnionType)type.getType()).getTypes()) {
                typeVariableTypes.putAllValues(RbsRubyTypeVariableExtractor.extractTypeVariableTypes(new RTypeWithNilability(subtype, type.getCanBeNil()), typeSignature, referenceType));
            }
            MultiMap multiMap = typeVariableTypes;
            if (multiMap == null) {
                RbsRubyTypeVariableExtractor.$$$reportNull$$$0(40);
            }
            return multiMap;
        }
        MyVisitor visitor = new MyVisitor(type, referenceType);
        typeSignature.accept((RbsTypeSignatureVisitor)visitor);
        MultiMap<Integer, RTypeWithNilability> multiMap = visitor.myTypeVariableTypes;
        if (multiMap == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(41);
        }
        return multiMap;
    }

    @NotNull
    private static List<RTypeWithNilability> collectTypesToList(@NotNull MultiMap<Integer, RTypeWithNilability> typeVariableTypes) {
        if (typeVariableTypes == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(42);
        }
        List<RTypeWithNilability> list = IntStream.range(0, typeVariableTypes.keySet().stream().max(Comparator.naturalOrder()).map(it -> it + 1).orElse(0)).mapToObj(i -> typeVariableTypes.get((Object)i).stream().reduce(RTypeWithNilability.EMPTY, RTypeWithNilability::union)).toList();
        if (list == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(43);
        }
        return list;
    }

    @Nullable
    private static String getProcName(@NotNull PsiElement callContextElement) {
        List callArguments;
        if (callContextElement == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(44);
        }
        if ((callArguments = (List)ObjectUtils.doIfCast((Object)callContextElement, RPossibleCall.class, RPossibleCall::getArguments)) == null) {
            return null;
        }
        RArgumentToBlock argumentToBlock = (RArgumentToBlock)ContainerUtil.findInstance((Iterable)callArguments, RArgumentToBlock.class);
        return argumentToBlock != null ? (String)ObjectUtils.doIfCast((Object)argumentToBlock.getArgument(), RSymbol.class, RSymbol::getValue) : null;
    }

    private static boolean hasTypeVariableReferences(@NotNull RbsTypeSignature signature, final @NotNull RbsTypeVariableReferenceSignature.ReferenceType referenceType) {
        if (signature == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(45);
        }
        if (referenceType == null) {
            RbsRubyTypeVariableExtractor.$$$reportNull$$$0(46);
        }
        final AtomicBoolean typeVariableReferenceFound = new AtomicBoolean();
        signature.accept((RbsTypeSignatureVisitor)new RbsRecursiveTypeSignatureVisitor(){

            public void visitTypeVariableReferenceSignature(@NotNull RbsTypeVariableReferenceSignature signature) {
                if (signature == null) {
                    1.$$$reportNull$$$0(0);
                }
                typeVariableReferenceFound.compareAndSet(false, signature.getReferenceType() == referenceType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeVariableExtractor$1", "visitTypeVariableReferenceSignature"));
            }
        });
        return typeVariableReferenceFound.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 15, 16, 40, 41, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolicCall";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 18: 
            case 22: 
            case 27: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 10: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerTypeVariableTypes";
                break;
            }
            case 12: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 40: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeVariableExtractor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeWithNilability";
                break;
            }
            case 19: 
            case 23: 
            case 28: 
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTypeVariableTypes";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockTypeSignature";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callContext";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procReceiverType";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSignature";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeVariableTypes";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callContextElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeVariableExtractor";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTypeVariableTypes";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypesToList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractContainerTypeVariableTypes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractMethodTypeVariableTypes";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArguments";
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 40: 
            case 41: 
            case 43: {
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "extractTypeVariableTypes";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getBlockReturnType";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "extractProcReturnType";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "collectTypesToList";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getProcName";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeVariableReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 15, 16, 40, 41, 43 -> new IllegalStateException(string);
        };
    }

    private static final class MyVisitor
    implements RbsTypeSignatureVisitor {
        private final RTypeWithNilability myType;
        private final RbsTypeVariableReferenceSignature.ReferenceType myReferenceType;
        private final MultiMap<Integer, RTypeWithNilability> myTypeVariableTypes;

        private MyVisitor(@NotNull RTypeWithNilability type, @NotNull RbsTypeVariableReferenceSignature.ReferenceType referenceType) {
            if (type == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (referenceType == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.myTypeVariableTypes = new MultiMap();
            this.myType = type;
            this.myReferenceType = referenceType;
        }

        public void visitOptionalTypeSignature(@NotNull RbsOptionalTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            RTypeWithNilability newType = new RTypeWithNilability(this.myType.getType(), false);
            this.myTypeVariableTypes.putAllValues(RbsRubyTypeVariableExtractor.extractTypeVariableTypes(newType, signature.getTypeSignature(), this.myReferenceType));
        }

        public void visitQualifiedNameTypeSignature(@NotNull RbsQualifiedNameTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            List typeArgumentSignatures = signature.getTypeArgumentSignatures();
            List<RTypeWithNilability> typeArguments = RbsRubyTypeVariableExtractor.getTypeArguments(this.myType);
            for (Pair pair : ContainerUtil.zip((Iterable)typeArgumentSignatures, typeArguments)) {
                this.myTypeVariableTypes.putAllValues(RbsRubyTypeVariableExtractor.extractTypeVariableTypes((RTypeWithNilability)pair.second, (RbsTypeSignature)pair.first, this.myReferenceType));
            }
        }

        public void visitSingletonTypeSignature(@NotNull RbsSingletonTypeSignature signature) {
            Symbol symbol;
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            if (!((symbol = RTypeUtilCore.getBirthTypeSymbol((RType)this.myType.getType())) instanceof SingletonClassSymbol)) {
                return;
            }
            SingletonClassSymbol symbol2 = (SingletonClassSymbol)symbol;
            this.myTypeVariableTypes.putAllValues(RbsRubyTypeVariableExtractor.extractTypeVariableTypes(new RTypeWithNilability(RTypeFactory.createTypeBySymbol((Symbol)symbol2.getOriginSymbol()), false), signature.getTypeSignature(), this.myReferenceType));
        }

        public void visitTupleTypeSignature(@NotNull RbsTupleTypeSignature signature) {
            RType type;
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if (!((type = this.myType.getType()) instanceof RCollectionType) || !RTypeUtilCore.isArrayType((RType)type)) {
                return;
            }
            List typeSignatures = signature.getTypeSignatures();
            List typeArguments = ((RCollectionType)type).getElementTypes();
            for (Pair pair : ContainerUtil.zip((Iterable)typeSignatures, (Iterable)typeArguments)) {
                this.myTypeVariableTypes.putAllValues(RbsRubyTypeVariableExtractor.extractTypeVariableTypes(new RTypeWithNilability((RType)pair.second), (RbsTypeSignature)pair.first, this.myReferenceType));
            }
        }

        public void visitTypeVariableReferenceSignature(@NotNull RbsTypeVariableReferenceSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if (signature.getReferenceType() == this.myReferenceType) {
                this.myTypeVariableTypes.putValue((Object)signature.getPosition(), (Object)this.myType);
            }
        }

        public void visitUnionTypeSignature(@NotNull RbsUnionTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            MultiMap typeVariableTypes = new MultiMap();
            signature.getTypeSignatures().forEach(it -> RbsRubyTypeVariableExtractor.extractTypeVariableTypes(this.myType, it, this.myReferenceType).toHashMap().forEach((key, values) -> {
                if (!typeVariableTypes.containsKey(key)) {
                    typeVariableTypes.putValues(key, values);
                }
            }));
            this.myTypeVariableTypes.putAllValues(typeVariableTypes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceType";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeVariableExtractor$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitOptionalTypeSignature";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitQualifiedNameTypeSignature";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSingletonTypeSignature";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTupleTypeSignature";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeVariableReferenceSignature";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnionTypeSignature";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

