/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.types;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerVariableSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsSymbol;
import com.intellij.lang.ruby.rbs.model.hierarchy.RbsContainerSymbolUtil;
import com.intellij.lang.ruby.rbs.model.impl.RbsConstantSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsGlobalVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInstanceVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureBinding;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureResolver;
import com.intellij.lang.ruby.rbs.psi.index.RbsMethodNamePropertiesIndex;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeUtil;
import com.intellij.model.Symbol;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.common.psi.data.RbsMethodTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsProcTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsQualifiedNameTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsSingletonTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsUnionTypeSignature;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RYieldStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyConstantSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyGlobalVariableSymbol;
import org.jetbrains.plugins.ruby.ruby.model.util.UtilKt;
import org.jetbrains.plugins.ruby.util.BiOptional;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RbsRubyTypeSignatureUtil {
    private static final Logger LOG = Logger.getInstance(RbsRubyTypeSignatureUtil.class);

    private RbsRubyTypeSignatureUtil() {
    }

    @NotNull
    public static BiOptional<CallContext, RbsProcTypeSignature> findBlockCallTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RBlockCall call) {
        String name;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(1);
        }
        if (call == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(2);
        }
        if ((name = RubyPsiUtil.getCallCommand((PsiElement)call)) == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(3);
            }
            return biOptional;
        }
        Set<RbsMethodNamePropertiesIndex.Property> properties = RbsMethodNamePropertiesIndex.getMethodProperties(project, searchScope, name);
        if (!properties.contains((Object)RbsMethodNamePropertiesIndex.Property.HAS_BLOCK_TYPE_SIGNATURE)) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(4);
            }
            return biOptional;
        }
        RType contextType = RTypeUtil.getTypeForReceiver((RPossibleCall)call);
        RbsContainerSymbol containerSymbol = RbsRubyTypeUtil.findContainerSymbolForRubyType(project, searchScope, contextType);
        if (containerSymbol == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(5);
            }
            return biOptional;
        }
        RbsMethodSymbol methodSymbol = containerSymbol.allChildren(project, searchScope).mapMulti(StreamUtil.select(RbsMethodSymbol.class, (Class[])new Class[0])).filter(child -> child.getName().equals(name)).findFirst().orElse(null);
        if (methodSymbol == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(6);
            }
            return biOptional;
        }
        Function<RbsTypeSignature, RbsTypeSignature> binding = containerSymbol.getTypeVariableBinding(project, searchScope).getOrDefault(methodSymbol.getContainerSymbol(), RbsTypeSignatureBinding.UNTYPED);
        RbsMethodTypeSignature matchingMethodTypeSignature = methodSymbol.getMethodTypeSignatures(project, searchScope).stream().map(signature -> signature.apply(binding).apply((Function)new RbsTypeSignatureResolver(project, searchScope))).collect(RbsRubyTypeUtil.matchingSignatures((RPossibleCall)call)).findFirst().orElse(null);
        if (matchingMethodTypeSignature == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(7);
            }
            return biOptional;
        }
        CallContext callContext = new CallContext(containerSymbol, methodSymbol, (RbsProcTypeSignature)matchingMethodTypeSignature);
        RbsProcTypeSignature matchingBlockTypeSignature = matchingMethodTypeSignature.getBlockTypeSignature();
        BiOptional biOptional = BiOptional.of((Object)callContext, (Object)matchingBlockTypeSignature);
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(8);
        }
        return biOptional;
    }

    @NotNull
    public static BiOptional<CallContext, RbsTypeSignature> findBlockParameterTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RBlockCall call, @NotNull RArgument parameter) {
        Set<RbsMethodNamePropertiesIndex.Property> properties;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(10);
        }
        if (call == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(11);
        }
        if (parameter == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(12);
        }
        if (!(properties = RbsMethodNamePropertiesIndex.getMethodProperties(project, searchScope, (String)ObjectUtils.coalesce((Object)RubyPsiUtil.getCallCommand((PsiElement)call), (Object)""))).contains((Object)RbsMethodNamePropertiesIndex.Property.HAS_BLOCK_TYPE_SIGNATURE_WITH_PARAMETERS)) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(13);
            }
            return biOptional;
        }
        BiOptional biOptional = RbsRubyTypeSignatureUtil.findBlockCallTypeSignature(project, searchScope, call).flatMap((context, signature) -> {
            List<ArgumentInfo> argumentInfos = Optional.ofNullable(call.getBlock().getBlockArguments()).map(RArgumentList::getArgumentInfos).orElse(Collections.emptyList());
            ArgumentInfo argumentInfo = parameter.getArgumentInfo();
            RbsTypeSignature matchingParameterTypeSignature = RbsRubyTypeUtil.findMatchingParameterTypeSignature(signature, argumentInfos, argumentInfo);
            return BiOptional.of((Object)context, (Object)matchingParameterTypeSignature);
        });
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(14);
        }
        return biOptional;
    }

    @NotNull
    public static BiOptional<CallContext, RbsTypeSignature> findBlockReturnTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RBlockCall call) {
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(15);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(16);
        }
        if (call == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(17);
        }
        BiOptional biOptional = RbsRubyTypeSignatureUtil.findBlockCallTypeSignature(project, searchScope, call).flatMap((context, signature) -> BiOptional.of((Object)context, (Object)signature.getReturnTypeSignature()));
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(18);
        }
        return biOptional;
    }

    @NotNull
    public static BiOptional<MethodContext, RbsTypeSignature> findCallArgumentTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RBinaryExpression expression, @NotNull RPsiElement argument) {
        RType contextType;
        RbsContainerSymbol containerSymbol;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(19);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(20);
        }
        if (expression == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(21);
        }
        if (argument == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(22);
        }
        if ((containerSymbol = RbsRubyTypeUtil.findContainerSymbolForRubyType(project, searchScope, contextType = RTypeUtil.getType((PsiElement)expression.getLeftOperand()))) == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(23);
            }
            return biOptional;
        }
        String command = expression.getOperation().getText();
        RbsMethodSymbol methodSymbol = containerSymbol.allChildren(project, searchScope).mapMulti(StreamUtil.select(RbsMethodSymbol.class, (Class[])new Class[0])).filter(child -> child.getName().equals(command)).mapMulti(RbsContainerSymbolUtil.inlineInitialize(project, searchScope, containerSymbol)).findFirst().orElse(null);
        if (methodSymbol == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(24);
            }
            return biOptional;
        }
        Function<RbsTypeSignature, RbsTypeSignature> binding = containerSymbol.getTypeVariableBinding(project, searchScope).getOrDefault(methodSymbol.getContainerSymbol(), RbsTypeSignatureBinding.UNTYPED);
        MethodContext methodContext = new MethodContext(containerSymbol, methodSymbol);
        RbsTypeSignature typeSignature = methodSymbol.getMethodTypeSignatures(project, searchScope).stream().map(signature -> signature.apply(binding).apply((Function)new RbsTypeSignatureResolver(project, searchScope))).collect(RbsRubyTypeUtil.matchingSignatures(expression, (PsiElement)argument)).flatMap(signature -> Stream.ofNullable(RbsRubyTypeUtil.findMatchingParameterTypeSignature((RbsProcTypeSignature)signature, List.of(argument), (PsiElement)argument))).reduce(RbsUnionTypeSignature::of).orElse(null);
        BiOptional biOptional = BiOptional.of((Object)methodContext, (Object)typeSignature);
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(25);
        }
        return biOptional;
    }

    @NotNull
    public static BiOptional<MethodContext, RbsTypeSignature> findCallArgumentTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RPossibleCall possibleCall, @NotNull PsiElement argument) {
        String command;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(26);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(27);
        }
        if (possibleCall == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(28);
        }
        if (argument == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(29);
        }
        if ((command = RubyPsiUtil.getCallCommandFollowingSuper((RPossibleCall)possibleCall)) == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(30);
            }
            return biOptional;
        }
        Set<RbsMethodNamePropertiesIndex.Property> properties = RbsMethodNamePropertiesIndex.getMethodProperties(project, searchScope, command);
        if (!properties.contains((Object)RbsMethodNamePropertiesIndex.Property.HAS_TYPE_SIGNATURE_WITH_PARAMETERS)) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(31);
            }
            return biOptional;
        }
        BiOptional<MethodContext, Stream<RbsProcTypeSignature>> procSignatures = RbsRubyTypeSignatureUtil.findMatchingCallTypeSignatures(project, searchScope, possibleCall, call -> RbsRubyTypeUtil.matchingSignatures(call, argument));
        if (procSignatures.isEmpty()) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(32);
            }
            return biOptional;
        }
        MethodContext methodContext = (MethodContext)procSignatures.getFirst();
        RbsTypeSignature typeSignature = ((Stream)procSignatures.getSecond()).flatMap(signature -> Stream.ofNullable(RbsRubyTypeUtil.findMatchingParameterTypeSignature(signature, RubyPsiUtil.getCallArgumentsIncludingIndexes((RPossibleCall)possibleCall), argument))).reduce(RbsUnionTypeSignature::of).orElse(null);
        BiOptional biOptional = BiOptional.of((Object)methodContext, (Object)typeSignature);
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(33);
        }
        return biOptional;
    }

    @NotNull
    public static BiOptional<MethodContext, RbsProcTypeSignature> findCallTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RPossibleCall call) {
        BiOptional<MethodContext, Stream<RbsProcTypeSignature>> matchingSignatures;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(34);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(35);
        }
        if (call == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(36);
        }
        if ((matchingSignatures = RbsRubyTypeSignatureUtil.findMatchingCallTypeSignatures(project, searchScope, call, RbsRubyTypeUtil::matchingSignatures)).isEmpty()) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(37);
            }
            return biOptional;
        }
        MethodContext methodContext = (MethodContext)matchingSignatures.getFirst();
        RbsProcTypeSignature procTypeSignature = ((Stream)matchingSignatures.getSecond()).findFirst().orElse(null);
        BiOptional biOptional = BiOptional.of((Object)methodContext, (Object)procTypeSignature);
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(38);
        }
        return biOptional;
    }

    @NotNull
    public static BiOptional<RbsSymbol, RbsTypeSignature> findConstantTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RConstant constant) {
        Fqn fqn;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(39);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(40);
        }
        if (constant == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(41);
        }
        if (UtilKt.isRubyModellingV2()) {
            RubyConstantSymbol symbol = (RubyConstantSymbol)ExtensionsKt.getSymbol((PsiElement)constant, RubyConstantSymbol.class);
            if (symbol == null) {
                BiOptional biOptional = BiOptional.empty();
                if (biOptional == null) {
                    RbsRubyTypeSignatureUtil.$$$reportNull$$$0(42);
                }
                return biOptional;
            }
            fqn = Fqn.of((FQN)symbol.getFqn());
        } else {
            fqn = Fqn.of((String)StringUtil.trimStart((String)constant.getFQNWithNesting().getFullPath(), (String)"Object::"), (String[])new String[0]);
        }
        RbsConstantSymbol constantSymbol = RbsConstantSymbol.find(project, searchScope, fqn).orElse(null);
        if (constantSymbol != null) {
            RbsTypeSignature typeSignature = constantSymbol.getTypeSignature(project, searchScope).apply((Function)new RbsTypeSignatureResolver(project, searchScope));
            BiOptional biOptional = BiOptional.of((Object)constantSymbol, (Object)typeSignature);
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(43);
            }
            return biOptional;
        }
        RbsContainerSymbol containerSymbol = RbsContainerSymbol.find(project, searchScope, fqn).mapMulti(RbsContainerSymbolUtil.followAliases(project, searchScope)).mapMulti(StreamUtil.select(RbsContainerSymbol.class, (Class[])new Class[0])).findAny().orElse(null);
        if (containerSymbol != null) {
            RbsSingletonTypeSignature typeSignature = new RbsSingletonTypeSignature((RbsTypeSignature)new RbsQualifiedNameTypeSignature(containerSymbol.getFqn()));
            BiOptional biOptional = BiOptional.of((Object)containerSymbol, (Object)typeSignature);
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(44);
            }
            return biOptional;
        }
        BiOptional biOptional = BiOptional.empty();
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(45);
        }
        return biOptional;
    }

    @NotNull
    public static BiOptional<RbsGlobalVariableSymbol, RbsTypeSignature> findGlobalVariableTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RubyGlobalVariableSymbol globalVariable) {
        RbsGlobalVariableSymbol globalVariableSymbol;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(46);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(47);
        }
        if (globalVariable == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(48);
        }
        if ((globalVariableSymbol = (RbsGlobalVariableSymbol)RbsGlobalVariableSymbol.find(project, searchScope, globalVariable.getName()).orElse(null)) == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(49);
            }
            return biOptional;
        }
        RbsTypeSignature globalVariableTypeSignature = globalVariableSymbol.getTypeSignature(project, searchScope).apply((Function)new RbsTypeSignatureResolver(project, searchScope));
        BiOptional biOptional = BiOptional.of((Object)globalVariableSymbol, (Object)globalVariableTypeSignature);
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(50);
        }
        return biOptional;
    }

    @NotNull
    public static BiOptional<RbsGlobalVariableSymbol, RbsTypeSignature> findGlobalVariableTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RGlobalVariable globalVariable) {
        String name;
        RbsGlobalVariableSymbol globalVariableSymbol;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(51);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(52);
        }
        if (globalVariable == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(53);
        }
        if ((globalVariableSymbol = (RbsGlobalVariableSymbol)RbsGlobalVariableSymbol.find(project, searchScope, name = StringUtil.notNullize((String)globalVariable.getName())).orElse(null)) == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(54);
            }
            return biOptional;
        }
        RbsTypeSignature globalVariableTypeSignature = globalVariableSymbol.getTypeSignature(project, searchScope).apply((Function)new RbsTypeSignatureResolver(project, searchScope));
        BiOptional biOptional = BiOptional.of((Object)globalVariableSymbol, (Object)globalVariableTypeSignature);
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(55);
        }
        return biOptional;
    }

    @NotNull
    public static BiOptional<RbsGlobalVariableSymbol, RbsTypeSignature> findGlobalVariableTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RAliasStatement alias) {
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(56);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(57);
        }
        if (alias == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(58);
        }
        LOG.assertTrue(alias.isGlobalVariableAlias(), (Object)"Trying to find a global variable type signature on an aliased method!");
        RPsiElement rPsiElement = alias.getPsiNewName();
        if (!(rPsiElement instanceof RGlobalVariable)) {
            LOG.warn("Alias statement does not contain a global variable!");
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(59);
            }
            return biOptional;
        }
        RGlobalVariable globalVariable = (RGlobalVariable)rPsiElement;
        return RbsRubyTypeSignatureUtil.findGlobalVariableTypeSignature(project, searchScope, globalVariable);
    }

    @NotNull
    public static BiOptional<MethodContext, RbsTypeSignature> findMethodParameterTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RMethod method, @NotNull RArgument parameter) {
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(60);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(61);
        }
        if (method == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(62);
        }
        if (parameter == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(63);
        }
        return RbsRubyTypeSignatureUtil.findMethodParameterTypeSignature(project, searchScope, method, parameter.getArgumentInfo());
    }

    @NotNull
    public static BiOptional<MethodContext, RbsTypeSignature> findMethodParameterTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RMethod method, @NotNull ArgumentInfo argumentInfo) {
        MethodContext methodContext;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(64);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(65);
        }
        if (method == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(66);
        }
        if (argumentInfo == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(67);
        }
        if ((methodContext = RbsRubyTypeSignatureUtil.getMethodContext(project, searchScope, (PsiElement)method, method.getName())) == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(68);
            }
            return biOptional;
        }
        List argumentInfos = method.getArgumentInfos();
        RbsTypeSignature parameterTypeSignature = RbsRubyTypeSignatureUtil.getParameterTypeSignature(project, searchScope, methodContext, argumentInfos, argumentInfo);
        BiOptional biOptional = BiOptional.of((Object)methodContext, (Object)parameterTypeSignature);
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(69);
        }
        return biOptional;
    }

    @NotNull
    public static BiOptional<MethodContext, RbsTypeSignature> findMethodParameterTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RMethodSymbol methodSymbol, @NotNull ArgumentInfo argumentInfo) {
        MethodContext methodContext;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(70);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(71);
        }
        if (methodSymbol == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(72);
        }
        if (argumentInfo == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(73);
        }
        if ((methodContext = RbsRubyTypeSignatureUtil.getMethodContext(project, searchScope, methodSymbol)) == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(74);
            }
            return biOptional;
        }
        List argumentInfos = (List)ObjectUtils.coalesce((Object)methodSymbol.getArgumentInfos(), Collections.emptyList());
        RbsTypeSignature parameterTypeSignature = RbsRubyTypeSignatureUtil.getParameterTypeSignature(project, searchScope, methodContext, argumentInfos, argumentInfo);
        BiOptional biOptional = BiOptional.of((Object)methodContext, (Object)parameterTypeSignature);
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(75);
        }
        return biOptional;
    }

    @NotNull
    public static BiOptional<MethodContext, RbsTypeSignature> findMethodReturnTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RMethodSymbol method) {
        PsiElement psiElement;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(76);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(77);
        }
        if (method == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(78);
        }
        if (!((psiElement = method.getPsiElement()) instanceof RMethod)) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(79);
            }
            return biOptional;
        }
        RMethod methodElement = (RMethod)psiElement;
        return RbsRubyTypeSignatureUtil.findMethodReturnTypeSignature(project, searchScope, methodElement);
    }

    @NotNull
    public static BiOptional<MethodContext, RbsTypeSignature> findMethodReturnTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RMethod method) {
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(80);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(81);
        }
        if (method == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(82);
        }
        return RbsRubyTypeSignatureUtil.internalFindMethodReturnTypeSignature(project, searchScope, (RPsiElement)method, method.getName());
    }

    @NotNull
    public static BiOptional<VariableContext, RbsTypeSignature> findVariableTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RCall call, @NotNull String name) {
        RbsContainerSymbol containerSymbol;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(83);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(84);
        }
        if (call == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(85);
        }
        if (name == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(86);
        }
        if ((containerSymbol = RbsRubyTypeUtil.findContainerSymbolForRubyElement(project, searchScope, (PsiElement)call)) == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(87);
            }
            return biOptional;
        }
        RbsInstanceVariableSymbol variableSymbol = containerSymbol.allChildren(project, searchScope).mapMulti(StreamUtil.select(RbsInstanceVariableSymbol.class, (Class[])new Class[0])).filter(child -> child.getName().equals(name)).findFirst().orElse(null);
        if (variableSymbol == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(88);
            }
            return biOptional;
        }
        Function<RbsTypeSignature, RbsTypeSignature> binding = containerSymbol.getTypeVariableBinding(project, searchScope).getOrDefault(variableSymbol.getContainerSymbol(), RbsTypeSignatureBinding.UNTYPED);
        VariableContext variableContext = new VariableContext(containerSymbol, variableSymbol);
        RbsTypeSignature variableTypeSignature = variableSymbol.getTypeSignature(project, searchScope).apply(binding).apply((Function)new RbsTypeSignatureResolver(project, searchScope));
        BiOptional biOptional = BiOptional.of((Object)variableContext, (Object)variableTypeSignature);
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(89);
        }
        return biOptional;
    }

    @NotNull
    public static BiOptional<VariableContext, RbsTypeSignature> findVariableTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RField field) {
        RbsContainerSymbol containerSymbol;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(90);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(91);
        }
        if (field == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(92);
        }
        if ((containerSymbol = RbsRubyTypeUtil.findContainerSymbolForRubyElement(project, searchScope, (PsiElement)field)) == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(93);
            }
            return biOptional;
        }
        String name = field.getPrefix() + field.getName();
        RbsContainerVariableSymbol variableSymbol = containerSymbol.allChildren(project, searchScope).mapMulti(StreamUtil.select(RbsContainerVariableSymbol.class, (Class[])new Class[0])).filter(child -> child.getFullName().equals(name)).findFirst().orElse(null);
        if (variableSymbol == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(94);
            }
            return biOptional;
        }
        Function<RbsTypeSignature, RbsTypeSignature> binding = containerSymbol.getTypeVariableBinding(project, searchScope).getOrDefault(variableSymbol.getContainerSymbol(), RbsTypeSignatureBinding.UNTYPED);
        VariableContext variableContext = new VariableContext(containerSymbol, variableSymbol);
        RbsTypeSignature variableTypeSignature = variableSymbol.getTypeSignature(project, searchScope).apply(binding).apply((Function)new RbsTypeSignatureResolver(project, searchScope));
        BiOptional biOptional = BiOptional.of((Object)variableContext, (Object)variableTypeSignature);
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(95);
        }
        return biOptional;
    }

    @NotNull
    public static BiOptional<MethodContext, RbsProcTypeSignature> findYieldTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RYieldStatement yield) {
        MethodContext methodContext;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(96);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(97);
        }
        if (yield == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(98);
        }
        if ((methodContext = RbsRubyTypeSignatureUtil.getMethodContext(project, searchScope, yield)) == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(99);
            }
            return biOptional;
        }
        RbsContainerSymbol containerSymbol = methodContext.getContainerSymbol();
        RbsMethodSymbol methodSymbol = methodContext.getSymbol();
        Function<RbsTypeSignature, RbsTypeSignature> binding = containerSymbol.getTypeVariableBinding(project, searchScope).getOrDefault(methodSymbol.getContainerSymbol(), RbsTypeSignatureBinding.UNTYPED);
        RbsProcTypeSignature typeSignature = methodSymbol.getMethodTypeSignatures(project, searchScope).stream().flatMap(signature -> Stream.ofNullable(signature.getBlockTypeSignature())).map(signature -> signature.apply(binding).apply((Function)new RbsTypeSignatureResolver(project, searchScope))).collect(RbsRubyTypeUtil.matchingSignatures((RPossibleCall)yield)).findFirst().orElse(null);
        BiOptional biOptional = BiOptional.of((Object)methodContext, (Object)typeSignature);
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(100);
        }
        return biOptional;
    }

    @NotNull
    public static BiOptional<MethodContext, RbsTypeSignature> findYieldArgumentTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RYieldStatement yield, @NotNull PsiElement argument) {
        MethodContext methodContext;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(101);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(102);
        }
        if (yield == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(103);
        }
        if (argument == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(104);
        }
        if ((methodContext = RbsRubyTypeSignatureUtil.getMethodContext(project, searchScope, yield)) == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(105);
            }
            return biOptional;
        }
        RbsContainerSymbol containerSymbol = methodContext.getContainerSymbol();
        RbsMethodSymbol methodSymbol = methodContext.getSymbol();
        Function<RbsTypeSignature, RbsTypeSignature> binding = containerSymbol.getTypeVariableBinding(project, searchScope).getOrDefault(methodSymbol.getContainerSymbol(), RbsTypeSignatureBinding.UNTYPED);
        RbsTypeSignature typeSignature = methodSymbol.getMethodTypeSignatures(project, searchScope).stream().flatMap(signature -> Stream.ofNullable(signature.getBlockTypeSignature())).map(signature -> signature.apply(binding).apply((Function)new RbsTypeSignatureResolver(project, searchScope))).collect(RbsRubyTypeUtil.matchingSignatures((RPossibleCall)yield, argument)).flatMap(signature -> Stream.ofNullable(RbsRubyTypeUtil.findMatchingParameterTypeSignature(signature, yield.getArguments(), argument))).reduce(RbsUnionTypeSignature::of).orElse(null);
        BiOptional biOptional = BiOptional.of((Object)methodContext, (Object)typeSignature);
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(106);
        }
        return biOptional;
    }

    @Nullable
    public static MethodContext getMethodContext(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RAliasStatement alias) {
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(107);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(108);
        }
        if (alias == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(109);
        }
        return RbsRubyTypeSignatureUtil.getMethodContext(project, searchScope, (PsiElement)alias, alias.getNewName());
    }

    @Nullable
    public static MethodContext getMethodContext(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RPossibleCall call) {
        String command;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(110);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(111);
        }
        if (call == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(112);
        }
        if ((command = RubyPsiUtil.getCallCommandFollowingSuper((RPossibleCall)call)) == null) {
            return null;
        }
        Set<RbsMethodNamePropertiesIndex.Property> properties = RbsMethodNamePropertiesIndex.getMethodProperties(project, searchScope, command);
        if (!properties.contains((Object)RbsMethodNamePropertiesIndex.Property.HAS_TYPE_SIGNATURE)) {
            return null;
        }
        RType contextType = RTypeUtil.getTypeForReceiver((RPossibleCall)call);
        RbsContainerSymbol containerSymbol = RbsRubyTypeUtil.findContainerSymbolForRubyType(project, searchScope, contextType);
        if (containerSymbol == null) {
            return null;
        }
        Stream<? extends Symbol> children = !RubyPsiUtil.isSuperCall((RPossibleCall)call) ? containerSymbol.allChildren(project, searchScope) : containerSymbol.superChildren(project, searchScope);
        RbsMethodSymbol methodSymbol = children.mapMulti(StreamUtil.select(RbsMethodSymbol.class, (Class[])new Class[0])).filter(child -> child.getName().equals(command)).mapMulti(RbsContainerSymbolUtil.inlineInitialize(project, searchScope, containerSymbol)).findFirst().orElse(null);
        if (methodSymbol == null) {
            return null;
        }
        return new MethodContext(containerSymbol, methodSymbol);
    }

    @Nullable
    public static MethodContext getMethodContext(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RMethod method) {
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(113);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(114);
        }
        if (method == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(115);
        }
        return RbsRubyTypeSignatureUtil.getMethodContext(project, searchScope, (PsiElement)method, method.getName());
    }

    @NotNull
    private static BiOptional<MethodContext, Stream<RbsProcTypeSignature>> findMatchingCallTypeSignatures(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RPossibleCall call, @NotNull Function<RPossibleCall, Collector<? super RbsMethodTypeSignature, ?, Stream<RbsProcTypeSignature>>> signatureMatcher) {
        MethodContext methodContext;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(116);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(117);
        }
        if (call == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(118);
        }
        if (signatureMatcher == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(119);
        }
        if ((methodContext = RbsRubyTypeSignatureUtil.getMethodContext(project, searchScope, call)) == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(120);
            }
            return biOptional;
        }
        RbsContainerSymbol containerSymbol = methodContext.getContainerSymbol();
        RbsMethodSymbol methodSymbol = methodContext.getSymbol();
        Function<RbsTypeSignature, RbsTypeSignature> binding = containerSymbol.getTypeVariableBinding(project, searchScope).getOrDefault(methodSymbol.getContainerSymbol(), RbsTypeSignatureBinding.UNTYPED);
        Stream<RbsProcTypeSignature> typeSignatures = methodSymbol.getMethodTypeSignatures(project, searchScope).stream().map(signature -> signature.apply(binding).apply((Function)new RbsTypeSignatureResolver(project, searchScope))).collect(signatureMatcher.apply(call));
        BiOptional biOptional = BiOptional.of((Object)methodContext, typeSignatures);
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(121);
        }
        return biOptional;
    }

    @Nullable
    private static RbsTypeSignature getParameterTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull MethodContext methodContext, @NotNull List<ArgumentInfo> argumentInfos, @NotNull ArgumentInfo argumentInfo) {
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(122);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(123);
        }
        if (methodContext == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(124);
        }
        if (argumentInfos == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(125);
        }
        if (argumentInfo == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(126);
        }
        Function<RbsTypeSignature, RbsTypeSignature> binding = methodContext.getContainerSymbol().getTypeVariableBinding(project, searchScope).getOrDefault(methodContext.getSymbol().getContainerSymbol(), RbsTypeSignatureBinding.UNTYPED);
        return methodContext.getSymbol().getMethodTypeSignatures(project, searchScope).stream().map(signature -> signature.apply(binding).apply((Function)new RbsTypeSignatureResolver(project, searchScope))).flatMap(signature -> Stream.ofNullable(RbsRubyTypeUtil.findMatchingParameterTypeSignature((RbsProcTypeSignature)signature, argumentInfos, argumentInfo))).reduce(RbsUnionTypeSignature::of).orElse(null);
    }

    @NotNull
    private static BiOptional<MethodContext, RbsTypeSignature> internalFindMethodReturnTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RPsiElement element, @Nullable String methodName) {
        MethodContext methodContext;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(127);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(128);
        }
        if (element == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(129);
        }
        if ((methodContext = RbsRubyTypeSignatureUtil.getMethodContext(project, searchScope, (PsiElement)element, methodName)) == null) {
            BiOptional biOptional = BiOptional.empty();
            if (biOptional == null) {
                RbsRubyTypeSignatureUtil.$$$reportNull$$$0(130);
            }
            return biOptional;
        }
        RbsContainerSymbol containerSymbol = methodContext.getContainerSymbol();
        RbsMethodSymbol methodSymbol = methodContext.getSymbol();
        Function<RbsTypeSignature, RbsTypeSignature> binding = containerSymbol.getTypeVariableBinding(project, searchScope).getOrDefault(methodSymbol.getContainerSymbol(), RbsTypeSignatureBinding.UNTYPED);
        RbsTypeSignature returnTypeSignature = methodSymbol.getMethodTypeSignatures(project, searchScope).stream().map(signature -> signature.apply(binding).apply((Function)new RbsTypeSignatureResolver(project, searchScope))).map(RbsProcTypeSignature::getReturnTypeSignature).reduce(RbsUnionTypeSignature::of).orElse(null);
        BiOptional biOptional = BiOptional.of((Object)methodContext, (Object)returnTypeSignature);
        if (biOptional == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(131);
        }
        return biOptional;
    }

    @Nullable
    private static MethodContext getMethodContext(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RMethodSymbol methodSymbol) {
        PsiElement psiElement;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(132);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(133);
        }
        if (methodSymbol == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(134);
        }
        if (!((psiElement = methodSymbol.getPsiElement()) instanceof RPsiElement)) {
            return null;
        }
        RPsiElement element = (RPsiElement)psiElement;
        return RbsRubyTypeSignatureUtil.getMethodContext(project, searchScope, (PsiElement)element, methodSymbol.getName());
    }

    @Nullable
    private static MethodContext getMethodContext(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull PsiElement element, @Nullable String methodName) {
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(135);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(136);
        }
        if (element == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(137);
        }
        if (methodName == null) {
            return null;
        }
        RbsContainerSymbol containerSymbol = RbsRubyTypeUtil.findContainerSymbolForRubyElement(project, searchScope, element);
        if (containerSymbol == null) {
            return null;
        }
        RbsMethodSymbol methodSymbol = containerSymbol.allChildren(project, searchScope).mapMulti(StreamUtil.select(RbsMethodSymbol.class, (Class[])new Class[0])).filter(child -> child.getName().equals(methodName)).findFirst().orElse(null);
        if (methodSymbol == null) {
            return null;
        }
        return new MethodContext(containerSymbol, methodSymbol);
    }

    @Nullable
    private static MethodContext getMethodContext(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RYieldStatement yield) {
        RMethod method;
        if (project == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(138);
        }
        if (searchScope == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(139);
        }
        if (yield == null) {
            RbsRubyTypeSignatureUtil.$$$reportNull$$$0(140);
        }
        if ((method = (RMethod)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)yield, RMethod.class)) == null) {
            return null;
        }
        RbsContainerSymbol containerSymbol = RbsRubyTypeUtil.findContainerSymbolForRubyElement(project, searchScope, (PsiElement)method);
        if (containerSymbol == null) {
            return null;
        }
        RbsMethodSymbol methodSymbol = containerSymbol.allChildren(project, searchScope).mapMulti(StreamUtil.select(RbsMethodSymbol.class, (Class[])new Class[0])).filter(it -> it.getName().equals(method.getName())).findFirst().orElse(null);
        if (methodSymbol == null) {
            return null;
        }
        return new MethodContext(containerSymbol, methodSymbol);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 13, 14, 18, 23, 24, 25, 30, 31, 32, 33, 37, 38, 42, 43, 44, 45, 49, 50, 54, 55, 59, 68, 69, 74, 75, 79, 87, 88, 89, 93, 94, 95, 99, 100, 105, 106, 120, 121, 130, 131 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 16: 
            case 20: 
            case 27: 
            case 35: 
            case 40: 
            case 47: 
            case 52: 
            case 57: 
            case 61: 
            case 65: 
            case 71: 
            case 77: 
            case 81: 
            case 84: 
            case 91: 
            case 97: 
            case 102: 
            case 108: 
            case 111: 
            case 114: 
            case 117: 
            case 123: 
            case 128: 
            case 133: 
            case 136: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 11: 
            case 17: 
            case 36: 
            case 85: 
            case 112: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 59: 
            case 68: 
            case 69: 
            case 74: 
            case 75: 
            case 79: 
            case 87: 
            case 88: 
            case 89: 
            case 93: 
            case 94: 
            case 95: 
            case 99: 
            case 100: 
            case 105: 
            case 106: 
            case 120: 
            case 121: 
            case 130: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeSignatureUtil";
                break;
            }
            case 12: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 22: 
            case 29: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVariable";
                break;
            }
            case 58: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 62: 
            case 66: 
            case 78: 
            case 82: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 67: 
            case 73: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentInfo";
                break;
            }
            case 72: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSymbol";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 98: 
            case 103: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yield";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureMatcher";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodContext";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentInfos";
                break;
            }
            case 129: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeSignatureUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findBlockCallTypeSignature";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findBlockParameterTypeSignature";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findBlockReturnTypeSignature";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "findCallArgumentTypeSignature";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "findCallTypeSignature";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "findConstantTypeSignature";
                break;
            }
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "findGlobalVariableTypeSignature";
                break;
            }
            case 68: 
            case 69: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodParameterTypeSignature";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodReturnTypeSignature";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "findVariableTypeSignature";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "findYieldTypeSignature";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "findYieldArgumentTypeSignature";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatchingCallTypeSignatures";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "internalFindMethodReturnTypeSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findBlockCallTypeSignature";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 59: 
            case 68: 
            case 69: 
            case 74: 
            case 75: 
            case 79: 
            case 87: 
            case 88: 
            case 89: 
            case 93: 
            case 94: 
            case 95: 
            case 99: 
            case 100: 
            case 105: 
            case 106: 
            case 120: 
            case 121: 
            case 130: 
            case 131: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findBlockParameterTypeSignature";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findBlockReturnTypeSignature";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findCallArgumentTypeSignature";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findCallTypeSignature";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findConstantTypeSignature";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findGlobalVariableTypeSignature";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "findMethodParameterTypeSignature";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "findMethodReturnTypeSignature";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "findVariableTypeSignature";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "findYieldTypeSignature";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "findYieldArgumentTypeSignature";
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "getMethodContext";
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingCallTypeSignatures";
                break;
            }
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeSignature";
                break;
            }
            case 127: 
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "internalFindMethodReturnTypeSignature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 13, 14, 18, 23, 24, 25, 30, 31, 32, 33, 37, 38, 42, 43, 44, 45, 49, 50, 54, 55, 59, 68, 69, 74, 75, 79, 87, 88, 89, 93, 94, 95, 99, 100, 105, 106, 120, 121, 130, 131 -> new IllegalStateException(string);
        };
    }

    public static final class CallContext {
        private final RbsContainerSymbol myContainerSymbol;
        private final RbsMethodSymbol mySymbol;
        private final RbsProcTypeSignature myMatchingTypeSignature;

        private CallContext(@NotNull RbsContainerSymbol containerSymbol, @NotNull RbsMethodSymbol symbol, @NotNull RbsProcTypeSignature matchingTypeSignature) {
            if (containerSymbol == null) {
                CallContext.$$$reportNull$$$0(0);
            }
            if (symbol == null) {
                CallContext.$$$reportNull$$$0(1);
            }
            if (matchingTypeSignature == null) {
                CallContext.$$$reportNull$$$0(2);
            }
            this.myContainerSymbol = containerSymbol;
            this.mySymbol = symbol;
            this.myMatchingTypeSignature = matchingTypeSignature;
        }

        @NotNull
        public RbsContainerSymbol getContainerSymbol() {
            RbsContainerSymbol rbsContainerSymbol = this.myContainerSymbol;
            if (rbsContainerSymbol == null) {
                CallContext.$$$reportNull$$$0(3);
            }
            return rbsContainerSymbol;
        }

        @NotNull
        public RbsProcTypeSignature getMatchingTypeSignature() {
            RbsProcTypeSignature rbsProcTypeSignature = this.myMatchingTypeSignature;
            if (rbsProcTypeSignature == null) {
                CallContext.$$$reportNull$$$0(4);
            }
            return rbsProcTypeSignature;
        }

        @NotNull
        public RbsMethodSymbol getSymbol() {
            RbsMethodSymbol rbsMethodSymbol = this.mySymbol;
            if (rbsMethodSymbol == null) {
                CallContext.$$$reportNull$$$0(5);
            }
            return rbsMethodSymbol;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containerSymbol";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchingTypeSignature";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeSignatureUtil$CallContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeSignatureUtil$CallContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainerSymbol";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatchingTypeSignature";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSymbol";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static final class MethodContext {
        private final RbsContainerSymbol myContainerSymbol;
        private final RbsMethodSymbol mySymbol;

        private MethodContext(@NotNull RbsContainerSymbol containerSymbol, @NotNull RbsMethodSymbol symbol) {
            if (containerSymbol == null) {
                MethodContext.$$$reportNull$$$0(0);
            }
            if (symbol == null) {
                MethodContext.$$$reportNull$$$0(1);
            }
            this.myContainerSymbol = containerSymbol;
            this.mySymbol = symbol;
        }

        @NotNull
        public RbsContainerSymbol getContainerSymbol() {
            RbsContainerSymbol rbsContainerSymbol = this.myContainerSymbol;
            if (rbsContainerSymbol == null) {
                MethodContext.$$$reportNull$$$0(2);
            }
            return rbsContainerSymbol;
        }

        @NotNull
        public RbsMethodSymbol getSymbol() {
            RbsMethodSymbol rbsMethodSymbol = this.mySymbol;
            if (rbsMethodSymbol == null) {
                MethodContext.$$$reportNull$$$0(3);
            }
            return rbsMethodSymbol;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containerSymbol";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeSignatureUtil$MethodContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeSignatureUtil$MethodContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainerSymbol";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSymbol";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class VariableContext {
        private final RbsContainerSymbol myContainerSymbol;
        private final RbsContainerVariableSymbol mySymbol;

        private VariableContext(@NotNull RbsContainerSymbol containerSymbol, @NotNull RbsContainerVariableSymbol symbol) {
            if (containerSymbol == null) {
                VariableContext.$$$reportNull$$$0(0);
            }
            if (symbol == null) {
                VariableContext.$$$reportNull$$$0(1);
            }
            this.myContainerSymbol = containerSymbol;
            this.mySymbol = symbol;
        }

        @NotNull
        public RbsContainerSymbol getContainerSymbol() {
            RbsContainerSymbol rbsContainerSymbol = this.myContainerSymbol;
            if (rbsContainerSymbol == null) {
                VariableContext.$$$reportNull$$$0(2);
            }
            return rbsContainerSymbol;
        }

        @NotNull
        public RbsContainerVariableSymbol getSymbol() {
            RbsContainerVariableSymbol rbsContainerVariableSymbol = this.mySymbol;
            if (rbsContainerVariableSymbol == null) {
                VariableContext.$$$reportNull$$$0(3);
            }
            return rbsContainerVariableSymbol;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containerSymbol";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeSignatureUtil$VariableContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeSignatureUtil$VariableContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainerSymbol";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSymbol";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

