/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.types;

import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeSignaturePresenter;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ruby.rbs.common.psi.data.RbsIntersectionTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsOptionalTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsProcTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsQualifiedNameReferenceSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsQualifiedNameTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsRecordTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsSingletonTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsSymbolLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTupleTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignatureVisitor;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeVariableReferenceSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsUnionTypeSignature;
import com.intellij.ruby.rbs.common.util.RbsNamingConventionUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RIntersectionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RUnionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RFrozenType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RProcType;

class RbsRubyTypeSignaturePresentationVisitor
implements RbsTypeSignatureVisitor {
    private final List<RType> myContainerTypeVariableTypes;
    private final List<RType> myLocalTypeVariableTypes;
    @NlsSafe
    @Nullable
    protected String myText;

    RbsRubyTypeSignaturePresentationVisitor(@NotNull List<RType> containerTypeVariableTypes, @NotNull List<RType> localTypeVariableTypes) {
        if (containerTypeVariableTypes == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(0);
        }
        if (localTypeVariableTypes == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(1);
        }
        this.myContainerTypeVariableTypes = List.copyOf(containerTypeVariableTypes);
        this.myLocalTypeVariableTypes = List.copyOf(localTypeVariableTypes);
    }

    @Nullable
    String getResult() {
        return this.myText;
    }

    public void visitIntersectionTypeSignature(@NotNull RbsIntersectionTypeSignature signature) {
        if (signature == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(2);
        }
        this.myText = signature.getTypeSignatures().stream().map(it -> this.isParenthesesRequired((RbsTypeSignature)it) ? String.format("(%s)", this.getPresentableText((RbsTypeSignature)it)) : this.getPresentableText((RbsTypeSignature)it)).collect(Collectors.joining(" & "));
    }

    public void visitOptionalTypeSignature(@NotNull RbsOptionalTypeSignature signature) {
        if (signature == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(3);
        }
        this.myText = this.isParenthesesRequired(signature.getTypeSignature()) ? String.format("(%s)?", this.getPresentableText(signature.getTypeSignature())) : String.format("%s?", this.getPresentableText(signature.getTypeSignature()));
    }

    public void visitProcTypeSignature(@NotNull RbsProcTypeSignature signature) {
        if (signature == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(4);
        }
        String parametersText = signature.hasUntypedParameters() ? "?" : StringUtil.join((Collection)signature.getParameters(), this::getPresentableText, (String)", ");
        String returnText = this.getPresentableText(signature.getReturnTypeSignature());
        RbsProcTypeSignature blockTypeSignature = signature.getBlockTypeSignature();
        if (blockTypeSignature != null) {
            String blockOptionalMarker = signature.isBlockOptional() ? "?" : "";
            String blockText = this.getPresentableText((RbsTypeSignature)blockTypeSignature);
            this.myText = String.format("(%s) %s{ %s } -> %s", parametersText, blockOptionalMarker, blockText, returnText);
        } else {
            this.myText = String.format("(%s) -> %s", parametersText, returnText);
        }
    }

    public void visitQualifiedNameReferenceSignature(@NotNull RbsQualifiedNameReferenceSignature signature) {
        if (signature == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(5);
        }
        if (!signature.getTypeArgumentSignatures().isEmpty()) {
            String typeArgumentsText = StringUtil.join((Collection)signature.getTypeArgumentSignatures(), this::getPresentableText, (String)", ");
            this.myText = String.format("%s[%s]", signature.getQualifiedName(), typeArgumentsText);
        } else {
            this.myText = signature.getQualifiedName();
        }
    }

    public void visitQualifiedNameTypeSignature(@NotNull RbsQualifiedNameTypeSignature signature) {
        if (signature == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(6);
        }
        if (!signature.getTypeArgumentSignatures().isEmpty()) {
            String typeArgumentsText = StringUtil.join((Collection)signature.getTypeArgumentSignatures(), this::getPresentableText, (String)", ");
            this.myText = String.format("%s[%s]", signature.getFqn().join(), typeArgumentsText);
        } else {
            this.myText = signature.getFqn().join();
        }
    }

    public void visitRecordTypeSignature(@NotNull RbsRecordTypeSignature signature) {
        List fields;
        if (signature == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(7);
        }
        if ((fields = signature.getFields()).isEmpty()) {
            this.myText = "{}";
            return;
        }
        this.myText = fields.stream().map(field -> {
            RbsSymbolLiteralSignature literal;
            String text;
            RbsLiteralSignature key = field.getKeyTypeSignature();
            String keyText = key instanceof RbsSymbolLiteralSignature ? (RbsNamingConventionUtils.isValidSymbolName((String)(":" + (text = (literal = (RbsSymbolLiteralSignature)key).getLiteral()))) ? "%s:".formatted(text) : (!text.contains("`") ? "`%s`:".formatted(text) : "%s =>".formatted(this.getPresentableText((RbsTypeSignature)key)))) : "%s =>".formatted(this.getPresentableText((RbsTypeSignature)key));
            String valueText = this.getPresentableText(field.getValueTypeSignature());
            return switch (field.getFieldType()) {
                default -> throw new MatchException(null, null);
                case RbsRecordTypeSignature.FieldType.OPTIONAL -> String.format("?%s %s", keyText, valueText);
                case RbsRecordTypeSignature.FieldType.REQUIRED -> String.format("%s %s", keyText, valueText);
            };
        }).collect(Collectors.joining(", ", "{ ", " }"));
    }

    public void visitSingletonTypeSignature(@NotNull RbsSingletonTypeSignature signature) {
        if (signature == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(8);
        }
        this.myText = String.format("singleton(%s)", this.getPresentableText(signature.getTypeSignature()));
    }

    public void visitTupleTypeSignature(@NotNull RbsTupleTypeSignature signature) {
        if (signature == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(9);
        }
        this.myText = !signature.getTypeSignatures().isEmpty() ? String.format("[%s]", StringUtil.join((Collection)signature.getTypeSignatures(), this::getPresentableText, (String)", ")) : "[ ]";
    }

    public void visitTypeSignature(@NotNull RbsTypeSignature signature) {
        if (signature == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(10);
        }
        this.myText = signature.toString();
    }

    public void visitTypeVariableReferenceSignature(@NotNull RbsTypeVariableReferenceSignature signature) {
        if (signature == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(11);
        }
        int position = signature.getPosition();
        switch (signature.getReferenceType()) {
            case CONTAINER_VARIABLE: {
                if (position >= this.myContainerTypeVariableTypes.size()) break;
                this.myText = RFrozenType.clearFrozenStatus((RType)this.myContainerTypeVariableTypes.get(position)).getPresentableName();
                break;
            }
            case METHOD_VARIABLE: 
            case TYPE_ALIAS_VARIABLE: {
                if (position >= this.myLocalTypeVariableTypes.size()) break;
                this.myText = RFrozenType.clearFrozenStatus((RType)this.myLocalTypeVariableTypes.get(position)).getPresentableName();
            }
        }
        if (this.myText == null) {
            this.myText = signature.getName();
        }
    }

    public void visitUnionTypeSignature(@NotNull RbsUnionTypeSignature signature) {
        if (signature == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(12);
        }
        this.myText = signature.getTypeSignatures().stream().map(it -> this.isParenthesesRequired((RbsTypeSignature)it) ? String.format("(%s)", this.getPresentableText((RbsTypeSignature)it)) : this.getPresentableText((RbsTypeSignature)it)).collect(Collectors.joining(" | "));
    }

    @NotNull
    protected String getPresentableText(@NotNull RbsTypeSignature signature) {
        if (signature == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(13);
        }
        String string = RbsRubyTypeSignaturePresenter.getPresentableText(this.myContainerTypeVariableTypes, this.myLocalTypeVariableTypes, signature);
        if (string == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    protected String getPresentableText(@NotNull RbsProcTypeSignature.Parameter parameter) {
        if (parameter == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(15);
        }
        String string = RbsRubyTypeSignaturePresenter.getPresentableText(this.myContainerTypeVariableTypes, this.myLocalTypeVariableTypes, parameter);
        if (string == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(16);
        }
        return string;
    }

    private boolean isParenthesesRequired(@NotNull RbsTypeSignature signature) {
        if (signature == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(17);
        }
        if (signature instanceof RbsIntersectionTypeSignature || signature instanceof RbsProcTypeSignature || signature instanceof RbsUnionTypeSignature) {
            return true;
        }
        if (signature instanceof RbsTypeVariableReferenceSignature) {
            RbsTypeVariableReferenceSignature referenceSignature = (RbsTypeVariableReferenceSignature)signature;
            int position = referenceSignature.getPosition();
            if (referenceSignature.getReferenceType() == RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE) {
                if (position < this.myContainerTypeVariableTypes.size()) {
                    return RbsRubyTypeSignaturePresentationVisitor.isParenthesesRequired(this.myContainerTypeVariableTypes.get(position));
                }
            } else if (position < this.myLocalTypeVariableTypes.size()) {
                return RbsRubyTypeSignaturePresentationVisitor.isParenthesesRequired(this.myLocalTypeVariableTypes.get(position));
            }
        }
        return false;
    }

    private static boolean isParenthesesRequired(@NotNull RType type) {
        if (type == null) {
            RbsRubyTypeSignaturePresentationVisitor.$$$reportNull$$$0(18);
        }
        return type instanceof RIntersectionType || type instanceof RProcType || type instanceof RUnionType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerTypeVariableTypes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTypeVariableTypes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeSignaturePresentationVisitor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeSignaturePresentationVisitor";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitIntersectionTypeSignature";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitOptionalTypeSignature";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitProcTypeSignature";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitQualifiedNameReferenceSignature";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitQualifiedNameTypeSignature";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitRecordTypeSignature";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitSingletonTypeSignature";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitTupleTypeSignature";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeSignature";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeVariableReferenceSignature";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitUnionTypeSignature";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 14: 
            case 16: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isParenthesesRequired";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 16 -> new IllegalStateException(string);
        };
    }
}

