/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.types;

import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureResolver;
import com.intellij.lang.ruby.rbs.ruby.codeInsight.types.RbsRubyAliasType;
import com.intellij.lang.ruby.rbs.ruby.codeInsight.types.RbsRubyInterfaceType;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeVariableExtractor;
import com.intellij.lang.ruby.rbs.util.RbsFqns;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.psi.data.RbsBooleanLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsIntegerLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsIntersectionTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsKeywordTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsNilLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsOptionalTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsProcTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsQualifiedNameTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsRecordTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsSingletonTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsStringLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsSymbolLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTupleTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignatureVisitor;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeVariableReferenceSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsUnionTypeSignature;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeWithNilability;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RIntersectionTypeImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RProcType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RUnionTypeImpl;

public final class RbsRubyTypeConverter {
    private RbsRubyTypeConverter() {
    }

    @Nullable
    public static RTypeWithNilability convert(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsTypeSignature signature, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(1);
        }
        if (signature == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(2);
        }
        return RbsRubyTypeConverter.convert(project, searchScope, null, Collections.emptyList(), Collections.emptyList(), signature, invocationPoint);
    }

    @Nullable
    public static RTypeWithNilability convert(@NotNull Project project, @NotNull SearchScope searchScope, @Nullable RType contextType, @NotNull RbsTypeSignature signature, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(4);
        }
        if (signature == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(5);
        }
        List<RTypeWithNilability> containerTypeVariableTypes = RbsRubyTypeVariableExtractor.getTypeArguments(new RTypeWithNilability((RType)ObjectUtils.coalesce((Object)contextType, (Object)REmptyType.INSTANCE)));
        return RbsRubyTypeConverter.convert(project, searchScope, contextType, containerTypeVariableTypes, Collections.emptyList(), signature, invocationPoint);
    }

    @Nullable
    public static RTypeWithNilability convert(@NotNull Project project, @NotNull SearchScope searchScope, @Nullable RType contextType, @NotNull List<RTypeWithNilability> containerTypeVariableTypes, @NotNull List<RTypeWithNilability> localTypeVariableTypes, @NotNull RbsTypeSignature signature, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(7);
        }
        if (containerTypeVariableTypes == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(8);
        }
        if (localTypeVariableTypes == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(9);
        }
        if (signature == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(10);
        }
        return RbsRubyTypeConverter.convert(project, searchScope, contextType, containerTypeVariableTypes, localTypeVariableTypes, Collections.emptySet(), signature, invocationPoint);
    }

    @Nullable
    private static RTypeWithNilability convert(@NotNull Project project, @NotNull SearchScope searchScope, @Nullable RType contextType, @NotNull List<RTypeWithNilability> containerTypeVariableTypes, @NotNull List<RTypeWithNilability> localTypeVariableTypes, @NotNull Set<RbsTypeAliasSymbol> visitedTypeAliasSymbols, @NotNull RbsTypeSignature signature, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(11);
        }
        if (searchScope == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(12);
        }
        if (containerTypeVariableTypes == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(13);
        }
        if (localTypeVariableTypes == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(14);
        }
        if (visitedTypeAliasSymbols == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(15);
        }
        if (signature == null) {
            RbsRubyTypeConverter.$$$reportNull$$$0(16);
        }
        MyVisitor visitor = new MyVisitor(project, searchScope, contextType, containerTypeVariableTypes, localTypeVariableTypes, visitedTypeAliasSymbols, invocationPoint);
        signature.accept((RbsTypeSignatureVisitor)visitor);
        return (RTypeWithNilability)ObjectUtils.doIfNotNull((Object)visitor.myType, type -> new RTypeWithNilability(type, visitor.myCanBeNil));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[0] = "searchScope";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[0] = "signature";
                break;
            }
            case 8: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[0] = "containerTypeVariableTypes";
                break;
            }
            case 9: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[0] = "localTypeVariableTypes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[0] = "visitedTypeAliasSymbols";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeConverter";
        objectArray[2] = "convert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyVisitor
    implements RbsTypeSignatureVisitor {
        private final Project myProject;
        private final SearchScope mySearchScope;
        @Nullable
        private final RType myContextType;
        private final List<RTypeWithNilability> myContainerTypeVariableTypes;
        private final List<RTypeWithNilability> myLocalTypeVariableTypes;
        private final Set<RbsTypeAliasSymbol> myVisitedTypeAliasSymbols;
        @Nullable
        private final PsiElement myInvocationPoint;
        private RType myType;
        private ThreeState myCanBeNil;

        private MyVisitor(@NotNull Project project, @NotNull SearchScope searchScope, @Nullable RType contextType, @NotNull List<RTypeWithNilability> containerTypeVariableTypes, @NotNull List<RTypeWithNilability> localTypeVariableTypes, @NotNull Set<RbsTypeAliasSymbol> visitedTypeAliasSymbols, @Nullable PsiElement invocationPoint) {
            if (project == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (searchScope == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if (containerTypeVariableTypes == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if (localTypeVariableTypes == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if (visitedTypeAliasSymbols == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            this.myCanBeNil = ThreeState.NO;
            this.myProject = project;
            this.mySearchScope = searchScope;
            this.myContextType = contextType;
            this.myContainerTypeVariableTypes = List.copyOf(containerTypeVariableTypes);
            this.myLocalTypeVariableTypes = List.copyOf(localTypeVariableTypes);
            this.myVisitedTypeAliasSymbols = new HashSet<RbsTypeAliasSymbol>(visitedTypeAliasSymbols);
            this.myInvocationPoint = invocationPoint;
        }

        public void visitBooleanLiteralSignature(@NotNull RbsBooleanLiteralSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            this.myType = signature.getLiteral() ? RTypeFactory.createTrueType((Project)this.myProject) : RTypeFactory.createFalseType((Project)this.myProject);
        }

        public void visitIntegerLiteralSignature(@NotNull RbsIntegerLiteralSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            this.myType = RTypeFactory.createIntType((Project)this.myProject);
        }

        public void visitIntersectionTypeSignature(@NotNull RbsIntersectionTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            List typeWithNilabilities = ContainerUtil.mapNotNull((Collection)signature.getTypeSignatures(), this::convert);
            boolean hasEmptyType = ContainerUtil.or((Iterable)typeWithNilabilities, it -> it.getType() == REmptyType.INSTANCE);
            typeWithNilabilities.stream().reduce(RTypeWithNilability::intersect).ifPresent(it -> {
                this.myType = hasEmptyType && it.getType() != REmptyType.INSTANCE ? RIntersectionTypeImpl.create((List)ContainerUtil.append((List)RTypeUtil.flattenUnionAndIntersectionType((RType)it.getType()), (Object[])new RType[]{REmptyType.INSTANCE})) : it.getType();
                this.myCanBeNil = it.getCanBeNil();
            });
        }

        public void visitKeywordTypeSignature(@NotNull RbsKeywordTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            Symbol symbol = RTypeUtilCore.getBirthTypeSymbol((RType)this.myContextType);
            switch (signature) {
                case BOOL: {
                    this.myType = RTypeFactory.createBoolType((Project)this.myProject);
                    break;
                }
                case CLASS: {
                    if (symbol == null) break;
                    this.myType = RTypeFactory.createTypeBySymbol((Symbol)symbol.getSingletonClassSymbol());
                    break;
                }
                case INSTANCE: {
                    if (symbol instanceof SingletonClassSymbol) {
                        this.myType = RTypeFactory.createTypeBySymbol((Symbol)((SingletonClassSymbol)symbol).getOriginSymbol());
                        break;
                    }
                    this.myType = this.myContextType;
                    break;
                }
                case SELF: {
                    this.myType = this.myContextType;
                }
            }
        }

        public void visitNilLiteralSignature(@NotNull RbsNilLiteralSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            this.myType = REmptyType.INSTANCE;
            this.myCanBeNil = ThreeState.YES;
        }

        public void visitOptionalTypeSignature(@NotNull RbsOptionalTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            signature.getTypeSignature().accept((RbsTypeSignatureVisitor)this);
            this.myCanBeNil = ThreeState.YES;
        }

        public void visitProcTypeSignature(@NotNull RbsProcTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(11);
            }
            ArrayList<RProcType.Parameter> parameters = new ArrayList<RProcType.Parameter>();
            for (RbsProcTypeSignature.Parameter parameter : signature.getParameters()) {
                RProcType.ParameterType parameterType = RProcType.ParameterType.valueOf((String)parameter.getParameterType().name());
                RType type = (RType)ObjectUtils.coalesce((Object)this.convertWithoutNilability(parameter.getTypeSignature()), (Object)REmptyType.INSTANCE);
                parameters.add(new RProcType.Parameter(parameterType, parameter.getName(), type));
            }
            RProcType blockType = (RProcType)ObjectUtils.tryCast((Object)ObjectUtils.doIfNotNull((Object)signature.getBlockTypeSignature(), this::convertWithoutNilability), RProcType.class);
            RType returnType = (RType)ObjectUtils.coalesce((Object)this.convertWithoutNilability(signature.getReturnTypeSignature()), (Object)REmptyType.INSTANCE);
            this.myType = signature.hasUntypedParameters() ? new RProcType(this.myProject, true, returnType) : new RProcType(this.myProject, parameters, blockType, returnType);
        }

        public void visitQualifiedNameTypeSignature(@NotNull RbsQualifiedNameTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(12);
            }
            this.myCanBeNil = ThreeState.fromBoolean((boolean)signature.getFqn().isEquivalentTo(RbsFqns.NIL_CLASS_FQN));
            Fqn fqn = signature.getFqn();
            List typeArguments = signature.getTypeArgumentSignatures().stream().map(this::convert).map(it -> (RTypeWithNilability)ObjectUtils.coalesce((Object)it, (Object)RTypeWithNilability.EMPTY)).collect(Collectors.toList());
            if (signature.isInterfaceReference()) {
                RbsInterfaceSymbol.find(this.myProject, this.mySearchScope, fqn).ifPresent(symbol -> {
                    this.myType = new RbsRubyInterfaceType(this.myProject, (RbsInterfaceSymbol)symbol, typeArguments);
                });
            } else if (signature.isTypeAliasReference()) {
                String name = fqn.join();
                RbsTypeAliasSymbol.find(this.myProject, this.mySearchScope, fqn).filter(this.myVisitedTypeAliasSymbols::add).map(symbol -> symbol.getTypeSignature(this.myProject, this.mySearchScope).apply((Function)new RbsTypeSignatureResolver(this.myProject, this.mySearchScope))).map(it -> this.convert((RbsTypeSignature)it, typeArguments)).ifPresent(type -> {
                    this.myType = new RbsRubyAliasType(type.getType(), name, typeArguments);
                    this.myCanBeNil = type.getCanBeNil();
                });
            } else if (fqn.isEquivalentTo(RbsFqns.NIL_CLASS_FQN)) {
                this.myType = REmptyType.INSTANCE;
            } else if (fqn.isEquivalentTo(RbsFqns.TRUE_CLASS_FQN)) {
                this.myType = RTypeFactory.createTrueType((Project)this.myProject);
            } else if (fqn.isEquivalentTo(RbsFqns.FALSE_CLASS_FQN)) {
                this.myType = RTypeFactory.createFalseType((Project)this.myProject);
            } else {
                RbsClassSymbol classSymbol = RbsClassSymbol.find(this.myProject, this.mySearchScope, fqn).orElse(null);
                RbsModuleSymbol moduleSymbol = RbsModuleSymbol.find(this.myProject, this.mySearchScope, fqn).orElse(null);
                if (classSymbol != null) {
                    fqn = ((RbsClassSymbol)ObjectUtils.coalesce((Object)classSymbol.getTargetClassSymbol(this.myProject, this.mySearchScope), (Object)classSymbol)).getFqn();
                } else if (moduleSymbol != null) {
                    fqn = ((RbsModuleSymbol)ObjectUtils.coalesce((Object)moduleSymbol.getTargetModuleSymbol(this.myProject, this.mySearchScope), (Object)moduleSymbol)).getFqn();
                }
                this.myType = RTypeFactory.createTypeByFQN((Project)this.myProject, (String)fqn.join(), (List)ContainerUtil.map(typeArguments, RTypeWithNilability::getType), (PsiElement)this.myInvocationPoint);
            }
        }

        public void visitRecordTypeSignature(@NotNull RbsRecordTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(13);
            }
            RType keyType = RTypeUtil.union((Collection)ContainerUtil.mapNotNull((Collection)signature.getKeyTypeSignatures(), this::convertWithoutNilability));
            List valueTypes = ContainerUtil.map((Collection)signature.getValueTypeSignatures(), it -> (RType)ObjectUtils.coalesce((Object)this.convertWithoutNilability((RbsTypeSignature)it), (Object)REmptyType.INSTANCE));
            boolean hasEmptyType = valueTypes.contains(REmptyType.INSTANCE);
            RType valueType = valueTypes.stream().reduce(RTypeUtil::union).map(it -> {
                if (hasEmptyType && it != REmptyType.INSTANCE) {
                    return RUnionTypeImpl.create((List)ContainerUtil.append((List)RTypeUtil.flattenUnionType((RType)it), (Object[])new RType[]{REmptyType.INSTANCE}));
                }
                return it;
            }).orElse((RType)REmptyType.INSTANCE);
            this.myType = RTypeFactory.createHashType((Project)this.myProject, (RType)keyType, (RType)valueType);
        }

        public void visitSingletonTypeSignature(@NotNull RbsSingletonTypeSignature signature) {
            RbsTypeSignature rbsTypeSignature;
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(14);
            }
            if ((rbsTypeSignature = signature.getTypeSignature()) instanceof RbsQualifiedNameTypeSignature) {
                RbsQualifiedNameTypeSignature qualifiedNameTypeSignature = (RbsQualifiedNameTypeSignature)rbsTypeSignature;
                this.myType = RTypeFactory.createSingletonTypeByFqn((Project)this.myProject, (String)qualifiedNameTypeSignature.getFqn().join(), (PsiElement)this.myInvocationPoint);
            }
        }

        public void visitStringLiteralSignature(@NotNull RbsStringLiteralSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(15);
            }
            this.myType = RTypeFactory.createStringType((Project)this.myProject);
        }

        public void visitSymbolLiteralSignature(@NotNull RbsSymbolLiteralSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(16);
            }
            this.myType = RTypeFactory.createSymbolType((Project)this.myProject);
        }

        public void visitTupleTypeSignature(@NotNull RbsTupleTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(17);
            }
            List types = ContainerUtil.map((Collection)ContainerUtil.map((Collection)signature.getTypeSignatures(), this::convertWithoutNilability), type -> (RType)ObjectUtils.coalesce((Object)type, (Object)REmptyType.INSTANCE));
            this.myType = RTypeFactory.createRCollectionType((Project)this.myProject, (List)types, (String)RbsFqns.ARRAY_FQN.join());
        }

        public void visitTypeVariableReferenceSignature(@NotNull RbsTypeVariableReferenceSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(18);
            }
            List<RTypeWithNilability> types = switch (signature.getReferenceType()) {
                default -> throw new MatchException(null, null);
                case RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE -> this.myContainerTypeVariableTypes;
                case RbsTypeVariableReferenceSignature.ReferenceType.METHOD_VARIABLE, RbsTypeVariableReferenceSignature.ReferenceType.TYPE_ALIAS_VARIABLE -> this.myLocalTypeVariableTypes;
            };
            this.setTypeWithNilability((RTypeWithNilability)ContainerUtil.getOrElse(types, (int)signature.getPosition(), (Object)RTypeWithNilability.EMPTY));
        }

        public void visitUnionTypeSignature(@NotNull RbsUnionTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(19);
            }
            List typeWithNilabilities = ContainerUtil.mapNotNull((Collection)signature.getTypeSignatures(), this::convert);
            boolean hasEmptyType = ContainerUtil.or((Iterable)typeWithNilabilities, it -> it.getType() == REmptyType.INSTANCE);
            typeWithNilabilities.stream().reduce(RTypeWithNilability::union).ifPresent(it -> {
                this.myType = hasEmptyType && it.getType() != REmptyType.INSTANCE ? RUnionTypeImpl.create((List)ContainerUtil.append((List)RTypeUtil.flattenUnionAndIntersectionType((RType)it.getType()), (Object[])new RType[]{REmptyType.INSTANCE})) : it.getType();
                this.myCanBeNil = it.getCanBeNil();
            });
        }

        @Nullable
        private RTypeWithNilability convert(@NotNull RbsTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(20);
            }
            return RbsRubyTypeConverter.convert(this.myProject, this.mySearchScope, this.myContextType, this.myContainerTypeVariableTypes, this.myLocalTypeVariableTypes, this.myVisitedTypeAliasSymbols, signature, this.myInvocationPoint);
        }

        @Nullable
        private RTypeWithNilability convert(@NotNull RbsTypeSignature signature, @NotNull List<RTypeWithNilability> localTypeVariableTypes) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(21);
            }
            if (localTypeVariableTypes == null) {
                MyVisitor.$$$reportNull$$$0(22);
            }
            return RbsRubyTypeConverter.convert(this.myProject, this.mySearchScope, this.myContextType, this.myContainerTypeVariableTypes, localTypeVariableTypes, this.myVisitedTypeAliasSymbols, signature, this.myInvocationPoint);
        }

        @Nullable
        private RType convertWithoutNilability(@NotNull RbsTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(23);
            }
            RTypeWithNilability type = RbsRubyTypeConverter.convert(this.myProject, this.mySearchScope, this.myContextType, this.myContainerTypeVariableTypes, this.myLocalTypeVariableTypes, this.myVisitedTypeAliasSymbols, signature, this.myInvocationPoint);
            return (RType)ObjectUtils.doIfNotNull((Object)type, RTypeWithNilability::getType);
        }

        private void setTypeWithNilability(@NotNull RTypeWithNilability typeWithNilability) {
            if (typeWithNilability == null) {
                MyVisitor.$$$reportNull$$$0(24);
            }
            this.myType = typeWithNilability.getType();
            this.myCanBeNil = typeWithNilability.getCanBeNil();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containerTypeVariableTypes";
                    break;
                }
                case 3: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localTypeVariableTypes";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitedTypeAliasSymbols";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeWithNilability";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyTypeConverter$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBooleanLiteralSignature";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIntegerLiteralSignature";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIntersectionTypeSignature";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitKeywordTypeSignature";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNilLiteralSignature";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitOptionalTypeSignature";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitProcTypeSignature";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitQualifiedNameTypeSignature";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRecordTypeSignature";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSingletonTypeSignature";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitStringLiteralSignature";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSymbolLiteralSignature";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTupleTypeSignature";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeVariableReferenceSignature";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnionTypeSignature";
                    break;
                }
                case 20: 
                case 21: 
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[2] = "convert";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[2] = "convertWithoutNilability";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setTypeWithNilability";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

