/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.types;

import com.intellij.ruby.rbs.common.psi.data.RbsProcTypeSignature;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;

public final class RbsRubyMethodSignatureConverter {
    @NotNull
    public static List<ArgumentInfo> convert(@NotNull RbsProcTypeSignature signature) {
        if (signature == null) {
            RbsRubyMethodSignatureConverter.$$$reportNull$$$0(0);
        }
        ArrayList<ArgumentInfo> parameters = new ArrayList<ArgumentInfo>();
        List signatureParameters = signature.getParameters();
        block8: for (int i = 0; i < signatureParameters.size(); ++i) {
            RbsProcTypeSignature.Parameter parameter = (RbsProcTypeSignature.Parameter)signatureParameters.get(i);
            String name = parameter.getName();
            switch (parameter.getParameterType()) {
                case POSITIONAL_REQUIRED: {
                    parameters.add(new ArgumentInfo((String)ObjectUtils.coalesce((Object)name, (Object)("p" + (i + 1))), ArgumentInfo.Type.SIMPLE));
                    continue block8;
                }
                case POSITIONAL_OPTIONAL: {
                    parameters.add(new ArgumentInfo((String)ObjectUtils.coalesce((Object)name, (Object)("p" + (i + 1))), ArgumentInfo.Type.PREDEFINED));
                    continue block8;
                }
                case POSITIONAL_REST: {
                    parameters.add(new ArgumentInfo((String)ObjectUtils.coalesce((Object)name, (Object)"args"), ArgumentInfo.Type.ARRAY));
                    continue block8;
                }
                case KEYWORD_REQUIRED: {
                    parameters.add(new ArgumentInfo((String)ObjectUtils.coalesce((Object)name, (Object)("kw" + (i + 1))), ArgumentInfo.Type.KEYREQ));
                    continue block8;
                }
                case KEYWORD_OPTIONAL: {
                    parameters.add(new ArgumentInfo((String)ObjectUtils.coalesce((Object)name, (Object)("kw" + (i + 1))), ArgumentInfo.Type.NAMED));
                    continue block8;
                }
                case KEYWORD_REST: {
                    parameters.add(new ArgumentInfo((String)ObjectUtils.coalesce((Object)name, (Object)"kwargs"), ArgumentInfo.Type.HASH));
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(parameter.getParameterType()));
                }
            }
        }
        if (signature.hasUntypedParameters()) {
            parameters.add(new ArgumentInfo("", ArgumentInfo.Type.CAPTURE));
        }
        if (signature.getBlockTypeSignature() != null) {
            parameters.add(new ArgumentInfo("block", signature.isBlockOptional() ? ArgumentInfo.Type.BLOCK : ArgumentInfo.Type.BLOCK_REQUIRED));
        }
        List<ArgumentInfo> list = Collections.unmodifiableList(parameters);
        if (list == null) {
            RbsRubyMethodSignatureConverter.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyMethodSignatureConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/types/RbsRubyMethodSignatureConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

