/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public final class RbsRubysigsLibraryUtil {
    @NotNull
    @NonNls
    private static final String CORE_DIR = "core";
    @NotNull
    @NonNls
    private static final String CORE_RBS_UNNAMED_DIR = "core/rbs/unnamed";
    @NotNull
    @NonNls
    private static final String STDLIB_DIR = "stdlib";

    private RbsRubysigsLibraryUtil() {
    }

    @Nullable
    public static VirtualFile getRbsLibraryRoot(@NotNull Project project, @Nullable Module module) {
        GemInfo gem;
        if (project == null) {
            RbsRubysigsLibraryUtil.$$$reportNull$$$0(0);
        }
        GemInfo gemInfo = gem = module != null ? RubyProjectGemSearchService.Companion.findGem(module, "rbs") : null;
        if (gem != null) {
            return gem.getFile();
        }
        Sdk sdk = RubySdkUtil.findRubySdk((Project)project);
        return sdk != null ? VirtualFileManager.getInstance().findFileByNioPath(RubySdkUtil.getRubysigsDir((Sdk)sdk)) : null;
    }

    @Nullable
    public static VirtualFile getRbsCoreLibraryRoot(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            RbsRubysigsLibraryUtil.$$$reportNull$$$0(1);
        }
        return (VirtualFile)ObjectUtils.doIfNotNull((Object)RbsRubysigsLibraryUtil.getRbsLibraryRoot(project, module), it -> it.findChild(CORE_DIR));
    }

    @Nullable
    public static VirtualFile getRbsCoreRbsUnnamedLibraryRoot(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            RbsRubysigsLibraryUtil.$$$reportNull$$$0(2);
        }
        return (VirtualFile)ObjectUtils.doIfNotNull((Object)RbsRubysigsLibraryUtil.getRbsLibraryRoot(project, module), it -> it.findFileByRelativePath(CORE_RBS_UNNAMED_DIR));
    }

    @Nullable
    public static VirtualFile getRbsStdlibLibraryRoot(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            RbsRubysigsLibraryUtil.$$$reportNull$$$0(3);
        }
        return (VirtualFile)ObjectUtils.doIfNotNull((Object)RbsRubysigsLibraryUtil.getRbsLibraryRoot(project, module), it -> it.findChild(STDLIB_DIR));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/project/RbsRubysigsLibraryUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRbsLibraryRoot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRbsCoreLibraryRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRbsCoreRbsUnnamedLibraryRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRbsStdlibLibraryRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

