/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.navigation;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsSymbol;
import com.intellij.lang.ruby.rbs.model.hierarchy.RbsContainerSymbolUtil;
import com.intellij.lang.ruby.rbs.model.impl.RbsAttributeSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsConstantSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsGlobalVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInstanceVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodAliasSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleMethodSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.psi.index.RbsExtendedContainerNameIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsIncludedContainerNameIndex;
import com.intellij.model.Pointer;
import com.intellij.navigation.EmptyNavigatable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.psi.data.RbsDeclarationType;
import com.intellij.ruby.rbs.common.psi.mixin.RbsExtendCallMixin;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.navigation.TargetLocation;
import org.jetbrains.plugins.ruby.model.navigation.TargetPresentationUtil;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyGlobalVariableSymbol;
import org.jetbrains.plugins.ruby.ruby.navigation.RubyAssociatedDeclarationProvider;

final class RbsRubyAssociatedDeclarationProvider
implements RubyAssociatedDeclarationProvider {
    RbsRubyAssociatedDeclarationProvider() {
    }

    @NotNull
    public List<? extends com.intellij.model.Symbol> getAssociatedDeclarations(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull com.intellij.model.Symbol signature) {
        if (project == null) {
            RbsRubyAssociatedDeclarationProvider.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RbsRubyAssociatedDeclarationProvider.$$$reportNull$$$0(1);
        }
        if (signature == null) {
            RbsRubyAssociatedDeclarationProvider.$$$reportNull$$$0(2);
        }
        if (!(signature instanceof RbsSymbol)) {
            List list = Collections.emptyList();
            if (list == null) {
                RbsRubyAssociatedDeclarationProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        RbsSymbol symbol = (RbsSymbol)signature;
        MyVisitor visitor = new MyVisitor(project, searchScope);
        if (symbol instanceof RbsAttributeSymbol) {
            RbsAttributeSymbol attributeSymbol = (RbsAttributeSymbol)symbol;
            attributeSymbol.getDynamicSymbols(project, searchScope).forEach(it -> visitor.mySymbols.addAll(this.getAssociatedDeclarations(project, searchScope, (com.intellij.model.Symbol)it)));
        } else if (symbol instanceof RbsClassSymbol) {
            RbsClassSymbol classSymbol = (RbsClassSymbol)symbol;
            visitor.visitClassSymbol(classSymbol);
        } else if (symbol instanceof RbsClassVariableSymbol) {
            RbsClassVariableSymbol classVariableSymbol = (RbsClassVariableSymbol)symbol;
            visitor.visitClassVariableSymbol(classVariableSymbol);
        } else if (symbol instanceof RbsConstantSymbol) {
            RbsConstantSymbol constantSymbol = (RbsConstantSymbol)symbol;
            visitor.visitConstantSymbol(constantSymbol);
        } else if (symbol instanceof RbsGlobalVariableSymbol) {
            RbsGlobalVariableSymbol globalVariableSymbol = (RbsGlobalVariableSymbol)symbol;
            visitor.visitGlobalVariableSymbol(globalVariableSymbol);
        } else if (symbol instanceof RbsInstanceVariableSymbol) {
            RbsInstanceVariableSymbol instanceVariableSymbol = (RbsInstanceVariableSymbol)symbol;
            visitor.visitInstanceVariableSymbol(instanceVariableSymbol);
        } else if (symbol instanceof RbsMethodAliasSymbol) {
            RbsMethodAliasSymbol methodAliasSymbol = (RbsMethodAliasSymbol)symbol;
            methodAliasSymbol.getDynamicSymbols(project, searchScope).forEach(it -> visitor.mySymbols.addAll(this.getAssociatedDeclarations(project, searchScope, (com.intellij.model.Symbol)it)));
        } else if (symbol instanceof RbsMethodSymbol) {
            RbsMethodSymbol methodSymbol = (RbsMethodSymbol)symbol;
            visitor.visitMethodSymbol(methodSymbol);
        } else if (symbol instanceof RbsModuleSymbol) {
            RbsModuleSymbol moduleSymbol = (RbsModuleSymbol)symbol;
            visitor.visitModuleSymbol(moduleSymbol);
        } else if (symbol instanceof RbsModuleMethodSymbol) {
            RbsModuleMethodSymbol moduleMethodSymbol = (RbsModuleMethodSymbol)symbol;
            moduleMethodSymbol.getDynamicSymbols(project, searchScope).forEach(it -> visitor.mySymbols.addAll(this.getAssociatedDeclarations(project, searchScope, (com.intellij.model.Symbol)it)));
        }
        List<com.intellij.model.Symbol> list = List.copyOf(visitor.mySymbols);
        if (list == null) {
            RbsRubyAssociatedDeclarationProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            RbsRubyAssociatedDeclarationProvider.$$$reportNull$$$0(5);
        }
        if (file == null) {
            RbsRubyAssociatedDeclarationProvider.$$$reportNull$$$0(6);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/navigation/RbsRubyAssociatedDeclarationProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/navigation/RbsRubyAssociatedDeclarationProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedDeclarations";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private static final class MyVisitor {
        private final Project myProject;
        private final SearchScope mySearchScope;
        private final Set<com.intellij.model.Symbol> mySymbols;

        private MyVisitor(@NotNull Project project, @NotNull SearchScope searchScope) {
            if (project == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (searchScope == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.mySymbols = new LinkedHashSet<com.intellij.model.Symbol>();
            this.myProject = project;
            this.mySearchScope = searchScope;
        }

        private void visitClassSymbol(@NotNull RbsClassSymbol symbol) {
            Symbol rubySymbol;
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if ((rubySymbol = this.findRubySymbol(symbol)) == null) {
                return;
            }
            String name = StringUtil.notNullize((String)rubySymbol.getName());
            Icon icon = rubySymbol.getExplicitIcon();
            rubySymbol.getAllDeclarations(null).stream().map(declaration -> new MySymbol((PsiElement)declaration, name, (Icon)ObjectUtils.coalesce((Object)icon, (Object)declaration.getIcon(0)))).forEach(this.mySymbols::add);
        }

        private void visitClassVariableSymbol(@NotNull RbsClassVariableSymbol symbol) {
            Symbol rubyContainer;
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if ((rubyContainer = this.findRubySymbol(symbol.getContainerSymbol())) == null) {
                return;
            }
            Symbol rubySymbol = SymbolUtil.findSymbolInHierarchy((Symbol)rubyContainer, (String)symbol.getName(), (TypeSet)Types.CLASS_FIELD_OR_ATTRS, null);
            if (rubySymbol == null) {
                return;
            }
            String name = StringUtil.notNullize((String)rubySymbol.getName());
            Icon icon = rubySymbol.getExplicitIcon();
            rubySymbol.getAllDeclarations(null).stream().map(declaration -> new MySymbol((PsiElement)declaration, name, (Icon)ObjectUtils.coalesce((Object)icon, (Object)declaration.getIcon(0)))).forEach(this.mySymbols::add);
        }

        private void visitConstantSymbol(@NotNull RbsConstantSymbol symbol) {
            RPsiElement constant;
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            if ((constant = RubyFQNUtil.findConstantByFQN((Project)this.myProject, (FQN)FQN.of((String)symbol.getFqn().join()), null)) != null) {
                this.mySymbols.add((com.intellij.model.Symbol)new MySymbol((PsiElement)constant, StringUtil.notNullize((String)constant.getName()), constant.getIcon(0)));
            }
        }

        private void visitGlobalVariableSymbol(@NotNull RbsGlobalVariableSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            RubyGlobalVariableSymbol.find((Project)this.myProject, (SearchScope)this.mySearchScope, (String)symbol.getName()).ifPresent(this.mySymbols::add);
        }

        private void visitInstanceVariableSymbol(@NotNull RbsInstanceVariableSymbol symbol) {
            Symbol rubyContainer;
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if ((rubyContainer = this.findRubySymbol(symbol.getContainerSymbol(), symbol.getDeclarationType() == RbsDeclarationType.SINGLETON_DECLARATION)) == null) {
                return;
            }
            Symbol rubySymbol = SymbolUtil.findSymbolInHierarchy((Symbol)rubyContainer, (String)symbol.getName(), (TypeSet)Types.INSTANCE_FIELD_OR_ATTRS, null);
            if (rubySymbol == null) {
                return;
            }
            String name = StringUtil.notNullize((String)rubySymbol.getName());
            Icon icon = rubySymbol.getExplicitIcon();
            rubySymbol.getAllDeclarations(null).stream().map(declaration -> new MySymbol((PsiElement)declaration, name, (Icon)ObjectUtils.coalesce((Object)icon, (Object)declaration.getIcon(0)))).forEach(this.mySymbols::add);
        }

        private void visitMethodSymbol(@NotNull RbsMethodSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            RbsContainerSymbol containerSymbol = symbol.getContainerSymbol();
            String name = symbol.getName();
            if (containerSymbol instanceof RbsInterfaceSymbol) {
                this.findRubySymbolsForInterface((RbsInterfaceSymbol)containerSymbol).forEach(rubyContainer -> this.addContainerMethod((Symbol)rubyContainer, name));
            } else {
                Symbol rubySymbol = this.findRubySymbol(containerSymbol, symbol.getDeclarationType() == RbsDeclarationType.SINGLETON_DECLARATION);
                if (rubySymbol != null) {
                    this.addContainerMethod(rubySymbol, name);
                }
            }
        }

        private void visitModuleSymbol(@NotNull RbsModuleSymbol symbol) {
            Symbol rubySymbol;
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            if ((rubySymbol = this.findRubySymbol(symbol)) == null) {
                return;
            }
            String name = StringUtil.notNullize((String)rubySymbol.getName());
            Icon icon = rubySymbol.getExplicitIcon();
            rubySymbol.getAllDeclarations(null).stream().map(declaration -> new MySymbol((PsiElement)declaration, name, (Icon)ObjectUtils.coalesce((Object)icon, (Object)declaration.getIcon(0)))).forEach(this.mySymbols::add);
        }

        @Nullable
        private Symbol findRubySymbol(@NotNull RbsContainerSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            return this.findRubySymbol(symbol, false);
        }

        @Nullable
        private Symbol findRubySymbol(@NotNull RbsContainerSymbol symbol, boolean isSingleton) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            Symbol rubyContainer = SymbolUtil.findConstantByFQN((Project)this.myProject, (TypeSet)MyVisitor.getRubyTypeSet(symbol), (FQN)FQN.of((String)symbol.getFqn().join()), null);
            return isSingleton && rubyContainer != null ? rubyContainer.getSingletonClassSymbol() : rubyContainer;
        }

        private void addContainerMethod(@NotNull Symbol rubyContainer, @NotNull String name) {
            Predicate filter;
            Symbol rubySymbol;
            if (rubyContainer == null) {
                MyVisitor.$$$reportNull$$$0(11);
            }
            if (name == null) {
                MyVisitor.$$$reportNull$$$0(12);
            }
            if ((rubySymbol = Symbol.getSymbolByFilter((Symbol)rubyContainer, (Predicate)(filter = Symbol.Filter.byName((String)name).and((Predicate)Symbol.Filter.byTypes((TypeSet)Types.METHODS_LIKE))), null)) == null) {
                return;
            }
            Icon icon = rubySymbol.getExplicitIcon();
            rubySymbol.getAllDeclarations(null).stream().map(declaration -> new MySymbol((PsiElement)declaration, name, (Icon)ObjectUtils.coalesce((Object)icon, (Object)declaration.getIcon(0)))).forEach(this.mySymbols::add);
        }

        @NotNull
        private Set<Symbol> findRubySymbolsForInterface(@NotNull RbsInterfaceSymbol interfaceSymbol) {
            if (interfaceSymbol == null) {
                MyVisitor.$$$reportNull$$$0(13);
            }
            LinkedHashSet<Symbol> rubySymbols = new LinkedHashSet<Symbol>();
            this.collectRubySymbolsForInterface(interfaceSymbol, rubySymbols, new HashSet<RbsInterfaceSymbol>());
            LinkedHashSet<Symbol> linkedHashSet = rubySymbols;
            if (linkedHashSet == null) {
                MyVisitor.$$$reportNull$$$0(14);
            }
            return linkedHashSet;
        }

        private void collectRubySymbolsForInterface(@NotNull RbsInterfaceSymbol interfaceSymbol, @NotNull Set<Symbol> rubySymbols, @NotNull Set<RbsInterfaceSymbol> visitedInterfaces) {
            if (interfaceSymbol == null) {
                MyVisitor.$$$reportNull$$$0(15);
            }
            if (rubySymbols == null) {
                MyVisitor.$$$reportNull$$$0(16);
            }
            if (visitedInterfaces == null) {
                MyVisitor.$$$reportNull$$$0(17);
            }
            if (!visitedInterfaces.add(interfaceSymbol)) {
                return;
            }
            String name = interfaceSymbol.getFullName();
            Processor processor = inclusionCall -> {
                ProgressManager.checkCanceled();
                String includedModuleName = inclusionCall.getIncludedModuleName();
                RbsContainerSymbol containerSymbol = (RbsContainerSymbol)ObjectUtils.doIfNotNull((Object)inclusionCall.getContainerDeclaration(), it -> (RbsContainerSymbol)ExtensionsKt.getSymbol((PsiElement)it, RbsContainerSymbol.class));
                if (includedModuleName == null || containerSymbol == null) {
                    return true;
                }
                GlobalSearchScope resolveScope = inclusionCall.getResolveScope();
                List<? super com.intellij.model.Symbol> inclusionCallResolveTargets = RbsResolveUtil.resolveQualifiedNameInNesting(this.myProject, (SearchScope)resolveScope, inclusionCall.getContainerFqn(), includedModuleName, (PsiElement)inclusionCall).stream().mapMulti(RbsContainerSymbolUtil.followAliases(this.myProject, (SearchScope)resolveScope)).toList();
                if (!inclusionCallResolveTargets.contains(interfaceSymbol)) {
                    return true;
                }
                if (containerSymbol instanceof RbsInterfaceSymbol) {
                    this.collectRubySymbolsForInterface((RbsInterfaceSymbol)containerSymbol, rubySymbols, visitedInterfaces);
                } else {
                    Symbol rubySymbol = this.findRubySymbol(containerSymbol);
                    if (inclusionCall instanceof RbsExtendCallMixin && rubySymbol != null) {
                        rubySymbol = rubySymbol.getSingletonClassSymbol();
                    }
                    if (rubySymbol != null) {
                        rubySymbols.add(rubySymbol);
                    }
                }
                return true;
            };
            RbsIncludedContainerNameIndex.getInstance().processElements(this.myProject, this.mySearchScope, name, processor);
            RbsExtendedContainerNameIndex.getInstance().processElements(this.myProject, this.mySearchScope, name, processor);
        }

        @NotNull
        private static TypeSet getRubyTypeSet(@NotNull RbsContainerSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(18);
            }
            if (symbol instanceof RbsClassSymbol) {
                TypeSet typeSet = SymbolUtil.getClassTypes();
                if (typeSet == null) {
                    MyVisitor.$$$reportNull$$$0(19);
                }
                return typeSet;
            }
            if (symbol instanceof RbsModuleSymbol) {
                TypeSet typeSet = SymbolUtil.getModuleTypes();
                if (typeSet == null) {
                    MyVisitor.$$$reportNull$$$0(20);
                }
                return typeSet;
            }
            TypeSet typeSet = TypeSet.EMPTY;
            if (typeSet == null) {
                MyVisitor.$$$reportNull$$$0(21);
            }
            return typeSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 14, 19, 20, 21 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rubyContainer";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interfaceSymbol";
                    break;
                }
                case 14: 
                case 19: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/navigation/RbsRubyAssociatedDeclarationProvider$MyVisitor";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rubySymbols";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitedInterfaces";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/navigation/RbsRubyAssociatedDeclarationProvider$MyVisitor";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findRubySymbolsForInterface";
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRubyTypeSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClassSymbol";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClassVariableSymbol";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitConstantSymbol";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitGlobalVariableSymbol";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitInstanceVariableSymbol";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitMethodSymbol";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "visitModuleSymbol";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "findRubySymbol";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "addContainerMethod";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "findRubySymbolsForInterface";
                    break;
                }
                case 14: 
                case 19: 
                case 20: 
                case 21: {
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "collectRubySymbolsForInterface";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "getRubyTypeSet";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 14, 19, 20, 21 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MySymbol
    implements NavigatableSymbol,
    NavigationTarget {
        private final PsiElement myElement;
        private final TargetLocation myLocation;
        private final TargetPresentation myPresentation;
        @Nullable
        private final Pointer<MySymbol> myPointer;

        private MySymbol(@NotNull PsiElement element, @NotNull String name, @Nullable Icon icon) {
            if (element == null) {
                MySymbol.$$$reportNull$$$0(0);
            }
            if (name == null) {
                MySymbol.$$$reportNull$$$0(1);
            }
            this(element, TargetLocation.fromElement((PsiElement)element), TargetPresentationUtil.createTargetPresentation((String)name, (Icon)icon, (PsiElement)element), null);
        }

        private MySymbol(@NotNull PsiElement element, @NotNull TargetLocation location, @NotNull TargetPresentation presentation, @Nullable Pointer<MySymbol> pointer) {
            if (element == null) {
                MySymbol.$$$reportNull$$$0(2);
            }
            if (location == null) {
                MySymbol.$$$reportNull$$$0(3);
            }
            if (presentation == null) {
                MySymbol.$$$reportNull$$$0(4);
            }
            this.myElement = element;
            this.myLocation = location;
            this.myPresentation = presentation;
            this.myPointer = pointer;
        }

        @NotNull
        public Pointer<MySymbol> createPointer() {
            if (this.myPointer != null) {
                Pointer<MySymbol> pointer2 = this.myPointer;
                if (pointer2 == null) {
                    MySymbol.$$$reportNull$$$0(5);
                }
                return pointer2;
            }
            TargetLocation location = this.myLocation;
            TargetPresentation presentation = this.myPresentation;
            Pointer pointer3 = Pointer.uroborosPointer((Pointer)SmartPointerManager.createPointer((PsiElement)this.myElement), (element, pointer) -> new MySymbol((PsiElement)element, location, presentation, (Pointer<MySymbol>)pointer));
            if (pointer3 == null) {
                MySymbol.$$$reportNull$$$0(6);
            }
            return pointer3;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MySymbol other = (MySymbol)obj;
            return this.myElement.equals((Object)other.myElement);
        }

        @NotNull
        public Navigatable getNavigatable() {
            Navigatable navigatable = (Navigatable)ObjectUtils.coalesce((Object)PsiNavigationSupport.getInstance().getDescriptor(this.myElement), (Object)EmptyNavigatable.INSTANCE);
            if (navigatable == null) {
                MySymbol.$$$reportNull$$$0(7);
            }
            return navigatable;
        }

        @NotNull
        public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
            if (project == null) {
                MySymbol.$$$reportNull$$$0(8);
            }
            List<MySymbol> list = List.of(this);
            if (list == null) {
                MySymbol.$$$reportNull$$$0(9);
            }
            return list;
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }

        @NotNull
        public TargetLocation location() {
            TargetLocation targetLocation = this.myLocation;
            if (targetLocation == null) {
                MySymbol.$$$reportNull$$$0(10);
            }
            return targetLocation;
        }

        @NotNull
        public TargetPresentation computePresentation() {
            TargetPresentation targetPresentation = this.myPresentation;
            if (targetPresentation == null) {
                MySymbol.$$$reportNull$$$0(11);
            }
            return targetPresentation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/navigation/RbsRubyAssociatedDeclarationProvider$MySymbol";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/navigation/RbsRubyAssociatedDeclarationProvider$MySymbol";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPointer";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatable";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationTargets";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "location";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computePresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigationTargets";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7, 9, 10, 11 -> new IllegalStateException(string);
            };
        }
    }
}

