/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.model.impl.extensions;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsConstantSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsSingletonSymbol;
import com.intellij.lang.ruby.rbs.psi.index.RbsDeclarationByParentFqnIndex;
import com.intellij.lang.ruby.rbs.util.RbsSymbols;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbol;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbolAncestor;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyContainerSymbolDataProvider;
import org.jetbrains.plugins.ruby.ruby.model.api.RubyQualifiedNameSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyClassSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyConstantSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubyModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.model.impl.RubySingletonSymbol;

public final class RbsRubyContainerSymbolDataProvider
implements RubyContainerSymbolDataProvider {
    @NotNull
    public List<RubyContainerSymbolAncestor> ancestors(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RubyContainerSymbol symbol) {
        if (project == null) {
            RbsRubyContainerSymbolDataProvider.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RbsRubyContainerSymbolDataProvider.$$$reportNull$$$0(1);
        }
        if (symbol == null) {
            RbsRubyContainerSymbolDataProvider.$$$reportNull$$$0(2);
        }
        RbsContainerSymbol containerSymbol = RbsRubyContainerSymbolDataProvider.getRbsContainerSymbol(symbol);
        Ref groupRef = new Ref((Object)RubyContainerSymbolAncestor.ProcessingGroup.PREPEND);
        AtomicInteger order = new AtomicInteger();
        List<RubyContainerSymbolAncestor> list = containerSymbol.ancestors(project, searchScope).mapMulti((ancestor, consumer) -> {
            if (groupRef.get() == RubyContainerSymbolAncestor.ProcessingGroup.PREPEND && ancestor.equals(containerSymbol)) {
                groupRef.set((Object)RubyContainerSymbolAncestor.ProcessingGroup.INCLUDE);
            } else if (ancestor instanceof RbsModuleSymbol) {
                RbsModuleSymbol moduleSymbol = (RbsModuleSymbol)ancestor;
                consumer.accept(new RubyContainerSymbolAncestor((RubyContainerSymbolAncestor.ProcessingGroup)groupRef.get(), order.incrementAndGet(), (RubyContainerSymbol)new RubyModuleSymbol(FQN.of((String)moduleSymbol.getFqn().join()))));
            }
        }).toList();
        if (list == null) {
            RbsRubyContainerSymbolDataProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<? extends RubyQualifiedNameSymbol> constants(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RubyContainerSymbol parent) {
        RubyModuleSymbol moduleSymbol;
        RubyClassSymbol classSymbol;
        if (project == null) {
            RbsRubyContainerSymbolDataProvider.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RbsRubyContainerSymbolDataProvider.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            RbsRubyContainerSymbolDataProvider.$$$reportNull$$$0(6);
        }
        if (parent instanceof RubyClassSymbol && (classSymbol = (RubyClassSymbol)parent).isAnonymous()) {
            List list = Collections.emptyList();
            if (list == null) {
                RbsRubyContainerSymbolDataProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        if (parent instanceof RubyModuleSymbol && (moduleSymbol = (RubyModuleSymbol)parent).isAnonymous()) {
            List list = Collections.emptyList();
            if (list == null) {
                RbsRubyContainerSymbolDataProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        if (parent instanceof RubySingletonSymbol) {
            List list = Collections.emptyList();
            if (list == null) {
                RbsRubyContainerSymbolDataProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        RbsContainerSymbol containerSymbol = RbsRubyContainerSymbolDataProvider.getRbsContainerSymbol(parent);
        Fqn containerFqn = containerSymbol.equals(RbsSymbols.OBJECT_SYMBOL) ? Fqn.INVALID : containerSymbol.getFqn();
        HashSet aliasNames = new HashSet();
        RbsDeclarationByParentFqnIndex.processAllValues(project, searchScope, containerFqn, EnumSet.of(RbsDeclarationByParentFqnIndex.Type.CLASS_ALIAS, RbsDeclarationByParentFqnIndex.Type.MODULE_ALIAS), (Processor<? super String>)((Processor)it -> {
            aliasNames.add(it);
            return true;
        }));
        List list = containerSymbol.constants(project, searchScope).mapMulti((symbol, consumer) -> {
            FQN fqn;
            if (symbol instanceof RbsClassSymbol) {
                RbsClassSymbol classSymbol = (RbsClassSymbol)symbol;
                fqn = FQN.of((String)classSymbol.getFqn().join());
                if (!aliasNames.contains(classSymbol.getName())) {
                    consumer.accept(new RubyClassSymbol(fqn));
                } else {
                    consumer.accept(new RubyConstantSymbol(fqn));
                }
            }
            if (symbol instanceof RbsModuleSymbol) {
                RbsModuleSymbol moduleSymbol = (RbsModuleSymbol)symbol;
                fqn = FQN.of((String)moduleSymbol.getFqn().join());
                if (!aliasNames.contains(moduleSymbol.getName())) {
                    consumer.accept(new RubyModuleSymbol(fqn));
                } else {
                    consumer.accept(new RubyConstantSymbol(fqn));
                }
            }
            if (symbol instanceof RbsConstantSymbol) {
                RbsConstantSymbol constantSymbol = (RbsConstantSymbol)symbol;
                consumer.accept(new RubyConstantSymbol(FQN.of((String)constantSymbol.getFqn().join())));
            }
        }).distinct().toList();
        if (list == null) {
            RbsRubyContainerSymbolDataProvider.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static RbsContainerSymbol getRbsContainerSymbol(@NotNull RubyContainerSymbol symbol) {
        if (symbol == null) {
            RbsRubyContainerSymbolDataProvider.$$$reportNull$$$0(11);
        }
        if (symbol instanceof RubyClassSymbol) {
            return new RbsClassSymbol(Fqn.of((FQN)symbol.getFqn()));
        }
        if (symbol instanceof RubyModuleSymbol) {
            return new RbsModuleSymbol(Fqn.of((FQN)symbol.getFqn()));
        }
        if (symbol instanceof RubySingletonSymbol) {
            RubySingletonSymbol singleton = (RubySingletonSymbol)symbol;
            return new RbsSingletonSymbol(RbsRubyContainerSymbolDataProvider.getRbsContainerSymbol(singleton.getOriginalSymbol()));
        }
        throw new UnsupportedOperationException("Unknown symbol class: " + symbol.getClass().getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/model/impl/extensions/RbsRubyContainerSymbolDataProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/model/impl/extensions/RbsRubyContainerSymbolDataProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "ancestors";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "constants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ancestors";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "constants";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRbsContainerSymbol";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

