/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.model.impl;

import com.intellij.lang.ruby.rbs.ruby.model.cache.RbsRubySymbolsCache;
import com.intellij.lang.ruby.rbs.ruby.model.impl.RbsRubyContainerSymbol;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.RbsIcons;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;

public final class RbsRubyModuleSymbol
extends RbsRubyContainerSymbol {
    private RbsRubyModuleSymbol(@NotNull Fqn fqn, @NotNull List<RbsRubyContainerSymbol.Ancestor> ancestors) {
        if (fqn == null) {
            RbsRubyModuleSymbol.$$$reportNull$$$0(0);
        }
        if (ancestors == null) {
            RbsRubyModuleSymbol.$$$reportNull$$$0(1);
        }
        super(fqn, ancestors);
    }

    @NotNull
    public Pointer<RbsRubyModuleSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RbsRubyModuleSymbol.$$$reportNull$$$0(2);
        }
        return pointer;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        String name = this.getName();
        @Nls Supplier shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.ruby.model.module.shortDescription", (Object[])new Object[]{name});
        Fqn fqn = this.myFqn.split();
        if (fqn.getParent() == Fqn.INVALID) {
            return new SymbolPresentation(RbsIcons.RBS_MODULE_ICON, name, shortDescriptionSupplier);
        }
        @Nls Supplier longDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.ruby.model.module.longDescription", (Object[])new Object[]{name, fqn.getParent().join()});
        return new SymbolPresentation(RbsIcons.RBS_MODULE_ICON, name, shortDescriptionSupplier, longDescriptionSupplier);
    }

    @NotNull
    public String toString() {
        String string = "RbsRubyModuleSymbol{myFqn=%s}".formatted(this.myFqn);
        if (string == null) {
            RbsRubyModuleSymbol.$$$reportNull$$$0(3);
        }
        return string;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static RbsRubyModuleSymbol create(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Symbol symbol) {
        if (project == null) {
            RbsRubyModuleSymbol.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RbsRubyModuleSymbol.$$$reportNull$$$0(5);
        }
        if (symbol == null) {
            RbsRubyModuleSymbol.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.softAssertReadAccess();
        Fqn fqn = Fqn.of((FQN)symbol.getFQNWithNesting());
        if (fqn == Fqn.INVALID) {
            return null;
        }
        return (RbsRubyModuleSymbol)RbsRubySymbolsCache.getInstance(project, searchScope).getRubyModuleSymbols().get((Object)fqn, __ -> new RbsRubyModuleSymbol(fqn, RbsRubyModuleSymbol.getAncestors(symbol)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestors";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/model/impl/RbsRubyModuleSymbol";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/model/impl/RbsRubyModuleSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

