/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.model.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.cache.RbsModificationTrackers;
import com.intellij.lang.ruby.rbs.ruby.model.impl.RbsRubyClassSymbol;
import com.intellij.lang.ruby.rbs.ruby.model.impl.RbsRubyModuleSymbol;
import com.intellij.lang.ruby.rbs.ruby.model.impl.RbsRubySingletonSymbol;
import com.intellij.model.Symbol;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.cache.DumbAwareCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubyModificationTrackers;

@Service(value={Service.Level.PROJECT})
public final class RbsRubySymbolsCache
implements Disposable {
    private final Project myProject;
    private final LoadingCache<@NotNull SearchScope, @NotNull Instance> myCache;
    private final AtomicLong myStamp;

    public RbsRubySymbolsCache(@NotNull Project project) {
        if (project == null) {
            RbsRubySymbolsCache.$$$reportNull$$$0(0);
        }
        this.myStamp = new AtomicLong();
        this.myProject = project;
        this.myCache = Caffeine.newBuilder().maximumSize(100L).build(__ -> new Instance(project));
        LowMemoryWatcher.register(() -> this.myCache.invalidateAll(), (Disposable)this);
    }

    public void dispose() {
        this.myCache.invalidateAll();
    }

    @RequiresReadLock
    @NotNull
    private Instance getCache(@NotNull SearchScope searchScope) {
        if (searchScope == null) {
            RbsRubySymbolsCache.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.softAssertReadAccess();
        long stamp = ProjectRootManager.getInstance((Project)this.myProject).getModificationCount() + RbsModificationTrackers.getInstance(this.myProject).getPerFileElementTypeModificationTracker().getModificationCount() + RubyModificationTrackers.getPerFileElementTypeModificationTracker((Project)this.myProject).getModificationCount();
        if (this.myStamp.getAndSet(stamp) != stamp) {
            this.myCache.invalidateAll();
        }
        Instance instance = (Instance)this.myCache.get((Object)searchScope);
        if (instance == null) {
            RbsRubySymbolsCache.$$$reportNull$$$0(2);
        }
        return instance;
    }

    @NotNull
    public static Instance getInstance(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsRubySymbolsCache.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            RbsRubySymbolsCache.$$$reportNull$$$0(4);
        }
        return ((RbsRubySymbolsCache)project.getService(RbsRubySymbolsCache.class)).getCache(searchScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/model/cache/RbsRubySymbolsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/model/cache/RbsRubySymbolsCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCache";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static final class Instance {
        private static final long DEFAULT_MAXIMUM_SIZE = Math.max(0, Registry.get((String)"rbs.symbols.cache.size").asInteger());
        private final Cache<Fqn, RbsRubyClassSymbol> myRubyClassSymbols;
        private final Cache<Fqn, RbsRubyModuleSymbol> myRubyModuleSymbols;
        private final Cache<Fqn, RbsRubySingletonSymbol> myRubySingletonSymbols;
        private final Cache<Symbol, List<? extends RbsContainerSymbol>> myAllAncestors;

        private Instance(@NotNull Project project) {
            if (project == null) {
                Instance.$$$reportNull$$$0(0);
            }
            this.myRubyClassSymbols = new DumbAwareCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myRubyModuleSymbols = new DumbAwareCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myRubySingletonSymbols = new DumbAwareCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myAllAncestors = new DumbAwareCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
        }

        @NotNull
        public Cache<Symbol, List<? extends RbsContainerSymbol>> getAllAncestors() {
            Cache<Symbol, List<? extends RbsContainerSymbol>> cache = this.myAllAncestors;
            if (cache == null) {
                Instance.$$$reportNull$$$0(1);
            }
            return cache;
        }

        @NotNull
        public Cache<Fqn, RbsRubyClassSymbol> getRubyClassSymbols() {
            Cache<Fqn, RbsRubyClassSymbol> cache = this.myRubyClassSymbols;
            if (cache == null) {
                Instance.$$$reportNull$$$0(2);
            }
            return cache;
        }

        @NotNull
        public Cache<Fqn, RbsRubyModuleSymbol> getRubyModuleSymbols() {
            Cache<Fqn, RbsRubyModuleSymbol> cache = this.myRubyModuleSymbols;
            if (cache == null) {
                Instance.$$$reportNull$$$0(3);
            }
            return cache;
        }

        @NotNull
        public Cache<Fqn, RbsRubySingletonSymbol> getRubySingletonSymbols() {
            Cache<Fqn, RbsRubySingletonSymbol> cache = this.myRubySingletonSymbols;
            if (cache == null) {
                Instance.$$$reportNull$$$0(4);
            }
            return cache;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/model/cache/RbsRubySymbolsCache$Instance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/model/cache/RbsRubySymbolsCache$Instance";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllAncestors";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRubyClassSymbols";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRubyModuleSymbols";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRubySingletonSymbols";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

