/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.inspections.probableBugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ruby.rbs.model.api.RbsSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsSearchScope;
import com.intellij.lang.ruby.rbs.ruby.inspections.probableBugs.RbsEditTypeSignatureQuickFix;
import com.intellij.lang.ruby.rbs.ruby.inspections.probableBugs.RbsGotoTypeSignatureQuickFix;
import com.intellij.lang.ruby.rbs.ruby.inspections.probableBugs.RbsRubyExpectedTypeUtil;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeConverter;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeSignatureUtil;
import com.intellij.model.Symbol;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeWithNilability;
import org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes.RubyExpectedConstantTypeProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

@ApiStatus.Internal
public final class RbsRubyExpectedConstantTypeProvider
implements RubyExpectedConstantTypeProvider {
    @NlsContexts.Label
    @NotNull
    public String getDisplayName() {
        String string = RbsBundle.message((String)"rbs.expected.constant.type.group.rbs", (Object[])new Object[0]);
        if (string == null) {
            RbsRubyExpectedConstantTypeProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public RTypeWithNilability getExpectedConstantTypeWithNilability(@NotNull RConstant constant) {
        if (constant == null) {
            RbsRubyExpectedConstantTypeProvider.$$$reportNull$$$0(1);
        }
        Project project = constant.getProject();
        GlobalSearchScope searchScope = constant.getResolveScope().intersectWith(RbsSearchScope.collectionScope((PsiElement)constant));
        RConstant invocationPoint = constant;
        return RbsRubyTypeSignatureUtil.findConstantTypeSignature(project, (SearchScope)searchScope, constant).filter((__, signature) -> !RbsRubyExpectedTypeUtil.isIgnoredTypeSignature(signature)).map((arg_0, arg_1) -> RbsRubyExpectedConstantTypeProvider.lambda$getExpectedConstantTypeWithNilability$1(project, (SearchScope)searchScope, (PsiElement)invocationPoint, arg_0, arg_1)).orElse(null);
    }

    public LocalQuickFix @NotNull [] getMismatchedTypeQuickFixes(@NotNull PsiElement element) {
        if (element == null) {
            RbsRubyExpectedConstantTypeProvider.$$$reportNull$$$0(2);
        }
        LocalQuickFix[] localQuickFixArray = ContainerUtil.packNullables((Object[])new LocalQuickFix[]{RbsRubyExpectedConstantTypeProvider.createEditTypeSignatureQuickFix(element), RbsRubyExpectedConstantTypeProvider.createGotoTypeSignatureQuickFix()}).toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            RbsRubyExpectedConstantTypeProvider.$$$reportNull$$$0(3);
        }
        return localQuickFixArray;
    }

    @Nullable
    private static LocalQuickFix createEditTypeSignatureQuickFix(@NotNull PsiElement element) {
        RbsEditTypeSignatureQuickFix quickFix;
        if (element == null) {
            RbsRubyExpectedConstantTypeProvider.$$$reportNull$$$0(4);
        }
        return (quickFix = new RbsEditTypeSignatureQuickFix(){

            @Override
            @Nullable
            protected Symbol getSymbol(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull PsiElement element) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (searchScope == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                return RbsRubyExpectedConstantTypeProvider.findConstantSymbol(project, searchScope, element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "searchScope";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/ruby/rbs/ruby/inspections/probableBugs/RbsRubyExpectedConstantTypeProvider$1";
                objectArray[2] = "getSymbol";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).isAvailable(element.getProject(), element) ? quickFix : null;
    }

    @NotNull
    private static LocalQuickFix createGotoTypeSignatureQuickFix() {
        return new RbsGotoTypeSignatureQuickFix(){

            @Override
            @Nullable
            protected Symbol getSymbol(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull PsiElement element) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (searchScope == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (element == null) {
                    2.$$$reportNull$$$0(2);
                }
                return RbsRubyExpectedConstantTypeProvider.findConstantSymbol(project, searchScope, element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "searchScope";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/ruby/rbs/ruby/inspections/probableBugs/RbsRubyExpectedConstantTypeProvider$2";
                objectArray[2] = "getSymbol";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static Symbol findConstantSymbol(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull PsiElement element) {
        RConstant constant;
        if (project == null) {
            RbsRubyExpectedConstantTypeProvider.$$$reportNull$$$0(5);
        }
        if (searchScope == null) {
            RbsRubyExpectedConstantTypeProvider.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RbsRubyExpectedConstantTypeProvider.$$$reportNull$$$0(7);
        }
        if ((constant = RbsRubyExpectedConstantTypeProvider.getConstant(element)) == null) {
            return null;
        }
        return RbsRubyTypeSignatureUtil.findConstantTypeSignature(project, searchScope, constant).first().orElse(null);
    }

    @Nullable
    private static RConstant getConstant(@NotNull PsiElement element) {
        RAssignmentExpression assignment;
        if (element == null) {
            RbsRubyExpectedConstantTypeProvider.$$$reportNull$$$0(8);
        }
        if ((assignment = RAssignmentExpressionNavigator.getAssignmentByRightPart((PsiElement)element)) == null) {
            return null;
        }
        RPsiElement rPsiElement = assignment.getObject();
        if (rPsiElement instanceof RColonReference) {
            RColonReference colonReference = (RColonReference)rPsiElement;
            return (RConstant)ContainerUtil.getLastItem((List)colonReference.getConstantList());
        }
        return (RConstant)ObjectUtils.tryCast((Object)assignment.getObject(), RConstant.class);
    }

    private static /* synthetic */ RTypeWithNilability lambda$getExpectedConstantTypeWithNilability$1(Project project, SearchScope searchScope, PsiElement invocationPoint, RbsSymbol __, RbsTypeSignature signature) {
        return RbsRubyTypeConverter.convert(project, searchScope, signature, invocationPoint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/inspections/probableBugs/RbsRubyExpectedConstantTypeProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/inspections/probableBugs/RbsRubyExpectedConstantTypeProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMismatchedTypeQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedConstantTypeWithNilability";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMismatchedTypeQuickFixes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEditTypeSignatureQuickFix";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findConstantSymbol";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConstant";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

