/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.inspections.dataFlow;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.ruby.rbs.RbsSupport;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsSearchScope;
import com.intellij.lang.ruby.rbs.ruby.inspections.dataFlow.RbsAddTypeSignatureQuickFix;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeSignatureUtil;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.TopLevelSymbolImpl;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RClassObject;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.AnonymousDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RbsMissingTypeSignatureInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(RbsMissingTypeSignatureInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsMissingTypeSignatureInspection.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || RbsSupport.isRbsUsedInProject(holder.getProject(), holder.getFile())) {
            return new Visitor(holder, isOnTheFly);
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            RbsMissingTypeSignatureInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/inspections/dataFlow/RbsMissingTypeSignatureInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/inspections/dataFlow/RbsMissingTypeSignatureInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class Visitor
    extends RubyInspectionVisitor {
        private Visitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, isOnTheFly);
        }

        public void visitRGlobalVariable(@NotNull RGlobalVariable rGvar) {
            GlobalSearchScope searchScope;
            Project project;
            if (rGvar == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (RubyPsiUtilCore.isDeclaration((PsiElement)rGvar) && RbsRubyTypeSignatureUtil.findGlobalVariableTypeSignature(project = rGvar.getProject(), (SearchScope)(searchScope = rGvar.getResolveScope().intersectWith(RbsSearchScope.collectionScope((PsiElement)rGvar))), rGvar).isEmpty()) {
                TextRange range = TextRange.from((int)1, (int)(rGvar.getTextLength() - 1));
                this.registerMissingTypeSignature((PsiElement)rGvar, range, rGvar.getName(), new RbsAddTypeSignatureQuickFix());
            }
        }

        public void visitRClassVariable(@NotNull RClassVariable rCvar) {
            if (rCvar == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (RubyPsiUtilCore.isDeclaration((PsiElement)rCvar) && Visitor.isInsideValidContext((PsiElement)rCvar)) {
                Project project = rCvar.getProject();
                GlobalSearchScope searchScope = rCvar.getResolveScope().intersectWith(RbsSearchScope.collectionScope((PsiElement)rCvar));
                PsiElement identifier = rCvar.getNameIdentifier();
                if (identifier != null && RbsRubyTypeSignatureUtil.findVariableTypeSignature(project, (SearchScope)searchScope, (RField)rCvar).isEmpty()) {
                    TextRange range = TextRange.from((int)2, (int)(identifier.getTextLength() - 2));
                    this.registerMissingTypeSignature(identifier, range, rCvar.getName(), new RbsAddTypeSignatureQuickFix());
                }
            }
        }

        public void visitRInstanceVariable(@NotNull RInstanceVariable rIvar) {
            if (rIvar == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (RubyPsiUtilCore.isDeclaration((PsiElement)rIvar) && Visitor.isInsideValidContext((PsiElement)rIvar)) {
                Project project = rIvar.getProject();
                GlobalSearchScope searchScope = rIvar.getResolveScope().intersectWith(RbsSearchScope.collectionScope((PsiElement)rIvar));
                PsiElement identifier = rIvar.getNameIdentifier();
                if (identifier != null && RbsRubyTypeSignatureUtil.findVariableTypeSignature(project, (SearchScope)searchScope, (RField)rIvar).isEmpty()) {
                    TextRange range = TextRange.from((int)1, (int)(identifier.getTextLength() - 1));
                    this.registerMissingTypeSignature(identifier, range, rIvar.getName(), new RbsAddTypeSignatureQuickFix());
                }
            }
        }

        public void visitRConstant(@NotNull RConstant rConstant) {
            GlobalSearchScope searchScope;
            Project project;
            if (rConstant == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (RubyPsiUtilCore.isDeclaration((PsiElement)rConstant) && RbsRubyTypeSignatureUtil.findConstantTypeSignature(project = rConstant.getProject(), (SearchScope)(searchScope = rConstant.getResolveScope().intersectWith(RbsSearchScope.collectionScope((PsiElement)rConstant))), rConstant).isEmpty()) {
                this.registerMissingTypeSignature(rConstant.getNameIdentifier(), null, rConstant.getName(), new RbsAddTypeSignatureQuickFix());
            }
        }

        public void visitRMethod(@NotNull RMethod method) {
            if (method == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (!Visitor.isInsideValidContext((PsiElement)method)) {
                return;
            }
            Project project = method.getProject();
            GlobalSearchScope searchScope = method.getResolveScope().intersectWith(RbsSearchScope.collectionScope((PsiElement)method));
            PsiElement identifier = method.getNameIdentifier();
            String name = method.getName();
            if (identifier == null) {
                return;
            }
            RbsRubyTypeSignatureUtil.MethodContext context = RbsRubyTypeSignatureUtil.getMethodContext(project, (SearchScope)searchScope, method);
            TextRange rangeInParent = identifier.getTextRange().shiftLeft(method.getTextRange().getStartOffset());
            if (context == null) {
                this.registerMissingTypeSignature((PsiElement)method, rangeInParent, name, new RbsAddTypeSignatureQuickFix());
            } else if (context.getContainerSymbol().children(project, (SearchScope)searchScope).noneMatch(it -> it.equals((Object)context.getSymbol()))) {
                this.registerOverridableTypeSignature((PsiElement)method, rangeInParent, name, new RbsAddTypeSignatureQuickFix());
            }
        }

        public void visitRSingletonMethod(@NotNull RSingletonMethod rsMethod) {
            if (rsMethod == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (!Visitor.isInsideValidContext((PsiElement)rsMethod)) {
                return;
            }
            if (RubyPsiUtilCore.isSelfObject((RClassObject)rsMethod.getClassObject())) {
                this.visitRMethod((RMethod)rsMethod);
            }
        }

        public void visitRAliasStatement(@NotNull RAliasStatement aliasStatement) {
            if (aliasStatement == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            Project project = aliasStatement.getProject();
            GlobalSearchScope searchScope = aliasStatement.getResolveScope().intersectWith(RbsSearchScope.collectionScope((PsiElement)aliasStatement));
            RPsiElement psiNewName = aliasStatement.getPsiNewName();
            String name = aliasStatement.getNewName();
            if (psiNewName == null || name == null) {
                return;
            }
            if (aliasStatement.isMethodAlias() && Visitor.isInsideValidContext((PsiElement)aliasStatement)) {
                RbsRubyTypeSignatureUtil.MethodContext context = RbsRubyTypeSignatureUtil.getMethodContext(project, (SearchScope)searchScope, aliasStatement);
                TextRange rangeInParent = psiNewName.getTextRangeInParent();
                if (context == null) {
                    this.registerMissingTypeSignature((PsiElement)aliasStatement, rangeInParent, name, new RbsAddTypeSignatureQuickFix());
                } else if (context.getContainerSymbol().children(project, (SearchScope)searchScope).noneMatch(it -> it.equals((Object)context.getSymbol()))) {
                    this.registerOverridableTypeSignature((PsiElement)aliasStatement, rangeInParent, name, new RbsAddTypeSignatureQuickFix());
                }
            } else if (aliasStatement.isGlobalVariableAlias() && RbsRubyTypeSignatureUtil.findGlobalVariableTypeSignature(project, (SearchScope)searchScope, aliasStatement).isEmpty()) {
                TextRange range = psiNewName.getTextRangeInParent().shiftRight(1).grown(-1);
                this.registerMissingTypeSignature((PsiElement)aliasStatement, range, psiNewName.getName(), new RbsAddTypeSignatureQuickFix());
            }
        }

        public void visitAttrReaderCall(@NotNull RCall rCall) {
            if (rCall == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            if (!Visitor.isInsideValidContext((PsiElement)rCall)) {
                return;
            }
            for (RPsiElement argument : rCall.getCallArguments().getElements()) {
                this.processAttrArgument(rCall, argument);
            }
        }

        public void visitAttrWriterCall(@NotNull RCall rCall) {
            if (rCall == null) {
                Visitor.$$$reportNull$$$0(9);
            }
            if (!Visitor.isInsideValidContext((PsiElement)rCall)) {
                return;
            }
            for (RPsiElement argument : rCall.getCallArguments().getElements()) {
                this.processAttrArgument(rCall, argument);
            }
        }

        public void visitAttrAccessorCall(@NotNull RCall rCall) {
            if (rCall == null) {
                Visitor.$$$reportNull$$$0(10);
            }
            if (!Visitor.isInsideValidContext((PsiElement)rCall)) {
                return;
            }
            for (RPsiElement argument : rCall.getCallArguments().getElements()) {
                this.processAttrArgument(rCall, argument);
            }
        }

        private void processAttrArgument(@NotNull RCall rCall, @NotNull RPsiElement argument) {
            RSymbol symbol;
            String symbolName;
            if (rCall == null) {
                Visitor.$$$reportNull$$$0(11);
            }
            if (argument == null) {
                Visitor.$$$reportNull$$$0(12);
            }
            if ((symbolName = (String)ObjectUtils.doIfNotNull((Object)(symbol = (RSymbol)ObjectUtils.tryCast((Object)argument, RSymbol.class)), RubyInterpretUtil::evaluateStringOrSymbolElement)) == null || symbolName.isBlank()) {
                return;
            }
            RubyCallType callType = rCall.getCallType();
            Project project = rCall.getProject();
            GlobalSearchScope searchScope = rCall.getResolveScope().intersectWith(RbsSearchScope.collectionScope((PsiElement)rCall));
            List<Pair<String, String>> missing = Visitor.getMissingTypeSignaturesForAttrCall(rCall, symbolName, callType, project, (SearchScope)searchScope);
            this.registerMissingTypeSignatureForAttrCall(symbolName, callType, rCall, symbol.getNameIdentifier(), missing);
        }

        private void registerMissingTypeSignatureForAttrCall(@NotNull String symbolName, @NotNull RubyCallType<?> callType, @NotNull RCall call, @Nullable PsiElement target, @NotNull List<Pair<String, String>> missing) {
            if (symbolName == null) {
                Visitor.$$$reportNull$$$0(13);
            }
            if (callType == null) {
                Visitor.$$$reportNull$$$0(14);
            }
            if (call == null) {
                Visitor.$$$reportNull$$$0(15);
            }
            if (missing == null) {
                Visitor.$$$reportNull$$$0(16);
            }
            if (target == null || missing.isEmpty()) {
                return;
            }
            TextRange rangeInParent = target.getTextRange().shiftLeft(call.getTextOffset());
            int maxMissingSigs = callType == RubyCallTypes.ATTR_ACCESSOR_CALL ? 3 : 2;
            int size = missing.size();
            LOG.assertTrue(size <= maxMissingSigs, (Object)("Number of missing signatures for attribute call exceeds " + maxMissingSigs));
            if (size == maxMissingSigs) {
                this.registerMissingTypeSignature((PsiElement)call, rangeInParent, symbolName, new RbsAddTypeSignatureQuickFix());
                return;
            }
            List args = ContainerUtil.prepend((List)ContainerUtil.flatMap(missing, p -> List.of((String)p.first, (String)p.second)), (Object[])new Object[]{size});
            String message = RbsBundle.message((String)"rbs.inspection.missing.type.signature.declaration.attr.description", (Object[])args.toArray());
            boolean isInjected = InjectedLanguageManager.getInstance((Project)this.myHolder.getProject()).isInjectedFragment(this.myHolder.getFile());
            ProblemHighlightType highlightType = !isInjected ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
            this.myHolder.registerProblem((PsiElement)call, message, highlightType, rangeInParent, new LocalQuickFix[]{new RbsAddTypeSignatureQuickFix()});
        }

        private void registerMissingTypeSignature(@Nullable PsiElement target, @Nullable(value="null means the text range of the element") @Nullable(value="null means the text range of the element") TextRange rangeInParent, @Nullable String name, @NotNull LocalQuickFix quickFix) {
            if (quickFix == null) {
                Visitor.$$$reportNull$$$0(17);
            }
            if (target == null || name == null) {
                return;
            }
            String message = RbsBundle.message((String)"rbs.inspection.missing.type.signature.declaration.description", (Object[])new Object[]{name});
            boolean isInjected = InjectedLanguageManager.getInstance((Project)this.myHolder.getProject()).isInjectedFragment(this.myHolder.getFile());
            if (!isInjected) {
                this.myHolder.registerProblem(target, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, rangeInParent, new LocalQuickFix[]{quickFix});
            } else if (this.myOnTheFly) {
                this.myHolder.registerProblem(target, message, ProblemHighlightType.INFORMATION, rangeInParent, new LocalQuickFix[]{quickFix});
            }
        }

        private void registerOverridableTypeSignature(@NotNull PsiElement target, @NotNull TextRange rangeInParent, @NotNull String name, @NotNull LocalQuickFix quickFix) {
            if (target == null) {
                Visitor.$$$reportNull$$$0(18);
            }
            if (rangeInParent == null) {
                Visitor.$$$reportNull$$$0(19);
            }
            if (name == null) {
                Visitor.$$$reportNull$$$0(20);
            }
            if (quickFix == null) {
                Visitor.$$$reportNull$$$0(21);
            }
            String message = RbsBundle.message((String)"rbs.inspection.missing.type.signature.declaration.description", (Object[])new Object[]{name});
            if (this.myOnTheFly) {
                this.myHolder.registerProblem(target, message, ProblemHighlightType.INFORMATION, rangeInParent, new LocalQuickFix[]{quickFix});
            }
        }

        @Nullable
        private static RbsMethodSymbol findMethodSymbol(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull PsiElement element, @NotNull String name) {
            RbsContainerSymbol containerSymbol;
            if (project == null) {
                Visitor.$$$reportNull$$$0(22);
            }
            if (searchScope == null) {
                Visitor.$$$reportNull$$$0(23);
            }
            if (element == null) {
                Visitor.$$$reportNull$$$0(24);
            }
            if (name == null) {
                Visitor.$$$reportNull$$$0(25);
            }
            if ((containerSymbol = RbsRubyTypeUtil.findContainerSymbolForRubyElement(project, searchScope, element)) == null) {
                return null;
            }
            return containerSymbol.allChildren(project, searchScope).mapMulti(StreamUtil.select(RbsMethodSymbol.class, (Class[])new Class[0])).filter(child -> child.getName().equals(name)).findFirst().orElse(null);
        }

        @NotNull
        private static List<Pair<String, String>> getMissingTypeSignaturesForAttrCall(@NotNull RCall rCall, @NotNull String symbolName, @NotNull RubyCallType<?> callType, @NotNull Project project, @NotNull SearchScope searchScope) {
            String setterName;
            if (rCall == null) {
                Visitor.$$$reportNull$$$0(26);
            }
            if (symbolName == null) {
                Visitor.$$$reportNull$$$0(27);
            }
            if (callType == null) {
                Visitor.$$$reportNull$$$0(28);
            }
            if (project == null) {
                Visitor.$$$reportNull$$$0(29);
            }
            if (searchScope == null) {
                Visitor.$$$reportNull$$$0(30);
            }
            SmartList missing = new SmartList();
            if (RbsRubyTypeSignatureUtil.findVariableTypeSignature(project, searchScope, rCall, symbolName).isEmpty()) {
                missing.add(Pair.pair((Object)RBundle.message((String)"instance.variable"), (Object)symbolName));
            }
            if (callType != RubyCallTypes.ATTR_WRITER_CALL && Visitor.findMethodSymbol(project, searchScope, (PsiElement)rCall, symbolName) == null) {
                missing.add(Pair.pair((Object)RBundle.message((String)"method"), (Object)symbolName));
            }
            if (callType != RubyCallTypes.ATTR_READER_CALL && Visitor.findMethodSymbol(project, searchScope, (PsiElement)rCall, setterName = symbolName + "=") == null) {
                missing.add(Pair.pair((Object)RBundle.message((String)"method"), (Object)setterName));
            }
            SmartList smartList = missing;
            if (smartList == null) {
                Visitor.$$$reportNull$$$0(31);
            }
            return smartList;
        }

        private static boolean isInsideValidContext(@NotNull PsiElement element) {
            Symbol context;
            if (element == null) {
                Visitor.$$$reportNull$$$0(32);
            }
            if ((context = SymbolUtil.getScopeContextWithCaching((PsiElement)element)) == null) {
                return false;
            }
            return !(context instanceof TopLevelSymbolImpl) && !AnonymousDefiningCallType.isAnonymousFQN((FQN)context.getFQNWithNesting());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 31 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rGvar";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rCvar";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rIvar";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rConstant";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rsMethod";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aliasStatement";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rCall";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 13: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbolName";
                    break;
                }
                case 14: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callType";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "missing";
                    break;
                }
                case 17: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "quickFix";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInParent";
                    break;
                }
                case 20: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 22: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 23: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
                case 24: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/inspections/dataFlow/RbsMissingTypeSignatureInspection$Visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/inspections/dataFlow/RbsMissingTypeSignatureInspection$Visitor";
                    break;
                }
                case 31: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMissingTypeSignaturesForAttrCall";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRGlobalVariable";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRClassVariable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRInstanceVariable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRConstant";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRMethod";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRSingletonMethod";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRAliasStatement";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAttrReaderCall";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAttrWriterCall";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAttrAccessorCall";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "processAttrArgument";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "registerMissingTypeSignatureForAttrCall";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "registerMissingTypeSignature";
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "registerOverridableTypeSignature";
                    break;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "findMethodSymbol";
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "getMissingTypeSignaturesForAttrCall";
                    break;
                }
                case 31: {
                    break;
                }
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "isInsideValidContext";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 31 -> new IllegalStateException(string);
            };
        }
    }
}

