/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.inspections;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.ruby.model.impl.RbsRubyContainerSymbol;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeSignatureUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.AnonymousDefiningCallType;

public final class RbsRubyInspectionUtil {
    private RbsRubyInspectionUtil() {
    }

    public static boolean isIgnoredCallContext(@NotNull RbsContainerSymbol container, @NotNull RbsMethodSymbol method, @NotNull RPossibleCall call) {
        if (container == null) {
            RbsRubyInspectionUtil.$$$reportNull$$$0(0);
        }
        if (method == null) {
            RbsRubyInspectionUtil.$$$reportNull$$$0(1);
        }
        if (call == null) {
            RbsRubyInspectionUtil.$$$reportNull$$$0(2);
        }
        PsiReference reference = (PsiReference)ObjectUtils.doIfNotNull((Object)call.getPsiCommand(), PsiElement::getReference);
        return RbsRubyInspectionUtil.isIgnoredCallOrMethodContext(container, method, reference);
    }

    public static boolean isIgnoredCallContext(@NotNull RbsRubyTypeSignatureUtil.CallContext context, @NotNull RPossibleCall call) {
        if (context == null) {
            RbsRubyInspectionUtil.$$$reportNull$$$0(3);
        }
        if (call == null) {
            RbsRubyInspectionUtil.$$$reportNull$$$0(4);
        }
        PsiReference reference = (PsiReference)ObjectUtils.doIfNotNull((Object)call.getPsiCommand(), PsiElement::getReference);
        return RbsRubyInspectionUtil.isIgnoredCallOrMethodContext(context.getContainerSymbol(), context.getSymbol(), reference);
    }

    public static boolean isIgnoredMethodContext(@NotNull RbsRubyTypeSignatureUtil.MethodContext context, @NotNull RBinaryExpression expression) {
        if (context == null) {
            RbsRubyInspectionUtil.$$$reportNull$$$0(5);
        }
        if (expression == null) {
            RbsRubyInspectionUtil.$$$reportNull$$$0(6);
        }
        PsiReference reference = expression.getReference();
        return RbsRubyInspectionUtil.isIgnoredCallOrMethodContext(context.getContainerSymbol(), context.getSymbol(), reference);
    }

    public static boolean isIgnoredMethodContext(@NotNull RbsRubyTypeSignatureUtil.MethodContext context, @NotNull RPossibleCall call) {
        if (context == null) {
            RbsRubyInspectionUtil.$$$reportNull$$$0(7);
        }
        if (call == null) {
            RbsRubyInspectionUtil.$$$reportNull$$$0(8);
        }
        PsiReference reference = (PsiReference)ContainerUtil.getOnlyItem(List.of(((PsiElement)ObjectUtils.coalesce((Object)call.getPsiCommand(), (Object)call.getFirstChild())).getReferences()));
        return RbsRubyInspectionUtil.isIgnoredCallOrMethodContext(context.getContainerSymbol(), context.getSymbol(), reference);
    }

    private static boolean isIgnoredCallOrMethodContext(@NotNull RbsContainerSymbol container, @NotNull RbsMethodSymbol symbol, @Nullable PsiReference reference) {
        if (container == null) {
            RbsRubyInspectionUtil.$$$reportNull$$$0(9);
        }
        if (symbol == null) {
            RbsRubyInspectionUtil.$$$reportNull$$$0(10);
        }
        if (!(container instanceof RbsRubyContainerSymbol)) {
            return false;
        }
        if (AnonymousDefiningCallType.isAnonymousFQN((FQN)FQN.of((String)container.getFqn().join()))) {
            return true;
        }
        Symbol target = ResolveUtil.resolveToSymbolWithCaching((PsiReference)reference);
        if (target == null) {
            return true;
        }
        return !target.getFQNWithNesting().getCallerFQN().getFullPath().equals(symbol.getContainerFqn().join());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/inspections/RbsRubyInspectionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredCallContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredMethodContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredCallOrMethodContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

