/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.ruby.codeInsight.types;

import com.intellij.lang.ruby.rbs.model.impl.RbsClassVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInstanceVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsSearchScope;
import com.intellij.lang.ruby.rbs.ruby.codeInsight.symbols.RbsRubyClassVariableSymbol;
import com.intellij.lang.ruby.rbs.ruby.codeInsight.symbols.RbsRubyInstanceVariableSymbol;
import com.intellij.lang.ruby.rbs.ruby.codeInsight.symbols.RbsRubyMethodSymbol;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ThreeState;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RDuckType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeWithNilability;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RTypeBase;

public final class RbsRubyInterfaceType
extends RTypeBase
implements RDuckType {
    private final Project myProject;
    private final SearchScope mySearchScope;
    private final RbsInterfaceSymbol mySymbol;
    private final List<RTypeWithNilability> myTypeArguments;

    public RbsRubyInterfaceType(@NotNull Project project, @NotNull RbsInterfaceSymbol symbol, @NotNull List<RTypeWithNilability> typeArguments) {
        if (project == null) {
            RbsRubyInterfaceType.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            RbsRubyInterfaceType.$$$reportNull$$$0(1);
        }
        if (typeArguments == null) {
            RbsRubyInterfaceType.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.mySearchScope = RbsSearchScope.collectionScope(project);
        this.mySymbol = symbol;
        this.myTypeArguments = List.copyOf(typeArguments);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RbsRubyInterfaceType other = (RbsRubyInterfaceType)((Object)obj);
        return this.myProject.equals((Object)other.myProject) && this.mySymbol.equals(other.mySymbol) && this.myTypeArguments.equals(other.myTypeArguments);
    }

    @NotNull
    public Collection<? extends Symbol> getMembers(@NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint) {
        if (filter == null) {
            RbsRubyInterfaceType.$$$reportNull$$$0(3);
        }
        List<? super Symbol> list = this.members().filter(filter).toList();
        if (list == null) {
            RbsRubyInterfaceType.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void processMembers(@NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint, @NotNull Consumer<? super Symbol> processor) {
        if (filter == null) {
            RbsRubyInterfaceType.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            RbsRubyInterfaceType.$$$reportNull$$$0(6);
        }
        this.members().filter(filter).forEach(processor);
    }

    @Nullable
    public Symbol getMemberForName(@NotNull String name, @NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint) {
        if (name == null) {
            RbsRubyInterfaceType.$$$reportNull$$$0(7);
        }
        if (filter == null) {
            RbsRubyInterfaceType.$$$reportNull$$$0(8);
        }
        return this.members().filter(member -> {
            RbsRubyMethodSymbol method;
            RbsRubyInstanceVariableSymbol instanceVariable;
            RbsRubyClassVariableSymbol classVariable;
            if (member instanceof RbsRubyClassVariableSymbol && (classVariable = (RbsRubyClassVariableSymbol)member).getName().equals(name)) {
                return true;
            }
            if (member instanceof RbsRubyInstanceVariableSymbol && (instanceVariable = (RbsRubyInstanceVariableSymbol)member).getName().equals(name)) {
                return true;
            }
            return member instanceof RbsRubyMethodSymbol && (method = (RbsRubyMethodSymbol)member).getName().equals(name);
        }).filter(filter).findFirst().orElse(null);
    }

    @NotNull
    public String getName() {
        String name = this.mySymbol.getFqn().join();
        if (this.myTypeArguments.isEmpty()) {
            String string = name;
            if (string == null) {
                RbsRubyInterfaceType.$$$reportNull$$$0(9);
            }
            return string;
        }
        String typeArguments = this.myTypeArguments.stream().map(it -> {
            if (it.getType() == REmptyType.INSTANCE) {
                return it.getCanBeNil() == ThreeState.YES ? RBundle.message((String)"nil") : RBundle.message((String)"editor.expressionTypeProvider.untypedType");
            }
            return it.getType().getName();
        }).collect(Collectors.joining(", "));
        String string = String.format("%s[%s]", name, typeArguments);
        if (string == null) {
            RbsRubyInterfaceType.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String presentableName = this.mySymbol.getFqn().join();
        if (this.myTypeArguments.isEmpty()) {
            String string = presentableName;
            if (string == null) {
                RbsRubyInterfaceType.$$$reportNull$$$0(11);
            }
            return string;
        }
        String typeArguments = this.myTypeArguments.stream().map(it -> {
            if (it.getType() == REmptyType.INSTANCE) {
                return it.getCanBeNil() == ThreeState.YES ? RBundle.message((String)"nil") : RBundle.message((String)"editor.expressionTypeProvider.untypedType");
            }
            return it.getType().getPresentableName();
        }).collect(Collectors.joining(", "));
        String string = String.format("%s[%s]", presentableName, typeArguments);
        if (string == null) {
            RbsRubyInterfaceType.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public RbsInterfaceSymbol getSymbol() {
        RbsInterfaceSymbol rbsInterfaceSymbol = this.mySymbol;
        if (rbsInterfaceSymbol == null) {
            RbsRubyInterfaceType.$$$reportNull$$$0(13);
        }
        return rbsInterfaceSymbol;
    }

    @NotNull
    public List<RTypeWithNilability> getTypeArguments() {
        List<RTypeWithNilability> list = this.myTypeArguments;
        if (list == null) {
            RbsRubyInterfaceType.$$$reportNull$$$0(14);
        }
        return list;
    }

    public int hashCode() {
        int result = this.myProject.hashCode();
        result = 31 * result + this.mySymbol.hashCode();
        result = 31 * result + this.myTypeArguments.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        String string = this.mySymbol.getFqn().join();
        if (string == null) {
            RbsRubyInterfaceType.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private Stream<Symbol> members() {
        Stream<Symbol> stream = this.mySymbol.allChildren(this.myProject, this.mySearchScope).mapMulti((child, consumer) -> {
            if (child instanceof RbsClassVariableSymbol) {
                RbsClassVariableSymbol classVariable = (RbsClassVariableSymbol)child;
                consumer.accept(new RbsRubyClassVariableSymbol(this.myProject, classVariable));
            } else if (child instanceof RbsInstanceVariableSymbol) {
                RbsInstanceVariableSymbol instanceVariable = (RbsInstanceVariableSymbol)child;
                consumer.accept(new RbsRubyInstanceVariableSymbol(this.myProject, instanceVariable));
            } else if (child instanceof RbsMethodSymbol) {
                RbsMethodSymbol method = (RbsMethodSymbol)child;
                consumer.accept(new RbsRubyMethodSymbol(this.myProject, method));
            }
        });
        if (stream == null) {
            RbsRubyInterfaceType.$$$reportNull$$$0(16);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 10, 11, 12, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/ruby/codeInsight/types/RbsRubyInterfaceType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/ruby/codeInsight/types/RbsRubyInterfaceType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbol";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "members";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMembers";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMemberForName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 10, 11, 12, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

