/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.psi.util;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ruby.rbs.common.RbsFileType;
import com.intellij.ruby.rbs.common.psi.RbsPsiFile;
import com.intellij.ruby.rbs.common.psi.RbsPsiRecursiveVisitor;
import com.intellij.ruby.rbs.common.psi.api.RbsAliasMember;
import com.intellij.ruby.rbs.common.psi.api.RbsAttributeMember;
import com.intellij.ruby.rbs.common.psi.api.RbsConstDecl;
import com.intellij.ruby.rbs.common.psi.api.RbsExtendMember;
import com.intellij.ruby.rbs.common.psi.api.RbsGlobalDecl;
import com.intellij.ruby.rbs.common.psi.api.RbsIncludeMember;
import com.intellij.ruby.rbs.common.psi.api.RbsMethodMember;
import com.intellij.ruby.rbs.common.psi.api.RbsMethodType;
import com.intellij.ruby.rbs.common.psi.api.RbsModuleTypeParam;
import com.intellij.ruby.rbs.common.psi.api.RbsPrivateMember;
import com.intellij.ruby.rbs.common.psi.api.RbsProcType;
import com.intellij.ruby.rbs.common.psi.api.RbsType;
import com.intellij.ruby.rbs.common.psi.api.RbsUseDirective;
import com.intellij.ruby.rbs.common.psi.api.RbsVarTypeMember;
import com.intellij.ruby.rbs.common.psi.data.RbsAttributeType;
import com.intellij.ruby.rbs.common.psi.data.RbsDeclarationType;
import com.intellij.ruby.rbs.common.psi.data.RbsUseClauseType;
import com.intellij.ruby.rbs.common.psi.data.RbsVisibility;
import com.intellij.ruby.rbs.common.psi.impl.RbsUseDirectiveImpl;
import com.intellij.ruby.rbs.common.util.Fqn;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class RbsPsiElementFactory {
    private static final String DUMMY_ALIAS_MEMBER = "class Dummy\nalias %s%s %s%s\nend";
    private static final String DUMMY_ATTRIBUTE_ACCESSOR_MEMBER = "class Dummy\n%s\nattr_accessor %s%s: untyped\nend";
    private static final String DUMMY_ATTRIBUTE_READER_MEMBER = "class Dummy\n%s\nattr_reader %s%s: untyped\nend";
    private static final String DUMMY_ATTRIBUTE_WRITER_MEMBER = "class Dummy\n%s\nattr_writer %s%s: untyped\nend";
    private static final String DUMMY_CLASS_VARIABLE = "class Dummy\n@@%s: untyped\nend";
    private static final String DUMMY_CONSTANT = "%s: untyped";
    private static final String DUMMY_EXTEND_MEMBER = "class Dummy\nextend %s\nend";
    private static final String DUMMY_FILENAME = "dummy.rbs";
    private static final String DUMMY_GLOBAL_VARIABLE = "$%s: untyped";
    private static final String DUMMY_INCLUDE_MEMBER = "class Dummy\ninclude %s\nend";
    private static final String DUMMY_INSTANCE_VARIABLE = "class Dummy\n%s@%s: untyped\nend";
    private static final String DUMMY_METHOD_MEMBER = "class Dummy\n%s\ndef %s%s: -> untyped\nend";
    private static final String DUMMY_METHOD_TYPE = "class Dummy\ndef dummy: %s\nend";
    private static final String DUMMY_MODULE_TYPE_PARAMETER = "class Dummy[%s]\nend";
    private static final String DUMMY_PRIVATE_MEMBER = "class Dummy\nprivate\nend";
    private static final String DUMMY_PROC_TYPE = "class Dummy\ndef call: %s\nend";
    private static final String DUMMY_TYPE = "$dummy: %s";
    private static final String DUMMY_USE_ALIAS = "use %s as %s";
    private static final String DUMMY_USE_IMPORT = "use %s";
    private static final String DUMMY_USE_WILDCARD = "use %s::*";

    private RbsPsiElementFactory() {
    }

    @NotNull
    public static RbsAliasMember createAliasMember(@NotNull Project project, @NotNull RbsDeclarationType declarationType, @NotNull String name, @NotNull String targetName) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(0);
        }
        if (declarationType == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(1);
        }
        if (name == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(2);
        }
        if (targetName == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(3);
        }
        final Ref aliasRef = new Ref();
        String declarationPrefix = declarationType == RbsDeclarationType.SINGLETON_DECLARATION ? "self." : "";
        String template = DUMMY_ALIAS_MEMBER.formatted(declarationPrefix, name, declarationPrefix, targetName);
        RbsPsiElementFactory.createFile(project, template).accept((PsiElementVisitor)new RbsPsiRecursiveVisitor(){

            public void visitAliasMember(@NotNull RbsAliasMember member) {
                if (member == null) {
                    1.$$$reportNull$$$0(0);
                }
                aliasRef.set((Object)member);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory$1", "visitAliasMember"));
            }
        });
        RbsAliasMember rbsAliasMember = (RbsAliasMember)aliasRef.get();
        if (rbsAliasMember == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(4);
        }
        return rbsAliasMember;
    }

    @NotNull
    public static RbsAttributeMember createAttributeMember(@NotNull Project project, @NotNull RbsVisibility visibility, @NotNull RbsAttributeType attributeType, @NotNull RbsDeclarationType declarationType, @NotNull String name) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(5);
        }
        if (visibility == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(6);
        }
        if (attributeType == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(7);
        }
        if (declarationType == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(8);
        }
        if (name == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(9);
        }
        final Ref attributeRef = new Ref();
        String visibilityPrefix = visibility == RbsVisibility.PRIVATE_VISIBILITY ? "private" : "";
        String declarationPrefix = declarationType == RbsDeclarationType.SINGLETON_DECLARATION ? "self." : "";
        String template = switch (attributeType) {
            default -> throw new MatchException(null, null);
            case RbsAttributeType.ATTRIBUTE_ACCESSOR -> DUMMY_ATTRIBUTE_ACCESSOR_MEMBER.formatted(visibilityPrefix, declarationPrefix, name);
            case RbsAttributeType.ATTRIBUTE_READER -> DUMMY_ATTRIBUTE_READER_MEMBER.formatted(visibilityPrefix, declarationPrefix, name);
            case RbsAttributeType.ATTRIBUTE_WRITER -> DUMMY_ATTRIBUTE_WRITER_MEMBER.formatted(visibilityPrefix, declarationPrefix, name);
        };
        RbsPsiElementFactory.createFile(project, template).accept((PsiElementVisitor)new RbsPsiRecursiveVisitor(){

            public void visitAttributeMember(@NotNull RbsAttributeMember member) {
                if (member == null) {
                    2.$$$reportNull$$$0(0);
                }
                attributeRef.set((Object)member);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory$2", "visitAttributeMember"));
            }
        });
        RbsAttributeMember rbsAttributeMember = (RbsAttributeMember)attributeRef.get();
        if (rbsAttributeMember == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(10);
        }
        return rbsAttributeMember;
    }

    @NotNull
    public static RbsVarTypeMember createClassVariableMember(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(11);
        }
        if (name == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(12);
        }
        final Ref classVariableRef = new Ref();
        RbsPsiElementFactory.createFile(project, DUMMY_CLASS_VARIABLE.formatted(name)).accept((PsiElementVisitor)new RbsPsiRecursiveVisitor(){

            public void visitVarTypeMember(@NotNull RbsVarTypeMember member) {
                if (member == null) {
                    3.$$$reportNull$$$0(0);
                }
                classVariableRef.set((Object)member);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory$3", "visitVarTypeMember"));
            }
        });
        RbsVarTypeMember rbsVarTypeMember = (RbsVarTypeMember)classVariableRef.get();
        if (rbsVarTypeMember == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(13);
        }
        return rbsVarTypeMember;
    }

    @NotNull
    public static RbsConstDecl createConstantDeclaration(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(14);
        }
        if (name == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(15);
        }
        final Ref constantRef = new Ref();
        RbsPsiElementFactory.createFile(project, DUMMY_CONSTANT.formatted(name)).accept((PsiElementVisitor)new RbsPsiRecursiveVisitor(){

            public void visitConstDecl(@NotNull RbsConstDecl declaration) {
                if (declaration == null) {
                    4.$$$reportNull$$$0(0);
                }
                constantRef.set((Object)declaration);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory$4", "visitConstDecl"));
            }
        });
        RbsConstDecl rbsConstDecl = (RbsConstDecl)constantRef.get();
        if (rbsConstDecl == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(16);
        }
        return rbsConstDecl;
    }

    @NotNull
    public static RbsPsiFile createFile(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(17);
        }
        if (text == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(18);
        }
        RbsPsiFile rbsPsiFile = (RbsPsiFile)PsiFileFactory.getInstance((Project)project).createFileFromText(DUMMY_FILENAME, (FileType)RbsFileType.INSTANCE, (CharSequence)text);
        if (rbsPsiFile == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(19);
        }
        return rbsPsiFile;
    }

    @NotNull
    public static RbsGlobalDecl createGlobalVariableDeclaration(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(20);
        }
        if (name == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(21);
        }
        final Ref globalVariableRef = new Ref();
        RbsPsiElementFactory.createFile(project, DUMMY_GLOBAL_VARIABLE.formatted(name)).accept((PsiElementVisitor)new RbsPsiRecursiveVisitor(){

            public void visitGlobalDecl(@NotNull RbsGlobalDecl declaration) {
                if (declaration == null) {
                    5.$$$reportNull$$$0(0);
                }
                globalVariableRef.set((Object)declaration);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory$5", "visitGlobalDecl"));
            }
        });
        RbsGlobalDecl rbsGlobalDecl = (RbsGlobalDecl)globalVariableRef.get();
        if (rbsGlobalDecl == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(22);
        }
        return rbsGlobalDecl;
    }

    @NotNull
    public static RbsExtendMember createExtendMember(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(23);
        }
        if (name == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(24);
        }
        final Ref rbsExtendMemberRef = new Ref();
        RbsPsiElementFactory.createFile(project, DUMMY_EXTEND_MEMBER.formatted(name)).accept((PsiElementVisitor)new RbsPsiRecursiveVisitor(){

            public void visitExtendMember(@NotNull RbsExtendMember member) {
                if (member == null) {
                    6.$$$reportNull$$$0(0);
                }
                rbsExtendMemberRef.setIfNull((Object)member);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory$6", "visitExtendMember"));
            }
        });
        RbsExtendMember rbsExtendMember = (RbsExtendMember)rbsExtendMemberRef.get();
        if (rbsExtendMember == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(25);
        }
        return rbsExtendMember;
    }

    @NotNull
    public static RbsIncludeMember createIncludeMember(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(26);
        }
        if (name == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(27);
        }
        final Ref rbsIncludeMemberRef = new Ref();
        RbsPsiElementFactory.createFile(project, DUMMY_INCLUDE_MEMBER.formatted(name)).accept((PsiElementVisitor)new RbsPsiRecursiveVisitor(){

            public void visitIncludeMember(@NotNull RbsIncludeMember member) {
                if (member == null) {
                    7.$$$reportNull$$$0(0);
                }
                rbsIncludeMemberRef.setIfNull((Object)member);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory$7", "visitIncludeMember"));
            }
        });
        RbsIncludeMember rbsIncludeMember = (RbsIncludeMember)rbsIncludeMemberRef.get();
        if (rbsIncludeMember == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(28);
        }
        return rbsIncludeMember;
    }

    @NotNull
    public static RbsVarTypeMember createInstanceVariableMember(@NotNull Project project, @NotNull RbsDeclarationType declarationType, @NotNull String name) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(29);
        }
        if (declarationType == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(30);
        }
        if (name == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(31);
        }
        final Ref instanceVariableRef = new Ref();
        String declarationPrefix = declarationType == RbsDeclarationType.SINGLETON_DECLARATION ? "self." : "";
        String template = DUMMY_INSTANCE_VARIABLE.formatted(declarationPrefix, name);
        RbsPsiElementFactory.createFile(project, template).accept((PsiElementVisitor)new RbsPsiRecursiveVisitor(){

            public void visitVarTypeMember(@NotNull RbsVarTypeMember member) {
                if (member == null) {
                    8.$$$reportNull$$$0(0);
                }
                instanceVariableRef.set((Object)member);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory$8", "visitVarTypeMember"));
            }
        });
        RbsVarTypeMember rbsVarTypeMember = (RbsVarTypeMember)instanceVariableRef.get();
        if (rbsVarTypeMember == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(32);
        }
        return rbsVarTypeMember;
    }

    @NotNull
    public static RbsMethodMember createMethodMember(@NotNull Project project, @NotNull RbsVisibility visibility, @NotNull RbsDeclarationType declarationType, @NotNull String name) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(33);
        }
        if (visibility == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(34);
        }
        if (declarationType == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(35);
        }
        if (name == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(36);
        }
        final Ref methodRef = new Ref();
        String declarationPrefix = declarationType == RbsDeclarationType.SINGLETON_DECLARATION ? "self." : "";
        String visibilityPrefix = visibility == RbsVisibility.PRIVATE_VISIBILITY ? "private" : "";
        String template = DUMMY_METHOD_MEMBER.formatted(visibilityPrefix, declarationPrefix, name);
        RbsPsiElementFactory.createFile(project, template).accept((PsiElementVisitor)new RbsPsiRecursiveVisitor(){

            public void visitMethodMember(@NotNull RbsMethodMember member) {
                if (member == null) {
                    9.$$$reportNull$$$0(0);
                }
                methodRef.set((Object)member);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory$9", "visitMethodMember"));
            }
        });
        RbsMethodMember rbsMethodMember = (RbsMethodMember)methodRef.get();
        if (rbsMethodMember == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(37);
        }
        return rbsMethodMember;
    }

    @NotNull
    public static RbsMethodType createMethodType(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(38);
        }
        if (text == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(39);
        }
        final Ref methodTypeRef = new Ref();
        RbsPsiElementFactory.createFile(project, DUMMY_METHOD_TYPE.formatted(text)).accept((PsiElementVisitor)new RbsPsiRecursiveVisitor(){

            public void visitMethodType(@NotNull RbsMethodType methodType) {
                if (methodType == null) {
                    10.$$$reportNull$$$0(0);
                }
                methodTypeRef.setIfNull((Object)methodType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodType", "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory$10", "visitMethodType"));
            }
        });
        RbsMethodType rbsMethodType = (RbsMethodType)methodTypeRef.get();
        if (rbsMethodType == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(40);
        }
        return rbsMethodType;
    }

    @NotNull
    public static RbsModuleTypeParam createModuleTypeParameter(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(41);
        }
        if (text == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(42);
        }
        final Ref typeParamRef = new Ref();
        RbsPsiElementFactory.createFile(project, DUMMY_MODULE_TYPE_PARAMETER.formatted(text)).accept((PsiElementVisitor)new RbsPsiRecursiveVisitor(){

            public void visitModuleTypeParam(@NotNull RbsModuleTypeParam typeParameter) {
                if (typeParameter == null) {
                    11.$$$reportNull$$$0(0);
                }
                typeParamRef.set((Object)typeParameter);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory$11", "visitModuleTypeParam"));
            }
        });
        RbsModuleTypeParam rbsModuleTypeParam = (RbsModuleTypeParam)typeParamRef.get();
        if (rbsModuleTypeParam == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(43);
        }
        return rbsModuleTypeParam;
    }

    @NotNull
    public static RbsPrivateMember createPrivateMember(@NotNull Project project) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(44);
        }
        final Ref privateRef = new Ref();
        RbsPsiElementFactory.createFile(project, DUMMY_PRIVATE_MEMBER).accept((PsiElementVisitor)new RbsPsiRecursiveVisitor(){

            public void visitPrivateMember(@NotNull RbsPrivateMember member) {
                if (member == null) {
                    12.$$$reportNull$$$0(0);
                }
                privateRef.set((Object)member);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory$12", "visitPrivateMember"));
            }
        });
        RbsPrivateMember rbsPrivateMember = (RbsPrivateMember)privateRef.get();
        if (rbsPrivateMember == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(45);
        }
        return rbsPrivateMember;
    }

    @NotNull
    public static RbsProcType createProcType(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(46);
        }
        if (text == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(47);
        }
        final Ref procTypeRef = new Ref();
        RbsPsiElementFactory.createFile(project, DUMMY_PROC_TYPE.formatted(text)).accept((PsiElementVisitor)new RbsPsiRecursiveVisitor(){

            public void visitProcType(@NotNull RbsProcType procType) {
                if (procType == null) {
                    13.$$$reportNull$$$0(0);
                }
                procTypeRef.set((Object)procType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procType", "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory$13", "visitProcType"));
            }
        });
        RbsProcType rbsProcType = (RbsProcType)procTypeRef.get();
        if (rbsProcType == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(48);
        }
        return rbsProcType;
    }

    @NotNull
    public static RbsType createType(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(49);
        }
        if (text == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(50);
        }
        final Ref typeRef = new Ref();
        RbsPsiElementFactory.createFile(project, DUMMY_TYPE.formatted(text)).accept((PsiElementVisitor)new RbsPsiRecursiveVisitor(){

            public void visitType(@NotNull RbsType type) {
                if (type == null) {
                    14.$$$reportNull$$$0(0);
                }
                typeRef.setIfNull((Object)type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory$14", "visitType"));
            }
        });
        RbsType rbsType = (RbsType)typeRef.get();
        if (rbsType == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(51);
        }
        return rbsType;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static RbsUseDirectiveImpl createUseDirective(@NotNull Project project, @NotNull RbsUseClauseType type) {
        if (project == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(52);
        }
        if (type == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(53);
        }
        final Ref useDirectiveRef = new Ref();
        RbsUseClauseType rbsUseClauseType = type;
        Objects.requireNonNull(rbsUseClauseType);
        RbsUseClauseType rbsUseClauseType2 = rbsUseClauseType;
        int n = 0;
        String template = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RbsUseClauseType.Alias.class, RbsUseClauseType.Import.class, RbsUseClauseType.Wildcard.class}, (Object)rbsUseClauseType2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Object var9_7;
                RbsUseClauseType.Alias var6_6 = (RbsUseClauseType.Alias)rbsUseClauseType2;
                RbsUseClauseType.Import fqn = var9_7 = var6_6.fqn();
                Object name = var9_7 = var6_6.name();
                yield DUMMY_USE_ALIAS.formatted(fqn.join(), name);
            }
            case 1 -> {
                RbsUseClauseType.Wildcard var11_10;
                Object var9_7 = (RbsUseClauseType.Import)rbsUseClauseType2;
                RbsUseClauseType.Wildcard fqn = var11_10 = var9_7.fqn();
                yield DUMMY_USE_IMPORT.formatted(fqn.join());
            }
            case 2 -> {
                Fqn var13_12;
                RbsUseClauseType.Wildcard var11_10 = (RbsUseClauseType.Wildcard)rbsUseClauseType2;
                Fqn fqn = var13_12 = var11_10.namespace();
                yield DUMMY_USE_WILDCARD.formatted(fqn.join());
            }
        };
        RbsPsiElementFactory.createFile(project, template).accept((PsiElementVisitor)new RbsPsiRecursiveVisitor(){

            public void visitUseDirective(@NotNull RbsUseDirective useDirective) {
                if (useDirective == null) {
                    15.$$$reportNull$$$0(0);
                }
                useDirectiveRef.set((Object)((RbsUseDirectiveImpl)useDirective));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useDirective", "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory$15", "visitUseDirective"));
            }
        });
        RbsUseDirectiveImpl rbsUseDirectiveImpl = (RbsUseDirectiveImpl)useDirectiveRef.get();
        if (rbsUseDirectiveImpl == null) {
            RbsPsiElementFactory.$$$reportNull$$$0(54);
        }
        return rbsUseDirectiveImpl;
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 10, 13, 16, 19, 22, 25, 28, 32, 37, 40, 43, 45, 48, 51, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationType";
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 15: 
            case 21: 
            case 24: 
            case 27: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 32: 
            case 37: 
            case 40: 
            case 43: 
            case 45: 
            case 48: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory";
                break;
            }
            case 6: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeType";
                break;
            }
            case 18: 
            case 39: 
            case 42: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/util/RbsPsiElementFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAliasMember";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttributeMember";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassVariableMember";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstantDeclaration";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createGlobalVariableDeclaration";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtendMember";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createIncludeMember";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstanceVariableMember";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodMember";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodType";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleTypeParameter";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrivateMember";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcType";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createUseDirective";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAliasMember";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 32: 
            case 37: 
            case 40: 
            case 43: 
            case 45: 
            case 48: 
            case 51: 
            case 54: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAttributeMember";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createClassVariableMember";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createConstantDeclaration";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createGlobalVariableDeclaration";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createExtendMember";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createIncludeMember";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createInstanceVariableMember";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createMethodMember";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createMethodType";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createModuleTypeParameter";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createPrivateMember";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createProcType";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createUseDirective";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 10, 13, 16, 19, 22, 25, 28, 32, 37, 40, 43, 45, 48, 51, 54 -> new IllegalStateException(string);
        };
    }
}

