/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.psi.util;

import com.intellij.ruby.rbs.common.psi.api.RbsAliasDeclaration;
import com.intellij.ruby.rbs.common.psi.api.RbsAttributeDeclaration;
import com.intellij.ruby.rbs.common.psi.api.RbsClassDeclaration;
import com.intellij.ruby.rbs.common.psi.api.RbsConstantDeclaration;
import com.intellij.ruby.rbs.common.psi.api.RbsExtendCall;
import com.intellij.ruby.rbs.common.psi.api.RbsGlobalDeclaration;
import com.intellij.ruby.rbs.common.psi.api.RbsIncludeCall;
import com.intellij.ruby.rbs.common.psi.api.RbsMethodDeclaration;
import com.intellij.ruby.rbs.common.psi.api.RbsModuleDeclaration;
import com.intellij.ruby.rbs.common.psi.api.RbsModuleInclusionCall;
import com.intellij.ruby.rbs.common.psi.api.RbsPrependCall;
import com.intellij.ruby.rbs.common.psi.api.RbsPrivateMember;
import com.intellij.ruby.rbs.common.psi.api.RbsQualifiedNameDeclaration;
import com.intellij.ruby.rbs.common.psi.api.RbsStatement;
import com.intellij.ruby.rbs.common.psi.api.RbsTypeDeclaration;
import com.intellij.ruby.rbs.common.psi.api.RbsUseClause;
import com.intellij.ruby.rbs.common.psi.api.RbsUseCls;
import com.intellij.ruby.rbs.common.psi.api.RbsUseDirective;
import com.intellij.ruby.rbs.common.psi.api.RbsVariableDeclaration;
import com.intellij.ruby.rbs.common.psi.data.RbsDeclarationType;
import com.intellij.ruby.rbs.common.psi.data.RbsUseClauseType;
import com.intellij.ruby.rbs.common.psi.data.RbsVariableType;
import com.intellij.ruby.rbs.common.psi.data.RbsVisibility;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RbsPsiComparators {
    static final Comparator<RbsStatement> STATEMENT_COMPARATOR = Comparator.comparingInt(RbsPsiComparators::getStatementGroup).thenComparing(RbsPsiComparators::getStatementKey, Comparator.nullsLast(Comparator.naturalOrder()));

    private RbsPsiComparators() {
    }

    private static int getStatementGroup(@NotNull RbsStatement statement) {
        if (statement == null) {
            RbsPsiComparators.$$$reportNull$$$0(0);
        }
        if (statement instanceof RbsUseDirective) {
            RbsUseDirective useDirective = (RbsUseDirective)statement;
            RbsUseClauseType type = (RbsUseClauseType)ObjectUtils.doIfNotNull((Object)((RbsUseCls)ContainerUtil.getFirstItem((List)useDirective.getUseClsList())), RbsUseClause::getClauseType);
            return !(type instanceof RbsUseClauseType.Wildcard) ? -35 : -34;
        }
        if (statement instanceof RbsTypeDeclaration) {
            return -30;
        }
        if (statement instanceof RbsGlobalDeclaration) {
            return -25;
        }
        if (statement instanceof RbsConstantDeclaration) {
            return -20;
        }
        if (statement instanceof RbsClassDeclaration || statement instanceof RbsModuleDeclaration) {
            return -10;
        }
        if (statement instanceof RbsIncludeCall) {
            return 0;
        }
        if (statement instanceof RbsPrependCall) {
            return 2;
        }
        if (statement instanceof RbsExtendCall) {
            return 4;
        }
        if (statement instanceof RbsVariableDeclaration) {
            RbsVariableDeclaration declaration = (RbsVariableDeclaration)statement;
            return switch (declaration.getVariableType()) {
                default -> throw new MatchException(null, null);
                case RbsVariableType.CLASS_VARIABLE -> 10;
                case RbsVariableType.INSTANCE_VARIABLE -> {
                    switch (declaration.getDeclarationType()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case SINGLETON_DECLARATION: {
                            yield 20;
                        }
                        case INSTANCE_DECLARATION: 
                    }
                    yield 30;
                }
            };
        }
        if (statement instanceof RbsAttributeDeclaration) {
            RbsAttributeDeclaration declaration = (RbsAttributeDeclaration)statement;
            return switch (declaration.getDeclarationType()) {
                default -> throw new MatchException(null, null);
                case RbsDeclarationType.SINGLETON_DECLARATION -> 50;
                case RbsDeclarationType.INSTANCE_DECLARATION -> 60;
            };
        }
        if (statement instanceof RbsMethodDeclaration) {
            RbsMethodDeclaration declaration = (RbsMethodDeclaration)statement;
            if (EnumSet.allOf(RbsDeclarationType.class).equals(declaration.getDeclarationTypes())) {
                return 40;
            }
            if (declaration.getDeclarationTypes().contains(RbsDeclarationType.SINGLETON_DECLARATION)) {
                if ("new".equals(declaration.getName())) {
                    return 52;
                }
                if (declaration.getVisibility() == RbsVisibility.PUBLIC_VISIBILITY) {
                    return 54;
                }
                return 56;
            }
            if ("initialize".equals(declaration.getName())) {
                return 62;
            }
            if (declaration.getVisibility() == RbsVisibility.PUBLIC_VISIBILITY) {
                return 64;
            }
            return 66;
        }
        if (statement instanceof RbsAliasDeclaration) {
            RbsAliasDeclaration declaration = (RbsAliasDeclaration)statement;
            return switch (declaration.getDeclarationType()) {
                default -> throw new MatchException(null, null);
                case RbsDeclarationType.SINGLETON_DECLARATION -> 54;
                case RbsDeclarationType.INSTANCE_DECLARATION -> 64;
            };
        }
        if (statement instanceof RbsPrivateMember) {
            return 65;
        }
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getStatementKey(@NotNull RbsStatement statement) {
        Fqn namespace;
        if (statement == null) {
            RbsPsiComparators.$$$reportNull$$$0(1);
        }
        if (statement instanceof RbsAliasDeclaration) {
            RbsAliasDeclaration declaration = (RbsAliasDeclaration)statement;
            return declaration.getAliasMethodName();
        }
        if (statement instanceof RbsAttributeDeclaration) {
            RbsAttributeDeclaration declaration = (RbsAttributeDeclaration)statement;
            return declaration.getName();
        }
        if (statement instanceof RbsGlobalDeclaration) {
            RbsGlobalDeclaration declaration = (RbsGlobalDeclaration)statement;
            return declaration.getName();
        }
        if (statement instanceof RbsMethodDeclaration) {
            RbsMethodDeclaration declaration = (RbsMethodDeclaration)statement;
            return declaration.getName();
        }
        if (statement instanceof RbsModuleInclusionCall) {
            RbsModuleInclusionCall inclusionCall = (RbsModuleInclusionCall)statement;
            return inclusionCall.getIncludedModuleText();
        }
        if (statement instanceof RbsQualifiedNameDeclaration) {
            RbsQualifiedNameDeclaration declaration = (RbsQualifiedNameDeclaration)statement;
            Fqn fqn = declaration.getFqn();
            if (fqn == Fqn.INVALID) return null;
            String string = fqn.getName();
            return string;
        }
        if (!(statement instanceof RbsUseDirective)) {
            if (!(statement instanceof RbsVariableDeclaration)) return null;
            RbsVariableDeclaration declaration = (RbsVariableDeclaration)statement;
            return declaration.getName();
        }
        RbsUseDirective useDirective = (RbsUseDirective)statement;
        RbsUseClauseType type = ((RbsUseCls)ContainerUtil.getFirstItem((List)useDirective.getUseClsList())).getClauseType();
        if (type instanceof RbsUseClauseType.Alias) {
            RbsUseClauseType.Alias alias = (RbsUseClauseType.Alias)type;
            return alias.fqn().join();
        }
        if (type instanceof RbsUseClauseType.Import) {
            RbsUseClauseType.Import import_ = (RbsUseClauseType.Import)type;
            try {
                Fqn fqn2;
                Fqn fqn22 = fqn2 = import_.fqn();
                return fqn22.join();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (!(type instanceof RbsUseClauseType.Wildcard)) return null;
        RbsUseClauseType.Wildcard wildcard = (RbsUseClauseType.Wildcard)type;
        {
            Fqn fqn;
            namespace = fqn = wildcard.namespace();
        }
        return namespace.join();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "statement";
        objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/util/RbsPsiComparators";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStatementGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getStatementKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

