/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.psi.tree;

import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ThrowablePairConsumer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RbsSerializationUtil {
    private RbsSerializationUtil() {
    }

    public static void serializeStringList(@NotNull List<String> list, @NotNull StubOutputStream dataStream) throws IOException {
        if (list == null) {
            RbsSerializationUtil.$$$reportNull$$$0(0);
        }
        if (dataStream == null) {
            RbsSerializationUtil.$$$reportNull$$$0(1);
        }
        RbsSerializationUtil.serializeList(list, dataStream, (s, stream) -> stream.writeName(s));
    }

    @NotNull
    public static List<String> deserializeStringList(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            RbsSerializationUtil.$$$reportNull$$$0(2);
        }
        return RbsSerializationUtil.deserializeList(dataStream, stream -> Objects.requireNonNull(stream.readNameString()));
    }

    public static @NotNull List<@Nullable String> deserializeNullableStringList(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            RbsSerializationUtil.$$$reportNull$$$0(3);
        }
        int size = dataStream.readVarInt();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(dataStream.readNameString());
        }
        List<String> list2 = Collections.unmodifiableList(list);
        if (list2 == null) {
            RbsSerializationUtil.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public static <T> void serializeList(@NotNull List<T> list, @NotNull StubOutputStream dataStream, @NotNull ThrowablePairConsumer<? super T, ? super StubOutputStream, ? extends IOException> serializer) throws IOException {
        if (list == null) {
            RbsSerializationUtil.$$$reportNull$$$0(5);
        }
        if (dataStream == null) {
            RbsSerializationUtil.$$$reportNull$$$0(6);
        }
        if (serializer == null) {
            RbsSerializationUtil.$$$reportNull$$$0(7);
        }
        dataStream.writeVarInt(list.size());
        for (T t : list) {
            serializer.consume(t, (Object)dataStream);
        }
    }

    public static <T> void serializeNullableList(@NotNull List<@Nullable T> list, @NotNull StubOutputStream dataStream, @NotNull @NotNull ThrowablePairConsumer<? super @NotNull T, ? super StubOutputStream, ? extends IOException> serializer) throws IOException {
        if (list == null) {
            RbsSerializationUtil.$$$reportNull$$$0(8);
        }
        if (dataStream == null) {
            RbsSerializationUtil.$$$reportNull$$$0(9);
        }
        if (serializer == null) {
            RbsSerializationUtil.$$$reportNull$$$0(10);
        }
        dataStream.writeVarInt(list.size());
        for (T t : list) {
            dataStream.writeBoolean(t != null);
            if (t == null) continue;
            serializer.consume(t, (Object)dataStream);
        }
    }

    @NotNull
    public static <T> List<T> deserializeList(@NotNull StubInputStream dataStream, @NotNull ThrowableNotNullFunction<? super StubInputStream, ? extends T, ? extends IOException> deserializer) throws IOException {
        if (dataStream == null) {
            RbsSerializationUtil.$$$reportNull$$$0(11);
        }
        if (deserializer == null) {
            RbsSerializationUtil.$$$reportNull$$$0(12);
        }
        int size = dataStream.readVarInt();
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(deserializer.fun((Object)dataStream));
        }
        List list2 = Collections.unmodifiableList(list);
        if (list2 == null) {
            RbsSerializationUtil.$$$reportNull$$$0(13);
        }
        return list2;
    }

    public static <T> @NotNull List<@Nullable T> deserializeNullableList(@NotNull StubInputStream dataStream, @NotNull ThrowableNotNullFunction<? super StubInputStream, ? extends T, ? extends IOException> deserializer) throws IOException {
        if (dataStream == null) {
            RbsSerializationUtil.$$$reportNull$$$0(14);
        }
        if (deserializer == null) {
            RbsSerializationUtil.$$$reportNull$$$0(15);
        }
        int size = dataStream.readVarInt();
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            if (dataStream.readBoolean()) {
                list.add(deserializer.fun((Object)dataStream));
                continue;
            }
            list.add(null);
        }
        List list2 = Collections.unmodifiableList(list);
        if (list2 == null) {
            RbsSerializationUtil.$$$reportNull$$$0(16);
        }
        return list2;
    }

    public static <K, V> void serializeMap(@NotNull Map<K, V> map, @NotNull StubOutputStream dataStream, @NotNull ThrowablePairConsumer<? super Map.Entry<K, V>, ? super StubOutputStream, ? extends IOException> serializer) throws IOException {
        if (map == null) {
            RbsSerializationUtil.$$$reportNull$$$0(17);
        }
        if (dataStream == null) {
            RbsSerializationUtil.$$$reportNull$$$0(18);
        }
        if (serializer == null) {
            RbsSerializationUtil.$$$reportNull$$$0(19);
        }
        dataStream.writeVarInt(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            serializer.consume(entry, (Object)dataStream);
        }
    }

    @NotNull
    public static <K, V> Map<K, V> deserializeMap(@NotNull StubInputStream dataStream, @NotNull ThrowableNotNullFunction<? super StubInputStream, ? extends Map.Entry<K, V>, ? extends IOException> deserializer) throws IOException {
        if (dataStream == null) {
            RbsSerializationUtil.$$$reportNull$$$0(20);
        }
        if (deserializer == null) {
            RbsSerializationUtil.$$$reportNull$$$0(21);
        }
        int size = dataStream.readVarInt();
        LinkedHashMap map = new LinkedHashMap(size);
        for (int i = 0; i < size; ++i) {
            Map.Entry entry = (Map.Entry)deserializer.fun((Object)dataStream);
            map.put(entry.getKey(), entry.getValue());
        }
        Map map2 = Collections.unmodifiableMap(map);
        if (map2 == null) {
            RbsSerializationUtil.$$$reportNull$$$0(22);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 13, 16, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 4: 
            case 13: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/psi/tree/RbsSerializationUtil";
                break;
            }
            case 7: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 12: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deserializer";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/tree/RbsSerializationUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeNullableStringList";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeNullableList";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serializeStringList";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deserializeStringList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserializeNullableStringList";
                break;
            }
            case 4: 
            case 13: 
            case 16: 
            case 22: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serializeList";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "serializeNullableList";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "deserializeNullableList";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "serializeMap";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "deserializeMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 13, 16, 22 -> new IllegalStateException(string);
        };
    }
}

