/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.psi.data;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsSingletonSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureBinding;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureResolver;
import com.intellij.lang.ruby.rbs.util.RbsFqns;
import com.intellij.lang.ruby.rbs.util.RbsSymbols;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.psi.data.RbsBooleanLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsIntegerLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsIntersectionTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsKeywordTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsNilLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsOptionalTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsProcTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsQualifiedNameTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsRecordTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsSingletonTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsStringLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsSymbolLiteralSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTupleTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignatureVisitor;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeVariableReferenceSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsUnionTypeSignature;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RbsTypeSignatureSubtypeChecker {
    private static final List<RbsTypeSignature> GLOBAL_SUBTYPES = List.of(RbsKeywordTypeSignature.BOT, RbsKeywordTypeSignature.UNTYPED, RbsKeywordTypeSignature.__TODO__);
    private static final List<RbsTypeSignature> GLOBAL_SUPERTYPES = List.of(RbsKeywordTypeSignature.TOP, RbsKeywordTypeSignature.UNTYPED, RbsKeywordTypeSignature.VOID, RbsKeywordTypeSignature.__TODO__);
    private final Project myProject;
    private final SearchScope mySearchScope;
    @Nullable
    private final PsiElement myInvocationPoint;

    public RbsTypeSignatureSubtypeChecker(@NotNull Project project, @NotNull SearchScope searchScope, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RbsTypeSignatureSubtypeChecker.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RbsTypeSignatureSubtypeChecker.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.mySearchScope = searchScope;
        this.myInvocationPoint = invocationPoint;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    public boolean isSubtype(@NotNull RbsTypeSignature childTypeSignature, @NotNull RbsTypeSignature parentTypeSignature) {
        if (childTypeSignature == null) {
            RbsTypeSignatureSubtypeChecker.$$$reportNull$$$0(2);
        }
        if (parentTypeSignature == null) {
            RbsTypeSignatureSubtypeChecker.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.softAssertReadAccess();
        RbsTypeSignatureResolver resolver = new RbsTypeSignatureResolver(this.myProject, this.mySearchScope);
        return this.isSubtypeImpl(this.normaliseTypeSignature(childTypeSignature.apply((Function)resolver)), this.normaliseTypeSignature(parentTypeSignature.apply((Function)resolver)));
    }

    private boolean isSubtypeImpl(@NotNull RbsTypeSignature childTypeSignature, @NotNull RbsTypeSignature parentTypeSignature) {
        if (childTypeSignature == null) {
            RbsTypeSignatureSubtypeChecker.$$$reportNull$$$0(4);
        }
        if (parentTypeSignature == null) {
            RbsTypeSignatureSubtypeChecker.$$$reportNull$$$0(5);
        }
        if (GLOBAL_SUPERTYPES.contains(parentTypeSignature)) {
            return true;
        }
        if (childTypeSignature instanceof RbsUnionTypeSignature) {
            RbsUnionTypeSignature unionTypeSignature = (RbsUnionTypeSignature)childTypeSignature;
            return unionTypeSignature.getTypeSignatures().stream().map(it -> this.isSubtype((RbsTypeSignature)it, parentTypeSignature)).reduce(true, Boolean::logicalAnd);
        }
        if (parentTypeSignature instanceof RbsIntersectionTypeSignature) {
            RbsIntersectionTypeSignature intersectionTypeSignature = (RbsIntersectionTypeSignature)parentTypeSignature;
            return intersectionTypeSignature.getTypeSignatures().stream().map(it -> this.isSubtype(childTypeSignature, (RbsTypeSignature)it)).reduce(true, Boolean::logicalAnd);
        }
        if (childTypeSignature instanceof RbsIntersectionTypeSignature) {
            RbsIntersectionTypeSignature intersectionTypeSignature = (RbsIntersectionTypeSignature)childTypeSignature;
            return intersectionTypeSignature.getTypeSignatures().stream().map(it -> this.isSubtype((RbsTypeSignature)it, parentTypeSignature)).reduce(false, Boolean::logicalOr);
        }
        if (parentTypeSignature instanceof RbsUnionTypeSignature) {
            RbsUnionTypeSignature unionTypeSignature = (RbsUnionTypeSignature)parentTypeSignature;
            return unionTypeSignature.getTypeSignatures().stream().map(it -> this.isSubtype(childTypeSignature, (RbsTypeSignature)it)).reduce(false, Boolean::logicalOr);
        }
        MyVisitor visitor = new MyVisitor(parentTypeSignature);
        childTypeSignature.accept((RbsTypeSignatureVisitor)visitor);
        return (Boolean)visitor.myIsSubtypeRef.get();
    }

    @NotNull
    private RbsTypeSignature normaliseTypeSignature(@NotNull RbsTypeSignature signature) {
        RbsQualifiedNameTypeSignature qualifiedNameTypeSignature;
        if (signature == null) {
            RbsTypeSignatureSubtypeChecker.$$$reportNull$$$0(6);
        }
        if (signature instanceof RbsBooleanLiteralSignature) {
            RbsBooleanLiteralSignature booleanLiteralSignature = (RbsBooleanLiteralSignature)signature;
            if (booleanLiteralSignature.getLiteral()) {
                return new RbsQualifiedNameTypeSignature(RbsFqns.TRUE_CLASS_FQN);
            }
            return new RbsQualifiedNameTypeSignature(RbsFqns.FALSE_CLASS_FQN);
        }
        if (signature == RbsKeywordTypeSignature.BOOL) {
            RbsTypeSignature rbsTypeSignature = RbsUnionTypeSignature.of((RbsTypeSignature)new RbsQualifiedNameTypeSignature(RbsFqns.TRUE_CLASS_FQN), (RbsTypeSignature)new RbsQualifiedNameTypeSignature(RbsFqns.FALSE_CLASS_FQN));
            if (rbsTypeSignature == null) {
                RbsTypeSignatureSubtypeChecker.$$$reportNull$$$0(7);
            }
            return rbsTypeSignature;
        }
        if (signature instanceof RbsNilLiteralSignature) {
            return new RbsQualifiedNameTypeSignature(RbsFqns.NIL_CLASS_FQN);
        }
        if (signature instanceof RbsQualifiedNameTypeSignature && (qualifiedNameTypeSignature = (RbsQualifiedNameTypeSignature)signature).isTypeAliasReference()) {
            RbsTypeSignature rbsTypeSignature = new RbsTypeAliasSymbol(qualifiedNameTypeSignature.getFqn()).getTypeSignature(this.myProject, this.mySearchScope);
            if (rbsTypeSignature == null) {
                RbsTypeSignatureSubtypeChecker.$$$reportNull$$$0(8);
            }
            return rbsTypeSignature;
        }
        if (signature instanceof RbsOptionalTypeSignature) {
            RbsOptionalTypeSignature optionalTypeSignature = (RbsOptionalTypeSignature)signature;
            RbsTypeSignature rbsTypeSignature = RbsUnionTypeSignature.of((RbsTypeSignature)optionalTypeSignature.getTypeSignature(), (RbsTypeSignature)new RbsQualifiedNameTypeSignature(RbsFqns.NIL_CLASS_FQN));
            if (rbsTypeSignature == null) {
                RbsTypeSignatureSubtypeChecker.$$$reportNull$$$0(9);
            }
            return rbsTypeSignature;
        }
        RbsTypeSignature rbsTypeSignature = signature;
        if (rbsTypeSignature == null) {
            RbsTypeSignatureSubtypeChecker.$$$reportNull$$$0(10);
        }
        return rbsTypeSignature;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTypeSignature";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTypeSignature";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/psi/data/RbsTypeSignatureSubtypeChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/data/RbsTypeSignatureSubtypeChecker";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "normaliseTypeSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSubtype";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSubtypeImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "normaliseTypeSignature";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    private final class MyVisitor
    implements RbsTypeSignatureVisitor {
        private final RbsTypeSignature myParentTypeSignature;
        private final Ref<Boolean> myIsSubtypeRef;

        private MyVisitor(RbsTypeSignature parentTypeSignature) {
            if (parentTypeSignature == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myIsSubtypeRef = new Ref((Object)false);
            this.myParentTypeSignature = parentTypeSignature;
        }

        public void visitIntegerLiteralSignature(@NotNull RbsIntegerLiteralSignature signature) {
            RbsTypeSignature rbsTypeSignature;
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if ((rbsTypeSignature = this.myParentTypeSignature) instanceof RbsIntegerLiteralSignature) {
                RbsIntegerLiteralSignature integerLiteralSignature = (RbsIntegerLiteralSignature)rbsTypeSignature;
                this.myIsSubtypeRef.set((Object)signature.getLiteral().equals(integerLiteralSignature.getLiteral()));
            } else {
                new RbsQualifiedNameTypeSignature(RbsFqns.INTEGER_FQN).accept((RbsTypeSignatureVisitor)this);
            }
        }

        public void visitKeywordTypeSignature(@NotNull RbsKeywordTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if (GLOBAL_SUBTYPES.contains(signature)) {
                this.myIsSubtypeRef.set((Object)true);
            }
        }

        public void visitProcTypeSignature(@NotNull RbsProcTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
        }

        public void visitQualifiedNameTypeSignature(@NotNull RbsQualifiedNameTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            this.myIsSubtypeRef.set((Object)this.isAncestor((RbsTypeSignature)signature, this.myParentTypeSignature));
        }

        public void visitRecordTypeSignature(@NotNull RbsRecordTypeSignature signature) {
            RbsTypeSignature rbsTypeSignature;
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if ((rbsTypeSignature = this.myParentTypeSignature) instanceof RbsRecordTypeSignature) {
                RbsRecordTypeSignature parentRecordTypeSignature = (RbsRecordTypeSignature)rbsTypeSignature;
                List parentFields = parentRecordTypeSignature.getFields();
                if (signature.getFields().size() < ContainerUtil.count((Iterable)parentFields, RbsRecordTypeSignature.Field::isRequired)) {
                    return;
                }
                for (RbsRecordTypeSignature.Field parentField : parentFields) {
                    RbsRecordTypeSignature.Field field = signature.getField((RbsTypeSignature)parentField.getKeyTypeSignature());
                    if (field == null && parentField.isOptional() || field != null && RbsTypeSignatureSubtypeChecker.this.isSubtype(field.getValueTypeSignature(), parentField.getValueTypeSignature())) continue;
                    return;
                }
                this.myIsSubtypeRef.set((Object)true);
            } else {
                RbsTypeSignature keyTypeSignature = (RbsTypeSignature)RbsUnionTypeSignature.of((Collection)signature.getKeyTypeSignatures()).orElse(RbsKeywordTypeSignature.UNTYPED);
                RbsTypeSignature valueTypeSignature = (RbsTypeSignature)RbsUnionTypeSignature.of((Collection)signature.getValueTypeSignatures()).orElse(RbsKeywordTypeSignature.UNTYPED);
                new RbsQualifiedNameTypeSignature(RbsFqns.HASH_FQN, List.of(keyTypeSignature, valueTypeSignature)).accept((RbsTypeSignatureVisitor)this);
            }
        }

        public void visitSingletonTypeSignature(@NotNull RbsSingletonTypeSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            this.myIsSubtypeRef.set((Object)this.isAncestor((RbsTypeSignature)signature, this.myParentTypeSignature));
        }

        public void visitStringLiteralSignature(@NotNull RbsStringLiteralSignature signature) {
            RbsTypeSignature rbsTypeSignature;
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            if ((rbsTypeSignature = this.myParentTypeSignature) instanceof RbsStringLiteralSignature) {
                RbsStringLiteralSignature stringLiteralSignature = (RbsStringLiteralSignature)rbsTypeSignature;
                this.myIsSubtypeRef.set((Object)signature.getLiteral().equals(stringLiteralSignature.getLiteral()));
            } else {
                new RbsQualifiedNameTypeSignature(RbsFqns.STRING_FQN).accept((RbsTypeSignatureVisitor)this);
            }
        }

        public void visitSymbolLiteralSignature(@NotNull RbsSymbolLiteralSignature signature) {
            RbsTypeSignature rbsTypeSignature;
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            if ((rbsTypeSignature = this.myParentTypeSignature) instanceof RbsSymbolLiteralSignature) {
                RbsSymbolLiteralSignature symbolLiteralSignature = (RbsSymbolLiteralSignature)rbsTypeSignature;
                this.myIsSubtypeRef.set((Object)signature.getLiteral().equals(symbolLiteralSignature.getLiteral()));
            } else {
                new RbsQualifiedNameTypeSignature(RbsFqns.SYMBOL_FQN).accept((RbsTypeSignatureVisitor)this);
            }
        }

        public void visitTupleTypeSignature(@NotNull RbsTupleTypeSignature signature) {
            RbsTypeSignature rbsTypeSignature;
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            if ((rbsTypeSignature = this.myParentTypeSignature) instanceof RbsTupleTypeSignature) {
                RbsTupleTypeSignature parentTupleTypeSignature = (RbsTupleTypeSignature)rbsTypeSignature;
                if (signature.getTypeSignatures().size() != parentTupleTypeSignature.getTypeSignatures().size()) {
                    return;
                }
                for (int i = 0; i < signature.getTypeSignatures().size(); ++i) {
                    if (RbsTypeSignatureSubtypeChecker.this.isSubtype((RbsTypeSignature)signature.getTypeSignatures().get(i), (RbsTypeSignature)parentTupleTypeSignature.getTypeSignatures().get(i))) continue;
                    return;
                }
                this.myIsSubtypeRef.set((Object)true);
            } else {
                RbsTypeSignature elementTypeSignature = (RbsTypeSignature)RbsUnionTypeSignature.of((Collection)signature.getTypeSignatures()).orElse(RbsKeywordTypeSignature.UNTYPED);
                new RbsQualifiedNameTypeSignature(RbsFqns.ARRAY_FQN, List.of(elementTypeSignature)).accept((RbsTypeSignatureVisitor)this);
            }
        }

        public void visitTypeVariableReferenceSignature(@NotNull RbsTypeVariableReferenceSignature signature) {
            if (signature == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            this.myIsSubtypeRef.set((Object)this.isAncestor((RbsTypeSignature)signature, this.myParentTypeSignature));
        }

        @Nullable
        private RbsContainerSymbol findContainerSymbol(@NotNull RbsTypeSignature typeSignature) {
            if (typeSignature == null) {
                MyVisitor.$$$reportNull$$$0(11);
            }
            final Ref containerSymbolRef = new Ref();
            typeSignature.accept(new RbsTypeSignatureVisitor(){

                public void visitQualifiedNameTypeSignature(@NotNull RbsQualifiedNameTypeSignature signature) {
                    RbsContainerSymbol containerSymbol;
                    if (signature == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((containerSymbol = (RbsContainerSymbol)RbsContainerSymbol.find(RbsTypeSignatureSubtypeChecker.this.myProject, RbsTypeSignatureSubtypeChecker.this.mySearchScope, signature.getFqn()).findAny().orElse(null)) instanceof RbsClassSymbol) {
                        RbsClassSymbol classSymbol = (RbsClassSymbol)containerSymbol;
                        containerSymbolRef.set((Object)((RbsContainerSymbol)ObjectUtils.coalesce((Object)classSymbol.getTargetClassSymbol(RbsTypeSignatureSubtypeChecker.this.myProject, RbsTypeSignatureSubtypeChecker.this.mySearchScope), (Object)classSymbol)));
                    } else if (containerSymbol instanceof RbsModuleSymbol) {
                        RbsModuleSymbol moduleSymbol = (RbsModuleSymbol)containerSymbol;
                        containerSymbolRef.set((Object)((RbsContainerSymbol)ObjectUtils.coalesce((Object)moduleSymbol.getTargetModuleSymbol(RbsTypeSignatureSubtypeChecker.this.myProject, RbsTypeSignatureSubtypeChecker.this.mySearchScope), (Object)moduleSymbol)));
                    } else if (containerSymbol != null) {
                        containerSymbolRef.set((Object)containerSymbol);
                    }
                }

                public void visitSingletonTypeSignature(@NotNull RbsSingletonTypeSignature signature) {
                    RbsTypeSignature rbsTypeSignature;
                    if (signature == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if ((rbsTypeSignature = signature.getTypeSignature()) instanceof RbsQualifiedNameTypeSignature) {
                        RbsQualifiedNameTypeSignature qualifiedNameTypeSignature = (RbsQualifiedNameTypeSignature)rbsTypeSignature;
                        RbsSingletonSymbol.find(RbsTypeSignatureSubtypeChecker.this.myProject, RbsTypeSignatureSubtypeChecker.this.mySearchScope, qualifiedNameTypeSignature.getFqn()).findAny().ifPresent(arg_0 -> ((Ref)containerSymbolRef).set(arg_0));
                    }
                }

                public void visitTypeVariableReferenceSignature(@NotNull RbsTypeVariableReferenceSignature signature) {
                    if (signature == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    ArrayList<RbsContainerTypeVariableSymbol> typeVariableSymbols = new ArrayList<RbsContainerTypeVariableSymbol>();
                    if (RbsTypeSignatureSubtypeChecker.this.myInvocationPoint != null) {
                        typeVariableSymbols.addAll(switch (signature.getReferenceType()) {
                            default -> throw new MatchException(null, null);
                            case RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE -> RbsResolveUtil.resolveSimpleNameToContainerTypeVariables(signature.getName(), RbsTypeSignatureSubtypeChecker.this.myInvocationPoint);
                            case RbsTypeVariableReferenceSignature.ReferenceType.METHOD_VARIABLE -> RbsResolveUtil.resolveSimpleNameToMethodTypeVariables(signature.getName(), RbsTypeSignatureSubtypeChecker.this.myInvocationPoint);
                            case RbsTypeVariableReferenceSignature.ReferenceType.TYPE_ALIAS_VARIABLE -> RbsResolveUtil.resolveSimpleNameToTypeAliasTypeVariables(signature.getName(), RbsTypeSignatureSubtypeChecker.this.myInvocationPoint);
                        });
                    }
                    RbsContainerSymbol upperBoundSymbol = typeVariableSymbols.stream().flatMap(it -> Stream.ofNullable(it.getUpperBound())).map(it -> it.apply((Function)new RbsTypeSignatureResolver(RbsTypeSignatureSubtypeChecker.this.myProject, RbsTypeSignatureSubtypeChecker.this.mySearchScope))).flatMap(it -> Stream.ofNullable(MyVisitor.this.findContainerSymbol((RbsTypeSignature)it))).findFirst().orElse(RbsSymbols.BASIC_OBJECT_SYMBOL);
                    containerSymbolRef.set((Object)upperBoundSymbol);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "signature";
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/data/RbsTypeSignatureSubtypeChecker$MyVisitor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitQualifiedNameTypeSignature";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitSingletonTypeSignature";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitTypeVariableReferenceSignature";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            return (RbsContainerSymbol)containerSymbolRef.get();
        }

        private boolean isAncestor(@NotNull RbsTypeSignature childSignature, @NotNull RbsTypeSignature parentSignature) {
            List childTypeArgumentSignatures;
            if (childSignature == null) {
                MyVisitor.$$$reportNull$$$0(12);
            }
            if (parentSignature == null) {
                MyVisitor.$$$reportNull$$$0(13);
            }
            RbsContainerSymbol childSymbol = this.findContainerSymbol(childSignature);
            RbsContainerSymbol parentSymbol = this.findContainerSymbol(parentSignature);
            if (childSymbol == null || parentSymbol == null) {
                return false;
            }
            if (childSignature instanceof RbsQualifiedNameTypeSignature) {
                RbsQualifiedNameTypeSignature qualifiedNameTypeSignature = (RbsQualifiedNameTypeSignature)childSignature;
                childTypeArgumentSignatures = qualifiedNameTypeSignature.getTypeArgumentSignatures();
            } else {
                childTypeArgumentSignatures = Collections.emptyList();
            }
            ArrayList<RbsTypeSignature> parentTypeArgumentSignatures = new ArrayList<RbsTypeSignature>();
            if (parentSignature instanceof RbsQualifiedNameTypeSignature) {
                RbsQualifiedNameTypeSignature qualifiedNameTypeSignature = (RbsQualifiedNameTypeSignature)parentSignature;
                parentTypeArgumentSignatures.addAll(qualifiedNameTypeSignature.getTypeArgumentSignatures());
            } else {
                parentSymbol.getTypeVariableSymbols(RbsTypeSignatureSubtypeChecker.this.myProject, RbsTypeSignatureSubtypeChecker.this.mySearchScope).toHashMap().forEach((index, typeVariableSymbols) -> {
                    while (parentTypeArgumentSignatures.size() < index) {
                        parentTypeArgumentSignatures.add((RbsTypeSignature)RbsKeywordTypeSignature.UNTYPED);
                    }
                    parentTypeArgumentSignatures.set((int)index, (RbsTypeSignature)ObjectUtils.coalesce((Object)((RbsContainerTypeVariableSymbol)ContainerUtil.getFirstItem((Collection)typeVariableSymbols)).getUpperBound(), (Object)RbsKeywordTypeSignature.UNTYPED));
                });
            }
            return this.isAncestor(childSymbol, childTypeArgumentSignatures, parentSymbol, parentTypeArgumentSignatures);
        }

        private boolean isAncestor(@NotNull RbsContainerSymbol childSymbol, @NotNull List<RbsTypeSignature> childTypeArgumentSignatures, @NotNull RbsContainerSymbol parentSymbol, @NotNull List<RbsTypeSignature> parentTypeArgumentSignatures) {
            if (childSymbol == null) {
                MyVisitor.$$$reportNull$$$0(14);
            }
            if (childTypeArgumentSignatures == null) {
                MyVisitor.$$$reportNull$$$0(15);
            }
            if (parentSymbol == null) {
                MyVisitor.$$$reportNull$$$0(16);
            }
            if (parentTypeArgumentSignatures == null) {
                MyVisitor.$$$reportNull$$$0(17);
            }
            if (childSymbol instanceof RbsInterfaceSymbol || parentSymbol instanceof RbsInterfaceSymbol) {
                Set childChildren = childSymbol.allChildren(RbsTypeSignatureSubtypeChecker.this.myProject, RbsTypeSignatureSubtypeChecker.this.mySearchScope).collect(Collectors.toSet());
                Set parentChildren = parentSymbol.allChildren(RbsTypeSignatureSubtypeChecker.this.myProject, RbsTypeSignatureSubtypeChecker.this.mySearchScope).collect(Collectors.toSet());
                return childChildren.containsAll(parentChildren);
            }
            Map<RbsContainerSymbol, Function<RbsTypeSignature, RbsTypeSignature>> binding = childSymbol.getTypeVariableBinding(RbsTypeSignatureSubtypeChecker.this.myProject, RbsTypeSignatureSubtypeChecker.this.mySearchScope);
            if (!binding.containsKey(parentSymbol)) {
                return false;
            }
            MultiMap<Integer, RbsContainerTypeVariableSymbol> typeVariableSymbols = parentSymbol.getTypeVariableSymbols(RbsTypeSignatureSubtypeChecker.this.myProject, RbsTypeSignatureSubtypeChecker.this.mySearchScope);
            int max = typeVariableSymbols.keySet().stream().max(Comparator.naturalOrder()).map(it -> it + 1).orElse(0);
            block5: for (int i = 0; i < max; ++i) {
                RbsContainerTypeVariableSymbol typeVariableSymbol = (RbsContainerTypeVariableSymbol)ContainerUtil.getFirstItem((Collection)typeVariableSymbols.get((Object)i));
                if (typeVariableSymbol == null) continue;
                RbsTypeSignature boundTypeArgumentSignature = new RbsTypeVariableReferenceSignature(RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE, "#" + i, i).apply(binding.get(parentSymbol)).apply((Function)new RbsTypeSignatureBinding(RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE, childTypeArgumentSignatures)).apply((Function)new RbsTypeSignatureResolver(RbsTypeSignatureSubtypeChecker.this.myProject, RbsTypeSignatureSubtypeChecker.this.mySearchScope));
                RbsTypeSignature parentTypeArgumentSignature = (RbsTypeSignature)ContainerUtil.getOrElse(parentTypeArgumentSignatures, (int)i, (Object)RbsKeywordTypeSignature.UNTYPED);
                switch (typeVariableSymbol.getVariance()) {
                    case INVARIANT: {
                        if (RbsTypeSignatureSubtypeChecker.this.isSubtype(boundTypeArgumentSignature, parentTypeArgumentSignature) && RbsTypeSignatureSubtypeChecker.this.isSubtype(parentTypeArgumentSignature, boundTypeArgumentSignature)) continue block5;
                        return false;
                    }
                    case COVARIANT: {
                        if (RbsTypeSignatureSubtypeChecker.this.isSubtype(boundTypeArgumentSignature, parentTypeArgumentSignature)) continue block5;
                        return false;
                    }
                    case CONTRAVARIANT: {
                        if (RbsTypeSignatureSubtypeChecker.this.isSubtype(parentTypeArgumentSignature, boundTypeArgumentSignature)) continue block5;
                        return false;
                    }
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentTypeSignature";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeSignature";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childSignature";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentSignature";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childSymbol";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childTypeArgumentSignatures";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentSymbol";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentTypeArgumentSignatures";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/psi/data/RbsTypeSignatureSubtypeChecker$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIntegerLiteralSignature";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitKeywordTypeSignature";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitProcTypeSignature";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitQualifiedNameTypeSignature";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRecordTypeSignature";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSingletonTypeSignature";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitStringLiteralSignature";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSymbolLiteralSignature";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTupleTypeSignature";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeVariableReferenceSignature";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findContainerSymbol";
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAncestor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

