/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.rename;

import com.intellij.lang.ruby.rbs.model.api.RbsSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsSyntacticSugarSymbol;
import com.intellij.lang.ruby.rbs.model.rename.RbsRenameTarget;
import com.intellij.lang.ruby.rbs.model.usages.RbsSearchTarget;
import com.intellij.model.Pointer;
import com.intellij.model.search.SearchRequest;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.rename.ReplaceReferenceTarget;

abstract class RbsRenameTargetBase<T extends RbsSymbol>
implements RbsRenameTarget {
    protected final Project myProject;
    protected final SearchScope mySearchScope;
    protected final T mySymbol;

    RbsRenameTargetBase(@NotNull Project project, @NotNull T symbol) {
        if (project == null) {
            RbsRenameTargetBase.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            RbsRenameTargetBase.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.mySearchScope = RbsSearchTarget.getSymbolUseScope(project, symbol);
        this.mySymbol = symbol;
    }

    @NotNull
    public abstract Pointer<? extends RbsRenameTargetBase<T>> createPointer();

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RbsRenameTargetBase other = (RbsRenameTargetBase)obj;
        return this.myProject.equals((Object)other.myProject) && this.mySymbol.equals(other.mySymbol);
    }

    @Override
    @NotNull
    public Collection<? extends SearchRequest> getReferenceSearchRequests() {
        Set set = Collections.emptySet();
        if (set == null) {
            RbsRenameTargetBase.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public List<ReplaceReferenceTarget> getReferenceTargets() {
        T t = this.mySymbol;
        if (t instanceof RbsSyntacticSugarSymbol) {
            RbsSyntacticSugarSymbol syntacticSugarSymbol = (RbsSyntacticSugarSymbol)t;
            List list = ContainerUtil.map(syntacticSugarSymbol.getDynamicSymbols(this.myProject, (SearchScope)GlobalSearchScope.allScope((Project)this.myProject)), ReplaceReferenceTarget::new);
            if (list == null) {
                RbsRenameTargetBase.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<ReplaceReferenceTarget> list = List.of(new ReplaceReferenceTarget(this.mySymbol));
        if (list == null) {
            RbsRenameTargetBase.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public T getTarget() {
        T t = this.mySymbol;
        if (t == null) {
            RbsRenameTargetBase.$$$reportNull$$$0(5);
        }
        return t;
    }

    @NotNull
    public String getTargetName() {
        String string = this.presentation().getPresentableText();
        if (string == null) {
            RbsRenameTargetBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    public int hashCode() {
        return 31 * this.myProject.hashCode() + this.mySymbol.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/rename/RbsRenameTargetBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/rename/RbsRenameTargetBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceSearchRequests";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceTargets";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

