/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.psi.reference;

import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNameCompletionTarget;
import com.intellij.lang.ruby.rbs.model.psi.reference.RbsQualifiedNameSymbolReference;
import com.intellij.lang.ruby.rbs.model.usages.RbsUsageTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.common.psi.api.RbsContainerDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsNamespace;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.usages.impl.rules.UsageType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class RbsReferenceFactory {
    private RbsReferenceFactory() {
    }

    @NotNull
    public static List<RbsQualifiedNameSymbolReference> createQualifiedNameReferences(@NotNull PsiElement declaringElement, @NotNull PsiElement nameElement, @NotNull UsageType usageType, @NotNull EnumSet<RbsQualifiedNameCompletionTarget> completionTargets) {
        RbsContainerDeclarationElement containerDeclaration;
        if (declaringElement == null) {
            RbsReferenceFactory.$$$reportNull$$$0(0);
        }
        if (nameElement == null) {
            RbsReferenceFactory.$$$reportNull$$$0(1);
        }
        if (usageType == null) {
            RbsReferenceFactory.$$$reportNull$$$0(2);
        }
        if (completionTargets == null) {
            RbsReferenceFactory.$$$reportNull$$$0(3);
        }
        Fqn containerFqn = (containerDeclaration = (RbsContainerDeclarationElement)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)declaringElement, RbsContainerDeclarationElement.class)) != null ? containerDeclaration.getFqn() : Fqn.INVALID;
        return RbsReferenceFactory.createQualifiedNameReferences(declaringElement, nameElement, usageType, containerFqn, completionTargets);
    }

    @NotNull
    public static List<RbsQualifiedNameSymbolReference> createQualifiedNameReferences(@NotNull PsiElement declaringElement, @NotNull PsiElement nameElement, @NotNull UsageType usageType, @NotNull Fqn containerFqn, @NotNull EnumSet<RbsQualifiedNameCompletionTarget> completionTargets) {
        String qualifiedName;
        TextRange textRange;
        String text;
        if (declaringElement == null) {
            RbsReferenceFactory.$$$reportNull$$$0(4);
        }
        if (nameElement == null) {
            RbsReferenceFactory.$$$reportNull$$$0(5);
        }
        if (usageType == null) {
            RbsReferenceFactory.$$$reportNull$$$0(6);
        }
        if (containerFqn == null) {
            RbsReferenceFactory.$$$reportNull$$$0(7);
        }
        if (completionTargets == null) {
            RbsReferenceFactory.$$$reportNull$$$0(8);
        }
        if ((text = StringUtil.trimEnd((String)nameElement.getText(), (String)"::")).isEmpty()) {
            List<RbsQualifiedNameSymbolReference> list = Collections.emptyList();
            if (list == null) {
                RbsReferenceFactory.$$$reportNull$$$0(9);
            }
            return list;
        }
        int offset = nameElement.getTextOffset() - declaringElement.getTextOffset();
        int startIndex = text.startsWith("::") ? 2 : 0;
        startIndex += StringUtil.findFirst((CharSequence)text.substring(startIndex), (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
        int endIndex = text.indexOf("::", startIndex += text.charAt(startIndex) == '_' ? 1 : 0);
        ArrayList<RbsQualifiedNameSymbolReference> references = new ArrayList<RbsQualifiedNameSymbolReference>();
        while (endIndex > startIndex) {
            textRange = TextRange.create((int)(offset + startIndex), (int)(offset + endIndex));
            qualifiedName = StringUtil.strip((String)(endIndex >= 0 ? text.substring(0, endIndex) : text), (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
            references.add(RbsReferenceFactory.createQualifiedNameReference(declaringElement, nameElement, textRange, RbsUsageTypes.USAGE_TYPE_NESTED_CONSTANT_ACCESS, containerFqn, qualifiedName, completionTargets));
            startIndex = endIndex + 2;
            startIndex += StringUtil.findFirst((CharSequence)text.substring(startIndex), (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
            endIndex = text.indexOf("::", startIndex += text.charAt(startIndex) == '_' ? 1 : 0);
        }
        textRange = TextRange.create((int)(offset + startIndex), (int)(offset + text.length()));
        qualifiedName = StringUtil.strip((String)text, (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
        references.add(RbsReferenceFactory.createQualifiedNameReference(declaringElement, nameElement, textRange, usageType, containerFqn, qualifiedName, completionTargets));
        ArrayList<RbsQualifiedNameSymbolReference> arrayList = references;
        if (arrayList == null) {
            RbsReferenceFactory.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static RbsQualifiedNameSymbolReference createQualifiedNameReference(@NotNull PsiElement declaringElement, @NotNull PsiElement nameElement, @NotNull TextRange textRange, @NotNull UsageType usageType, @NotNull Fqn containerFqn, @NotNull String qualifiedName, @NotNull EnumSet<RbsQualifiedNameCompletionTarget> completionTargets) {
        if (declaringElement == null) {
            RbsReferenceFactory.$$$reportNull$$$0(11);
        }
        if (nameElement == null) {
            RbsReferenceFactory.$$$reportNull$$$0(12);
        }
        if (textRange == null) {
            RbsReferenceFactory.$$$reportNull$$$0(13);
        }
        if (usageType == null) {
            RbsReferenceFactory.$$$reportNull$$$0(14);
        }
        if (containerFqn == null) {
            RbsReferenceFactory.$$$reportNull$$$0(15);
        }
        if (qualifiedName == null) {
            RbsReferenceFactory.$$$reportNull$$$0(16);
        }
        if (completionTargets == null) {
            RbsReferenceFactory.$$$reportNull$$$0(17);
        }
        if (nameElement instanceof RbsNamespace && containerFqn != Fqn.INVALID) {
            return new RbsQualifiedNameSymbolReference(declaringElement, textRange, usageType, Fqn.INVALID, Fqn.concat((Fqn)containerFqn, (String)qualifiedName, (String[])new String[0]).join(), completionTargets);
        }
        return new RbsQualifiedNameSymbolReference(declaringElement, textRange, usageType, containerFqn, qualifiedName, completionTargets);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringElement";
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameElement";
                break;
            }
            case 2: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageType";
                break;
            }
            case 3: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionTargets";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerFqn";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/psi/reference/RbsReferenceFactory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/psi/reference/RbsReferenceFactory";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createQualifiedNameReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedNameReferences";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedNameReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10 -> new IllegalStateException(string);
        };
    }
}

