/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.psi.declaration;

import com.intellij.lang.ruby.rbs.model.api.RbsSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsSyntacticSugarSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsAttributeSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsConstantSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsGlobalVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInstanceVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodAliasSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleMethodSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsParameterSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsUseClauseAliasSymbol;
import com.intellij.lang.ruby.rbs.model.psi.declaration.RbsPsiSymbolDeclaration;
import com.intellij.lang.ruby.rbs.psi.index.RbsAttributeDeclarationNameIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsClassDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsClassVariableDeclarationNameIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsConstantDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsGlobalVariableDeclarationNameIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsInstanceVariableDeclarationNameIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsInterfaceDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsMethodDeclarationNameIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsModuleDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsTypeDeclarationFqnIndex;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.rbs.common.psi.api.RbsContainerDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsMethodDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsProcType;
import com.intellij.ruby.rbs.common.psi.api.RbsTypeDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsUseCls;
import com.intellij.ruby.rbs.common.psi.data.RbsDeclarationType;
import com.intellij.ruby.rbs.common.psi.mixin.RbsAttributeDeclarationMixin;
import com.intellij.ruby.rbs.common.psi.mixin.RbsParamMixin;
import com.intellij.ruby.rbs.common.psi.mixin.RbsVariableDeclarationMixin;
import com.intellij.ruby.rbs.common.psi.stub.RbsStubBasedPsiElement;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;
import org.jetbrains.plugins.ruby.model.psi.declaration.PsiSymbolDeclarationHints;

public final class RbsPsiSymbolDeclarationSearcher {
    private RbsPsiSymbolDeclarationSearcher() {
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static List<? extends RbsPsiSymbolDeclaration> getDeclarations(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Symbol symbol) {
        if (project == null) {
            RbsPsiSymbolDeclarationSearcher.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RbsPsiSymbolDeclarationSearcher.$$$reportNull$$$0(1);
        }
        if (symbol == null) {
            RbsPsiSymbolDeclarationSearcher.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.softAssertReadAccess();
        ArrayList declarations = new ArrayList();
        RbsPsiSymbolDeclarationSearcher.processDeclarations(project, searchScope, symbol, (Processor<? super RbsPsiSymbolDeclaration>)((Processor)declaration -> {
            ProgressManager.checkCanceled();
            declarations.add(declaration);
            return true;
        }));
        List list = Collections.unmodifiableList(declarations);
        if (list == null) {
            RbsPsiSymbolDeclarationSearcher.$$$reportNull$$$0(3);
        }
        return list;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    public static boolean processDeclarations(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Symbol symbol, @NotNull Processor<? super RbsPsiSymbolDeclaration> processor) {
        if (project == null) {
            RbsPsiSymbolDeclarationSearcher.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RbsPsiSymbolDeclarationSearcher.$$$reportNull$$$0(5);
        }
        if (symbol == null) {
            RbsPsiSymbolDeclarationSearcher.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            RbsPsiSymbolDeclarationSearcher.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (!(symbol instanceof RbsSymbol)) {
            return true;
        }
        MyVisitor visitor = new MyVisitor(project, searchScope, processor);
        if (symbol instanceof RbsAttributeSymbol) {
            RbsAttributeSymbol attributeSymbol = (RbsAttributeSymbol)symbol;
            visitor.visitAttributeSymbol(attributeSymbol);
        } else if (symbol instanceof RbsClassSymbol) {
            RbsClassSymbol classSymbol = (RbsClassSymbol)symbol;
            visitor.visitClassSymbol(classSymbol);
        } else if (symbol instanceof RbsClassVariableSymbol) {
            RbsClassVariableSymbol classVariableSymbol = (RbsClassVariableSymbol)symbol;
            visitor.visitClassVariableSymbol(classVariableSymbol);
        } else if (symbol instanceof RbsConstantSymbol) {
            RbsConstantSymbol constantSymbol = (RbsConstantSymbol)symbol;
            visitor.visitConstantSymbol(constantSymbol);
        } else if (symbol instanceof RbsContainerTypeVariableSymbol) {
            RbsContainerTypeVariableSymbol containerTypeVariableSymbol = (RbsContainerTypeVariableSymbol)symbol;
            visitor.visitContainerTypeVariableSymbol(containerTypeVariableSymbol);
        } else if (symbol instanceof RbsGlobalVariableSymbol) {
            RbsGlobalVariableSymbol globalVariableSymbol = (RbsGlobalVariableSymbol)symbol;
            visitor.visitGlobalVariableSymbol(globalVariableSymbol);
        } else if (symbol instanceof RbsInstanceVariableSymbol) {
            RbsInstanceVariableSymbol instanceVariableSymbol = (RbsInstanceVariableSymbol)symbol;
            visitor.visitInstanceVariableSymbol(instanceVariableSymbol);
        } else if (symbol instanceof RbsInterfaceSymbol) {
            RbsInterfaceSymbol interfaceSymbol = (RbsInterfaceSymbol)symbol;
            visitor.visitInterfaceSymbol(interfaceSymbol);
        } else if (symbol instanceof RbsMethodAliasSymbol) {
            RbsMethodAliasSymbol methodAliasSymbol = (RbsMethodAliasSymbol)symbol;
            visitor.visitMethodAliasSymbol(methodAliasSymbol);
        } else if (symbol instanceof RbsMethodSymbol) {
            RbsMethodSymbol methodSymbol = (RbsMethodSymbol)symbol;
            visitor.visitMethodSymbol(methodSymbol);
        } else if (symbol instanceof RbsMethodTypeVariableSymbol) {
            RbsMethodTypeVariableSymbol methodTypeVariableSymbol = (RbsMethodTypeVariableSymbol)symbol;
            visitor.visitMethodTypeVariableSymbol(methodTypeVariableSymbol);
        } else if (symbol instanceof RbsModuleSymbol) {
            RbsModuleSymbol moduleSymbol = (RbsModuleSymbol)symbol;
            visitor.visitModuleSymbol(moduleSymbol);
        } else if (symbol instanceof RbsModuleMethodSymbol) {
            RbsModuleMethodSymbol moduleMethodSymbol = (RbsModuleMethodSymbol)symbol;
            visitor.visitModuleMethodSymbol(moduleMethodSymbol);
        } else if (symbol instanceof RbsParameterSymbol) {
            RbsParameterSymbol parameterSymbol = (RbsParameterSymbol)symbol;
            visitor.visitParameterSymbol(parameterSymbol);
        } else if (symbol instanceof RbsTypeAliasSymbol) {
            RbsTypeAliasSymbol typeAliasSymbol = (RbsTypeAliasSymbol)symbol;
            visitor.visitTypeAliasSymbol(typeAliasSymbol);
        } else if (symbol instanceof RbsTypeAliasTypeVariableSymbol) {
            RbsTypeAliasTypeVariableSymbol typeAliasTypeVariableSymbol = (RbsTypeAliasTypeVariableSymbol)symbol;
            visitor.visitTypeAliasTypeVariableSymbol(typeAliasTypeVariableSymbol);
        } else if (symbol instanceof RbsUseClauseAliasSymbol) {
            RbsUseClauseAliasSymbol useClauseAliasSymbol = (RbsUseClauseAliasSymbol)symbol;
            visitor.visitUseClauseAliasSymbol(useClauseAliasSymbol);
        }
        return visitor.myContinue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/psi/declaration/RbsPsiSymbolDeclarationSearcher";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/psi/declaration/RbsPsiSymbolDeclarationSearcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarations";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class MyVisitor {
        private final Project myProject;
        private final SearchScope mySearchScope;
        private final Processor<? super PsiSymbolDeclaration> myProcessor;
        private boolean myContinue;

        private MyVisitor(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Processor<? super RbsPsiSymbolDeclaration> processor) {
            if (project == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (searchScope == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if (processor == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            this.myContinue = true;
            this.myProject = project;
            this.mySearchScope = searchScope;
            this.myProcessor = it -> {
                RbsPsiSymbolDeclaration declaration;
                return !(it instanceof RbsPsiSymbolDeclaration) || processor.process((Object)(declaration = (RbsPsiSymbolDeclaration)it));
            };
        }

        private boolean processElement(@NotNull PsiElement element, @NotNull Symbol symbol) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            for (PsiSymbolDeclaration declaration : ExtensionsKt.getSymbolDeclarations((PsiElement)element, (PsiSymbolDeclarationHints)PsiSymbolDeclarationHints.symbolHint((Symbol)symbol))) {
                if (this.myProcessor.process((Object)declaration)) continue;
                return false;
            }
            return true;
        }

        private boolean processElement(@NotNull PsiElement element, @NotNull List<Symbol> symbols) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if (symbols == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            for (PsiSymbolDeclaration declaration : ExtensionsKt.getSymbolDeclarations((PsiElement)element)) {
                RbsSyntacticSugarSymbol syntacticSugarSymbol;
                List<? extends RbsSymbol> dynamicSymbols;
                Symbol declarationSymbol = declaration.getSymbol();
                if (!(symbols.contains(declarationSymbol) ? !this.myProcessor.process((Object)declaration) : declarationSymbol instanceof RbsSyntacticSugarSymbol && ContainerUtil.intersects(symbols, dynamicSymbols = (syntacticSugarSymbol = (RbsSyntacticSugarSymbol)declarationSymbol).getDynamicSymbols(this.myProject, this.mySearchScope)) && !this.myProcessor.process((Object)declaration))) continue;
                return false;
            }
            return true;
        }

        private void visitAttributeSymbol(@NotNull RbsAttributeSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            RbsDeclarationType type = symbol.getDeclarationType();
            Fqn containerFqn = symbol.getContainerFqn();
            String name = symbol.getName();
            this.myContinue = RbsAttributeDeclarationNameIndex.getInstance().processElements(this.myProject, this.mySearchScope, type, containerFqn, name, (Processor<? super RbsAttributeDeclarationMixin>)((Processor)it -> this.processElement((PsiElement)it, symbol)));
        }

        private void visitClassSymbol(@NotNull RbsClassSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            Fqn fqn = symbol.getFqn();
            this.myContinue = RbsClassDeclarationFqnIndex.getInstance().processElements(this.myProject, this.mySearchScope, fqn, it -> this.processElement((PsiElement)it, symbol));
        }

        private void visitClassVariableSymbol(@NotNull RbsClassVariableSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            Fqn containerFqn = symbol.getContainerFqn();
            String name = symbol.getName();
            this.myContinue = RbsClassVariableDeclarationNameIndex.getInstance().processElements(this.myProject, this.mySearchScope, containerFqn, name, (Processor<? super RbsVariableDeclarationMixin>)((Processor)it -> this.processElement((PsiElement)it, symbol)));
        }

        private void visitConstantSymbol(@NotNull RbsConstantSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            Fqn fqn = symbol.getFqn();
            this.myContinue = RbsConstantDeclarationFqnIndex.getInstance().processElements(this.myProject, this.mySearchScope, fqn, it -> this.processElement((PsiElement)it, symbol));
        }

        private void visitContainerTypeVariableSymbol(@NotNull RbsContainerTypeVariableSymbol symbol) {
            RbsContainerDeclarationElement element;
            VirtualFile file;
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(11);
            }
            if ((file = PsiUtilCore.getVirtualFile((PsiElement)(element = symbol.getElement()))) == null || !this.mySearchScope.contains(file)) {
                return;
            }
            this.myContinue = this.processElement((PsiElement)element, symbol);
        }

        private void visitGlobalVariableSymbol(@NotNull RbsGlobalVariableSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(12);
            }
            String name = symbol.getName();
            this.myContinue = RbsGlobalVariableDeclarationNameIndex.getInstance().processElements(this.myProject, this.mySearchScope, name, it -> this.processElement((PsiElement)it, symbol));
        }

        private void visitInstanceVariableSymbol(@NotNull RbsInstanceVariableSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(13);
            }
            RbsDeclarationType type = symbol.getDeclarationType();
            Fqn containerFqn = symbol.getContainerFqn();
            String name = symbol.getName();
            List symbols = ContainerUtil.packNullables((Object[])new Symbol[]{symbol, symbol.getOriginalDeclaration()});
            this.myContinue = RbsInstanceVariableDeclarationNameIndex.getInstance().processElements(this.myProject, this.mySearchScope, type, containerFqn, name, (Processor<? super RbsStubBasedPsiElement>)((Processor)it -> this.processElement((PsiElement)it, symbols)));
        }

        private void visitInterfaceSymbol(@NotNull RbsInterfaceSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(14);
            }
            Fqn fqn = symbol.getFqn();
            this.myContinue = RbsInterfaceDeclarationFqnIndex.getInstance().processElements(this.myProject, this.mySearchScope, fqn, it -> this.processElement((PsiElement)it, symbol));
        }

        private void visitMethodAliasSymbol(@NotNull RbsMethodAliasSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(15);
            }
            RbsDeclarationType type = symbol.getDeclarationType();
            Fqn containerFqn = symbol.getContainerFqn();
            String name = symbol.getName();
            this.myContinue = RbsMethodDeclarationNameIndex.getInstance().processElements(this.myProject, this.mySearchScope, type, containerFqn, name, (Processor<? super RbsStubBasedPsiElement>)((Processor)it -> this.processElement((PsiElement)it, symbol)));
        }

        private void visitMethodSymbol(@NotNull RbsMethodSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(16);
            }
            RbsDeclarationType type = symbol.getDeclarationType();
            Fqn containerFqn = symbol.getContainerFqn();
            String name = symbol.getName();
            List symbols = ContainerUtil.packNullables((Object[])new Symbol[]{symbol, symbol.getOriginalDeclaration()});
            this.myContinue = RbsMethodDeclarationNameIndex.getInstance().processElements(this.myProject, this.mySearchScope, type, containerFqn, name, (Processor<? super RbsStubBasedPsiElement>)((Processor)it -> this.processElement((PsiElement)it, symbols)));
        }

        private void visitMethodTypeVariableSymbol(@NotNull RbsMethodTypeVariableSymbol symbol) {
            RbsMethodDeclarationElement element;
            VirtualFile file;
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(17);
            }
            if ((file = PsiUtilCore.getVirtualFile((PsiElement)(element = symbol.getElement()))) == null || !this.mySearchScope.contains(file)) {
                return;
            }
            this.myContinue = this.processElement((PsiElement)element, symbol);
        }

        private void visitModuleSymbol(@NotNull RbsModuleSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(18);
            }
            Fqn fqn = symbol.getFqn();
            this.myContinue = RbsModuleDeclarationFqnIndex.getInstance().processElements(this.myProject, this.mySearchScope, fqn, it -> this.processElement((PsiElement)it, symbol));
        }

        private void visitModuleMethodSymbol(@NotNull RbsModuleMethodSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(19);
            }
            EnumSet<RbsDeclarationType> declarationTypes = EnumSet.allOf(RbsDeclarationType.class);
            Fqn containerFqn = symbol.getContainerFqn();
            String name = symbol.getName();
            this.myContinue = RbsMethodDeclarationNameIndex.getInstance().processElements(this.myProject, this.mySearchScope, declarationTypes, containerFqn, name, (Processor<? super RbsStubBasedPsiElement>)((Processor)it -> this.processElement((PsiElement)it, symbol)));
        }

        private void visitParameterSymbol(@NotNull RbsParameterSymbol symbol) {
            RbsProcType element;
            VirtualFile file;
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(20);
            }
            if ((file = PsiUtilCore.getVirtualFile((PsiElement)(element = symbol.getElement()))) == null || !this.mySearchScope.contains(file)) {
                return;
            }
            for (RbsParamMixin parameter : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)element, RbsParamMixin.class)) {
                if (this.processElement((PsiElement)parameter, symbol)) continue;
                this.myContinue = false;
                return;
            }
        }

        private void visitTypeAliasSymbol(@NotNull RbsTypeAliasSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(21);
            }
            Fqn fqn = symbol.getFqn();
            this.myContinue = RbsTypeDeclarationFqnIndex.getInstance().processElements(this.myProject, this.mySearchScope, fqn, it -> this.processElement((PsiElement)it, symbol));
        }

        private void visitTypeAliasTypeVariableSymbol(@NotNull RbsTypeAliasTypeVariableSymbol symbol) {
            RbsTypeDeclarationElement element;
            VirtualFile file;
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(22);
            }
            if ((file = PsiUtilCore.getVirtualFile((PsiElement)(element = symbol.getElement()))) == null || !this.mySearchScope.contains(file)) {
                return;
            }
            this.myContinue = this.processElement((PsiElement)element, symbol);
        }

        private void visitUseClauseAliasSymbol(@NotNull RbsUseClauseAliasSymbol symbol) {
            RbsUseCls element;
            VirtualFile file;
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(23);
            }
            if ((file = PsiUtilCore.getVirtualFile((PsiElement)(element = symbol.getElement()))) == null || !this.mySearchScope.contains(file)) {
                return;
            }
            this.myContinue = this.processElement((PsiElement)element, symbol);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbols";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/model/psi/declaration/RbsPsiSymbolDeclarationSearcher$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processElement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAttributeSymbol";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassSymbol";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassVariableSymbol";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitConstantSymbol";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitContainerTypeVariableSymbol";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitGlobalVariableSymbol";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInstanceVariableSymbol";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInterfaceSymbol";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodAliasSymbol";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodSymbol";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodTypeVariableSymbol";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModuleSymbol";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModuleMethodSymbol";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameterSymbol";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeAliasSymbol";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeAliasTypeVariableSymbol";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUseClauseAliasSymbol";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

