/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.impl;

import com.intellij.lang.ruby.rbs.model.api.RbsSymbol;
import com.intellij.model.Pointer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.RbsIcons;
import com.intellij.ruby.rbs.common.psi.api.RbsProcType;
import com.intellij.ruby.rbs.common.psi.data.RbsKeywordTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsParameterType;
import com.intellij.ruby.rbs.common.psi.data.RbsProcTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;

public final class RbsParameterSymbol
implements RbsSymbol,
PresentableSymbol {
    private final RbsProcType myElement;
    private final RbsParameterType myParameterType;
    @NlsSafe
    private final String myName;
    @Nullable
    private final Pointer<RbsParameterSymbol> myPointer;

    public RbsParameterSymbol(@NotNull RbsProcType element, @NotNull RbsParameterType parameterType, @NlsSafe @NotNull String name) {
        if (element == null) {
            RbsParameterSymbol.$$$reportNull$$$0(0);
        }
        if (parameterType == null) {
            RbsParameterSymbol.$$$reportNull$$$0(1);
        }
        if (name == null) {
            RbsParameterSymbol.$$$reportNull$$$0(2);
        }
        this(element, parameterType, name, null);
    }

    private RbsParameterSymbol(@NotNull RbsProcType element, @NotNull RbsParameterType parameterType, @NlsSafe @NotNull String name, @Nullable Pointer<RbsParameterSymbol> pointer) {
        if (element == null) {
            RbsParameterSymbol.$$$reportNull$$$0(3);
        }
        if (parameterType == null) {
            RbsParameterSymbol.$$$reportNull$$$0(4);
        }
        if (name == null) {
            RbsParameterSymbol.$$$reportNull$$$0(5);
        }
        this.myElement = element;
        this.myParameterType = parameterType;
        this.myName = name;
        this.myPointer = pointer;
    }

    @NotNull
    public Pointer<RbsParameterSymbol> createPointer() {
        if (this.myPointer != null) {
            Pointer<RbsParameterSymbol> pointer2 = this.myPointer;
            if (pointer2 == null) {
                RbsParameterSymbol.$$$reportNull$$$0(6);
            }
            return pointer2;
        }
        RbsParameterType parameterType = this.myParameterType;
        String name = this.myName;
        Pointer pointer3 = Pointer.uroborosPointer((Pointer)SmartPointerManager.createPointer((PsiElement)this.myElement), (element, pointer) -> new RbsParameterSymbol((RbsProcType)element, parameterType, name, (Pointer<RbsParameterSymbol>)pointer));
        if (pointer3 == null) {
            RbsParameterSymbol.$$$reportNull$$$0(7);
        }
        return pointer3;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RbsParameterSymbol other = (RbsParameterSymbol)obj;
        return this.myElement.equals((Object)other.myElement) && this.myParameterType.equals((Object)other.myParameterType) && this.myName.equals(other.myName);
    }

    @NotNull
    public RbsProcType getElement() {
        RbsProcType rbsProcType = this.myElement;
        if (rbsProcType == null) {
            RbsParameterSymbol.$$$reportNull$$$0(8);
        }
        return rbsProcType;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RbsParameterSymbol.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public RbsParameterType getParameterType() {
        RbsParameterType rbsParameterType = this.myParameterType;
        if (rbsParameterType == null) {
            RbsParameterSymbol.$$$reportNull$$$0(10);
        }
        return rbsParameterType;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        String key = switch (this.myParameterType) {
            default -> throw new MatchException(null, null);
            case RbsParameterType.POSITIONAL_PARAMETER -> "rbs.model.parameter.shortDescription";
            case RbsParameterType.KEYWORD_PARAMETER -> "rbs.model.keyword.shortDescription";
        };
        @Nls Supplier shortDescriptionSupplier = RbsBundle.messagePointer((String)key, (Object[])new Object[]{this.myName});
        return new SymbolPresentation(RbsIcons.RBS_PARAMETER_ICON, this.myName, shortDescriptionSupplier);
    }

    @NotNull
    public RbsTypeSignature getTypeSignature() {
        Set parameterTypes = this.myParameterType == RbsParameterType.POSITIONAL_PARAMETER ? RbsProcTypeSignature.ParameterType.POSITIONAL_TYPES : RbsProcTypeSignature.ParameterType.KEYWORD_TYPES;
        RbsTypeSignature rbsTypeSignature = Optional.ofNullable(this.myElement.getTypeSignature().findParameter(parameterTypes, this.myName)).map(RbsProcTypeSignature.Parameter::getTypeSignature).orElse((RbsTypeSignature)RbsKeywordTypeSignature.UNTYPED);
        if (rbsTypeSignature == null) {
            RbsParameterSymbol.$$$reportNull$$$0(11);
        }
        return rbsTypeSignature;
    }

    public int hashCode() {
        int result = this.myElement.hashCode();
        result = 31 * result + this.myParameterType.hashCode();
        result = 31 * result + this.myName.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        String string = String.format("RbsParameterSymbol{myElement=%s, myParameterType=%s, myName='%s', myPointer=%s}", this.myElement, this.myParameterType, this.myName, this.myPointer);
        if (string == null) {
            RbsParameterSymbol.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/impl/RbsParameterSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/impl/RbsParameterSymbol";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignature";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

