/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.cache.RbsSymbolsCache;
import com.intellij.lang.ruby.rbs.model.hierarchy.RbsContainerSymbolUtil;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsSingletonSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.model.psi.declaration.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.psi.index.RbsDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsModuleDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.util.RbsSymbols;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.RbsIcons;
import com.intellij.ruby.rbs.common.psi.mixin.RbsModuleAliasDeclarationMixin;
import com.intellij.ruby.rbs.common.psi.mixin.RbsModuleDeclarationMixin;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.model.psi.declaration.NavigatablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.util.StreamUtil;
import org.jetbrains.plugins.ruby.utils.SmartCancellationChecker;

public final class RbsModuleSymbol
implements RbsContainerSymbol,
NavigatableSymbol {
    private final Fqn myFqn;

    public RbsModuleSymbol(@NotNull Fqn fqn) {
        if (fqn == null) {
            RbsModuleSymbol.$$$reportNull$$$0(0);
        }
        this.myFqn = fqn.normalize();
    }

    @NotNull
    public Pointer<RbsModuleSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RbsModuleSymbol.$$$reportNull$$$0(1);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myFqn.isEquivalentTo(((RbsModuleSymbol)obj).myFqn);
    }

    @Override
    @NotNull
    public Fqn getFqn() {
        Fqn fqn = this.myFqn;
        if (fqn == null) {
            RbsModuleSymbol.$$$reportNull$$$0(2);
        }
        return fqn;
    }

    @NotNull
    public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
        if (project == null) {
            RbsModuleSymbol.$$$reportNull$$$0(3);
        }
        GlobalSearchScope maximalSearchScope = GlobalSearchScope.allScope((Project)project);
        List<NavigationTarget> list = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)maximalSearchScope, this).stream().map(NavigatablePsiSymbolDeclaration::getNavigationTarget).sorted().toList();
        if (list == null) {
            RbsModuleSymbol.$$$reportNull$$$0(4);
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        String name = this.getName();
        @Nls Supplier shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.module.shortDescription", (Object[])new Object[]{name});
        Fqn fqn = this.myFqn.split();
        if (fqn.getParent() == Fqn.INVALID) {
            return new SymbolPresentation(RbsIcons.RBS_MODULE_ICON, name, shortDescriptionSupplier);
        }
        @Nls Supplier longDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.module.longDescription", (Object[])new Object[]{name, fqn.getParent().join()});
        return new SymbolPresentation(RbsIcons.RBS_MODULE_ICON, name, shortDescriptionSupplier, longDescriptionSupplier);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public List<? extends RbsContainerSymbol> getSelfTypeSymbols(@NotNull Project project, @NotNull SearchScope searchScope) {
        Cache<Symbol, List<RbsContainerSymbol>> cache;
        List cachedSelfTypes;
        if (project == null) {
            RbsModuleSymbol.$$$reportNull$$$0(5);
        }
        if (searchScope == null) {
            RbsModuleSymbol.$$$reportNull$$$0(6);
        }
        if ((cachedSelfTypes = (List)(cache = RbsSymbolsCache.getInstance(project, searchScope).getSelfTypes()).getIfPresent((Object)this)) != null) {
            List list = cachedSelfTypes;
            if (list == null) {
                RbsModuleSymbol.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<? extends RbsContainerSymbol> selfTypes = this.getSelfTypeSymbolsImpl(project, searchScope, new HashSet<RbsModuleSymbol>());
        cache.put((Object)this, List.copyOf(selfTypes));
        List<? extends RbsContainerSymbol> list = selfTypes;
        if (list == null) {
            RbsModuleSymbol.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public RbsSingletonSymbol getSingletonSymbol() {
        return new RbsSingletonSymbol(this);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public RbsModuleSymbol getTargetModuleSymbol(@NotNull Project project, @NotNull SearchScope searchScope) {
        Cache<RbsModuleSymbol, List<RbsModuleSymbol>> cache;
        List cachedTargetModules;
        if (project == null) {
            RbsModuleSymbol.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            RbsModuleSymbol.$$$reportNull$$$0(10);
        }
        if ((cachedTargetModules = (List)(cache = RbsSymbolsCache.getInstance(project, searchScope).getTargetModules()).getIfPresent((Object)this)) != null) {
            return (RbsModuleSymbol)ContainerUtil.getOnlyItem((Collection)cachedTargetModules);
        }
        List<RbsModuleSymbol> targetModules = this.getTargetModuleSymbols(project, searchScope, new HashSet<RbsModuleSymbol>());
        cache.put((Object)this, targetModules);
        return (RbsModuleSymbol)ContainerUtil.getOnlyItem(targetModules);
    }

    public int hashCode() {
        return this.myFqn.hashCode();
    }

    @NotNull
    public String toString() {
        String string = String.format("RbsModuleSymbol{myFqn=%s}", this.myFqn);
        if (string == null) {
            RbsModuleSymbol.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private List<? extends RbsContainerSymbol> getSelfTypeSymbolsImpl(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Set<RbsModuleSymbol> visited) {
        if (project == null) {
            RbsModuleSymbol.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            RbsModuleSymbol.$$$reportNull$$$0(13);
        }
        if (visited == null) {
            RbsModuleSymbol.$$$reportNull$$$0(14);
        }
        if (!visited.add(this)) {
            List list = Collections.emptyList();
            if (list == null) {
                RbsModuleSymbol.$$$reportNull$$$0(15);
            }
            return list;
        }
        RbsModuleSymbol targetModule = this.getTargetModuleSymbol(project, searchScope);
        if (targetModule != null) {
            return targetModule.getSelfTypeSymbolsImpl(project, searchScope, visited);
        }
        LinkedHashSet<RbsClassSymbol> selfTypes = new LinkedHashSet<RbsClassSymbol>();
        RbsModuleDeclarationFqnIndex.getInstance().processElements(project, searchScope, this.myFqn, elem -> {
            ProgressManager.checkCanceled();
            if (elem instanceof RbsModuleDeclarationMixin) {
                RbsModuleDeclarationMixin element = (RbsModuleDeclarationMixin)elem;
                GlobalSearchScope resolveScope = element.getResolveScope();
                Fqn containerFqn = element.getFqn();
                for (String selfTypeName : element.getModuleSelfTypes().keySet()) {
                    RbsResolveUtil.resolveQualifiedNameInNesting(project, (SearchScope)resolveScope, containerFqn, selfTypeName, (PsiElement)element).stream().mapMulti(RbsContainerSymbolUtil.followAliases(project, (SearchScope)resolveScope)).mapMulti(StreamUtil.select(RbsContainerSymbol.class, (Class[])new Class[0])).forEach(selfTypes::add);
                }
            }
            return true;
        });
        if (selfTypes.isEmpty()) {
            selfTypes.add(RbsSymbols.OBJECT_SYMBOL);
        }
        List list = List.copyOf(selfTypes);
        if (list == null) {
            RbsModuleSymbol.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    private List<RbsModuleSymbol> getTargetModuleSymbols(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Set<RbsModuleSymbol> visited) {
        if (project == null) {
            RbsModuleSymbol.$$$reportNull$$$0(17);
        }
        if (searchScope == null) {
            RbsModuleSymbol.$$$reportNull$$$0(18);
        }
        if (visited == null) {
            RbsModuleSymbol.$$$reportNull$$$0(19);
        }
        if (!visited.add(this)) {
            List<RbsModuleSymbol> list = Collections.emptyList();
            if (list == null) {
                RbsModuleSymbol.$$$reportNull$$$0(20);
            }
            return list;
        }
        LinkedHashSet moduleDeclarations = new LinkedHashSet();
        RbsModuleDeclarationFqnIndex.getInstance().processElements(project, searchScope, this.myFqn, element -> {
            ProgressManager.checkCanceled();
            if (element instanceof RbsModuleDeclarationMixin) {
                moduleDeclarations.clear();
                return false;
            }
            if (element instanceof RbsModuleAliasDeclarationMixin) {
                RbsModuleAliasDeclarationMixin moduleAlias = (RbsModuleAliasDeclarationMixin)element;
                String targetModuleName = moduleAlias.getTargetModuleName();
                if (targetModuleName == null) {
                    return true;
                }
                RbsResolveUtil.resolveQualifiedName(project, searchScope, moduleAlias.getContainerFqn(), targetModuleName, Collections.emptySet(), (PsiElement)moduleAlias).stream().mapMulti(StreamUtil.select(RbsModuleSymbol.class, (Class[])new Class[0])).forEach(symbol -> {
                    List<RbsModuleSymbol> targets = symbol.getTargetModuleSymbols(project, searchScope, visited);
                    if (targets.isEmpty()) {
                        moduleDeclarations.add(symbol);
                    } else {
                        moduleDeclarations.addAll(targets);
                    }
                });
            }
            return true;
        });
        List<RbsModuleSymbol> list = List.copyOf(moduleDeclarations);
        if (list == null) {
            RbsModuleSymbol.$$$reportNull$$$0(21);
        }
        return list;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Optional<RbsModuleSymbol> find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Fqn fqn) {
        if (project == null) {
            RbsModuleSymbol.$$$reportNull$$$0(22);
        }
        if (searchScope == null) {
            RbsModuleSymbol.$$$reportNull$$$0(23);
        }
        if (fqn == null) {
            RbsModuleSymbol.$$$reportNull$$$0(24);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (fqn == Fqn.INVALID) {
            Optional<RbsModuleSymbol> optional = Optional.empty();
            if (optional == null) {
                RbsModuleSymbol.$$$reportNull$$$0(25);
            }
            return optional;
        }
        Cache<@NotNull RbsDeclarationFqnIndex.Type, @NotNull SequencedSet<Fqn>> cache = RbsSymbolsCache.getInstance(project, searchScope).getDeclarationFqns();
        Set moduleFqns = (Set)cache.get((Object)RbsDeclarationFqnIndex.Type.MODULE, it -> RbsDeclarationFqnIndex.getAllValues(project, searchScope, it));
        if (moduleFqns.contains(fqn.normalize())) {
            Optional<RbsModuleSymbol> optional = Optional.of(new RbsModuleSymbol(fqn));
            if (optional == null) {
                RbsModuleSymbol.$$$reportNull$$$0(26);
            }
            return optional;
        }
        Set moduleAliasFqns = (Set)cache.get((Object)RbsDeclarationFqnIndex.Type.MODULE_ALIAS, it -> RbsDeclarationFqnIndex.getAllValues(project, searchScope, it));
        if (moduleAliasFqns.contains(fqn.normalize())) {
            Optional<RbsModuleSymbol> optional = Optional.of(new RbsModuleSymbol(fqn));
            if (optional == null) {
                RbsModuleSymbol.$$$reportNull$$$0(27);
            }
            return optional;
        }
        Optional<RbsModuleSymbol> optional = Optional.empty();
        if (optional == null) {
            RbsModuleSymbol.$$$reportNull$$$0(28);
        }
        return optional;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Stream<RbsModuleSymbol> stream(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsModuleSymbol.$$$reportNull$$$0(29);
        }
        if (searchScope == null) {
            RbsModuleSymbol.$$$reportNull$$$0(30);
        }
        ThreadingAssertions.softAssertReadAccess();
        Cache<@NotNull RbsDeclarationFqnIndex.Type, @NotNull SequencedSet<Fqn>> cache = RbsSymbolsCache.getInstance(project, searchScope).getDeclarationFqns();
        SmartCancellationChecker checker = new SmartCancellationChecker(1000);
        Stream<RbsModuleSymbol> stream = Stream.of(RbsDeclarationFqnIndex.Type.MODULE, RbsDeclarationFqnIndex.Type.MODULE_ALIAS).flatMap(it -> ((SequencedSet)cache.get((Object)it, __ -> RbsDeclarationFqnIndex.getAllValues(project, searchScope, it))).stream()).map(RbsModuleSymbol::new).peek(__ -> checker.checkCancelled());
        if (stream == null) {
            RbsModuleSymbol.$$$reportNull$$$0(31);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 7, 8, 11, 15, 16, 20, 21, 25, 26, 27, 28, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/impl/RbsModuleSymbol";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 12: 
            case 17: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 18: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/impl/RbsModuleSymbol";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationTargets";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelfTypeSymbols";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelfTypeSymbolsImpl";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetModuleSymbols";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargets";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSelfTypeSymbols";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTargetModuleSymbol";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSelfTypeSymbolsImpl";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTargetModuleSymbols";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "stream";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 7, 8, 11, 15, 16, 20, 21, 25, 26, 27, 28, 31 -> new IllegalStateException(string);
        };
    }
}

