/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsSyntacticSugarSymbol;
import com.intellij.lang.ruby.rbs.model.cache.RbsSymbolsCache;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.psi.declaration.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.psi.index.RbsMethodDeclarationNameIndex;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.RbsIcons;
import com.intellij.ruby.rbs.common.psi.api.RbsMethodDeclarationElement;
import com.intellij.ruby.rbs.common.psi.data.RbsDeclarationType;
import com.intellij.ruby.rbs.common.psi.data.RbsMethodTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsVisibility;
import com.intellij.ruby.rbs.common.psi.stub.RbsStubBasedPsiElement;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.model.psi.declaration.NavigatablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;

public final class RbsModuleMethodSymbol
implements RbsSyntacticSugarSymbol,
NavigatableSymbol,
PresentableSymbol {
    private final RbsContainerSymbol myContainer;
    @NlsSafe
    private final String myName;

    public RbsModuleMethodSymbol(@NotNull RbsContainerSymbol container, @NlsSafe @NotNull String name) {
        if (container == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(0);
        }
        if (name == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(1);
        }
        this.myContainer = container;
        this.myName = name;
    }

    @NotNull
    public Pointer<RbsModuleMethodSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(2);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RbsModuleMethodSymbol other = (RbsModuleMethodSymbol)obj;
        return this.myContainer.equals(other.myContainer) && this.myName.equals(other.myName);
    }

    @NotNull
    public Fqn getContainerFqn() {
        Fqn fqn = this.myContainer.getFqn();
        if (fqn == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(3);
        }
        return fqn;
    }

    @NotNull
    public RbsContainerSymbol getContainerSymbol() {
        RbsContainerSymbol rbsContainerSymbol = this.myContainer;
        if (rbsContainerSymbol == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(4);
        }
        return rbsContainerSymbol;
    }

    @NotNull
    public List<RbsMethodSymbol> getDynamicSymbols(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(5);
        }
        if (searchScope == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(6);
        }
        List<RbsMethodSymbol> list = List.of(new RbsMethodSymbol(RbsVisibility.PUBLIC_VISIBILITY, RbsDeclarationType.SINGLETON_DECLARATION, this.myContainer, this.myName, this), new RbsMethodSymbol(RbsVisibility.PRIVATE_VISIBILITY, RbsDeclarationType.INSTANCE_DECLARATION, this.myContainer, this.myName, this));
        if (list == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(8);
        }
        return string;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public List<RbsMethodTypeSignature> getMethodTypeSignatures(@NotNull Project project, @NotNull SearchScope searchScope) {
        Cache<Symbol, List<RbsMethodTypeSignature>> cache;
        List cachedTypeSignatures;
        if (project == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(10);
        }
        if ((cachedTypeSignatures = (List)(cache = RbsSymbolsCache.getInstance(project, searchScope).getMethodTypeSignatures()).getIfPresent((Object)this)) != null) {
            List list = cachedTypeSignatures;
            if (list == null) {
                RbsModuleMethodSymbol.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<RbsMethodTypeSignature> typeSignatures = this.getMethodTypeSignaturesImpl(project, searchScope);
        cache.put((Object)this, typeSignatures);
        List<RbsMethodTypeSignature> list = typeSignatures;
        if (list == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
        if (project == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(13);
        }
        GlobalSearchScope maximalSearchScope = GlobalSearchScope.allScope((Project)project);
        List<NavigationTarget> list = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)maximalSearchScope, this).stream().map(NavigatablePsiSymbolDeclaration::getNavigationTarget).sorted().toList();
        if (list == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(14);
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        @Nls Supplier shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.module.method.shortDescription", (Object[])new Object[]{this.myName});
        Supplier<@Nls String> longDescriptionSupplier = () -> {
            @Nls String containerDescription = TextUtil.decapitalize((String)this.myContainer.getPresentation().longDescription());
            return RbsBundle.message((String)"rbs.model.module.method.longDescription", (Object[])new Object[]{this.myName, containerDescription});
        };
        return new SymbolPresentation(RbsIcons.RBS_MODULE_METHOD_ICON, this.myName, shortDescriptionSupplier, longDescriptionSupplier);
    }

    public int hashCode() {
        return 31 * this.myContainer.hashCode() + this.myName.hashCode();
    }

    @NotNull
    public String toString() {
        String string = String.format("RbsModuleMethodSymbol{myContainer=%s, myName='%s'}", this.myContainer, this.myName);
        if (string == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private List<RbsMethodTypeSignature> getMethodTypeSignaturesImpl(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(16);
        }
        if (searchScope == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(17);
        }
        LinkedHashSet typeSignatures = new LinkedHashSet();
        EnumSet<RbsDeclarationType> declarationTypes = EnumSet.allOf(RbsDeclarationType.class);
        Fqn containerFqn = this.getContainerFqn();
        RbsMethodDeclarationNameIndex.getInstance().processElements(project, searchScope, declarationTypes, containerFqn, this.myName, (Processor<? super RbsStubBasedPsiElement>)((Processor)element -> {
            ProgressManager.checkCanceled();
            if (element instanceof RbsMethodDeclarationElement) {
                RbsMethodDeclarationElement methodDeclaration = (RbsMethodDeclarationElement)element;
                typeSignatures.addAll(methodDeclaration.getMethodTypeSignatures());
            }
            return true;
        }));
        List<RbsMethodTypeSignature> list = List.copyOf(typeSignatures);
        if (list == null) {
            RbsModuleMethodSymbol.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 7, 8, 11, 12, 14, 15, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/impl/RbsModuleMethodSymbol";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/impl/RbsModuleMethodSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerFqn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerSymbol";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDynamicSymbols";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodTypeSignatures";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationTargets";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodTypeSignaturesImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 18: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDynamicSymbols";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMethodTypeSignatures";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargets";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMethodTypeSignaturesImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 7, 8, 11, 12, 14, 15, 18 -> new IllegalStateException(string);
        };
    }
}

