/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.impl;

import com.intellij.lang.ruby.rbs.model.api.RbsSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleMethodSymbol;
import com.intellij.lang.ruby.rbs.model.psi.declaration.RbsPsiSymbolDeclarationSearcher;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.RbsIcons;
import com.intellij.ruby.rbs.common.psi.api.RbsMethodDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsMethodMember;
import com.intellij.ruby.rbs.common.psi.api.RbsMethodType;
import com.intellij.ruby.rbs.common.psi.data.RbsMethodTypeParameter;
import com.intellij.ruby.rbs.common.psi.data.RbsMethodTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsVariance;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;
import org.jetbrains.plugins.ruby.model.psi.declaration.NavigatablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;

public final class RbsMethodTypeVariableSymbol
implements RbsTypeVariableSymbol,
NavigatableSymbol,
PresentableSymbol {
    private final RbsMethodMember myElement;
    private final int myMethodTypeIndex;
    private final int myTypeVariableIndex;
    @Nullable
    private final Pointer<RbsMethodTypeVariableSymbol> myPointer;

    public RbsMethodTypeVariableSymbol(@NotNull RbsMethodMember element, int methodTypeIndex, int typeVariableIndex) {
        if (element == null) {
            RbsMethodTypeVariableSymbol.$$$reportNull$$$0(0);
        }
        this(element, methodTypeIndex, typeVariableIndex, null);
    }

    private RbsMethodTypeVariableSymbol(@NotNull RbsMethodMember element, int methodTypeIndex, int typeVariableIndex, @Nullable Pointer<RbsMethodTypeVariableSymbol> pointer) {
        if (element == null) {
            RbsMethodTypeVariableSymbol.$$$reportNull$$$0(1);
        }
        this.myElement = element;
        this.myMethodTypeIndex = methodTypeIndex;
        this.myTypeVariableIndex = typeVariableIndex;
        this.myPointer = pointer;
    }

    @NotNull
    public Pointer<RbsMethodTypeVariableSymbol> createPointer() {
        if (this.myPointer != null) {
            Pointer<RbsMethodTypeVariableSymbol> pointer2 = this.myPointer;
            if (pointer2 == null) {
                RbsMethodTypeVariableSymbol.$$$reportNull$$$0(2);
            }
            return pointer2;
        }
        int methodTypeIndex = this.myMethodTypeIndex;
        int typeVariableIndex = this.myTypeVariableIndex;
        Pointer pointer3 = Pointer.uroborosPointer((Pointer)SmartPointerManager.createPointer((PsiElement)this.myElement), (element, pointer) -> new RbsMethodTypeVariableSymbol((RbsMethodMember)element, methodTypeIndex, typeVariableIndex, (Pointer<RbsMethodTypeVariableSymbol>)pointer));
        if (pointer3 == null) {
            RbsMethodTypeVariableSymbol.$$$reportNull$$$0(3);
        }
        return pointer3;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RbsMethodTypeVariableSymbol other = (RbsMethodTypeVariableSymbol)obj;
        return this.myElement.equals((Object)other.myElement) && this.myMethodTypeIndex == other.myMethodTypeIndex && this.myTypeVariableIndex == other.myTypeVariableIndex;
    }

    @Override
    @Nullable
    public RbsTypeSignature getDefaultType() {
        return null;
    }

    @NotNull
    public RbsMethodDeclarationElement getElement() {
        RbsMethodMember rbsMethodMember = this.myElement;
        if (rbsMethodMember == null) {
            RbsMethodTypeVariableSymbol.$$$reportNull$$$0(4);
        }
        return rbsMethodMember;
    }

    @Nullable
    public RbsSymbol getMethodSymbol() {
        return (RbsSymbol)ContainerUtil.find((Iterable)ExtensionsKt.getSymbols((PsiElement)this.myElement, RbsSymbol.class), it -> it instanceof RbsMethodSymbol || it instanceof RbsModuleMethodSymbol);
    }

    public int getMethodTypeIndex() {
        return this.myMethodTypeIndex;
    }

    @Override
    @NlsSafe
    @NotNull
    public String getName() {
        String string = ((RbsMethodTypeParameter)((RbsMethodTypeSignature)this.myElement.getMethodTypeSignatures().get(this.myMethodTypeIndex)).getTypeParameters().get(this.myTypeVariableIndex)).name();
        if (string == null) {
            RbsMethodTypeVariableSymbol.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
        if (project == null) {
            RbsMethodTypeVariableSymbol.$$$reportNull$$$0(6);
        }
        GlobalSearchScope maximalSearchScope = GlobalSearchScope.allScope((Project)project);
        List<NavigationTarget> list = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)maximalSearchScope, this).stream().map(NavigatablePsiSymbolDeclaration::getNavigationTarget).sorted().toList();
        if (list == null) {
            RbsMethodTypeVariableSymbol.$$$reportNull$$$0(7);
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        String name = this.getName();
        @Nls Supplier shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.type.variable.shortDescription", (Object[])new Object[]{name});
        RbsSymbol rbsSymbol = this.getMethodSymbol();
        if (!(rbsSymbol instanceof PresentableSymbol)) {
            return new SymbolPresentation(RbsIcons.RBS_TYPE_VARIABLE_ICON, name, shortDescriptionSupplier);
        }
        PresentableSymbol methodSymbol = (PresentableSymbol)rbsSymbol;
        Supplier<@Nls String> longDescriptionSupplier = () -> {
            String methodDescription = TextUtil.decapitalize((String)methodSymbol.getPresentation().shortDescription());
            return RbsBundle.message((String)"rbs.model.type.variable.longDescription", (Object[])new Object[]{name, methodDescription});
        };
        return new SymbolPresentation(RbsIcons.RBS_TYPE_VARIABLE_ICON, name, shortDescriptionSupplier, longDescriptionSupplier);
    }

    public int getTypeVariableIndex() {
        return this.myTypeVariableIndex;
    }

    @Override
    @Nullable
    public RbsTypeSignature getUpperBound() {
        return Objects.requireNonNull((RbsMethodTypeParameter)((RbsMethodType)this.myElement.getMethodTypeList().get(this.myMethodTypeIndex)).getTypeParameters().get(this.myTypeVariableIndex)).upperBound();
    }

    @Override
    @NotNull
    public RbsVariance getVariance() {
        RbsVariance rbsVariance = RbsVariance.INVARIANT;
        if (rbsVariance == null) {
            RbsMethodTypeVariableSymbol.$$$reportNull$$$0(8);
        }
        return rbsVariance;
    }

    public int hashCode() {
        int result = this.myElement.hashCode();
        result = 31 * result + this.myMethodTypeIndex;
        result = 31 * result + this.myTypeVariableIndex;
        return result;
    }

    @Override
    public boolean isUnchecked() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/impl/RbsMethodTypeVariableSymbol";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/impl/RbsMethodTypeVariableSymbol";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationTargets";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

