/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsSyntacticSugarSymbol;
import com.intellij.lang.ruby.rbs.model.cache.RbsSymbolsCache;
import com.intellij.lang.ruby.rbs.model.impl.RbsAttributeSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsSingletonSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.model.psi.declaration.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.psi.index.RbsMethodDeclarationNameIndex;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.RbsIcons;
import com.intellij.ruby.rbs.common.psi.api.RbsAliasDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsMethodDeclarationElement;
import com.intellij.ruby.rbs.common.psi.data.RbsDeclarationType;
import com.intellij.ruby.rbs.common.psi.data.RbsMethodTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsVisibility;
import com.intellij.ruby.rbs.common.psi.stub.RbsStubBasedPsiElement;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.model.psi.declaration.NavigatablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;

public final class RbsMethodSymbol
implements RbsSymbol,
NavigatableSymbol,
PresentableSymbol {
    private final RbsVisibility myVisibility;
    private final RbsDeclarationType myDeclarationType;
    private final RbsContainerSymbol myContainer;
    @NlsSafe
    private final String myName;
    @Nullable
    private final RbsSyntacticSugarSymbol myOriginalDeclaration;

    public RbsMethodSymbol(@NotNull RbsVisibility visibility, @NotNull RbsDeclarationType declarationType, @NotNull RbsContainerSymbol container, @NlsSafe @NotNull String name) {
        if (visibility == null) {
            RbsMethodSymbol.$$$reportNull$$$0(0);
        }
        if (declarationType == null) {
            RbsMethodSymbol.$$$reportNull$$$0(1);
        }
        if (container == null) {
            RbsMethodSymbol.$$$reportNull$$$0(2);
        }
        if (name == null) {
            RbsMethodSymbol.$$$reportNull$$$0(3);
        }
        this(visibility, declarationType, container, name, null);
    }

    public RbsMethodSymbol(@NotNull RbsVisibility visibility, @NotNull RbsDeclarationType declarationType, @NotNull RbsContainerSymbol container, @NlsSafe @NotNull String name, @Nullable RbsSyntacticSugarSymbol originalDeclaration) {
        if (visibility == null) {
            RbsMethodSymbol.$$$reportNull$$$0(4);
        }
        if (declarationType == null) {
            RbsMethodSymbol.$$$reportNull$$$0(5);
        }
        if (container == null) {
            RbsMethodSymbol.$$$reportNull$$$0(6);
        }
        if (name == null) {
            RbsMethodSymbol.$$$reportNull$$$0(7);
        }
        this.myVisibility = visibility;
        this.myDeclarationType = declarationType;
        this.myContainer = container;
        this.myName = name;
        this.myOriginalDeclaration = originalDeclaration;
    }

    @NotNull
    public Pointer<RbsMethodSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RbsMethodSymbol.$$$reportNull$$$0(8);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RbsMethodSymbol other = (RbsMethodSymbol)obj;
        return this.myDeclarationType == other.myDeclarationType && this.myContainer.equals(other.myContainer) && this.myName.equals(other.myName);
    }

    @NotNull
    public Fqn getContainerFqn() {
        Fqn fqn = this.myContainer.getFqn();
        if (fqn == null) {
            RbsMethodSymbol.$$$reportNull$$$0(9);
        }
        return fqn;
    }

    @NotNull
    public RbsContainerSymbol getContainerSymbol() {
        RbsContainerSymbol rbsContainerSymbol = this.myContainer;
        if (rbsContainerSymbol == null) {
            RbsMethodSymbol.$$$reportNull$$$0(10);
        }
        return rbsContainerSymbol;
    }

    @NotNull
    public RbsDeclarationType getDeclarationType() {
        RbsDeclarationType rbsDeclarationType = this.myDeclarationType;
        if (rbsDeclarationType == null) {
            RbsMethodSymbol.$$$reportNull$$$0(11);
        }
        return rbsDeclarationType;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RbsMethodSymbol.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
        if (project == null) {
            RbsMethodSymbol.$$$reportNull$$$0(13);
        }
        GlobalSearchScope maximalSearchScope = GlobalSearchScope.allScope((Project)project);
        List<NavigationTarget> list = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)maximalSearchScope, this).stream().map(NavigatablePsiSymbolDeclaration::getNavigationTarget).sorted().toList();
        if (list == null) {
            RbsMethodSymbol.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    public RbsSyntacticSugarSymbol getOriginalDeclaration() {
        return this.myOriginalDeclaration;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        @Nls Supplier shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.method.shortDescription", (Object[])new Object[]{this.myName});
        Supplier<@Nls String> longDescriptionSupplier = () -> {
            @Nls String containerDescription = TextUtil.decapitalize((String)this.myContainer.getPresentation().longDescription());
            return RbsBundle.message((String)"rbs.model.method.longDescription", (Object[])new Object[]{this.myName, containerDescription});
        };
        if (this.myVisibility == RbsVisibility.PUBLIC_VISIBILITY) {
            return new SymbolPresentation(RbsIcons.RBS_PUBLIC_METHOD_ICON, this.myName, shortDescriptionSupplier, longDescriptionSupplier);
        }
        String prefix = RbsBundle.message((String)"rbs.model.descriptions.private.prefix", (Object[])new Object[0]) + " ";
        return new SymbolPresentation(RbsIcons.RBS_PRIVATE_METHOD_ICON, this.myName, () -> RbsMethodSymbol.lambda$getPresentation$1(prefix, (Supplier)shortDescriptionSupplier), () -> prefix + TextUtil.decapitalize((String)((String)longDescriptionSupplier.get())));
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public List<RbsMethodTypeSignature> getMethodTypeSignatures(@NotNull Project project, @NotNull SearchScope searchScope) {
        Cache<Symbol, List<RbsMethodTypeSignature>> cache;
        List cachedTypeSignatures;
        if (project == null) {
            RbsMethodSymbol.$$$reportNull$$$0(15);
        }
        if (searchScope == null) {
            RbsMethodSymbol.$$$reportNull$$$0(16);
        }
        if ((cachedTypeSignatures = (List)(cache = RbsSymbolsCache.getInstance(project, searchScope).getMethodTypeSignatures()).getIfPresent((Object)this)) != null) {
            List list = cachedTypeSignatures;
            if (list == null) {
                RbsMethodSymbol.$$$reportNull$$$0(17);
            }
            return list;
        }
        List<RbsMethodTypeSignature> typeSignatures = this.getMethodTypeSignaturesImpl(project, searchScope);
        cache.put((Object)this, typeSignatures);
        List<RbsMethodTypeSignature> list = typeSignatures;
        if (list == null) {
            RbsMethodSymbol.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public RbsVisibility getVisibility() {
        RbsVisibility rbsVisibility = this.myVisibility;
        if (rbsVisibility == null) {
            RbsMethodSymbol.$$$reportNull$$$0(19);
        }
        return rbsVisibility;
    }

    public int hashCode() {
        int result = this.myDeclarationType.hashCode();
        result = 31 * result + this.myContainer.hashCode();
        result = 31 * result + this.myName.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        String string = String.format("RbsMethodSymbol{myVisibility=%s, myDeclarationType=%s, myContainer=%s, myName='%s', myOriginalDeclaration=%s}", this.myVisibility, this.myDeclarationType, this.myContainer, this.myName, this.myOriginalDeclaration);
        if (string == null) {
            RbsMethodSymbol.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private List<RbsMethodTypeSignature> getMethodTypeSignaturesImpl(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsMethodSymbol.$$$reportNull$$$0(21);
        }
        if (searchScope == null) {
            RbsMethodSymbol.$$$reportNull$$$0(22);
        }
        return this.getMethodTypeSignaturesImpl(project, searchScope, new HashSet<Symbol>());
    }

    @NotNull
    private List<RbsMethodTypeSignature> getMethodTypeSignaturesImpl(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Set<Symbol> visited) {
        if (project == null) {
            RbsMethodSymbol.$$$reportNull$$$0(23);
        }
        if (searchScope == null) {
            RbsMethodSymbol.$$$reportNull$$$0(24);
        }
        if (visited == null) {
            RbsMethodSymbol.$$$reportNull$$$0(25);
        }
        if (!visited.add(this)) {
            List<RbsMethodTypeSignature> list = Collections.emptyList();
            if (list == null) {
                RbsMethodSymbol.$$$reportNull$$$0(26);
            }
            return list;
        }
        LinkedHashSet<RbsMethodTypeSignature> typeSignatures = new LinkedHashSet<RbsMethodTypeSignature>();
        RbsMethodDeclarationNameIndex.getInstance().processElements(project, searchScope, this.myDeclarationType, this.getContainerFqn(), this.myName, (Processor<? super RbsStubBasedPsiElement>)((Processor)element -> {
            ProgressManager.checkCanceled();
            if (element instanceof RbsMethodDeclarationElement) {
                RbsMethodDeclarationElement methodDeclaration = (RbsMethodDeclarationElement)element;
                typeSignatures.addAll(methodDeclaration.getMethodTypeSignatures());
            } else if (element instanceof RbsAliasDeclarationElement) {
                RbsAliasDeclarationElement aliasDeclaration = (RbsAliasDeclarationElement)element;
                Optional.ofNullable(aliasDeclaration.getTargetMethodName()).map(name -> {
                    if (aliasDeclaration.getDeclarationType() == RbsDeclarationType.SINGLETON_DECLARATION) {
                        return RbsResolveUtil.resolveMethodName(project, searchScope, new RbsSingletonSymbol(this.myContainer), name);
                    }
                    return RbsResolveUtil.resolveMethodName(project, searchScope, this.myContainer, name);
                }).map(target -> target.getMethodTypeSignaturesImpl(project, searchScope, visited)).ifPresent(typeSignatures::addAll);
            }
            return true;
        }));
        RbsSyntacticSugarSymbol rbsSyntacticSugarSymbol = this.myOriginalDeclaration;
        if (rbsSyntacticSugarSymbol instanceof RbsAttributeSymbol) {
            RbsAttributeSymbol attribute = (RbsAttributeSymbol)rbsSyntacticSugarSymbol;
            RbsTypeSignature attributeTypeSignature = attribute.getTypeSignature(project, searchScope);
            if (!this.myName.endsWith("=")) {
                typeSignatures.add(RbsMethodTypeSignature.forAttributeReader((RbsTypeSignature)attributeTypeSignature));
            } else {
                typeSignatures.add(RbsMethodTypeSignature.forAttributeWriter((RbsTypeSignature)attributeTypeSignature));
            }
        }
        List<RbsMethodTypeSignature> list = List.copyOf(typeSignatures);
        if (list == null) {
            RbsMethodSymbol.$$$reportNull$$$0(27);
        }
        return list;
    }

    private static /* synthetic */ String lambda$getPresentation$1(String prefix, Supplier shortDescriptionSupplier) {
        return prefix + TextUtil.decapitalize((String)((String)shortDescriptionSupplier.get()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 14, 17, 18, 19, 20, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationType";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/impl/RbsMethodSymbol";
                break;
            }
            case 13: 
            case 15: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/impl/RbsMethodSymbol";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerFqn";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerSymbol";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationTargets";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodTypeSignatures";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodTypeSignaturesImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 26: 
            case 27: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargets";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getMethodTypeSignatures";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMethodTypeSignaturesImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 14, 17, 18, 19, 20, 26, 27 -> new IllegalStateException(string);
        };
    }
}

