/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.cache.RbsSymbolsCache;
import com.intellij.lang.ruby.rbs.model.psi.declaration.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.psi.index.RbsConstantDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsDeclarationFqnIndex;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.RbsIcons;
import com.intellij.ruby.rbs.common.psi.api.RbsConstantDeclaration;
import com.intellij.ruby.rbs.common.psi.data.RbsKeywordTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsUnionTypeSignature;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.model.psi.declaration.NavigatablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.utils.SmartCancellationChecker;

public final class RbsConstantSymbol
implements RbsQualifiedNameSymbol,
NavigatableSymbol {
    private final Fqn myFqn;

    public RbsConstantSymbol(@NotNull Fqn fqn) {
        if (fqn == null) {
            RbsConstantSymbol.$$$reportNull$$$0(0);
        }
        this.myFqn = fqn.normalize();
    }

    @NotNull
    public Pointer<RbsConstantSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RbsConstantSymbol.$$$reportNull$$$0(1);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myFqn.isEquivalentTo(((RbsConstantSymbol)obj).myFqn);
    }

    @Override
    @NotNull
    public Fqn getFqn() {
        Fqn fqn = this.myFqn;
        if (fqn == null) {
            RbsConstantSymbol.$$$reportNull$$$0(2);
        }
        return fqn;
    }

    @NotNull
    public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
        if (project == null) {
            RbsConstantSymbol.$$$reportNull$$$0(3);
        }
        GlobalSearchScope maximalSearchScope = GlobalSearchScope.allScope((Project)project);
        List<NavigationTarget> list = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)maximalSearchScope, this).stream().map(NavigatablePsiSymbolDeclaration::getNavigationTarget).sorted().toList();
        if (list == null) {
            RbsConstantSymbol.$$$reportNull$$$0(4);
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        String name = this.getName();
        @Nls Supplier shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.constant.shortDescription", (Object[])new Object[]{name});
        Fqn fqn = this.myFqn.split();
        if (fqn.getParent() == Fqn.INVALID) {
            return new SymbolPresentation(RbsIcons.RBS_CONSTANT_ICON, name, shortDescriptionSupplier);
        }
        @Nls Supplier longDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.constant.longDescription", (Object[])new Object[]{name, fqn.getParent().join()});
        return new SymbolPresentation(RbsIcons.RBS_CONSTANT_ICON, name, shortDescriptionSupplier, longDescriptionSupplier);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public RbsTypeSignature getTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsConstantSymbol.$$$reportNull$$$0(5);
        }
        if (searchScope == null) {
            RbsConstantSymbol.$$$reportNull$$$0(6);
        }
        RbsTypeSignature rbsTypeSignature = (RbsTypeSignature)RbsSymbolsCache.getInstance(project, searchScope).getTypeSignatures().get((Object)this, __ -> this.getTypeSignatureImpl(project, searchScope));
        if (rbsTypeSignature == null) {
            RbsConstantSymbol.$$$reportNull$$$0(7);
        }
        return rbsTypeSignature;
    }

    public int hashCode() {
        return this.myFqn.hashCode();
    }

    @NotNull
    public String toString() {
        String string = String.format("RbsConstantSymbol{myFqn=%s}", this.myFqn);
        if (string == null) {
            RbsConstantSymbol.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private RbsTypeSignature getTypeSignatureImpl(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsConstantSymbol.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            RbsConstantSymbol.$$$reportNull$$$0(10);
        }
        Collection elements = RbsConstantDeclarationFqnIndex.getInstance().getElements(project, searchScope, this.myFqn);
        RbsTypeSignature rbsTypeSignature = (RbsTypeSignature)RbsUnionTypeSignature.of((Collection)ContainerUtil.mapNotNull(elements, RbsConstantDeclaration::getTypeSignature)).orElse(RbsKeywordTypeSignature.UNTYPED);
        if (rbsTypeSignature == null) {
            RbsConstantSymbol.$$$reportNull$$$0(11);
        }
        return rbsTypeSignature;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Optional<RbsConstantSymbol> find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Fqn fqn) {
        if (project == null) {
            RbsConstantSymbol.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            RbsConstantSymbol.$$$reportNull$$$0(13);
        }
        if (fqn == null) {
            RbsConstantSymbol.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (fqn == Fqn.INVALID) {
            Optional<RbsConstantSymbol> optional = Optional.empty();
            if (optional == null) {
                RbsConstantSymbol.$$$reportNull$$$0(15);
            }
            return optional;
        }
        Cache<@NotNull RbsDeclarationFqnIndex.Type, @NotNull SequencedSet<Fqn>> cache = RbsSymbolsCache.getInstance(project, searchScope).getDeclarationFqns();
        boolean isConstantFqn = ((SequencedSet)cache.get((Object)RbsDeclarationFqnIndex.Type.CONSTANT, type -> RbsDeclarationFqnIndex.getAllValues(project, searchScope, RbsDeclarationFqnIndex.Type.CONSTANT))).contains(fqn.normalize());
        Optional<RbsConstantSymbol> optional = isConstantFqn ? Optional.of(new RbsConstantSymbol(fqn)) : Optional.empty();
        if (optional == null) {
            RbsConstantSymbol.$$$reportNull$$$0(16);
        }
        return optional;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Stream<RbsConstantSymbol> stream(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsConstantSymbol.$$$reportNull$$$0(17);
        }
        if (searchScope == null) {
            RbsConstantSymbol.$$$reportNull$$$0(18);
        }
        ThreadingAssertions.softAssertReadAccess();
        SmartCancellationChecker checker = new SmartCancellationChecker(1000);
        Stream<RbsConstantSymbol> stream = ((SequencedSet)RbsSymbolsCache.getInstance(project, searchScope).getDeclarationFqns().get((Object)RbsDeclarationFqnIndex.Type.CONSTANT, type -> RbsDeclarationFqnIndex.getAllValues(project, searchScope, type))).stream().map(RbsConstantSymbol::new).peek(__ -> checker.checkCancelled());
        if (stream == null) {
            RbsConstantSymbol.$$$reportNull$$$0(19);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 7, 8, 11, 15, 16, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/impl/RbsConstantSymbol";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/impl/RbsConstantSymbol";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationTargets";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignature";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignatureImpl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargets";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSignature";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSignatureImpl";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "stream";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 7, 8, 11, 15, 16, 19 -> new IllegalStateException(string);
        };
    }
}

