/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.impl;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerVariableSymbol;
import com.intellij.lang.ruby.rbs.model.cache.RbsSymbolsCache;
import com.intellij.lang.ruby.rbs.model.psi.declaration.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.psi.index.RbsClassVariableDeclarationNameIndex;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.RbsIcons;
import com.intellij.ruby.rbs.common.psi.api.RbsVariableDeclaration;
import com.intellij.ruby.rbs.common.psi.data.RbsKeywordTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsUnionTypeSignature;
import com.intellij.ruby.rbs.common.psi.mixin.RbsVariableDeclarationMixin;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.model.psi.declaration.NavigatablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;

public final class RbsClassVariableSymbol
implements RbsContainerVariableSymbol,
NavigatableSymbol,
PresentableSymbol {
    private final RbsContainerSymbol myContainer;
    @NlsSafe
    private final String myName;

    public RbsClassVariableSymbol(@NotNull RbsContainerSymbol container, @NlsSafe @NotNull String name) {
        if (container == null) {
            RbsClassVariableSymbol.$$$reportNull$$$0(0);
        }
        if (name == null) {
            RbsClassVariableSymbol.$$$reportNull$$$0(1);
        }
        this.myContainer = container;
        this.myName = name;
    }

    @NotNull
    public Pointer<RbsClassVariableSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RbsClassVariableSymbol.$$$reportNull$$$0(2);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RbsClassVariableSymbol other = (RbsClassVariableSymbol)obj;
        return this.myContainer.equals(other.myContainer) && this.myName.equals(other.myName);
    }

    @Override
    @NotNull
    public RbsContainerSymbol getContainerSymbol() {
        RbsContainerSymbol rbsContainerSymbol = this.myContainer;
        if (rbsContainerSymbol == null) {
            RbsClassVariableSymbol.$$$reportNull$$$0(3);
        }
        return rbsContainerSymbol;
    }

    @Override
    @NlsSafe
    @NotNull
    public String getFullName() {
        String string = "@@" + this.myName;
        if (string == null) {
            RbsClassVariableSymbol.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RbsClassVariableSymbol.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
        if (project == null) {
            RbsClassVariableSymbol.$$$reportNull$$$0(6);
        }
        GlobalSearchScope maximalSearchScope = GlobalSearchScope.allScope((Project)project);
        List<NavigationTarget> list = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)maximalSearchScope, this).stream().map(NavigatablePsiSymbolDeclaration::getNavigationTarget).sorted().toList();
        if (list == null) {
            RbsClassVariableSymbol.$$$reportNull$$$0(7);
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        @Nls Supplier shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.class.variable.shortDescription", (Object[])new Object[]{this.myName});
        Supplier<@Nls String> longDescriptionSupplier = () -> {
            @Nls String containerDescription = TextUtil.decapitalize((String)this.myContainer.getPresentation().longDescription());
            return RbsBundle.message((String)"rbs.model.class.variable.longDescription", (Object[])new Object[]{this.myName, containerDescription});
        };
        return new SymbolPresentation(RbsIcons.RBS_CLASS_VARIABLE_ICON, this.myName, shortDescriptionSupplier, longDescriptionSupplier);
    }

    @Override
    @NotNull
    public RbsTypeSignature getTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsClassVariableSymbol.$$$reportNull$$$0(8);
        }
        if (searchScope == null) {
            RbsClassVariableSymbol.$$$reportNull$$$0(9);
        }
        RbsTypeSignature rbsTypeSignature = (RbsTypeSignature)RbsSymbolsCache.getInstance(project, searchScope).getTypeSignatures().get((Object)this, __ -> this.getTypeSignatureImpl(project, searchScope));
        if (rbsTypeSignature == null) {
            RbsClassVariableSymbol.$$$reportNull$$$0(10);
        }
        return rbsTypeSignature;
    }

    public int hashCode() {
        return 31 * this.myContainer.hashCode() + this.myName.hashCode();
    }

    @NotNull
    public String toString() {
        String string = String.format("RbsClassVariableSymbol{myContainer=%s, myName='%s'}", this.myContainer, this.myName);
        if (string == null) {
            RbsClassVariableSymbol.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private RbsTypeSignature getTypeSignatureImpl(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsClassVariableSymbol.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            RbsClassVariableSymbol.$$$reportNull$$$0(13);
        }
        Collection<RbsVariableDeclarationMixin> elements = RbsClassVariableDeclarationNameIndex.getInstance().getElements(project, searchScope, this.getContainerFqn(), this.myName);
        RbsTypeSignature rbsTypeSignature = (RbsTypeSignature)RbsUnionTypeSignature.of((Collection)ContainerUtil.mapNotNull(elements, RbsVariableDeclaration::getTypeSignature)).orElse(RbsKeywordTypeSignature.UNTYPED);
        if (rbsTypeSignature == null) {
            RbsClassVariableSymbol.$$$reportNull$$$0(14);
        }
        return rbsTypeSignature;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7, 10, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/impl/RbsClassVariableSymbol";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/impl/RbsClassVariableSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerSymbol";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationTargets";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignature";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSignatureImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargets";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSignature";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSignatureImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7, 10, 11, 14 -> new IllegalStateException(string);
        };
    }
}

