/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.cache.RbsSymbolsCache;
import com.intellij.lang.ruby.rbs.model.hierarchy.RbsContainerSymbolUtil;
import com.intellij.lang.ruby.rbs.model.impl.RbsSingletonSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.model.psi.declaration.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.psi.index.RbsClassDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.util.RbsFqns;
import com.intellij.lang.ruby.rbs.util.RbsSymbols;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.RbsIcons;
import com.intellij.ruby.rbs.common.psi.api.RbsClassDeclarationElement;
import com.intellij.ruby.rbs.common.psi.mixin.RbsClassAliasDeclarationMixin;
import com.intellij.ruby.rbs.common.psi.stub.RbsStubBasedPsiElement;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.model.psi.declaration.NavigatablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.util.StreamUtil;
import org.jetbrains.plugins.ruby.utils.SmartCancellationChecker;

public final class RbsClassSymbol
implements RbsContainerSymbol,
NavigatableSymbol {
    private final Fqn myFqn;

    public RbsClassSymbol(@NotNull Fqn fqn) {
        if (fqn == null) {
            RbsClassSymbol.$$$reportNull$$$0(0);
        }
        this.myFqn = fqn.normalize();
    }

    @NotNull
    public Stream<RbsClassSymbol> allSuperclasses(@NotNull Project project, @NotNull SearchScope searchScope) {
        RbsClassSymbol seed;
        if (project == null) {
            RbsClassSymbol.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            RbsClassSymbol.$$$reportNull$$$0(2);
        }
        if ((seed = this.getSuperclassSymbol(project, searchScope)) == null) {
            Stream<RbsClassSymbol> stream = Stream.empty();
            if (stream == null) {
                RbsClassSymbol.$$$reportNull$$$0(3);
            }
            return stream;
        }
        HashSet<RbsClassSymbol> visited = new HashSet<RbsClassSymbol>(List.of(this, seed));
        Stream<RbsClassSymbol> stream = Stream.iterate(seed, it -> {
            RbsClassSymbol superclass = it.getSuperclassSymbol(project, searchScope);
            return superclass != null && visited.add(superclass);
        }, it -> it.getSuperclassSymbol(project, searchScope));
        if (stream == null) {
            RbsClassSymbol.$$$reportNull$$$0(4);
        }
        return stream;
    }

    @NotNull
    public Pointer<RbsClassSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        if (pointer == null) {
            RbsClassSymbol.$$$reportNull$$$0(5);
        }
        return pointer;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myFqn.isEquivalentTo(((RbsClassSymbol)obj).myFqn);
    }

    @Override
    @NotNull
    public Fqn getFqn() {
        Fqn fqn = this.myFqn;
        if (fqn == null) {
            RbsClassSymbol.$$$reportNull$$$0(6);
        }
        return fqn;
    }

    @NotNull
    public Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project) {
        if (project == null) {
            RbsClassSymbol.$$$reportNull$$$0(7);
        }
        GlobalSearchScope maximalSearchScope = GlobalSearchScope.allScope((Project)project);
        List<NavigationTarget> list = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)maximalSearchScope, this).stream().map(NavigatablePsiSymbolDeclaration::getNavigationTarget).sorted().toList();
        if (list == null) {
            RbsClassSymbol.$$$reportNull$$$0(8);
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public SymbolPresentation getPresentation() {
        String name = this.getName();
        @Nls Supplier shortDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.class.shortDescription", (Object[])new Object[]{name});
        Fqn fqn = this.myFqn.split();
        if (fqn.getParent() == Fqn.INVALID) {
            return new SymbolPresentation(RbsIcons.RBS_CLASS_ICON, name, shortDescriptionSupplier);
        }
        @Nls Supplier longDescriptionSupplier = RbsBundle.messagePointer((String)"rbs.model.class.longDescription", (Object[])new Object[]{name, fqn.getParent().join()});
        return new SymbolPresentation(RbsIcons.RBS_CLASS_ICON, name, shortDescriptionSupplier, longDescriptionSupplier);
    }

    @NotNull
    public RbsSingletonSymbol getSingletonSymbol() {
        return new RbsSingletonSymbol(this);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public RbsClassSymbol getSuperclassSymbol(@NotNull Project project, @NotNull SearchScope searchScope) {
        Cache<Symbol, List<RbsContainerSymbol>> cache;
        List cachedSuperclasses;
        if (project == null) {
            RbsClassSymbol.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            RbsClassSymbol.$$$reportNull$$$0(10);
        }
        if ((cachedSuperclasses = (List)(cache = RbsSymbolsCache.getInstance(project, searchScope).getSuperclasses()).getIfPresent((Object)this)) != null) {
            return (RbsClassSymbol)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem((Collection)cachedSuperclasses), RbsClassSymbol.class);
        }
        List<RbsContainerSymbol> superclasses = this.getSuperclassSymbols(project, searchScope, new HashSet<RbsClassSymbol>());
        cache.put((Object)this, superclasses);
        return (RbsClassSymbol)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem(superclasses), RbsClassSymbol.class);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public RbsClassSymbol getTargetClassSymbol(@NotNull Project project, @NotNull SearchScope searchScope) {
        Cache<RbsClassSymbol, List<RbsClassSymbol>> cache;
        List cachedTargetClasses;
        if (project == null) {
            RbsClassSymbol.$$$reportNull$$$0(11);
        }
        if (searchScope == null) {
            RbsClassSymbol.$$$reportNull$$$0(12);
        }
        if ((cachedTargetClasses = (List)(cache = RbsSymbolsCache.getInstance(project, searchScope).getTargetClasses()).getIfPresent((Object)this)) != null) {
            return (RbsClassSymbol)ContainerUtil.getOnlyItem((Collection)cachedTargetClasses);
        }
        List<RbsClassSymbol> targetClasses = this.getTargetClassSymbols(project, searchScope, new HashSet<RbsClassSymbol>());
        cache.put((Object)this, targetClasses);
        return (RbsClassSymbol)ContainerUtil.getOnlyItem(targetClasses);
    }

    public int hashCode() {
        return this.myFqn.hashCode();
    }

    @NotNull
    public String toString() {
        String string = String.format("RbsClassSymbol{myFqn=%s}", this.myFqn);
        if (string == null) {
            RbsClassSymbol.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private List<RbsContainerSymbol> getSuperclassSymbols(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Set<RbsClassSymbol> visited) {
        if (project == null) {
            RbsClassSymbol.$$$reportNull$$$0(14);
        }
        if (searchScope == null) {
            RbsClassSymbol.$$$reportNull$$$0(15);
        }
        if (visited == null) {
            RbsClassSymbol.$$$reportNull$$$0(16);
        }
        if (this.myFqn.isEquivalentTo(RbsFqns.OBJECT_FQN)) {
            List<RbsContainerSymbol> list = List.of(RbsSymbols.BASIC_OBJECT_SYMBOL);
            if (list == null) {
                RbsClassSymbol.$$$reportNull$$$0(17);
            }
            return list;
        }
        if (this.myFqn.isEquivalentTo(RbsFqns.BASIC_OBJECT_FQN)) {
            List<RbsContainerSymbol> list = Collections.emptyList();
            if (list == null) {
                RbsClassSymbol.$$$reportNull$$$0(18);
            }
            return list;
        }
        if (!visited.add(this)) {
            List<RbsContainerSymbol> list = Collections.emptyList();
            if (list == null) {
                RbsClassSymbol.$$$reportNull$$$0(19);
            }
            return list;
        }
        RbsClassSymbol targetClass = this.getTargetClassSymbol(project, searchScope);
        if (targetClass != null) {
            return targetClass.getSuperclassSymbols(project, searchScope, visited);
        }
        SmartHashSet superclasses = new SmartHashSet();
        RbsClassDeclarationFqnIndex.getInstance().processElements(project, searchScope, this.myFqn, arg_0 -> RbsClassSymbol.lambda$getSuperclassSymbols$2(project, (Set)superclasses, arg_0));
        if (superclasses.size() == 1) {
            List<RbsContainerSymbol> list = List.copyOf(superclasses);
            if (list == null) {
                RbsClassSymbol.$$$reportNull$$$0(20);
            }
            return list;
        }
        List<RbsContainerSymbol> list = List.of(RbsSymbols.OBJECT_SYMBOL);
        if (list == null) {
            RbsClassSymbol.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    private List<RbsClassSymbol> getTargetClassSymbols(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Set<RbsClassSymbol> visited) {
        if (project == null) {
            RbsClassSymbol.$$$reportNull$$$0(22);
        }
        if (searchScope == null) {
            RbsClassSymbol.$$$reportNull$$$0(23);
        }
        if (visited == null) {
            RbsClassSymbol.$$$reportNull$$$0(24);
        }
        if (!visited.add(this)) {
            List<RbsClassSymbol> list = Collections.emptyList();
            if (list == null) {
                RbsClassSymbol.$$$reportNull$$$0(25);
            }
            return list;
        }
        LinkedHashSet classDeclarations = new LinkedHashSet();
        RbsClassDeclarationFqnIndex.getInstance().processElements(project, searchScope, this.myFqn, element -> {
            ProgressManager.checkCanceled();
            if (element instanceof RbsClassDeclarationElement) {
                classDeclarations.clear();
                return false;
            }
            if (element instanceof RbsClassAliasDeclarationMixin) {
                RbsClassAliasDeclarationMixin classAlias = (RbsClassAliasDeclarationMixin)element;
                String targetClassName = classAlias.getTargetClassName();
                if (targetClassName == null) {
                    return true;
                }
                RbsResolveUtil.resolveQualifiedName(project, searchScope, classAlias.getContainerFqn(), targetClassName, Collections.emptySet(), (PsiElement)classAlias).stream().mapMulti(StreamUtil.select(RbsClassSymbol.class, (Class[])new Class[0])).forEach(symbol -> {
                    List<RbsClassSymbol> targets = symbol.getTargetClassSymbols(project, searchScope, visited);
                    if (targets.isEmpty()) {
                        classDeclarations.add(symbol);
                    } else {
                        classDeclarations.addAll(targets);
                    }
                });
            }
            return true;
        });
        List<RbsClassSymbol> list = List.copyOf(classDeclarations);
        if (list == null) {
            RbsClassSymbol.$$$reportNull$$$0(26);
        }
        return list;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Optional<RbsClassSymbol> find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Fqn fqn) {
        if (project == null) {
            RbsClassSymbol.$$$reportNull$$$0(27);
        }
        if (searchScope == null) {
            RbsClassSymbol.$$$reportNull$$$0(28);
        }
        if (fqn == null) {
            RbsClassSymbol.$$$reportNull$$$0(29);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (fqn == Fqn.INVALID) {
            Optional<RbsClassSymbol> optional = Optional.empty();
            if (optional == null) {
                RbsClassSymbol.$$$reportNull$$$0(30);
            }
            return optional;
        }
        Cache<@NotNull RbsDeclarationFqnIndex.Type, @NotNull SequencedSet<Fqn>> cache = RbsSymbolsCache.getInstance(project, searchScope).getDeclarationFqns();
        SequencedSet classFqns = (SequencedSet)cache.get((Object)RbsDeclarationFqnIndex.Type.CLASS, it -> RbsDeclarationFqnIndex.getAllValues(project, searchScope, it));
        if (classFqns.contains(fqn.normalize())) {
            Optional<RbsClassSymbol> optional = Optional.of(new RbsClassSymbol(fqn));
            if (optional == null) {
                RbsClassSymbol.$$$reportNull$$$0(31);
            }
            return optional;
        }
        SequencedSet classAliasFqns = (SequencedSet)cache.get((Object)RbsDeclarationFqnIndex.Type.CLASS_ALIAS, it -> RbsDeclarationFqnIndex.getAllValues(project, searchScope, it));
        if (classAliasFqns.contains(fqn.normalize())) {
            Optional<RbsClassSymbol> optional = Optional.of(new RbsClassSymbol(fqn));
            if (optional == null) {
                RbsClassSymbol.$$$reportNull$$$0(32);
            }
            return optional;
        }
        Optional<RbsClassSymbol> optional = Optional.empty();
        if (optional == null) {
            RbsClassSymbol.$$$reportNull$$$0(33);
        }
        return optional;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Stream<RbsClassSymbol> stream(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsClassSymbol.$$$reportNull$$$0(34);
        }
        if (searchScope == null) {
            RbsClassSymbol.$$$reportNull$$$0(35);
        }
        ThreadingAssertions.softAssertReadAccess();
        Cache<@NotNull RbsDeclarationFqnIndex.Type, @NotNull SequencedSet<Fqn>> cache = RbsSymbolsCache.getInstance(project, searchScope).getDeclarationFqns();
        SmartCancellationChecker checker = new SmartCancellationChecker(1000);
        Stream<RbsClassSymbol> stream = Stream.of(RbsDeclarationFqnIndex.Type.CLASS, RbsDeclarationFqnIndex.Type.CLASS_ALIAS).flatMap(it -> ((SequencedSet)cache.get((Object)it, __ -> RbsDeclarationFqnIndex.getAllValues(project, searchScope, it))).stream()).map(RbsClassSymbol::new).peek(__ -> checker.checkCancelled());
        if (stream == null) {
            RbsClassSymbol.$$$reportNull$$$0(36);
        }
        return stream;
    }

    private static /* synthetic */ boolean lambda$getSuperclassSymbols$2(Project project, Set superclasses, RbsStubBasedPsiElement element) {
        ProgressManager.checkCanceled();
        if (element instanceof RbsClassDeclarationElement) {
            RbsClassDeclarationElement classDeclaration = (RbsClassDeclarationElement)element;
            GlobalSearchScope resolveScope = element.getResolveScope();
            Fqn containerFqn = classDeclaration.getFqn().getParent();
            String superclassName = classDeclaration.getSuperclassName();
            if (superclassName == null) {
                return true;
            }
            RbsResolveUtil.resolveQualifiedNameInNesting(project, (SearchScope)resolveScope, containerFqn, superclassName, (PsiElement)element).stream().mapMulti(RbsContainerSymbolUtil.followAliases(project, (SearchScope)resolveScope)).mapMulti(StreamUtil.select(RbsClassSymbol.class, (Class[])new Class[0])).forEach(superclasses::add);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8, 13, 17, 18, 19, 20, 21, 25, 26, 30, 31, 32, 33, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 22: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 10: 
            case 12: 
            case 15: 
            case 23: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/impl/RbsClassSymbol";
                break;
            }
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/impl/RbsClassSymbol";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "allSuperclasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationTargets";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperclassSymbols";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetClassSymbols";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "allSuperclasses";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationTargets";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclassSymbol";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTargetClassSymbol";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclassSymbols";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTargetClassSymbols";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "stream";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8, 13, 17, 18, 19, 20, 21, 25, 26, 30, 31, 32, 33, 36 -> new IllegalStateException(string);
        };
    }
}

