/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.hierarchy;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.hierarchy.RbsContainerHierarchyMapper;
import com.intellij.lang.ruby.rbs.model.hierarchy.RbsContainerSymbolUtil;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsConstantSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsSingletonSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.model.psi.declaration.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureBinding;
import com.intellij.lang.ruby.rbs.psi.index.RbsClassDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsContainerStatementParentFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsDeclarationByParentFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsFqnStubIndexExtension;
import com.intellij.lang.ruby.rbs.psi.index.RbsModuleDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsSingletonStatementParentFqnIndex;
import com.intellij.lang.ruby.rbs.util.RbsSymbols;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.psi.api.RbsClassDeclaration;
import com.intellij.ruby.rbs.common.psi.api.RbsContainerDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsModuleInclusionCall;
import com.intellij.ruby.rbs.common.psi.data.RbsKeywordTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsModuleInclusionCallType;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeVariableReferenceSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsUnionTypeSignature;
import com.intellij.ruby.rbs.common.psi.mixin.RbsClassDeclarationMixin;
import com.intellij.ruby.rbs.common.psi.mixin.RbsModuleDeclarationMixin;
import com.intellij.ruby.rbs.common.psi.mixin.RbsModuleInclusionCallMixin;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.PairProcessor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.SequencedSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;
import org.jetbrains.plugins.ruby.model.psi.declaration.PsiSymbolDeclarationService;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class RbsContainerHierarchyUtil {
    private RbsContainerHierarchyUtil() {
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static List<? extends RbsContainerSymbol> getAncestors(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsContainerSymbol container) {
        if (project == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(1);
        }
        if (container == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.softAssertReadAccess();
        RbsFqnStubIndexExtension index = container instanceof RbsSingletonSymbol ? RbsSingletonStatementParentFqnIndex.getInstance() : RbsContainerStatementParentFqnIndex.getInstance();
        MultiMap moduleInclusionCalls = new MultiMap();
        index.processElements(project, searchScope, container.getFqn(), statement -> {
            ProgressManager.checkCanceled();
            if (!(statement instanceof RbsModuleInclusionCallMixin)) {
                return true;
            }
            RbsModuleInclusionCallMixin inclusionCall = (RbsModuleInclusionCallMixin)statement;
            Fqn containerFqn = inclusionCall.getContainerFqn();
            String includedModuleName = inclusionCall.getIncludedModuleText();
            if (includedModuleName == null) {
                return true;
            }
            GlobalSearchScope resolveScope = inclusionCall.getResolveScope();
            SequencedCollection<? extends RbsQualifiedNameSymbol> ancestors = RbsResolveUtil.resolveQualifiedNameInNesting(project, (SearchScope)resolveScope, containerFqn, includedModuleName, (PsiElement)inclusionCall);
            ancestors.stream().mapMulti(RbsContainerSymbolUtil.followAliases(project, (SearchScope)resolveScope)).mapMulti(StreamUtil.select(RbsContainerSymbol.class, (Class[])new Class[0])).forEach(it -> moduleInclusionCalls.putValue((Object)inclusionCall.getInclusionCallType(), it));
            return true;
        });
        ArrayList<? extends RbsContainerSymbol> ancestors = new ArrayList<RbsContainerSymbol>();
        if (container instanceof RbsClassSymbol) {
            RbsClassSymbol classSymbol = (RbsClassSymbol)container;
            ContainerUtil.addIfNotNull(ancestors, (Object)classSymbol.getSuperclassSymbol(project, searchScope));
        } else if (container instanceof RbsSingletonSymbol) {
            RbsSingletonSymbol singletonSymbol = (RbsSingletonSymbol)container;
            ContainerUtil.addIfNotNull(ancestors, (Object)singletonSymbol.getSuperclassSymbol(project, searchScope));
        } else if (container instanceof RbsModuleSymbol) {
            RbsModuleSymbol moduleSymbol = (RbsModuleSymbol)container;
            ancestors.addAll(moduleSymbol.getSelfTypeSymbols(project, searchScope));
        }
        ancestors.addAll(moduleInclusionCalls.get((Object)RbsModuleInclusionCallType.EXTEND));
        ancestors.addAll(moduleInclusionCalls.get((Object)RbsModuleInclusionCallType.INCLUDE));
        ancestors.add(container);
        ancestors.addAll(moduleInclusionCalls.get((Object)RbsModuleInclusionCallType.PREPEND));
        List list = ContainerUtil.reverse(ancestors);
        if (list == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static List<? extends Symbol> getChildren(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsContainerSymbol container) {
        if (project == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(5);
        }
        if (container == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.softAssertReadAccess();
        RbsFqnStubIndexExtension index = container instanceof RbsSingletonSymbol ? RbsSingletonStatementParentFqnIndex.getInstance() : RbsContainerStatementParentFqnIndex.getInstance();
        ArrayList children = new ArrayList();
        index.processElements(project, searchScope, container.getFqn(), statement -> {
            ProgressManager.checkCanceled();
            PsiSymbolDeclarationService.getInstance().getDeclarations((PsiElement)statement).forEach(declaration -> children.add(declaration.getSymbol()));
            return true;
        });
        List<? extends Symbol> list = List.copyOf(RbsContainerHierarchyMapper.getComposite().mapChildren(project, searchScope, container, children));
        if (list == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static SequencedSet<? extends RbsQualifiedNameSymbol> getConstants(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsContainerSymbol container) {
        if (project == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(8);
        }
        if (searchScope == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(9);
        }
        if (container == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.softAssertReadAccess();
        LinkedHashSet constants = new LinkedHashSet();
        boolean isObject = container.equals(RbsSymbols.OBJECT_SYMBOL);
        Fqn containerFqn = isObject ? Fqn.INVALID : container.getFqn();
        RbsDeclarationByParentFqnIndex.processAllValues(project, searchScope, containerFqn, (PairProcessor<? super RbsDeclarationByParentFqnIndex.Type, ? super String>)((PairProcessor)(type, name) -> {
            Fqn fqn = isObject ? Fqn.of((String)name, (String[])new String[0]) : Fqn.concat((Fqn)containerFqn, (String)name, (String[])new String[0]);
            switch (type) {
                case CLASS: 
                case CLASS_ALIAS: {
                    constants.add(new RbsClassSymbol(fqn));
                    break;
                }
                case CONSTANT: {
                    constants.add(new RbsConstantSymbol(fqn));
                    break;
                }
                case MODULE: 
                case MODULE_ALIAS: {
                    constants.add(new RbsModuleSymbol(fqn));
                    break;
                }
                case TYPE_ALIAS: {
                    constants.add(new RbsTypeAliasSymbol(fqn));
                    break;
                }
                case INTERFACE: {
                    constants.add(new RbsInterfaceSymbol(fqn));
                }
            }
            return true;
        }));
        SequencedSet sequencedSet = Collections.unmodifiableSequencedSet(constants);
        if (sequencedSet == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(11);
        }
        return sequencedSet;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Map<RbsContainerSymbol, Function<RbsTypeSignature, RbsTypeSignature>> getTypeVariableBinding(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsContainerSymbol container) {
        if (project == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(13);
        }
        if (container == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.softAssertReadAccess();
        return RbsContainerHierarchyUtil.getTypeVariableBinding(project, searchScope, container, Map.of(container, Function.identity()));
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static MultiMap<Integer, RbsContainerTypeVariableSymbol> getTypeVariableSymbols(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsContainerSymbol container) {
        if (project == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(15);
        }
        if (searchScope == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(16);
        }
        if (container == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(17);
        }
        ThreadingAssertions.softAssertReadAccess();
        Supplier<MultiMap> supplier = () -> new MultiMap();
        BiConsumer<MultiMap, RbsContainerTypeVariableSymbol> accumulator = (map, typeVariable) -> map.putValue((Object)typeVariable.getTypeVariableIndex(), typeVariable);
        BiConsumer<MultiMap, MultiMap> combiner = (first, second) -> first.putAllValues(second);
        MultiMap multiMap = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, searchScope, container).stream().map(PsiSymbolDeclaration::getDeclaringElement).mapMulti(StreamUtil.select(RbsContainerDeclarationElement.class, (Class[])new Class[0])).flatMap(declaration -> ExtensionsKt.getSymbols((PsiElement)declaration, RbsContainerTypeVariableSymbol.class).stream()).collect(supplier, accumulator, combiner);
        if (multiMap == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(18);
        }
        return multiMap;
    }

    @NotNull
    private static Map<RbsContainerSymbol, Function<RbsTypeSignature, RbsTypeSignature>> getTypeVariableBinding(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsContainerSymbol container, @NotNull Map<? extends RbsContainerSymbol, Function<RbsTypeSignature, RbsTypeSignature>> initialBinding) {
        if (project == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(19);
        }
        if (searchScope == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(20);
        }
        if (container == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(21);
        }
        if (initialBinding == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(22);
        }
        HashMap<? extends RbsContainerSymbol, Function<RbsTypeSignature, RbsTypeSignature>> binding = new HashMap<RbsContainerSymbol, Function<RbsTypeSignature, RbsTypeSignature>>(initialBinding);
        Function containerBinding = (Function)binding.get(container);
        RbsFqnStubIndexExtension index = container instanceof RbsSingletonSymbol ? RbsSingletonStatementParentFqnIndex.getInstance() : RbsContainerStatementParentFqnIndex.getInstance();
        index.getElements(project, searchScope, container.getFqn()).stream().mapMulti(StreamUtil.select(RbsModuleInclusionCallMixin.class, (Class[])new Class[0])).sorted(Comparator.comparing(RbsModuleInclusionCall::getInclusionCallType, RbsModuleInclusionCallType.PROCESSING_ORDER_COMPARATOR)).forEach(inclusionCall -> {
            ProgressManager.checkCanceled();
            Fqn containerFqn = inclusionCall.getContainerFqn();
            String includedModuleName = inclusionCall.getIncludedModuleText();
            if (includedModuleName == null) {
                return;
            }
            GlobalSearchScope resolveScope = inclusionCall.getResolveScope();
            SequencedCollection<? extends RbsQualifiedNameSymbol> ancestors = RbsResolveUtil.resolveQualifiedNameInNesting(project, (SearchScope)resolveScope, containerFqn, includedModuleName, (PsiElement)inclusionCall);
            ancestors.stream().mapMulti(RbsContainerSymbolUtil.followAliases(project, (SearchScope)resolveScope)).mapMulti(StreamUtil.select(RbsContainerSymbol.class, (Class[])new Class[0])).forEach(ancestor -> {
                if (binding.containsKey(ancestor)) {
                    return;
                }
                List includedModuleArguments = ContainerUtil.map((Collection)inclusionCall.getIncludedModuleArguments(), signature -> signature.apply(containerBinding));
                binding.put((RbsContainerSymbol)ancestor, new RbsTypeSignatureBinding(RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE, (List<RbsTypeSignature>)includedModuleArguments));
                binding.putAll(RbsContainerHierarchyUtil.getTypeVariableBinding(project, searchScope, ancestor, binding));
            });
        });
        if (container instanceof RbsClassSymbol) {
            RbsClassSymbol classSymbol = (RbsClassSymbol)container;
            RbsClassSymbol superclass = classSymbol.getSuperclassSymbol(project, searchScope);
            if (superclass != null && !binding.containsKey(superclass)) {
                List<RbsTypeSignature> superclassArguments = RbsClassDeclarationFqnIndex.getInstance().getElements(project, searchScope, container.getFqn()).stream().mapMulti(StreamUtil.select(RbsClassDeclarationMixin.class, (Class[])new Class[0])).map(RbsClassDeclaration::getSuperclassTypeArgumentSignatures).reduce((first, second) -> {
                    ArrayList<RbsTypeSignature> result = new ArrayList<RbsTypeSignature>();
                    for (int i = 0; i < Math.max(first.size(), second.size()); ++i) {
                        result.add(RbsUnionTypeSignature.of((RbsTypeSignature)((RbsTypeSignature)ContainerUtil.getOrElse((List)first, (int)i, (Object)RbsKeywordTypeSignature.UNTYPED)), (RbsTypeSignature)((RbsTypeSignature)ContainerUtil.getOrElse((List)second, (int)i, (Object)RbsKeywordTypeSignature.UNTYPED))).apply(containerBinding));
                    }
                    return result;
                }).orElse(Collections.emptyList());
                binding.put(superclass, new RbsTypeSignatureBinding(RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE, superclassArguments));
                binding.putAll(RbsContainerHierarchyUtil.getTypeVariableBinding(project, searchScope, superclass, binding));
            }
        } else if (container instanceof RbsSingletonSymbol) {
            RbsSingletonSymbol singletonSymbol = (RbsSingletonSymbol)container;
            RbsContainerSymbol superclass = singletonSymbol.getSuperclassSymbol(project, searchScope);
            if (superclass != null && !binding.containsKey(superclass)) {
                binding.put(superclass, RbsTypeSignatureBinding.UNTYPED);
                binding.putAll(RbsContainerHierarchyUtil.getTypeVariableBinding(project, searchScope, superclass, binding));
            }
        } else if (container instanceof RbsModuleSymbol) {
            RbsModuleDeclarationFqnIndex.getInstance().processElements(project, searchScope, container.getFqn(), elem -> {
                ProgressManager.checkCanceled();
                if (!(elem instanceof RbsModuleDeclarationMixin)) {
                    return true;
                }
                RbsModuleDeclarationMixin element = (RbsModuleDeclarationMixin)elem;
                GlobalSearchScope resolveScope = element.getResolveScope();
                Fqn containerFqn = element.getFqn();
                for (Map.Entry moduleSelfType : element.getModuleSelfTypes().entrySet()) {
                    SequencedCollection<? extends RbsQualifiedNameSymbol> ancestors = RbsResolveUtil.resolveQualifiedNameInNesting(project, (SearchScope)resolveScope, containerFqn, (String)moduleSelfType.getKey(), (PsiElement)element);
                    ancestors.stream().mapMulti(RbsContainerSymbolUtil.followAliases(project, (SearchScope)resolveScope)).mapMulti(StreamUtil.select(RbsContainerSymbol.class, (Class[])new Class[0])).forEach(selfType -> {
                        if (binding.containsKey(selfType)) {
                            return;
                        }
                        List selfTypeArguments = ContainerUtil.map((Collection)((Collection)moduleSelfType.getValue()), signature -> signature.apply(containerBinding));
                        binding.put((RbsContainerSymbol)selfType, new RbsTypeSignatureBinding(RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE, (List<RbsTypeSignature>)selfTypeArguments));
                        binding.putAll(RbsContainerHierarchyUtil.getTypeVariableBinding(project, searchScope, selfType, binding));
                    });
                }
                return true;
            });
        }
        Map<RbsContainerSymbol, Function<RbsTypeSignature, RbsTypeSignature>> map = Collections.unmodifiableMap(binding);
        if (map == null) {
            RbsContainerHierarchyUtil.$$$reportNull$$$0(23);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 11, 18, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/hierarchy/RbsContainerHierarchyUtil";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialBinding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/hierarchy/RbsContainerHierarchyUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstants";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeVariableSymbols";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeVariableBinding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAncestors";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 18: 
            case 23: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConstants";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTypeVariableBinding";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypeVariableSymbols";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 11, 18, 23 -> new IllegalStateException(string);
        };
    }
}

