/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.documentation;

import com.intellij.lang.ruby.rbs.model.documentation.RbsDocumentationChunk;
import com.intellij.lang.ruby.rbs.model.documentation.RbsDocumentationTargetBase;
import com.intellij.lang.ruby.rbs.model.impl.RbsAttributeSymbol;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureResolver;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.ruby.rbs.common.psi.data.RbsAttributeType;
import com.intellij.ruby.rbs.common.psi.data.RbsDeclarationType;
import com.intellij.ruby.rbs.common.psi.data.RbsVisibility;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;

final class RbsAttributeDocumentationTarget
extends RbsDocumentationTargetBase<RbsAttributeSymbol> {
    RbsAttributeDocumentationTarget(@NotNull Project project, @NotNull RbsAttributeSymbol symbol) {
        if (project == null) {
            RbsAttributeDocumentationTarget.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            RbsAttributeDocumentationTarget.$$$reportNull$$$0(1);
        }
        super(project, symbol);
    }

    @NlsContexts.HintText
    @NotNull
    public String computeDocumentationHint() {
        @Nls StringBuilder sb = new StringBuilder();
        sb.append(RbsDocumentationChunk.fqn(((RbsAttributeSymbol)this.mySymbol).getContainerFqn()));
        sb.append(RbsDocumentationChunk.typeVariables(this.myProject, ((RbsAttributeSymbol)this.mySymbol).getContainerSymbol().getTypeVariableSymbols(this.myProject, this.mySearchScope), true));
        sb.append(HtmlChunk.br());
        if (((RbsAttributeSymbol)this.mySymbol).getVisibility() == RbsVisibility.PRIVATE_VISIBILITY) {
            sb.append(RbsDocumentationChunk.keyword("private")).append(" ");
        }
        sb.append(RbsDocumentationChunk.keyword(switch (((RbsAttributeSymbol)this.mySymbol).getAttributeType()) {
            default -> throw new MatchException(null, null);
            case RbsAttributeType.ATTRIBUTE_ACCESSOR -> "attr_accessor";
            case RbsAttributeType.ATTRIBUTE_READER -> "attr_reader";
            case RbsAttributeType.ATTRIBUTE_WRITER -> "attr_writer";
        })).append(" ");
        if (((RbsAttributeSymbol)this.mySymbol).getDeclarationType() == RbsDeclarationType.SINGLETON_DECLARATION) {
            sb.append(RbsDocumentationChunk.keyword("self")).append(RbsDocumentationChunk.operation("."));
        }
        sb.append(RbsDocumentationChunk.highlighted(RubyHighlighter.METHOD_NAME, ((RbsAttributeSymbol)this.mySymbol).getName()));
        if (((RbsAttributeSymbol)this.mySymbol).isOverridesAttributeVariable()) {
            sb.append(" ").append(RbsDocumentationChunk.parentheses("("));
            String attributeVariableName = ((RbsAttributeSymbol)this.mySymbol).getAttributeVariableName();
            if (attributeVariableName != null) {
                sb.append(RbsDocumentationChunk.highlighted(RubyHighlighter.IVAR, "@" + attributeVariableName));
            }
            sb.append(RbsDocumentationChunk.parentheses(")"));
        }
        sb.append(RbsDocumentationChunk.operation(":")).append(" ").append(RbsDocumentationChunk.typeSignature(((RbsAttributeSymbol)this.mySymbol).getTypeSignature(this.myProject, this.mySearchScope).apply((Function)new RbsTypeSignatureResolver(this.myProject, this.mySearchScope))));
        String string = sb.toString();
        if (string == null) {
            RbsAttributeDocumentationTarget.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = TargetPresentation.builder((String)((RbsAttributeSymbol)this.mySymbol).getName()).icon(((RbsAttributeSymbol)this.mySymbol).getPresentation().icon()).presentation();
        if (targetPresentation == null) {
            RbsAttributeDocumentationTarget.$$$reportNull$$$0(3);
        }
        return targetPresentation;
    }

    @Override
    @NotNull
    public Pointer<RbsAttributeDocumentationTarget> createPointer() {
        Project project = this.myProject;
        Pointer pointer = Pointer.delegatingPointer(((RbsAttributeSymbol)this.mySymbol).createPointer(), it -> !project.isDisposed() ? new RbsAttributeDocumentationTarget(project, (RbsAttributeSymbol)it) : null);
        if (pointer == null) {
            RbsAttributeDocumentationTarget.$$$reportNull$$$0(4);
        }
        return pointer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/documentation/RbsAttributeDocumentationTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/documentation/RbsAttributeDocumentationTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDocumentationHint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

