/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.completion;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ruby.rbs.common.util.Fqn;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.model.completion.SymbolLookupElementKeys;
import org.jetbrains.plugins.ruby.model.completion.SymbolLookupElementLocation;

final class RbsQualifiedNameLookupElement
extends LookupElement {
    private final Fqn myFqn;
    private final int myNestingDepth;
    private final String myLookupString;
    private final Set<String> myAllLookupStrings;
    private final LookupElementPresentation myPresentation;
    @Nullable
    private final LookupElementRenderer<? extends LookupElement> myExpensiveRenderer;

    RbsQualifiedNameLookupElement(@NotNull RbsQualifiedNameSymbol symbol, @NotNull SymbolLookupElementLocation location, @Nullable LookupElementRenderer<? extends LookupElement> expensiveRenderer) {
        if (symbol == null) {
            RbsQualifiedNameLookupElement.$$$reportNull$$$0(0);
        }
        if (location == null) {
            RbsQualifiedNameLookupElement.$$$reportNull$$$0(1);
        }
        this.myPresentation = new LookupElementPresentation();
        this.myFqn = symbol.getFqn().normalize();
        this.myNestingDepth = this.myFqn.split().getComponents().size();
        this.myLookupString = this.myFqn.absolute().join();
        this.myAllLookupStrings = Set.of(this.myLookupString, symbol.getName());
        this.myPresentation.setItemText(symbol.getName());
        this.myPresentation.setTypeText(StringUtil.defaultIfEmpty((String)this.myFqn.split().getParent().join(), (String)"::"));
        this.myPresentation.setTypeGrayed(true);
        this.myPresentation.setIcon(symbol.getPresentation().icon());
        boolean isTopLevelSdkTypeAlias = symbol instanceof RbsTypeAliasSymbol && location == SymbolLookupElementLocation.SDK && this.myFqn.split().getParent() == Fqn.INVALID;
        this.myPresentation.setItemTextBold(location == SymbolLookupElementLocation.SAME_FILE || isTopLevelSdkTypeAlias);
        this.myExpensiveRenderer = expensiveRenderer;
        this.putUserData(SymbolLookupElementKeys.SYMBOL_POINTER, symbol.createPointer());
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RbsQualifiedNameLookupElement other = (RbsQualifiedNameLookupElement)((Object)obj);
        return this.myFqn.equals((Object)other.myFqn) && this.myPresentation.isItemTextBold() == other.myPresentation.isItemTextBold();
    }

    public @Unmodifiable @NotNull Set<String> getAllLookupStrings() {
        Set<String> set = this.myAllLookupStrings;
        if (set == null) {
            RbsQualifiedNameLookupElement.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public AutoCompletionPolicy getAutoCompletionPolicy() {
        AutoCompletionPolicy autoCompletionPolicy = AutoCompletionPolicy.NEVER_AUTOCOMPLETE;
        if (autoCompletionPolicy == null) {
            RbsQualifiedNameLookupElement.$$$reportNull$$$0(3);
        }
        return autoCompletionPolicy;
    }

    @Nullable
    public LookupElementRenderer<? extends LookupElement> getExpensiveRenderer() {
        return this.myExpensiveRenderer;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myLookupString;
        if (string == null) {
            RbsQualifiedNameLookupElement.$$$reportNull$$$0(4);
        }
        return string;
    }

    public int getNestingDepth() {
        return this.myNestingDepth;
    }

    @NotNull
    public Object getObject() {
        Fqn fqn = this.myFqn;
        if (fqn == null) {
            RbsQualifiedNameLookupElement.$$$reportNull$$$0(5);
        }
        return fqn;
    }

    @Nullable
    public PsiElement getPsiElement() {
        return null;
    }

    public int hashCode() {
        return 31 * this.myFqn.hashCode() + this.myPresentation.hashCode();
    }

    public boolean isValid() {
        return true;
    }

    public boolean isWorthShowingInAutoPopup() {
        return false;
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        if (presentation == null) {
            RbsQualifiedNameLookupElement.$$$reportNull$$$0(6);
        }
        presentation.copyFrom(this.myPresentation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/completion/RbsQualifiedNameLookupElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/completion/RbsQualifiedNameLookupElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLookupStrings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoCompletionPolicy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renderElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

