/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.cache.RbsModificationTrackers;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.psi.index.RbsDeclarationFqnIndex;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.psi.data.RbsMethodTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.cache.IdempotentCache;

@Service(value={Service.Level.PROJECT})
public final class RbsSymbolsCache
implements Disposable {
    private final Project myProject;
    private final LoadingCache<@NotNull SearchScope, @NotNull Instance> myCache;
    private final AtomicLong myStamp;

    public RbsSymbolsCache(@NotNull Project project) {
        if (project == null) {
            RbsSymbolsCache.$$$reportNull$$$0(0);
        }
        this.myStamp = new AtomicLong();
        this.myProject = project;
        this.myCache = Caffeine.newBuilder().maximumSize(100L).build(__ -> new Instance(project));
        LowMemoryWatcher.register(() -> this.myCache.invalidateAll(), (Disposable)this);
    }

    public void dispose() {
        this.myCache.invalidateAll();
    }

    @RequiresReadLock
    @NotNull
    private Instance getCache(@NotNull SearchScope searchScope) {
        if (searchScope == null) {
            RbsSymbolsCache.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.softAssertReadAccess();
        long stamp = ProjectRootManager.getInstance((Project)this.myProject).getModificationCount() + RbsModificationTrackers.getInstance(this.myProject).getPerFileElementTypeModificationTracker().getModificationCount();
        if (this.myStamp.getAndSet(stamp) != stamp) {
            this.myCache.invalidateAll();
        }
        Instance instance = (Instance)this.myCache.get((Object)searchScope);
        if (instance == null) {
            RbsSymbolsCache.$$$reportNull$$$0(2);
        }
        return instance;
    }

    @NotNull
    public static Instance getInstance(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsSymbolsCache.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            RbsSymbolsCache.$$$reportNull$$$0(4);
        }
        return ((RbsSymbolsCache)project.getService(RbsSymbolsCache.class)).getCache(searchScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/cache/RbsSymbolsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/cache/RbsSymbolsCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCache";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static final class Instance {
        private static final long DEFAULT_MAXIMUM_SIZE = Math.max(0, Registry.get((String)"rbs.symbols.cache.size").asInteger());
        private final Cache<@NotNull Symbol, @NotNull List<RbsContainerSymbol>> myAllAncestors;
        private final Cache<@NotNull Symbol, @NotNull List<RbsContainerSymbol>> myAncestors;
        private final Cache<@NotNull Symbol, @NotNull List<RbsContainerSymbol>> mySuperclasses;
        private final Cache<@NotNull Symbol, @NotNull List<RbsContainerSymbol>> mySelfTypes;
        private final Cache<@NotNull Symbol, @NotNull Map<RbsContainerSymbol, Function<RbsTypeSignature, RbsTypeSignature>>> myTypeVariableBindings;
        private final Cache<@NotNull Symbol, @NotNull MultiMap<Integer, Pointer<RbsContainerTypeVariableSymbol>>> myContainerTypeVariablePointers;
        private final Cache<@NotNull Symbol, @NotNull Map<Integer, Pointer<RbsTypeAliasTypeVariableSymbol>>> myTypeAliasTypeVariablePointers;
        private final Cache<@NotNull Symbol, @NotNull List<Symbol>> myChildren;
        private final Cache<@NotNull Symbol, @NotNull List<RbsQualifiedNameSymbol>> myConstants;
        private final Cache<@NotNull Symbol, @NotNull RbsTypeSignature> myTypeSignatures;
        private final Cache<@NotNull Symbol, @NotNull List<RbsMethodTypeSignature>> myMethodTypeSignatures;
        private final Cache<@NotNull RbsClassSymbol, @NotNull List<RbsClassSymbol>> myTargetClasses;
        private final Cache<@NotNull RbsModuleSymbol, @NotNull List<RbsModuleSymbol>> myTargetModules;
        private final Cache< @NotNull RbsDeclarationFqnIndex.Type, @NotNull SequencedSet<Fqn>> myDeclarationFqns;
        private final Cache<@NotNull String, @NotNull Boolean> myGlobalVariableNames;

        private Instance(@NotNull Project project) {
            if (project == null) {
                Instance.$$$reportNull$$$0(0);
            }
            this.myAllAncestors = new IdempotentCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myAncestors = new IdempotentCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.mySuperclasses = new IdempotentCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.mySelfTypes = new IdempotentCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myTypeVariableBindings = new IdempotentCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myContainerTypeVariablePointers = new IdempotentCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myTypeAliasTypeVariablePointers = new IdempotentCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myChildren = new IdempotentCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myConstants = new IdempotentCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myTypeSignatures = new IdempotentCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myMethodTypeSignatures = new IdempotentCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myTargetClasses = new IdempotentCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myTargetModules = new IdempotentCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
            this.myDeclarationFqns = new IdempotentCache(project, Caffeine.newBuilder().build());
            this.myGlobalVariableNames = new IdempotentCache(project, Caffeine.newBuilder().maximumSize(DEFAULT_MAXIMUM_SIZE).build());
        }

        @NotNull
        public @NotNull Cache<@NotNull Symbol, @NotNull List<RbsContainerSymbol>> getAllAncestors() {
            Cache<Symbol, List<RbsContainerSymbol>> cache = this.myAllAncestors;
            if (cache == null) {
                Instance.$$$reportNull$$$0(1);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull Symbol, @NotNull List<RbsContainerSymbol>> getAncestors() {
            Cache<Symbol, List<RbsContainerSymbol>> cache = this.myAncestors;
            if (cache == null) {
                Instance.$$$reportNull$$$0(2);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull Symbol, @NotNull List<Symbol>> getChildren() {
            Cache<Symbol, List<Symbol>> cache = this.myChildren;
            if (cache == null) {
                Instance.$$$reportNull$$$0(3);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull Symbol, @NotNull List<RbsQualifiedNameSymbol>> getConstants() {
            Cache<Symbol, List<RbsQualifiedNameSymbol>> cache = this.myConstants;
            if (cache == null) {
                Instance.$$$reportNull$$$0(4);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull Symbol, @NotNull MultiMap<Integer, Pointer<RbsContainerTypeVariableSymbol>>> getContainerTypeVariablePointers() {
            Cache<Symbol, MultiMap<Integer, Pointer<RbsContainerTypeVariableSymbol>>> cache = this.myContainerTypeVariablePointers;
            if (cache == null) {
                Instance.$$$reportNull$$$0(5);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache< @NotNull RbsDeclarationFqnIndex.Type, @NotNull SequencedSet<Fqn>> getDeclarationFqns() {
            Cache<RbsDeclarationFqnIndex.Type, SequencedSet<Fqn>> cache = this.myDeclarationFqns;
            if (cache == null) {
                Instance.$$$reportNull$$$0(6);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull String, @NotNull Boolean> getGlobalVariableNames() {
            Cache<String, Boolean> cache = this.myGlobalVariableNames;
            if (cache == null) {
                Instance.$$$reportNull$$$0(7);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull Symbol, @NotNull List<RbsMethodTypeSignature>> getMethodTypeSignatures() {
            Cache<Symbol, List<RbsMethodTypeSignature>> cache = this.myMethodTypeSignatures;
            if (cache == null) {
                Instance.$$$reportNull$$$0(8);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull Symbol, @NotNull List<RbsContainerSymbol>> getSelfTypes() {
            Cache<Symbol, List<RbsContainerSymbol>> cache = this.mySelfTypes;
            if (cache == null) {
                Instance.$$$reportNull$$$0(9);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull Symbol, @NotNull List<RbsContainerSymbol>> getSuperclasses() {
            Cache<Symbol, List<RbsContainerSymbol>> cache = this.mySuperclasses;
            if (cache == null) {
                Instance.$$$reportNull$$$0(10);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull RbsClassSymbol, @NotNull List<RbsClassSymbol>> getTargetClasses() {
            Cache<RbsClassSymbol, List<RbsClassSymbol>> cache = this.myTargetClasses;
            if (cache == null) {
                Instance.$$$reportNull$$$0(11);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull RbsModuleSymbol, @NotNull List<RbsModuleSymbol>> getTargetModules() {
            Cache<RbsModuleSymbol, List<RbsModuleSymbol>> cache = this.myTargetModules;
            if (cache == null) {
                Instance.$$$reportNull$$$0(12);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull Symbol, @NotNull Map<Integer, Pointer<RbsTypeAliasTypeVariableSymbol>>> getTypeAliasTypeVariablePointers() {
            Cache<Symbol, Map<Integer, Pointer<RbsTypeAliasTypeVariableSymbol>>> cache = this.myTypeAliasTypeVariablePointers;
            if (cache == null) {
                Instance.$$$reportNull$$$0(13);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull Symbol, @NotNull RbsTypeSignature> getTypeSignatures() {
            Cache<Symbol, RbsTypeSignature> cache = this.myTypeSignatures;
            if (cache == null) {
                Instance.$$$reportNull$$$0(14);
            }
            return cache;
        }

        @NotNull
        public @NotNull Cache<@NotNull Symbol, @NotNull Map<RbsContainerSymbol, Function<RbsTypeSignature, RbsTypeSignature>>> getTypeVariableBindings() {
            Cache<Symbol, Map<RbsContainerSymbol, Function<RbsTypeSignature, RbsTypeSignature>>> cache = this.myTypeVariableBindings;
            if (cache == null) {
                Instance.$$$reportNull$$$0(15);
            }
            return cache;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/model/cache/RbsSymbolsCache$Instance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/model/cache/RbsSymbolsCache$Instance";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllAncestors";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAncestors";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConstants";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainerTypeVariablePointers";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeclarationFqns";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGlobalVariableNames";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodTypeSignatures";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelfTypes";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuperclasses";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetClasses";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetModules";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeAliasTypeVariablePointers";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeSignatures";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeVariableBindings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
            };
        }
    }
}

