/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.api;

import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.cache.RbsSymbolsCache;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

final class RbsContainerSymbolAllAncestorsSpliterator
extends Spliterators.AbstractSpliterator<RbsContainerSymbol> {
    private final Project myProject;
    private final SearchScope mySearchScope;
    private final RbsContainerSymbol mySymbol;
    private final LinkedList<RbsContainerSymbol> myPrependQueue;
    private final Set<RbsContainerSymbol> myPrependProcessed;
    private final LinkedList<RbsContainerSymbol> myQueue;
    private final Set<RbsContainerSymbol> myProcessed;
    private final List<RbsContainerSymbol> myAllAncestors;

    RbsContainerSymbolAllAncestorsSpliterator(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsContainerSymbol symbol) {
        if (project == null) {
            RbsContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RbsContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(1);
        }
        if (symbol == null) {
            RbsContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(2);
        }
        super(Long.MAX_VALUE, 1296);
        this.myPrependQueue = new LinkedList();
        this.myPrependProcessed = new HashSet<RbsContainerSymbol>();
        this.myQueue = new LinkedList();
        this.myProcessed = new HashSet<RbsContainerSymbol>();
        this.myAllAncestors = new ArrayList<RbsContainerSymbol>();
        this.myProject = project;
        this.mySearchScope = searchScope;
        this.mySymbol = symbol;
    }

    @Override
    public long getExactSizeIfKnown() {
        return this.myQueue.isEmpty() ? 0L : -1L;
    }

    @Override
    public boolean tryAdvance(@NotNull Consumer<? super RbsContainerSymbol> action) {
        Set<RbsContainerSymbol> processed;
        if (action == null) {
            RbsContainerSymbolAllAncestorsSpliterator.$$$reportNull$$$0(3);
        }
        ProgressManager.checkCanceled();
        LinkedList<RbsContainerSymbol> queue = !this.myPrependQueue.isEmpty() ? this.myPrependQueue : this.myQueue;
        Set<RbsContainerSymbol> set = processed = !this.myPrependQueue.isEmpty() ? this.myPrependProcessed : this.myProcessed;
        if (queue.isEmpty()) {
            if (this.myAllAncestors.isEmpty()) {
                this.initializeQueue();
                return this.tryAdvance(action);
            }
            RbsSymbolsCache.getInstance(this.myProject, this.mySearchScope).getAllAncestors().put((Object)this.mySymbol, List.copyOf(this.myAllAncestors));
            return false;
        }
        RbsContainerSymbol ancestor = queue.poll();
        if (!processed.add(ancestor)) {
            this.myAllAncestors.add(ancestor);
            action.accept(ancestor);
            return true;
        }
        if (ancestor instanceof RbsModuleSymbol) {
            RbsModuleSymbol moduleSymbol = (RbsModuleSymbol)ancestor;
            ArrayList<? extends RbsContainerSymbol> selfTypes = new ArrayList<RbsContainerSymbol>(moduleSymbol.getSelfTypeSymbols(this.myProject, this.mySearchScope));
            queue.addAll(0, ancestor.ancestors(this.myProject, this.mySearchScope).filter(candidate -> !selfTypes.remove(candidate)).toList());
        } else {
            queue.addAll(0, ancestor.ancestors(this.myProject, this.mySearchScope).toList());
        }
        return this.tryAdvance(action);
    }

    private void initializeQueue() {
        Ref queueRef = new Ref(this.myPrependQueue);
        this.mySymbol.ancestors(this.myProject, this.mySearchScope).forEach(ancestor -> {
            if (ancestor.equals(this.mySymbol)) {
                queueRef.set(this.myQueue);
            }
            ((LinkedList)queueRef.get()).add(ancestor);
        });
        this.myProcessed.add(this.mySymbol);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ruby/rbs/model/api/RbsContainerSymbolAllAncestorsSpliterator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "tryAdvance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

