/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.probableBugs;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.model.psi.reference.RbsQualifiedNameSymbolReference;
import com.intellij.model.Symbol;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.psi.RbsPsiVisitor;
import com.intellij.ruby.rbs.common.psi.api.RbsAndType;
import com.intellij.ruby.rbs.common.psi.api.RbsAttributeMember;
import com.intellij.ruby.rbs.common.psi.api.RbsBlock;
import com.intellij.ruby.rbs.common.psi.api.RbsContainerDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsMethodDeclaration;
import com.intellij.ruby.rbs.common.psi.api.RbsMethodType;
import com.intellij.ruby.rbs.common.psi.api.RbsOrType;
import com.intellij.ruby.rbs.common.psi.api.RbsParam;
import com.intellij.ruby.rbs.common.psi.api.RbsProcType;
import com.intellij.ruby.rbs.common.psi.api.RbsQualifiedName;
import com.intellij.ruby.rbs.common.psi.api.RbsSimpleFunctionType;
import com.intellij.ruby.rbs.common.psi.api.RbsSimpleType;
import com.intellij.ruby.rbs.common.psi.api.RbsType;
import com.intellij.ruby.rbs.common.psi.api.RbsTypeDecl;
import com.intellij.ruby.rbs.common.psi.api.RbsVarTypeMember;
import com.intellij.ruby.rbs.common.psi.data.RbsDeclarationType;
import com.intellij.ruby.rbs.common.psi.data.RbsOptionalTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeVariableReferenceSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsVariance;
import com.intellij.ruby.rbs.common.psi.impl.RbsMethodMemberImpl;
import com.intellij.ruby.rbs.common.psi.navigators.RbsMethodDeclarationNavigator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;

@ApiStatus.Internal
public final class RbsInvalidTypeArgumentUsageInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsInvalidTypeArgumentUsageInspection.$$$reportNull$$$0(0);
        }
        return new MyDeclarationVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsInvalidTypeArgumentUsageInspection", "buildVisitor"));
    }

    private static final class MyDeclarationVisitor
    extends RbsPsiVisitor {
        private final ProblemsHolder myHolder;

        private MyDeclarationVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyDeclarationVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        public void visitAttributeMember(@NotNull RbsAttributeMember declaration) {
            RbsContainerDeclarationElement container;
            if (declaration == null) {
                MyDeclarationVisitor.$$$reportNull$$$0(1);
            }
            if ((container = (RbsContainerDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)declaration, RbsContainerDeclarationElement.class)) == null) {
                return;
            }
            List typeVariableSymbols = ExtensionsKt.getSymbols((PsiElement)container, RbsContainerTypeVariableSymbol.class);
            if (typeVariableSymbols.isEmpty()) {
                return;
            }
            RbsType type = declaration.getType();
            if (type == null) {
                return;
            }
            if (declaration.isAttributeReader()) {
                type.accept((PsiElementVisitor)new MyTypeVisitor(this.myHolder, typeVariableSymbols, Collections.emptyList(), RbsVariance.COVARIANT));
            } else {
                type.accept((PsiElementVisitor)new MyTypeVisitor(this.myHolder, typeVariableSymbols, Collections.emptyList(), RbsVariance.INVARIANT));
            }
        }

        public void visitMethodType(@NotNull RbsMethodType overload) {
            RbsSimpleType returnType;
            RbsContainerDeclarationElement container;
            if (overload == null) {
                MyDeclarationVisitor.$$$reportNull$$$0(2);
            }
            if ((container = (RbsContainerDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)overload, RbsContainerDeclarationElement.class)) == null) {
                return;
            }
            List typeVariableSymbols = ExtensionsKt.getSymbols((PsiElement)container, RbsContainerTypeVariableSymbol.class);
            if (typeVariableSymbols.isEmpty()) {
                return;
            }
            RbsMethodMemberImpl declaration = RbsMethodDeclarationNavigator.getByMethodType((RbsMethodType)overload);
            if (declaration == null || MyDeclarationVisitor.isInitializeMethod((RbsMethodDeclaration)declaration)) {
                return;
            }
            RbsProcType type = overload.getProcType();
            for (Object parameter : type.getParamList()) {
                parameter.getType().accept((PsiElementVisitor)new MyTypeVisitor(this.myHolder, typeVariableSymbols, Collections.emptyList(), RbsVariance.CONTRAVARIANT));
            }
            RbsSimpleFunctionType blockType = (RbsSimpleFunctionType)ObjectUtils.doIfNotNull((Object)type.getBlock(), RbsBlock::getSimpleFunctionType);
            if (blockType != null) {
                for (RbsParam parameter : blockType.getParamList()) {
                    parameter.getType().accept((PsiElementVisitor)new MyTypeVisitor(this.myHolder, typeVariableSymbols, Collections.emptyList(), RbsVariance.COVARIANT));
                }
                RbsSimpleType blockReturnType = blockType.getSimpleType();
                if (blockReturnType != null) {
                    blockReturnType.accept((PsiElementVisitor)new MyTypeVisitor(this.myHolder, typeVariableSymbols, Collections.emptyList(), RbsVariance.CONTRAVARIANT));
                }
            }
            if ((returnType = type.getSimpleType()) != null) {
                returnType.accept((PsiElementVisitor)new MyTypeVisitor(this.myHolder, typeVariableSymbols, Collections.emptyList(), RbsVariance.COVARIANT));
            }
        }

        public void visitTypeDecl(@NotNull RbsTypeDecl declaration) {
            List typeVariableSymbols;
            if (declaration == null) {
                MyDeclarationVisitor.$$$reportNull$$$0(3);
            }
            if ((typeVariableSymbols = ExtensionsKt.getSymbols((PsiElement)declaration, RbsTypeVariableSymbol.class)).isEmpty()) {
                return;
            }
            RbsType type = declaration.getType();
            if (type == null) {
                return;
            }
            type.accept((PsiElementVisitor)new MyTypeVisitor(this.myHolder, Collections.emptyList(), typeVariableSymbols, RbsVariance.COVARIANT));
        }

        public void visitVarTypeMember(@NotNull RbsVarTypeMember declaration) {
            if (declaration == null) {
                MyDeclarationVisitor.$$$reportNull$$$0(4);
            }
        }

        private static boolean isInitializeMethod(@NotNull RbsMethodDeclaration declaration) {
            if (declaration == null) {
                MyDeclarationVisitor.$$$reportNull$$$0(5);
            }
            return declaration.getDeclarationTypes().equals(Set.of(RbsDeclarationType.INSTANCE_DECLARATION)) && "initialize".equals(declaration.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "overload";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsInvalidTypeArgumentUsageInspection$MyDeclarationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAttributeMember";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeDecl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVarTypeMember";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInitializeMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyTypeVisitor
    extends RbsPsiVisitor {
        private final Project myProject;
        private final SearchScope mySearchScope;
        private final ProblemsHolder myHolder;
        private final List<RbsContainerTypeVariableSymbol> myContainerTypeVariables;
        private final List<RbsTypeVariableSymbol> myLocalTypeVariables;
        private final RbsVariance myRequirement;

        private MyTypeVisitor(@NotNull ProblemsHolder holder, @NotNull List<RbsContainerTypeVariableSymbol> containerTypeVariables, @NotNull List<? extends RbsTypeVariableSymbol> localTypeVariables, @NotNull RbsVariance requirement) {
            if (holder == null) {
                MyTypeVisitor.$$$reportNull$$$0(0);
            }
            if (containerTypeVariables == null) {
                MyTypeVisitor.$$$reportNull$$$0(1);
            }
            if (localTypeVariables == null) {
                MyTypeVisitor.$$$reportNull$$$0(2);
            }
            if (requirement == null) {
                MyTypeVisitor.$$$reportNull$$$0(3);
            }
            this.myProject = holder.getProject();
            this.mySearchScope = holder.getFile().getResolveScope();
            this.myHolder = holder;
            this.myContainerTypeVariables = List.copyOf(containerTypeVariables);
            this.myLocalTypeVariables = List.copyOf(localTypeVariables);
            this.myRequirement = requirement;
        }

        public void visitAndType(@NotNull RbsAndType type) {
            if (type == null) {
                MyTypeVisitor.$$$reportNull$$$0(4);
            }
            type.getTypeList().forEach(it -> it.accept((PsiElementVisitor)this));
        }

        public void visitOrType(@NotNull RbsOrType type) {
            if (type == null) {
                MyTypeVisitor.$$$reportNull$$$0(5);
            }
            type.getTypeList().forEach(it -> it.accept((PsiElementVisitor)this));
        }

        public void visitProcType(@NotNull RbsProcType type) {
            RbsSimpleType returnType;
            if (type == null) {
                MyTypeVisitor.$$$reportNull$$$0(6);
            }
            for (Object parameter : type.getParamList()) {
                parameter.getType().accept((PsiElementVisitor)new MyTypeVisitor(this.myHolder, this.myContainerTypeVariables, this.myLocalTypeVariables, this.myRequirement.invert()));
            }
            RbsSimpleFunctionType blockType = (RbsSimpleFunctionType)ObjectUtils.doIfNotNull((Object)type.getBlock(), RbsBlock::getSimpleFunctionType);
            if (blockType != null) {
                for (RbsParam parameter : blockType.getParamList()) {
                    parameter.getType().accept((PsiElementVisitor)this);
                }
                RbsSimpleType blockReturnType = blockType.getSimpleType();
                if (blockReturnType != null) {
                    blockReturnType.accept((PsiElementVisitor)new MyTypeVisitor(this.myHolder, this.myContainerTypeVariables, this.myLocalTypeVariables, this.myRequirement.invert()));
                }
            }
            if ((returnType = type.getSimpleType()) != null) {
                returnType.accept((PsiElementVisitor)this);
            }
        }

        public void visitSimpleType(@NotNull RbsSimpleType type) {
            if (type == null) {
                MyTypeVisitor.$$$reportNull$$$0(7);
            }
            if (type.getProcType() != null) {
                type.getProcType().accept((PsiElementVisitor)this);
            } else if (type.getQualifiedName() != null) {
                this.visitTypeArgument(type);
                this.visitGenericType(type);
            } else if (type.getRecordType() != null) {
                type.getRecordType().getRecordFieldList().stream().flatMap(it -> Stream.ofNullable(it.getType())).forEach(it -> it.accept((PsiElementVisitor)this));
            } else if (type.isTuple()) {
                type.getTypeListElements().forEach(it -> it.accept((PsiElementVisitor)this));
            } else if (type.getType() != null) {
                type.getType().accept((PsiElementVisitor)this);
            }
        }

        private void visitGenericType(@NotNull RbsSimpleType type) {
            RbsQualifiedNameSymbolReference reference;
            if (type == null) {
                MyTypeVisitor.$$$reportNull$$$0(8);
            }
            if ((reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)type, RbsQualifiedNameSymbolReference.class))) == null) {
                return;
            }
            Symbol target = (Symbol)ContainerUtil.getOnlyItem(reference.resolveReference(true));
            if (target == null) {
                return;
            }
            List arguments = type.getTypeListElements();
            for (int i = 0; i < arguments.size(); ++i) {
                RbsTypeVariableSymbol parameter;
                RbsType argument = (RbsType)ContainerUtil.getOrElse((List)arguments, (int)i, null);
                if (argument == null || (parameter = target instanceof RbsContainerSymbol ? (RbsTypeVariableSymbol)ContainerUtil.getFirstItem((Collection)((RbsContainerSymbol)target).getTypeVariableSymbols(this.myProject, this.mySearchScope).get((Object)i)) : (target instanceof RbsTypeAliasSymbol ? (RbsTypeVariableSymbol)((RbsTypeAliasSymbol)target).getTypeVariableSymbols(this.myProject, this.mySearchScope).get(i) : null)) == null) continue;
                RbsVariance requirement = switch (parameter.getVariance()) {
                    default -> throw new MatchException(null, null);
                    case RbsVariance.INVARIANT -> RbsVariance.INVARIANT;
                    case RbsVariance.COVARIANT -> this.myRequirement;
                    case RbsVariance.CONTRAVARIANT -> this.myRequirement.invert();
                };
                argument.accept((PsiElementVisitor)new MyTypeVisitor(this.myHolder, this.myContainerTypeVariables, this.myLocalTypeVariables, requirement));
            }
        }

        private void visitTypeArgument(@NotNull RbsSimpleType type) {
            RbsTypeVariableSymbol argument;
            RbsQualifiedName identifier;
            if (type == null) {
                MyTypeVisitor.$$$reportNull$$$0(9);
            }
            if ((identifier = type.getQualifiedName()) == null) {
                return;
            }
            RbsTypeVariableReferenceSignature signature = Optional.of(type.getTypeSignature()).map(it -> it instanceof RbsOptionalTypeSignature ? ((RbsOptionalTypeSignature)it).getTypeSignature() : it).map(it -> (RbsTypeVariableReferenceSignature)ObjectUtils.tryCast((Object)it, RbsTypeVariableReferenceSignature.class)).orElse(null);
            if (signature == null) {
                return;
            }
            switch (signature.getReferenceType()) {
                default: {
                    throw new MatchException(null, null);
                }
                case CONTAINER_VARIABLE: {
                    RbsTypeVariableSymbol rbsTypeVariableSymbol = (RbsContainerTypeVariableSymbol)ContainerUtil.getOrElse(this.myContainerTypeVariables, (int)signature.getPosition(), null);
                    break;
                }
                case METHOD_VARIABLE: 
                case TYPE_ALIAS_VARIABLE: {
                    RbsTypeVariableSymbol rbsTypeVariableSymbol = argument = (RbsTypeVariableSymbol)ContainerUtil.getOrElse(this.myLocalTypeVariables, (int)signature.getPosition(), null);
                }
            }
            if (argument == null) {
                return;
            }
            RbsVariance variance = argument.getVariance();
            if (argument.isUnchecked() || variance == RbsVariance.INVARIANT || variance == this.myRequirement) {
                return;
            }
            String varianceName = variance.getPresentableName();
            String description = TextUtil.decapitalize((String)argument.getPresentation().longDescription());
            int expectedVariance = this.myRequirement.ordinal();
            this.myHolder.registerProblem((PsiElement)identifier, RbsBundle.message((String)"rbs.inspection.invalid.type.argument.usage.description", (Object[])new Object[]{varianceName, description, expectedVariance}), new LocalQuickFix[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containerTypeVariables";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localTypeVariables";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requirement";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsInvalidTypeArgumentUsageInspection$MyTypeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAndType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitOrType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitProcType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSimpleType";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitGenericType";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeArgument";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

