/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.probableBugs;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.psi.reference.RbsQualifiedNameSymbolReference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.psi.RbsPsiVisitor;
import com.intellij.ruby.rbs.common.psi.api.RbsContainerDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsIncludeCallElement;
import com.intellij.ruby.rbs.common.psi.api.RbsModuleInclusionCallElement;
import com.intellij.ruby.rbs.common.psi.api.RbsModuleSelfType;
import com.intellij.ruby.rbs.common.psi.api.RbsPrependCallElement;
import com.intellij.ruby.rbs.common.psi.api.RbsSuperClassElement;
import com.intellij.ruby.rbs.common.psi.api.RbsTypeElement;
import com.intellij.ruby.rbs.common.psi.api.RbsTypeList;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeVariableReferenceSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsVariance;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;

@ApiStatus.Internal
public final class RbsIncorrectTypeArgumentVarianceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsIncorrectTypeArgumentVarianceInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsIncorrectTypeArgumentVarianceInspection", "buildVisitor"));
    }

    private static final class MyVisitor
    extends RbsPsiVisitor {
        private final ProblemsHolder myHolder;

        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        public void visitIncludeCallElement(@NotNull RbsIncludeCallElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.visitModuleInclusionCallElement((RbsModuleInclusionCallElement)element);
        }

        public void visitModuleSelfType(@NotNull RbsModuleSelfType element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            Project project = element.getProject();
            GlobalSearchScope searchScope = element.getResolveScope();
            RbsQualifiedNameSymbolReference reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)element, RbsQualifiedNameSymbolReference.class));
            if (reference == null) {
                return;
            }
            Object object = ContainerUtil.getOnlyItem(reference.resolveReference(true));
            if (!(object instanceof RbsContainerSymbol)) {
                return;
            }
            RbsContainerSymbol target = (RbsContainerSymbol)object;
            RbsTypeList typeList = element.getTypeList();
            if (typeList == null) {
                return;
            }
            this.checkTypeList(project, (SearchScope)searchScope, target, typeList);
        }

        public void visitPrependCallElement(@NotNull RbsPrependCallElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            this.visitModuleInclusionCallElement((RbsModuleInclusionCallElement)element);
        }

        public void visitSuperClassElement(@NotNull RbsSuperClassElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            Project project = element.getProject();
            GlobalSearchScope searchScope = element.getResolveScope();
            RbsQualifiedNameSymbolReference reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)element, RbsQualifiedNameSymbolReference.class));
            if (reference == null) {
                return;
            }
            Object object = ContainerUtil.getOnlyItem(reference.resolveReference(true));
            if (!(object instanceof RbsContainerSymbol)) {
                return;
            }
            RbsContainerSymbol target = (RbsContainerSymbol)object;
            RbsTypeList typeList = element.getTypeList();
            if (typeList == null) {
                return;
            }
            this.checkTypeList(project, (SearchScope)searchScope, target, typeList);
        }

        private void visitModuleInclusionCallElement(@NotNull RbsModuleInclusionCallElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            Project project = element.getProject();
            GlobalSearchScope searchScope = element.getResolveScope();
            RbsQualifiedNameSymbolReference reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)element, RbsQualifiedNameSymbolReference.class));
            if (reference == null) {
                return;
            }
            Object object = ContainerUtil.getOnlyItem(reference.resolveReference(true));
            if (!(object instanceof RbsContainerSymbol)) {
                return;
            }
            RbsContainerSymbol target = (RbsContainerSymbol)object;
            RbsTypeList typeList = element.getTypeList();
            if (typeList == null) {
                return;
            }
            this.checkTypeList(project, (SearchScope)searchScope, target, typeList);
        }

        private void checkTypeList(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsContainerSymbol target, @NotNull RbsTypeList typeList) {
            RbsContainerDeclarationElement container;
            if (project == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if (searchScope == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            if (target == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            if (typeList == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            if ((container = (RbsContainerDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)typeList, RbsContainerDeclarationElement.class)) == null) {
                return;
            }
            List elements = typeList.getTypeList();
            List signatures = ContainerUtil.map((Collection)elements, RbsTypeElement::getTypeSignature);
            for (int i = 0; i < elements.size(); ++i) {
                PsiElement identifier;
                RbsContainerTypeVariableSymbol argument;
                RbsTypeVariableReferenceSignature signature;
                Object object = ContainerUtil.getOrElse((List)signatures, (int)i, null);
                if (!(object instanceof RbsTypeVariableReferenceSignature) || (signature = (RbsTypeVariableReferenceSignature)object).getReferenceType() != RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE || (argument = (RbsContainerTypeVariableSymbol)ContainerUtil.find((Iterable)ExtensionsKt.getSymbols((PsiElement)container, RbsContainerTypeVariableSymbol.class), it -> it.getTypeVariableIndex() == signature.getPosition())) == null || argument.isUnchecked() || argument.getVariance() == RbsVariance.INVARIANT || (identifier = (PsiElement)ContainerUtil.getOrElse((List)elements, (int)i, null)) == null) continue;
                target.getTypeVariableSymbols(project, searchScope).get((Object)i).stream().filter(parameter -> parameter.getVariance() != argument.getVariance()).findFirst().ifPresent(parameter -> {
                    String actualVariance = argument.getVariance().getPresentableName();
                    String description = TextUtil.decapitalize((String)argument.getPresentation().longDescription());
                    int expectedVariance = parameter.getVariance().ordinal();
                    this.myHolder.registerProblem(identifier, RbsBundle.message((String)"rbs.inspection.incorrect.type.argument.variance.description", (Object[])new Object[]{actualVariance, description, expectedVariance}), new LocalQuickFix[0]);
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeList";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsIncorrectTypeArgumentVarianceInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIncludeCallElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModuleSelfType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPrependCallElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSuperClassElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModuleInclusionCallElement";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkTypeList";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

