/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.probableBugs;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.psi.reference.RbsQualifiedNameSymbolReference;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.psi.RbsPsiVisitor;
import com.intellij.ruby.rbs.common.psi.api.RbsExtendCallElement;
import com.intellij.ruby.rbs.common.psi.api.RbsIncludeCallElement;
import com.intellij.ruby.rbs.common.psi.api.RbsModuleSelfTypeElement;
import com.intellij.ruby.rbs.common.psi.api.RbsPrependCallElement;
import com.intellij.ruby.rbs.common.psi.api.RbsSimpleType;
import com.intellij.ruby.rbs.common.psi.api.RbsSuperClassElement;
import com.intellij.ruby.rbs.common.psi.api.RbsTypeList;
import com.intellij.ruby.rbs.common.psi.api.RbsTypeListOwner;
import com.intellij.ruby.rbs.common.psi.tree.RbsElementTypesGenerated;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;

@ApiStatus.Internal
public final class RbsIncorrectTypeArgumentCountInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsIncorrectTypeArgumentCountInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsIncorrectTypeArgumentCountInspection", "buildVisitor"));
    }

    private static final class MyVisitor
    extends RbsPsiVisitor {
        private final ProblemsHolder myHolder;

        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        public void visitExtendCallElement(@NotNull RbsExtendCallElement element) {
            RbsQualifiedNameSymbolReference reference;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if ((reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)element, RbsQualifiedNameSymbolReference.class))) == null || PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                return;
            }
            this.checkTypeArguments(reference, (PsiElement)element, element.getTypeList());
        }

        public void visitIncludeCallElement(@NotNull RbsIncludeCallElement element) {
            RbsQualifiedNameSymbolReference reference;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if ((reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)element, RbsQualifiedNameSymbolReference.class))) == null || PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                return;
            }
            this.checkTypeArguments(reference, (PsiElement)element, element.getTypeList());
        }

        public void visitModuleSelfTypeElement(@NotNull RbsModuleSelfTypeElement element) {
            RbsQualifiedNameSymbolReference reference;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if ((reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)element, RbsQualifiedNameSymbolReference.class))) == null || PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                return;
            }
            this.checkTypeArguments(reference, (PsiElement)element, element.getTypeList());
        }

        public void visitPrependCallElement(@NotNull RbsPrependCallElement element) {
            RbsQualifiedNameSymbolReference reference;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            if ((reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)element, RbsQualifiedNameSymbolReference.class))) == null || PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                return;
            }
            this.checkTypeArguments(reference, (PsiElement)element, element.getTypeList());
        }

        public void visitSimpleType(@NotNull RbsSimpleType element) {
            RbsQualifiedNameSymbolReference reference;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if ((reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)element, RbsQualifiedNameSymbolReference.class))) == null || element.isSingleton() || PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                return;
            }
            this.checkTypeArguments(reference, (PsiElement)element, element.getTypeList());
        }

        public void visitSuperClassElement(@NotNull RbsSuperClassElement element) {
            RbsQualifiedNameSymbolReference reference;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if ((reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)element, RbsQualifiedNameSymbolReference.class))) == null || PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                return;
            }
            this.checkTypeArguments(reference, (PsiElement)element, element.getTypeList());
        }

        private void checkTypeArguments(@NotNull RbsQualifiedNameSymbolReference reference, @NotNull PsiElement element, @Nullable RbsTypeList typeList) {
            if (reference == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            Project project = element.getProject();
            GlobalSearchScope searchScope = element.getResolveScope();
            int count = typeList != null ? typeList.getTypeList().size() : 0;
            for (PresentableSymbol symbol : ContainerUtil.filterIsInstance(reference.resolveReference(true), PresentableSymbol.class)) {
                int max;
                int min;
                SymbolPresentation presentation = symbol.getPresentation();
                if (symbol instanceof RbsContainerSymbol) {
                    RbsContainerSymbol containerSymbol = (RbsContainerSymbol)symbol;
                    typeVariables = containerSymbol.getTypeVariableSymbols(project, (SearchScope)searchScope);
                    min = typeVariables.entrySet().stream().filter(it -> ObjectUtils.doIfNotNull((Object)((RbsContainerTypeVariableSymbol)ContainerUtil.getFirstItem((Collection)((Collection)it.getValue()))), RbsContainerTypeVariableSymbol::getDefaultType) == null).map(Map.Entry::getKey).max(Comparator.naturalOrder()).map(it -> it + 1).orElse(0);
                    max = typeVariables.keySet().stream().max(Comparator.naturalOrder()).map(it -> it + 1).orElse(0);
                } else {
                    if (!(symbol instanceof RbsTypeAliasSymbol)) continue;
                    RbsTypeAliasSymbol typeAliasSymbol = (RbsTypeAliasSymbol)symbol;
                    typeVariables = typeAliasSymbol.getTypeVariableSymbols(project, (SearchScope)searchScope);
                    min = typeVariables.entrySet().stream().filter(it -> ((RbsTypeAliasTypeVariableSymbol)it.getValue()).getDefaultType() == null).map(Map.Entry::getKey).max(Comparator.naturalOrder()).map(it -> it + 1).orElse(0);
                    max = typeVariables.keySet().stream().max(Comparator.naturalOrder()).map(it -> it + 1).orElse(0);
                }
                if (count < min) {
                    this.myHolder.registerProblem(element, reference.getRangeInElement(), RbsBundle.message((String)"rbs.inspection.incorrect.type.argument.count.add.description", (Object[])new Object[]{presentation.longDescription(), min}), new LocalQuickFix[]{new MyAddQuickFix(count, min)});
                    continue;
                }
                if (count <= max || typeList == null) continue;
                PsiElement first = (PsiElement)typeList.getTypeList().get(max);
                PsiElement last = (PsiElement)ContainerUtil.getLastItem((List)typeList.getTypeList());
                TextRange range = TextRange.create((int)first.getTextOffset(), (int)last.getTextRange().getEndOffset()).shiftLeft(element.getTextOffset());
                String message = RbsBundle.message((String)"rbs.inspection.incorrect.type.argument.count.remove.description", (Object[])new Object[0]);
                this.myHolder.registerProblem(element, range, message, new LocalQuickFix[]{new MyRemoveQuickFix(count, max)});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsIncorrectTypeArgumentCountInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitExtendCallElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIncludeCallElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModuleSelfTypeElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPrependCallElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSimpleType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSuperClassElement";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkTypeArguments";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyRemoveQuickFix
    implements LocalQuickFix,
    DumbAware {
        private final int myCount;
        private final int myExpected;

        private MyRemoveQuickFix(int count, int expected) {
            this.myCount = count;
            this.myExpected = expected;
        }

        @NotNull
        public String getName() {
            if (this.myExpected == 0) {
                String string = RbsBundle.message((String)"rbs.inspection.incorrect.type.argument.count.remove.all.quickfix.name", (Object[])new Object[]{this.myCount - this.myExpected});
                if (string == null) {
                    MyRemoveQuickFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = RbsBundle.message((String)"rbs.inspection.incorrect.type.argument.count.remove.quickfix.name", (Object[])new Object[]{this.myCount - this.myExpected});
            if (string == null) {
                MyRemoveQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.incorrect.type.argument.count.remove.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyRemoveQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyRemoveQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MyRemoveQuickFix.$$$reportNull$$$0(4);
            }
            PsiElement element = descriptor.getPsiElement();
            RbsTypeList typeList = Objects.requireNonNull(((RbsTypeListOwner)element).getTypeList());
            if (this.myExpected == 0) {
                PsiElement first = PsiTreeUtil.findSiblingBackward((PsiElement)typeList, (IElementType)RbsElementTypesGenerated.RBS_KLBRACKET, null);
                PsiElement last = PsiTreeUtil.findSiblingForward((PsiElement)typeList, (IElementType)RbsElementTypesGenerated.RBS_KRBRACKET, null);
                element.deleteChildRange(first, last);
            } else {
                PsiElement first = PsiTreeUtil.prevVisibleLeaf((PsiElement)((PsiElement)typeList.getTypeList().get(this.myExpected)));
                PsiElement last = (PsiElement)ContainerUtil.getLastItem((List)typeList.getTypeList());
                typeList.deleteChildRange(first, last);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsIncorrectTypeArgumentCountInspection$MyRemoveQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsIncorrectTypeArgumentCountInspection$MyRemoveQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class MyAddQuickFix
    implements LocalQuickFix,
    DumbAware {
        private final int myCount;
        private final int myExpected;

        private MyAddQuickFix(int count, int expected) {
            this.myCount = count;
            this.myExpected = expected;
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = RbsBundle.message((String)"rbs.inspection.incorrect.type.argument.count.add.quickfix.name", (Object[])new Object[]{this.myExpected - this.myCount});
            if (string == null) {
                MyAddQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.incorrect.type.argument.count.add.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyAddQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyAddQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MyAddQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement element = descriptor.getPsiElement();
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            TemplateManager manager = TemplateManager.getInstance((Project)project);
            Template template = manager.createTemplate("rbs_add_type_variables_template", "rbs");
            template.setToReformat(true);
            RbsTypeList typeList = ((RbsTypeListOwner)element).getTypeList();
            if (typeList == null) {
                template.addTextSegment("[");
                for (int i = 0; i < this.myExpected; ++i) {
                    if (i > 0) {
                        template.addTextSegment(", ");
                    }
                    template.addVariable((Expression)new ConstantNode("untyped"), true);
                }
                template.addTextSegment("]");
                editor.getCaretModel().moveToOffset(descriptor.getTextRangeInElement().shiftRight(element.getTextOffset()).getEndOffset());
            } else {
                for (int i = 0; i < this.myExpected - this.myCount; ++i) {
                    template.addTextSegment(", ");
                    template.addVariable((Expression)new ConstantNode("untyped"), true);
                }
                editor.getCaretModel().moveToOffset(typeList.getTextRange().getEndOffset());
            }
            manager.startTemplate(editor, template);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsIncorrectTypeArgumentCountInspection$MyAddQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsIncorrectTypeArgumentCountInspection$MyAddQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

