/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.probableBugs;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.psi.RbsPsiVisitor;
import com.intellij.ruby.rbs.common.psi.api.RbsKeywordParam;
import com.intellij.ruby.rbs.common.psi.api.RbsProcType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RbsDuplicateKeywordParameterInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsDuplicateKeywordParameterInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateKeywordParameterInspection", "buildVisitor"));
    }

    private static class MyVisitor
    extends RbsPsiVisitor {
        private final ProblemsHolder myProblemsHolder;

        protected MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myProblemsHolder = holder;
        }

        public void visitProcType(@NotNull RbsProcType procType) {
            if (procType == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            List keywordParams = ContainerUtil.filterIsInstance((Collection)procType.getParamList(), RbsKeywordParam.class);
            Map<String, Long> keywordParamsCount = keywordParams.stream().collect(Collectors.groupingBy(p -> Objects.requireNonNull(p.getKeywordName().getKeyword()).getText(), Collectors.counting()));
            for (RbsKeywordParam param : keywordParams) {
                if (keywordParamsCount.get(Objects.requireNonNull(param.getKeywordName().getKeyword()).getText()) <= 1L) continue;
                this.myProblemsHolder.registerProblem((PsiElement)param.getKeywordName(), RbsBundle.message((String)"rbs.inspection.duplicate.keyword.parameter", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, param.getKeywordName().getTextRangeInParent().grown(-1), new LocalQuickFix[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "procType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateKeywordParameterInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitProcType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

