/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.probableBugs;

import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureSubtypeChecker;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeSignaturePresenter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.psi.RbsPsiVisitor;
import com.intellij.ruby.rbs.common.psi.api.RbsModuleTypeParam;
import com.intellij.ruby.rbs.common.psi.api.RbsType;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RbsBadTypeVariableDefaultTypeInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsBadTypeVariableDefaultTypeInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsBadTypeVariableDefaultTypeInspection", "buildVisitor"));
    }

    private static final class MyVisitor
    extends RbsPsiVisitor {
        private final ProblemsHolder myHolder;

        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        public void visitModuleTypeParam(@NotNull RbsModuleTypeParam element) {
            GlobalSearchScope searchScope;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            RbsTypeSignature upperBoundTypeSignature = element.getUpperBoundTypeSignature();
            RbsTypeSignature defaultTypeTypeSignature = element.getDefaultTypeTypeSignature();
            if (upperBoundTypeSignature == null || defaultTypeTypeSignature == null) {
                return;
            }
            Project project = element.getProject();
            RbsTypeSignatureSubtypeChecker checker = new RbsTypeSignatureSubtypeChecker(project, (SearchScope)(searchScope = element.getResolveScope()), (PsiElement)element);
            if (!checker.isSubtype(defaultTypeTypeSignature, upperBoundTypeSignature)) {
                RbsType type = Objects.requireNonNull(Objects.requireNonNull(element.getDefaultType()).getType());
                String message = RbsBundle.message((String)"rbs.inspection.bad.type.variable.default.type.description", (Object[])new Object[]{type.getText(), RbsRubyTypeSignaturePresenter.getPresentableText(upperBoundTypeSignature)});
                this.myHolder.registerProblem((PsiElement)type, message, new LocalQuickFix[]{new MyReplaceQuickFix(type.getText())});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsBadTypeVariableDefaultTypeInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModuleTypeParam";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyReplaceQuickFix
    implements LocalQuickFix,
    DumbAware {
        private final String myTypeArgument;

        private MyReplaceQuickFix(@NotNull String typeArgument) {
            if (typeArgument == null) {
                MyReplaceQuickFix.$$$reportNull$$$0(0);
            }
            this.myTypeArgument = typeArgument;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyReplaceQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyReplaceQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getPsiElement();
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            editor.getCaretModel().moveToOffset(element.getTextOffset());
            TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder(element);
            builder.replaceElement(element, "untyped");
            TemplateManager.getInstance((Project)project).startTemplate(editor, builder.buildInlineTemplate());
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.bad.type.variable.default.type.replace.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyReplaceQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = RbsBundle.message((String)"rbs.inspection.bad.type.variable.default.type.replace.quickfix.name", (Object[])new Object[]{this.myTypeArgument});
            if (string == null) {
                MyReplaceQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeArgument";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsBadTypeVariableDefaultTypeInspection$MyReplaceQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsBadTypeVariableDefaultTypeInspection$MyReplaceQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

