/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.probableBugs;

import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.model.psi.reference.RbsQualifiedNameSymbolReference;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureSubtypeChecker;
import com.intellij.lang.ruby.rbs.ruby.types.RbsRubyTypeSignaturePresenter;
import com.intellij.model.Symbol;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.psi.RbsPsiVisitor;
import com.intellij.ruby.rbs.common.psi.api.RbsExtendCallElement;
import com.intellij.ruby.rbs.common.psi.api.RbsIncludeCallElement;
import com.intellij.ruby.rbs.common.psi.api.RbsModuleSelfTypeElement;
import com.intellij.ruby.rbs.common.psi.api.RbsPrependCallElement;
import com.intellij.ruby.rbs.common.psi.api.RbsSimpleType;
import com.intellij.ruby.rbs.common.psi.api.RbsSuperClassElement;
import com.intellij.ruby.rbs.common.psi.api.RbsType;
import com.intellij.ruby.rbs.common.psi.api.RbsTypeList;
import com.intellij.ruby.rbs.common.psi.data.RbsTypeSignature;
import com.intellij.ruby.rbs.common.psi.data.RbsUnionTypeSignature;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;

@ApiStatus.Internal
public final class RbsBadTypeArgumentTypeInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsBadTypeArgumentTypeInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsBadTypeArgumentTypeInspection", "buildVisitor"));
    }

    private static final class MyVisitor
    extends RbsPsiVisitor {
        private final ProblemsHolder myHolder;

        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        public void visitExtendCallElement(@NotNull RbsExtendCallElement element) {
            RbsQualifiedNameSymbolReference reference;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if ((reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)element, RbsQualifiedNameSymbolReference.class))) == null || PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                return;
            }
            this.checkTypeArguments(reference, (PsiElement)element, element.getTypeList());
        }

        public void visitIncludeCallElement(@NotNull RbsIncludeCallElement element) {
            RbsQualifiedNameSymbolReference reference;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if ((reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)element, RbsQualifiedNameSymbolReference.class))) == null || PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                return;
            }
            this.checkTypeArguments(reference, (PsiElement)element, element.getTypeList());
        }

        public void visitModuleSelfTypeElement(@NotNull RbsModuleSelfTypeElement element) {
            RbsQualifiedNameSymbolReference reference;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if ((reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)element, RbsQualifiedNameSymbolReference.class))) == null || PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                return;
            }
            this.checkTypeArguments(reference, (PsiElement)element, element.getTypeList());
        }

        public void visitPrependCallElement(@NotNull RbsPrependCallElement element) {
            RbsQualifiedNameSymbolReference reference;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            if ((reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)element, RbsQualifiedNameSymbolReference.class))) == null || PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                return;
            }
            this.checkTypeArguments(reference, (PsiElement)element, element.getTypeList());
        }

        public void visitSimpleType(@NotNull RbsSimpleType element) {
            RbsQualifiedNameSymbolReference reference;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if ((reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)element, RbsQualifiedNameSymbolReference.class))) == null || PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                return;
            }
            this.checkTypeArguments(reference, (PsiElement)element, element.getTypeList());
        }

        public void visitSuperClassElement(@NotNull RbsSuperClassElement element) {
            RbsQualifiedNameSymbolReference reference;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if ((reference = (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)ExtensionsKt.getSymbolReferences((PsiElement)element, RbsQualifiedNameSymbolReference.class))) == null || PsiTreeUtil.hasErrorElements((PsiElement)element)) {
                return;
            }
            this.checkTypeArguments(reference, (PsiElement)element, element.getTypeList());
        }

        /*
         * WARNING - void declaration
         */
        private void checkTypeArguments(@NotNull RbsQualifiedNameSymbolReference reference, @NotNull PsiElement element, @Nullable RbsTypeList typeList) {
            void var8_10;
            if (reference == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            if (typeList == null || typeList.getTypeList().isEmpty()) {
                return;
            }
            Project project = element.getProject();
            GlobalSearchScope searchScope = element.getResolveScope();
            MultiMap upperBounds = new MultiMap();
            for (Symbol symbol : reference.resolveReference(true)) {
                if (symbol instanceof RbsContainerSymbol) {
                    RbsContainerSymbol containerSymbol = (RbsContainerSymbol)symbol;
                    containerSymbol.getTypeVariableSymbols(project, (SearchScope)searchScope).toHashMap().forEach((i, typeVariables) -> upperBounds.putValues(i, (Collection)ContainerUtil.mapNotNull((Collection)typeVariables, RbsContainerTypeVariableSymbol::getUpperBound)));
                    continue;
                }
                if (!(symbol instanceof RbsTypeAliasSymbol)) continue;
                RbsTypeAliasSymbol typeAliasSymbol = (RbsTypeAliasSymbol)symbol;
                typeAliasSymbol.getTypeVariableSymbols(project, (SearchScope)searchScope).forEach((i, typeVariable) -> {
                    RbsTypeSignature upperBound = typeVariable.getUpperBound();
                    if (upperBound != null) {
                        upperBounds.putValue(i, (Object)upperBound);
                    }
                });
            }
            RbsTypeSignatureSubtypeChecker checker = new RbsTypeSignatureSubtypeChecker(project, (SearchScope)searchScope, element);
            boolean bl = false;
            while (var8_10 < typeList.getTypeList().size()) {
                RbsType type = (RbsType)typeList.getTypeList().get((int)var8_10);
                RbsTypeSignature argumentTypeSignature = type.getTypeSignature();
                RbsTypeSignature upperBoundTypeSignature = RbsUnionTypeSignature.of((Collection)upperBounds.get((Object)((int)var8_10))).orElse(null);
                if (upperBoundTypeSignature != null && !checker.isSubtype(argumentTypeSignature, upperBoundTypeSignature)) {
                    String message = RbsBundle.message((String)"rbs.inspection.bad.type.argument.type.description", (Object[])new Object[]{type.getText(), RbsRubyTypeSignaturePresenter.getPresentableText(upperBoundTypeSignature)});
                    this.myHolder.registerProblem((PsiElement)type, message, new LocalQuickFix[]{new MyReplaceQuickFix(type.getText())});
                }
                ++var8_10;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsBadTypeArgumentTypeInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitExtendCallElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIncludeCallElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModuleSelfTypeElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPrependCallElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSimpleType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSuperClassElement";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkTypeArguments";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyReplaceQuickFix
    implements LocalQuickFix,
    DumbAware {
        private final String myTypeArgument;

        private MyReplaceQuickFix(@NotNull String typeArgument) {
            if (typeArgument == null) {
                MyReplaceQuickFix.$$$reportNull$$$0(0);
            }
            this.myTypeArgument = typeArgument;
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = RbsBundle.message((String)"rbs.inspection.bad.type.argument.type.replace.quickfix.name", (Object[])new Object[]{this.myTypeArgument});
            if (string == null) {
                MyReplaceQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.bad.type.argument.type.replace.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyReplaceQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyReplaceQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MyReplaceQuickFix.$$$reportNull$$$0(4);
            }
            PsiElement element = descriptor.getPsiElement();
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            editor.getCaretModel().moveToOffset(element.getTextOffset());
            TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder(element);
            builder.replaceElement(element, "untyped");
            TemplateManager.getInstance((Project)project).startTemplate(editor, builder.buildInlineTemplate());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeArgument";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsBadTypeArgumentTypeInspection$MyReplaceQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsBadTypeArgumentTypeInspection$MyReplaceQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

