/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.namingConventions;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.options.RegexValidator;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.lang.ruby.rbs.model.rename.RbsSymbolRenameTargetFactory;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.impl.StartRenameQuickFix;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.psi.RbsPsiVisitor;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;

@ApiStatus.Internal
public abstract class RbsUnconventionalNameInspectionBase
extends LocalInspectionTool {
    public String myRegex;
    public boolean myRegexEnabled;
    public int myMinLength;
    public boolean myMinLengthEnabled;
    public int myMaxLength;
    public boolean myMaxLengthEnabled;
    private final String myDefaultRegex;
    private final Pattern myDefaultRegexPattern;
    private Pattern myRegexPattern;

    RbsUnconventionalNameInspectionBase(@NotNull String regex, int minLength, int maxLength) {
        if (regex == null) {
            RbsUnconventionalNameInspectionBase.$$$reportNull$$$0(0);
        }
        this.myRegex = regex;
        this.myRegexEnabled = true;
        this.myMinLength = minLength;
        this.myMinLengthEnabled = false;
        this.myMaxLength = maxLength;
        this.myMaxLengthEnabled = false;
        this.myDefaultRegex = regex;
        this.myRegexPattern = this.myDefaultRegexPattern = Pattern.compile(regex);
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValueSet("myRegex", value -> {
            try {
                this.myRegexPattern = Pattern.compile(this.myRegex);
            }
            catch (PatternSyntaxException ignore) {
                this.myRegex = this.myDefaultRegex;
                this.myRegexPattern = this.myDefaultRegexPattern;
            }
        });
        if (optionController == null) {
            RbsUnconventionalNameInspectionBase.$$$reportNull$$$0(1);
        }
        return optionController;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myRegexEnabled", (String)InspectionsBundle.message((String)"label.pattern", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.string((String)"myRegex", (String)"", (int)-1, (StringValidator)new RegexValidator())}), OptPane.checkbox((String)"myMinLengthEnabled", (String)InspectionsBundle.message((String)"label.min.length", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"myMinLength", (String)"", (int)1, (int)1000000)}), OptPane.checkbox((String)"myMaxLengthEnabled", (String)InspectionsBundle.message((String)"label.max.length", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"myMaxLength", (String)"", (int)1, (int)1000000)})});
        if (optPane == null) {
            RbsUnconventionalNameInspectionBase.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            RbsUnconventionalNameInspectionBase.$$$reportNull$$$0(3);
        }
        super.readSettings(element);
        this.myRegexPattern = Pattern.compile(this.myRegex);
    }

    @TestOnly
    public void setRegex(@NotNull String regex) {
        if (regex == null) {
            RbsUnconventionalNameInspectionBase.$$$reportNull$$$0(4);
        }
        this.myRegex = regex;
        this.myRegexPattern = Pattern.compile(regex);
    }

    @TestOnly
    public void setMaxLength(int maxLength) {
        this.myMaxLength = maxLength;
    }

    @TestOnly
    public void setMaxLengthEnabled(boolean maxLengthEnabled) {
        this.myMaxLengthEnabled = maxLengthEnabled;
    }

    @TestOnly
    public void setMinLength(int minLength) {
        this.myMinLength = minLength;
    }

    @TestOnly
    public void setMinLengthEnabled(boolean minLengthEnabled) {
        this.myMinLengthEnabled = minLengthEnabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regex";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/namingConventions/RbsUnconventionalNameInspectionBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/namingConventions/RbsUnconventionalNameInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setRegex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    protected abstract class Visitor
    extends RbsPsiVisitor {
        private final Project myProject;
        private final ProblemsHolder myHolder;

        protected Visitor(@NotNull Project project, ProblemsHolder holder) {
            if (project == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myHolder = holder;
        }

        protected void visitPsiSymbolDeclaration(@NotNull PsiSymbolDeclaration declaration) {
            PresentableSymbol symbol;
            if (declaration == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((symbol = (PresentableSymbol)ObjectUtils.tryCast((Object)declaration.getSymbol(), PresentableSymbol.class)) == null) {
                return;
            }
            String name = symbol.getPresentation().name();
            RenameTarget target = RbsSymbolRenameTargetFactory.getRenameTarget(this.myProject, (Symbol)symbol);
            LocalQuickFix[] quickFixes = target != null ? List.of(new StartRenameQuickFix(target)).toArray(LocalQuickFix.EMPTY_ARRAY) : LocalQuickFix.EMPTY_ARRAY;
            PsiElement element = declaration.getDeclaringElement();
            TextRange rangeInElement = declaration.getRangeInDeclaringElement();
            if (RbsUnconventionalNameInspectionBase.this.myMinLengthEnabled && name.length() < RbsUnconventionalNameInspectionBase.this.myMinLength) {
                this.myHolder.registerProblem(element, rangeInElement, RbsBundle.message((String)"rbs.inspection.unconventional.name.too.short.description", (Object[])new Object[]{name, RbsUnconventionalNameInspectionBase.this.myMinLength}), quickFixes);
            }
            if (RbsUnconventionalNameInspectionBase.this.myMaxLengthEnabled && name.length() > RbsUnconventionalNameInspectionBase.this.myMaxLength) {
                this.myHolder.registerProblem(element, rangeInElement, RbsBundle.message((String)"rbs.inspection.unconventional.name.too.long.description", (Object[])new Object[]{name, RbsUnconventionalNameInspectionBase.this.myMaxLength}), quickFixes);
            }
            if (RbsUnconventionalNameInspectionBase.this.myRegexEnabled && !RbsUnconventionalNameInspectionBase.this.myRegexPattern.matcher(name).matches()) {
                this.myHolder.registerProblem(element, rangeInElement, RbsBundle.message((String)"rbs.inspection.unconventional.name.mismatched.description", (Object[])new Object[]{name, RbsUnconventionalNameInspectionBase.this.myRegex}), quickFixes);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/namingConventions/RbsUnconventionalNameInspectionBase$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPsiSymbolDeclaration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

