/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.dataFlow;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ruby.rbs.formatter.RbsImportOptimizer;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.model.psi.reference.RbsQualifiedNameSymbolReference;
import com.intellij.lang.ruby.rbs.psi.index.RbsDeclarationByParentFqnIndex;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.psi.RbsPsiFile;
import com.intellij.ruby.rbs.common.psi.RbsPsiVisitor;
import com.intellij.ruby.rbs.common.psi.api.RbsUseClauseElement;
import com.intellij.ruby.rbs.common.psi.api.RbsUseCls;
import com.intellij.ruby.rbs.common.psi.data.RbsUseClauseType;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RbsUnusedUseClauseInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsUnusedUseClauseInspection.$$$reportNull$$$0(0);
        }
        final HashSet<String> referencedNames = new HashSet<String>();
        holder.getFile().accept((PsiElementVisitor)new PsiRecursiveElementVisitor(this){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                Collection references = PsiSymbolReferenceService.getService().getReferences(element, RbsQualifiedNameSymbolReference.class);
                for (RbsQualifiedNameSymbolReference reference : references) {
                    String name = reference.getQualifiedName();
                    if (name.startsWith("::")) continue;
                    referencedNames.add((String)ObjectUtils.coalesce((Object)StringUtil.substringBefore((String)name, (String)"::"), (Object)name));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ruby/rbs/inspections/dataFlow/RbsUnusedUseClauseInspection$1", "visitElement"));
            }
        });
        return new MyVisitor(holder, referencedNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ruby/rbs/inspections/dataFlow/RbsUnusedUseClauseInspection", "buildVisitor"));
    }

    private static final class MyVisitor
    extends RbsPsiVisitor {
        private final Project myProject;
        private final ProblemsHolder myHolder;
        private final Set<String> myReferencedNames;

        private MyVisitor(@NotNull ProblemsHolder holder, @NotNull Set<String> referencedNames) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (referencedNames == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.myProject = holder.getProject();
            this.myHolder = holder;
            this.myReferencedNames = Set.copyOf(referencedNames);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void visitUseCls(@NotNull RbsUseCls element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            HashSet<Object> names = new HashSet<Object>();
            RbsUseClauseType type = element.getClauseType();
            if (type instanceof RbsUseClauseType.Alias) {
                Object name;
                block13: {
                    RbsUseClauseType.Alias alias = (RbsUseClauseType.Alias)type;
                    try {
                        Object object;
                        Fqn fqn = object = alias.fqn();
                        name = object = alias.name();
                        if (!fqn.split().getName().equals(name)) break block13;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    this.myHolder.registerProblem((PsiElement)Objects.requireNonNull(element.getUseAlias()), RbsBundle.message((String)"rbs.inspection.unused.use.clause.unnecessary.alias.description", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new MyQuickFix(this.myReferencedNames)});
                    return;
                }
                names.add(name);
            } else if (type instanceof RbsUseClauseType.Import) {
                RbsUseClauseType.Import import_ = (RbsUseClauseType.Import)type;
                Fqn fqn = import_.fqn();
                Fqn fqn2 = fqn;
                if (fqn2.split().getParent() == Fqn.INVALID) {
                    this.myHolder.registerProblem((PsiElement)element, RbsBundle.message((String)"rbs.inspection.unused.use.clause.unnecessary.description", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new MyQuickFix(this.myReferencedNames)});
                    return;
                }
                names.add(fqn2.split().getName());
            } else if (type instanceof RbsUseClauseType.Wildcard) {
                RbsUseClauseType.Wildcard wildcard = (RbsUseClauseType.Wildcard)type;
                SequencedCollection<? extends RbsQualifiedNameSymbol> targets = RbsResolveUtil.resolveUseClauseWildcard(this.myProject, (SearchScope)element.getResolveScope(), wildcard);
                if (targets.isEmpty()) {
                    this.myHolder.registerProblem((PsiElement)element, RbsBundle.message((String)"rbs.inspection.unused.use.clause.unnecessary.description", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new MyQuickFix(this.myReferencedNames)});
                    return;
                }
                for (RbsQualifiedNameSymbol rbsQualifiedNameSymbol : targets) {
                    names.add(rbsQualifiedNameSymbol.getFullName());
                }
            }
            if (ContainerUtil.intersects(names, this.getUnresolvedReferencedNames(element))) {
                return;
            }
            String message = ContainerUtil.intersects(names, this.myReferencedNames) ? RbsBundle.message((String)"rbs.inspection.unused.use.clause.shadowed.description", (Object[])new Object[0]) : RbsBundle.message((String)"rbs.inspection.unused.use.clause.unused.description", (Object[])new Object[0]);
            this.myHolder.registerProblem((PsiElement)element, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new MyQuickFix(this.myReferencedNames)});
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        private Set<String> getUnresolvedReferencedNames(@NotNull RbsUseCls anchor) {
            RbsUseClauseElement useClause;
            RbsPsiFile file;
            if (anchor == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if ((file = (RbsPsiFile)ObjectUtils.tryCast((Object)anchor.getContainingFile(), RbsPsiFile.class)) == null) {
                Set<String> set = Collections.emptySet();
                if (set == null) {
                    MyVisitor.$$$reportNull$$$0(4);
                }
                return set;
            }
            HashSet<String> unresolvedNames = new HashSet<String>(this.myReferencedNames);
            Iterator iterator = ContainerUtil.reverse((List)file.getUseClauses()).iterator();
            while (iterator.hasNext() && !(useClause = (RbsUseClauseElement)iterator.next()).equals((Object)anchor)) {
                Fqn namespace;
                Fqn fqn;
                RbsUseClauseType clauseType = useClause.getClauseType();
                if (clauseType instanceof RbsUseClauseType.Alias) {
                    RbsUseClauseType.Alias alias = (RbsUseClauseType.Alias)clauseType;
                    unresolvedNames.remove(alias.name());
                    continue;
                }
                if (clauseType instanceof RbsUseClauseType.Import) {
                    RbsUseClauseType.Import import_ = (RbsUseClauseType.Import)clauseType;
                    try {
                        Fqn fqn2 = fqn = import_.fqn();
                        unresolvedNames.remove(fqn2.split().getName());
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                if (!(clauseType instanceof RbsUseClauseType.Wildcard)) continue;
                RbsUseClauseType.Wildcard wildcard = (RbsUseClauseType.Wildcard)clauseType;
                {
                    namespace = fqn = wildcard.namespace();
                }
                RbsDeclarationByParentFqnIndex.processAllValues(this.myProject, (SearchScope)useClause.getResolveScope(), namespace, (type, name) -> {
                    switch (type) {
                        case CLASS: 
                        case CLASS_ALIAS: 
                        case INTERFACE: 
                        case MODULE: 
                        case MODULE_ALIAS: 
                        case TYPE_ALIAS: {
                            unresolvedNames.remove(name);
                        }
                    }
                });
            }
            Set<String> set = Collections.unmodifiableSet(unresolvedNames);
            if (set == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referencedNames";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/dataFlow/RbsUnusedUseClauseInspection$MyVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/dataFlow/RbsUnusedUseClauseInspection$MyVisitor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedReferencedNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitUseCls";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getUnresolvedReferencedNames";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyQuickFix
    implements LocalQuickFix {
        @FileModifier.SafeFieldForPreview
        private final Set<String> myReferencedNames;

        private MyQuickFix(@NotNull Set<String> referencedNames) {
            if (referencedNames == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            this.myReferencedNames = Set.copyOf(referencedNames);
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.unused.use.clause.optimize.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiFile psiFile;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            if ((psiFile = descriptor.getPsiElement().getContainingFile()) instanceof RbsPsiFile) {
                RbsPsiFile file = (RbsPsiFile)psiFile;
                new RbsImportOptimizer().run(project, file, this.myReferencedNames);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referencedNames";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/dataFlow/RbsUnusedUseClauseInspection$MyQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/dataFlow/RbsUnusedUseClauseInspection$MyQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

