/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.codeStyle;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ruby.rbs.completion.RbsCompletionUtil;
import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNameCompletionTarget;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.model.psi.reference.RbsQualifiedNameSymbolReference;
import com.intellij.lang.ruby.rbs.model.usages.RbsUsageTypes;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.common.RbsBundle;
import com.intellij.ruby.rbs.common.RbsFileType;
import com.intellij.ruby.rbs.common.psi.RbsPsiVisitor;
import com.intellij.ruby.rbs.common.psi.data.RbsUseClauseType;
import com.intellij.ruby.rbs.common.psi.util.RbsPsiUtil;
import com.intellij.ruby.rbs.common.util.Fqn;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.SequencedCollection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RbsUnnecessaryQualifierInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsUnnecessaryQualifierInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsUnnecessaryQualifierInspection", "buildVisitor"));
    }

    private static final class MyVisitor
    extends RbsPsiVisitor {
        private final Project myProject;
        private final SearchScope mySearchScope;
        private final ProblemsHolder myHolder;
        private final List<RbsUseClauseType> myUseClauses;

        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myProject = holder.getProject();
            this.mySearchScope = holder.getFile().getResolveScope();
            this.myHolder = holder;
            this.myUseClauses = RbsPsiUtil.getUseClauseTypes((PsiElement)holder.getFile());
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            Collection references = PsiSymbolReferenceService.getService().getReferences(element, RbsQualifiedNameSymbolReference.class);
            block0: for (RbsQualifiedNameSymbolReference reference : references) {
                String candidate;
                String qualifiedName;
                Fqn fqn;
                Fqn containerFqn;
                if (reference.getUsage().getUsageType() == RbsUsageTypes.USAGE_TYPE_NESTED_CONSTANT_ACCESS || (containerFqn = reference.getContainerFqn()) == Fqn.INVALID && this.myUseClauses.isEmpty() || (fqn = Fqn.of((String)(qualifiedName = reference.getQualifiedName()), (String[])new String[0])).split().getParent() == Fqn.INVALID || fqn.isAbsolute()) continue;
                EnumSet<RbsQualifiedNameCompletionTarget> targets = reference.getCompletionTargets();
                Iterator iterator = RbsCompletionUtil.getCandidateRelativeQualifiedNames(this.myUseClauses, containerFqn, fqn).iterator();
                while (iterator.hasNext() && !(candidate = (String)iterator.next()).equals(qualifiedName)) {
                    SequencedCollection<? extends Symbol> result = RbsResolveUtil.resolveQualifiedName(this.myProject, this.mySearchScope, containerFqn, candidate, targets, element);
                    if (result.isEmpty() || !ContainerUtil.and(result, reference::resolvesTo)) continue;
                    String message = RbsBundle.message((String)"rbs.inspection.unnecessary.qualifier.description", (Object[])new Object[]{qualifiedName});
                    TextRange range = TextRange.allOf((String)qualifiedName).shiftRight(reference.getRangeInElement().getStartOffset() - (StringUtil.substringBeforeLast((String)qualifiedName, (String)"::").length() + 2));
                    this.myHolder.registerProblem(element, message, ProblemHighlightType.WEAK_WARNING, range, new LocalQuickFix[]{new MyQuickFix(candidate)});
                    continue block0;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsUnnecessaryQualifierInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyQuickFix
    implements LocalQuickFix,
    DumbAware {
        private final String myReplacement;

        private MyQuickFix(@NotNull String replacement) {
            if (replacement == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            this.myReplacement = replacement;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiDocumentManager manager;
            Document document;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            if ((document = (manager = PsiDocumentManager.getInstance((Project)project)).getDocument(descriptor.getPsiElement().getContainingFile())) == null) {
                return;
            }
            TextRange range = descriptor.getTextRangeInElement().shiftRight(descriptor.getPsiElement().getTextOffset());
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)this.myReplacement);
            manager.commitDocument(document);
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(4);
            }
            String text = descriptor.getPsiElement().getContainingFile().getText();
            TextRange range = descriptor.getTextRangeInElement().shiftRight(descriptor.getPsiElement().getTextOffset());
            return new IntentionPreviewInfo.CustomDiff((FileType)RbsFileType.INSTANCE, text, range.replace(text, this.myReplacement));
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.unnecessary.qualifier.replace.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = RbsBundle.message((String)"rbs.inspection.unnecessary.qualifier.replace.quickfix.name", (Object[])new Object[]{this.myReplacement});
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacement";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsUnnecessaryQualifierInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsUnnecessaryQualifierInspection$MyQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

