/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.common.psi.api.RbsClassDeclaration;
import com.intellij.ruby.rbs.common.psi.api.RbsClassName;
import com.intellij.ruby.rbs.common.psi.api.RbsInterfaceDeclaration;
import com.intellij.ruby.rbs.common.psi.api.RbsInterfaceName;
import com.intellij.ruby.rbs.common.psi.api.RbsModuleDeclaration;
import com.intellij.ruby.rbs.common.psi.tree.RbsTokenSets;
import com.intellij.util.TimeoutUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.folding.RubyFoldingBuilder;

final class RbsFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(RbsFoldingBuilder.class);

    RbsFoldingBuilder() {
    }

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        long executionTime;
        if (descriptors == null) {
            RbsFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            RbsFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            RbsFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (100L < (executionTime = TimeoutUtil.measureExecutionTime(() -> this.collectDescriptors(root.getNode(), descriptors)))) {
            LOG.warn("Folding regions building took too long: " + executionTime + "ms; Root size: " + root.getTextLength() + "; Ranges collected: " + descriptors.size());
        }
    }

    private void collectDescriptors(@NotNull ASTNode node, @NotNull List<? super FoldingDescriptor> descriptors) {
        ASTNode[] children;
        TextRange range;
        IElementType type;
        if (node == null) {
            RbsFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (descriptors == null) {
            RbsFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (RbsTokenSets.RBS_FOLDED_ELEMENTS.contains(type = node.getElementType()) && (range = RbsFoldingBuilder.getFoldingTextRange(node)).getStartOffset() + 1 < range.getEndOffset()) {
            descriptors.add((FoldingDescriptor)new FoldingDescriptor(node, range, FoldingGroup.newGroup((String)"group"), RbsFoldingBuilder.placeholderText(node), Boolean.valueOf(this.isRegionCollapsedByDefault(node)), Collections.emptySet()));
        }
        for (ASTNode child : children = node.getChildren(null)) {
            this.collectDescriptors(child, descriptors);
        }
    }

    @NotNull
    private static TextRange getFoldingTextRange(@NotNull ASTNode node) {
        PsiElement firstChild;
        RbsClassName name;
        if (node == null) {
            RbsFoldingBuilder.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = node.getPsi();
        int endOffset = node.getTextRange().getEndOffset();
        if (psiElement instanceof RbsClassDeclaration || psiElement instanceof RbsModuleDeclaration) {
            name = (RbsClassName)PsiTreeUtil.getChildOfType((PsiElement)psiElement, RbsClassName.class);
            if (name != null) {
                return new TextRange(RubyFoldingBuilder.getVisibleTextOffset((PsiElement)name), endOffset);
            }
            firstChild = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)psiElement.getFirstChild());
            if (firstChild != null) {
                return new TextRange(node.getTextRange().getStartOffset() + firstChild.getTextLength(), endOffset);
            }
        }
        if (psiElement instanceof RbsInterfaceDeclaration) {
            name = (RbsInterfaceName)PsiTreeUtil.getChildOfType((PsiElement)psiElement, RbsInterfaceName.class);
            if (name != null) {
                return new TextRange(RubyFoldingBuilder.getVisibleTextOffset((PsiElement)name), endOffset);
            }
            firstChild = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)psiElement.getFirstChild());
            if (firstChild != null) {
                return new TextRange(node.getTextRange().getStartOffset() + firstChild.getTextLength(), endOffset);
            }
        }
        TextRange textRange = node.getTextRange();
        if (textRange == null) {
            RbsFoldingBuilder.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @NotNull
    private static String placeholderText(@NotNull ASTNode node) {
        IElementType type;
        if (node == null) {
            RbsFoldingBuilder.$$$reportNull$$$0(7);
        }
        if (RbsTokenSets.RBS_TOP_DECLARATIONS.contains(type = node.getElementType())) {
            return " ... end";
        }
        return "...";
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            RbsFoldingBuilder.$$$reportNull$$$0(8);
        }
        if (range == null) {
            RbsFoldingBuilder.$$$reportNull$$$0(9);
        }
        return null;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            RbsFoldingBuilder.$$$reportNull$$$0(10);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/folding/RbsFoldingBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/folding/RbsFoldingBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingTextRange";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "placeholderText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePlaceholderText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isRegionCollapsedByDefault";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

