/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.lang.ruby.rbs.completion.RbsCompletionScope;
import com.intellij.openapi.project.Project;
import com.intellij.ruby.rbs.common.util.RbsKeywords;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class RbsWeighedLookupElement
extends LookupElementDecorator<LookupElement> {
    private static final InsertHandler<LookupElement> AUTO_POPUP = (context, item) -> AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
    private static final Set<String> KEYWORDS_WITH_SPACE_AFTER = Set.copyOf(ContainerUtil.concat((List[])new List[]{RbsKeywords.DECLARATIONS, RbsKeywords.INTERFACE_MEMBERS, RbsKeywords.CLASS_OR_MODULE_ONLY_MEMBERS, RbsKeywords.VARIANCE, List.of("as", "unchecked", "use")}));
    private static final Set<String> KEYWORDS_LOW_PRIORITY = Set.of("__todo__");
    @NotNull
    private final RbsCompletionScope myScope;
    private final boolean myIsTypeAlias;

    public RbsWeighedLookupElement(@NotNull LookupElement delegate, boolean isTypeAlias) {
        if (delegate == null) {
            RbsWeighedLookupElement.$$$reportNull$$$0(0);
        }
        this(delegate, RbsCompletionScope.UNKNOWN, isTypeAlias);
    }

    public RbsWeighedLookupElement(@NotNull LookupElement delegate, @NotNull RbsCompletionScope scope, boolean isTypeAlias) {
        if (delegate == null) {
            RbsWeighedLookupElement.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            RbsWeighedLookupElement.$$$reportNull$$$0(2);
        }
        super(delegate);
        this.myScope = scope;
        this.myIsTypeAlias = isTypeAlias;
    }

    @NotNull
    RbsCompletionScope getScope() {
        RbsCompletionScope rbsCompletionScope = this.myScope;
        if (rbsCompletionScope == null) {
            RbsWeighedLookupElement.$$$reportNull$$$0(3);
        }
        return rbsCompletionScope;
    }

    boolean isTypeAlias() {
        return this.myIsTypeAlias;
    }

    @NotNull
    static RbsWeighedLookupElement fromKeyword(@NotNull String keyword) {
        if (keyword == null) {
            RbsWeighedLookupElement.$$$reportNull$$$0(4);
        }
        LookupElementBuilder element = LookupElementBuilder.create((String)keyword).bold();
        if (KEYWORDS_WITH_SPACE_AFTER.contains(keyword)) {
            element = element.withInsertHandler(AddSpaceInsertHandler.INSTANCE);
        }
        if (keyword.equals("singleton")) {
            element = element.withInsertHandler((context, item) -> {
                ParenthesesInsertHandler.WITH_PARAMETERS.handleInsert(context, item);
                context.commitDocument();
                AUTO_POPUP.handleInsert(context, item);
            });
        }
        if (KEYWORDS_LOW_PRIORITY.contains(keyword)) {
            return new RbsWeighedLookupElement((LookupElement)element, RbsCompletionScope.KEYWORD_LOW_PRIORITY, false);
        }
        return new RbsWeighedLookupElement((LookupElement)element, RbsCompletionScope.KEYWORD, false);
    }

    @NotNull
    static RbsWeighedLookupElement fromOperator(@NotNull String operator) {
        if (operator == null) {
            RbsWeighedLookupElement.$$$reportNull$$$0(5);
        }
        LookupElementBuilder element = LookupElementBuilder.create((String)operator).bold();
        return new RbsWeighedLookupElement((LookupElement)element, RbsCompletionScope.OPERATOR, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/completion/RbsWeighedLookupElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/completion/RbsWeighedLookupElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromKeyword";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromOperator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

